/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.web;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.run.plugins.TestCaseCreator;
import com.ftinc.si.assist.test.AssertRecord;
import com.ftinc.si.assist.test.Fson;
import com.ftinc.si.assist.test.JSONRecord;
import com.ftinc.si.assist.test.ObjectRecord;
import com.ftinc.si.assist.test.Record;
import com.ftinc.si.assist.test.TestCaseRecord;
import com.ftinc.si.assist.test.TestCommandRecord;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.web.AfterAction;
import com.ftinc.si.assist.test.web.BeforeAction;
import com.ftinc.si.assist.test.web.CheckFor;
import com.ftinc.si.assist.test.web.Click;
import com.ftinc.si.assist.test.web.Clock;
import com.ftinc.si.assist.test.web.DBGetter;
import com.ftinc.si.assist.test.web.DBSetter;
import com.ftinc.si.assist.test.web.Drag;
import com.ftinc.si.assist.test.web.Drop;
import com.ftinc.si.assist.test.web.Hover;
import com.ftinc.si.assist.test.web.IndexSetter;
import com.ftinc.si.assist.test.web.JQExec;
import com.ftinc.si.assist.test.web.MacroActions;
import com.ftinc.si.assist.test.web.PageAction;
import com.ftinc.si.assist.test.web.PagePlayer;
import com.ftinc.si.assist.test.web.Prompt;
import com.ftinc.si.assist.test.web.ResetBrowser;
import com.ftinc.si.assist.test.web.SendKeys;
import com.ftinc.si.assist.test.web.Sleep;
import com.ftinc.si.assist.test.web.Snap;
import com.ftinc.si.assist.test.web.StatusViewer;
import com.ftinc.si.assist.test.web.ToFrame;
import com.ftinc.si.assist.test.web.UseHand;
import com.ftinc.si.assist.test.web.Verify;
import com.ftinc.si.assist.test.web.WebElementGetter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WebTestCreator
extends TestCaseCreator {
    private static StatusViewer s_viewer = new StatusViewer();
    private static Pattern attribute_pat = Pattern.compile("\\s*([^\\s=]+)\\s*=\\s*\"([^\"]+?)\"");

    @Override
    public int command(HashMap<String, Object> map) {
        String cmd;
        switch (cmd = map.get("verb").toString()) {
            case "#inspect": {
                return this.inspect(map);
            }
            case "#xpath": {
                return this.xpathTest(map);
            }
        }
        return super.command(map);
    }

    private int xpathTest(HashMap<String, Object> map) {
        WebElementGetter t_getter = new WebElementGetter(null);
        t_getter.setModal(true);
        t_getter.setVisible(true);
        return 0;
    }

    private int inspect(HashMap<String, Object> map) {
        String e_msg = "null";
        if (map.containsKey("from") && map.containsKey("checkpoints")) {
            JSONRecord t_jdata;
            ArrayList temp_list = (ArrayList)map.get("checkpoints");
            ArrayList<String> chk_list = new ArrayList<String>();
            int i = 0;
            while (i < temp_list.size()) {
                String sdata;
                Pattern t_pat1 = Pattern.compile("^(.*?)\\.([^\\(]+)\\(([^\\)]+)\\)$");
                Matcher t_m = t_pat1.matcher(sdata = (String)temp_list.get(i));
                if (t_m.find()) {
                    chk_list.add(String.valueOf(t_m.group(1)) + "\t" + t_m.group(3) + "\t" + t_m.group(2));
                } else {
                    Pattern t_pat2 = Pattern.compile("^([^\\.\\(]+)\\(([^\\)]+)\\)$");
                    t_m = t_pat2.matcher(sdata);
                    if (t_m.find()) {
                        chk_list.add(String.valueOf(t_m.group(1)) + "\t" + t_m.group(2) + "\t");
                    } else {
                        Pattern t_pat3 = Pattern.compile("^(.*?)\\.([^\\(]+)$");
                        t_m = t_pat3.matcher(sdata);
                        if (t_m.find()) {
                            chk_list.add(String.valueOf(t_m.group(1)) + "\t\t" + t_m.group(2));
                        } else {
                            chk_list.add(String.valueOf(sdata) + "\t\t");
                        }
                    }
                }
                ++i;
            }
            ArrayList from_list = (ArrayList)map.get("from");
            if (from_list == null || from_list.size() == 0) {
                Tool.alertMSG(null, Messages.getString("WebTestCreator.12"));
                return -1;
            }
            s_viewer.setVisible(true);
            String keyact = map.get("start").toString();
            String[] keys = keyact.split("\t", -1);
            if (keys.length == 1) {
                keyact = String.valueOf(keys[0]) + "\t\t";
            }
            if ((t_jdata = JSONRecord.getJSONRec(MacroActions.class.getName(), String.valueOf(keys[0]) + "_submit")) != null) {
                MacroActions t_macro;
                block18: {
                    t_macro = new MacroActions();
                    Fson.updateFromJson(t_macro, t_jdata.content);
                    Fson.updateByJsonPath(t_macro, "$.trans_from", Tool.getJSONfromObject(from_list));
                    Fson.updateByJsonPath(t_macro, "$.key4actions", keyact);
                    t_macro.options = "_submit";
                    ArrayList<String> ng_list = new ArrayList<String>();
                    ng_list.add(map.get("start").toString());
                    ArrayList<ArrayList<String>> xres = t_macro.getHistory(chk_list, ng_list);
                    if (xres == null || xres.size() <= 0) break block18;
                    String t_result = "";
                    ArrayList<String> routes = xres.get(0);
                    int j = 0;
                    while (j < routes.size()) {
                        if (j > 0) {
                            t_result = String.valueOf(t_result) + " > ";
                        }
                        String[] t_strs = routes.get(j).split("\t", -1);
                        t_result = String.valueOf(t_result) + t_strs[0];
                        ++j;
                    }
                    s_viewer.setVisible(false);
                    Tool.alertMSG(null, String.valueOf(Messages.getString("WebTestCreator.25")) + t_result + " > " + keys[0]);
                    return 0;
                }
                try {
                    e_msg = t_macro.getErrMsg();
                    Tool.alertMSG(null, "history of " + keyact + " not found.\n" + e_msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    e_msg = t_macro.getErrMsg();
                    Tool.alertMSG(null, String.valueOf(e_msg) + " ExceptionMsg=" + e.getMessage());
                }
            } else {
                Tool.alertMSG(null, String.valueOf(keyact) + Messages.getString("WebTestCreator.28"));
            }
            s_viewer.setVisible(false);
        } else {
            Tool.alertMSG(null, String.valueOf(Messages.getString("WebTestCreator.29")) + e_msg);
        }
        return -1;
    }

    @Override
    protected int createTestRecords(String s) {
        s_viewer.setVisible(true);
        HashMap<String, MacroActions> t_macros = new HashMap<String, MacroActions>();
        Pattern macro_pat = Pattern.compile("<macro_template\\s+([^>]*)>\\s*([\\s\\S]+?)\\s*</macro_template>");
        Matcher t_m = macro_pat.matcher(s);
        while (t_m.find()) {
            Tool.logIfDebug(null, String.valueOf(Messages.getString("WebTestCreator.1")) + t_m.group(1));
            this.createMacroTemplate(t_m.group(1), t_m.group(2), t_macros);
            if (t_macros.size() != 0) continue;
            s_viewer.setVisible(false);
            return -1;
        }
        String panelName = "";
        String head = "";
        if (t_macros.size() == 1) {
            for (Map.Entry entry : t_macros.entrySet()) {
                String[] name_data = ((String)entry.getKey()).split("_", -1);
                head = name_data[1].equals("submit") ? "S." : "C.";
                panelName = name_data[0];
            }
        } else {
            Tool.alertMSG(null, Messages.getString("WebTestCreator.9"));
            s_viewer.setVisible(false);
            return -1;
        }
        ArrayList<TestCaseRecord> t_list = Tool._db().getTestCaseList(String.valueOf(head) + panelName + "%", 0, 0, Tool.group_code, Tool.version);
        ArrayList<String> testCases = new ArrayList<String>();
        int i = 0;
        while (i < t_list.size()) {
            testCases.add(t_list.get(i).getCaseName());
            ++i;
        }
        Pattern case_pat1 = Pattern.compile("<testcase\\s+([^>]*)>\\s*([\\s\\S]+?)\\s*</testcase>");
        t_m = case_pat1.matcher(s);
        while (t_m.find()) {
            String t_attr = t_m.group(1);
            Tool.logIfDebug(null, String.valueOf(Messages.getString("WebTestCreator.3")) + t_attr);
            String t_data = t_m.group(2);
            try {
                String t_msg = this.createTestCase(t_macros, t_attr, t_data, testCases);
                if (t_msg.length() <= 0) continue;
                Tool.logForTesting(null, t_msg);
                s_viewer.setVisible(false);
                return -2;
            }
            catch (Throwable e) {
                Tool.logForTesting(null, String.valueOf(Messages.getString("WebTestCreator.30")) + e.getMessage());
            }
        }
        if (testCases.size() > 0) {
            int i2 = 0;
            while (i2 < testCases.size()) {
                try {
                    Tool._db().removeCase((String)testCases.get(i2), Tool.version);
                }
                catch (SQLException e) {
                    Tool.alertMSG(null, String.valueOf(Messages.getString("WebTestCreator.11")) + (String)testCases.get(i2));
                    s_viewer.setVisible(false);
                    return 0;
                }
                ++i2;
            }
        }
        Tool.logIfDebug(null, "Succeeded @ " + new Date());
        WebTestCreator.setStatus("Succeeded @ " + new Date());
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        s_viewer.setVisible(false);
        return 0;
    }

    private void createMacroTemplate(String attr, String s, HashMap<String, MacroActions> macros) {
        String t_options;
        Pattern submit_action_map_pat;
        Pattern input_positions_pat;
        Pattern outerset_positions_pat;
        Pattern mile_pat;
        Pattern tto_pat;
        Pattern tfrom_pat;
        Pattern frame_pat;
        Pattern title_pat;
        HashMap<String, String> t_map = new HashMap<String, String>();
        Matcher t_m = attribute_pat.matcher(attr);
        while (t_m.find()) {
            t_map.put(t_m.group(1), t_m.group(2));
        }
        MacroActions t_act = new MacroActions();
        Pattern url_pat = Pattern.compile("<url>([\\s\\S]+?)</url>");
        t_m = url_pat.matcher(s);
        if (t_m.find() && t_m.group(1).length() > 0) {
            Fson.updateByJsonPath(t_act, "$.arg_map.url", t_m.group(1));
        }
        if ((t_m = (title_pat = Pattern.compile("<window_title>([\\s\\S]+?)</window_title>")).matcher(s)).find() && t_m.group(1).length() > 0) {
            Fson.updateByJsonPath(t_act, "$.arg_map.title", t_m.group(1));
        }
        if ((t_m = (frame_pat = Pattern.compile("<frame>([\\s\\S]+?)</frame>")).matcher(s)).find() && t_m.group(1).length() > 0) {
            Fson.updateByJsonPath(t_act, "$.arg_map.frame", t_m.group(1));
        }
        if ((t_m = (tfrom_pat = Pattern.compile("<trans_from>([\\s\\S]+?)</trans_from>")).matcher(s)).find()) {
            Fson.updateByJsonPath(t_act, "$.trans_from", "[" + t_m.group(1) + "]");
        }
        if ((t_m = (tto_pat = Pattern.compile("<trans_to>([\\s\\S]+?)</trans_to>")).matcher(s)).find()) {
            Fson.updateByJsonPath(t_act, "$.trans_to", t_m.group(1));
        }
        if ((t_m = (mile_pat = Pattern.compile("<checkpoints>([\\s\\S]+?)</checkpoints>")).matcher(s)).find()) {
            Fson.updateByJsonPath(t_act, "$.checkpoints_map", t_m.group(1));
        }
        String pName = (String)t_map.get("panelName");
        ArrayList<PageAction> act_list = new ArrayList<PageAction>();
        Pattern outerset_pat = Pattern.compile("<outerset>([\\s\\S]+?)</outerset>");
        t_m = outerset_pat.matcher(s);
        if (t_m.find()) {
            String t_str = t_m.group(1).trim().replaceAll(Pattern.quote("\\''"), "\"");
            Pattern dbset_pat = Pattern.compile("<dbset.*?/>");
            t_m = dbset_pat.matcher(t_str);
            while (t_m.find()) {
                PageAction sub_act = this.makeAtomAction(t_m.group(), pName, null);
                act_list.add(sub_act);
            }
            Pattern before_pat = Pattern.compile("<before.*?/>");
            t_m = before_pat.matcher(t_str);
            while (t_m.find()) {
                PageAction sub_act = this.makeAtomAction(t_m.group(), pName, null);
                act_list.add(sub_act);
            }
        }
        if ((t_m = (outerset_positions_pat = Pattern.compile("<outerset_positions>([\\s\\S]+?)</ouyterset_positions>")).matcher(s)).find()) {
            String t_str = t_m.group(1).trim();
            String[] str_setter = t_str.split("\n", -1);
            String t_json = "{";
            int i = 0;
            while (i < str_setter.length) {
                String[] set_data = str_setter[i].split(":\t", -1);
                t_json = String.valueOf(t_json) + "\"" + set_data[0] + "\":[" + set_data[1] + "],";
                ++i;
            }
            if (t_json.length() > 1) {
                t_json = String.valueOf(t_json.substring(0, t_json.length() - 1)) + "}";
                Fson.updateByJsonPath(t_act, "$.outerset_poslist", t_json);
            }
        }
        if ((t_m = (input_positions_pat = Pattern.compile("<input_positions>([\\s\\S]+?)</input_positions>")).matcher(s)).find()) {
            String t_str = t_m.group(1).trim();
            String[] str_setter = t_str.split("\n", -1);
            String t_json = "{";
            int i = 0;
            while (i < str_setter.length) {
                String[] set_data = str_setter[i].split(":\t", -1);
                t_json = String.valueOf(t_json) + "\"" + set_data[0] + "\":[" + set_data[1] + "],";
                ++i;
            }
            if (t_json.length() > 1) {
                t_json = String.valueOf(t_json.substring(0, t_json.length() - 1)) + "}";
                Fson.updateByJsonPath(t_act, "$.input_poslist", t_json);
            }
        }
        ArrayList<PageAction> input_acts = new ArrayList<PageAction>();
        Pattern inputs_pat = Pattern.compile("<inputs>([\\s\\S]+?)</inputs>");
        t_m = inputs_pat.matcher(s);
        if (t_m.find()) {
            String t_str = t_m.group(1);
            String[] str_inputs = t_str.split(",\t", -1);
            int i = 0;
            while (i < str_inputs.length) {
                ArrayList<PageAction> t_list = new ArrayList<PageAction>();
                String[] sub_acts = str_inputs[i].split("/>", 0);
                int j = 0;
                while (j < sub_acts.length) {
                    if (sub_acts[j].length() > 0) {
                        PageAction sub_act = this.makeAtomAction(sub_acts[j], pName, null);
                        t_list.add(sub_act);
                    }
                    ++j;
                }
                if (t_list.size() > 0) {
                    MacroActions t_macro = new MacroActions();
                    t_macro.setUnitedActions(t_list);
                    input_acts.add(t_macro);
                } else {
                    input_acts.add(null);
                }
                ++i;
            }
            if (input_acts.size() > 0) {
                t_act.setInputActions(input_acts);
            }
        }
        if ((t_m = (submit_action_map_pat = Pattern.compile("<submit_map>([\\s\\S]+?)</submit_map>")).matcher(s)).find()) {
            HashMap<String, ArrayList<PageAction>> submit_map = new HashMap<String, ArrayList<PageAction>>();
            String t_str = t_m.group(1).trim();
            String[] str_setter = t_str.split("\n", -1);
            int i = 0;
            while (i < str_setter.length) {
                String[] set_data = str_setter[i].split(",\t", -1);
                int j = 0;
                while (j < set_data.length) {
                    String[] temp = set_data[j].split(":\t", -1);
                    String t_key = temp[0].trim();
                    String[] action_data = temp[1].trim().split("/>", 0);
                    ArrayList<PageAction> t_list = new ArrayList<PageAction>();
                    int k = 0;
                    while (k < action_data.length) {
                        PageAction sub_act = this.makeAtomAction(action_data[k], pName, macros);
                        if (sub_act != null) {
                            t_list.add(sub_act);
                        } else {
                            Tool.logForTesting(null, "src = " + temp[1] + "\nelm @k=" + Integer.toString(k) + Messages.getString("WebTestCreator.54"));
                        }
                        ++k;
                    }
                    if (t_list.size() > 0) {
                        submit_map.put(t_key, t_list);
                    }
                    ++j;
                }
                ++i;
            }
            if (submit_map.size() > 0) {
                t_act.setSubmitMap(submit_map);
            }
        }
        if ((t_options = (String)t_map.get("type")) == null) {
            t_options = "";
        }
        t_act.options = t_options;
        macros.put(String.valueOf(pName) + t_options, t_act);
        try {
            WebTestCreator.setStatus("Saving JsonTemplatee=" + pName + t_options);
            Tool.saveJSONfromObject(String.valueOf(pName) + t_options, t_act, "(arg_map|options|trans_|action|poslist|checkpoints)");
        }
        catch (SQLException e) {
            Tool.logForTesting(e, String.valueOf(Messages.getString("WebTestCreator.59")) + pName + ".");
        }
    }

    protected PageAction makeAtomAction(String s, String panelName, HashMap<String, MacroActions> macros) {
        HashMap<String, String> t_map = new HashMap<String, String>();
        Matcher t_m = attribute_pat.matcher(s);
        while (t_m.find()) {
            String t_str = t_m.group(2);
            t_map.put(t_m.group(1), t_str);
        }
        if (t_map.containsKey("$VAR")) {
            t_map.put("$VAR", ((String)t_map.get("$VAR")).replaceAll(Pattern.quote("\\''"), "\""));
        }
        PageAction t_act = null;
        if (s.startsWith("<$KEY")) {
            t_act = new IndexSetter();
        } else if (s.startsWith("<click")) {
            t_act = new Click();
        } else if (s.startsWith("<hover")) {
            t_act = new Hover();
        } else if (s.startsWith("<snapshot")) {
            t_act = new Snap();
        } else if (s.startsWith("<sendkeys")) {
            t_act = new SendKeys();
        } else if (s.startsWith("<verify")) {
            t_act = new Verify();
        } else if (s.startsWith("<hand")) {
            t_act = new UseHand();
        } else if (s.startsWith("<startClock")) {
            t_act = new Clock();
        } else if (s.startsWith("<endClock")) {
            t_act = new Clock();
            t_act.options = "end";
        } else if (s.startsWith("<sleep")) {
            t_act = new Sleep();
        } else if (s.startsWith("<drag")) {
            t_act = new Drag();
        } else if (s.startsWith("<drop")) {
            t_act = new Drop();
        } else if (s.startsWith("<checkfor")) {
            t_act = new CheckFor();
        } else if (s.startsWith("<prompt")) {
            t_act = new Prompt();
        } else if (s.startsWith("<alert")) {
            t_act = new CheckFor();
            t_act.options = "Alert";
        } else {
            if (s.startsWith("<validate")) {
                MacroActions x_act = new MacroActions();
                ArrayList<PageAction> t_list = new ArrayList<PageAction>();
                if (t_map.containsKey("title")) {
                    CheckFor t_ch = new CheckFor();
                    t_ch.options = "ToWindow";
                    Fson.updateByJsonPath(t_ch, "$.arg_map.title", (String)t_map.get("title"));
                    t_list.add(t_ch);
                } else if (t_map.containsKey("frame")) {
                    ToFrame t_ch = new ToFrame();
                    String str_id = (String)t_map.get("frame");
                    if (str_id.startsWith("src=")) {
                        str_id = str_id.substring(4);
                        Fson.updateByJsonPath(t_ch, "$.arg_map.src", str_id);
                    } else if (str_id.startsWith("title=")) {
                        str_id = str_id.substring(6);
                        Fson.updateByJsonPath(t_ch, "$.arg_map.title", str_id);
                    } else if (str_id.startsWith("xpath=")) {
                        str_id = str_id.substring(6);
                        Fson.updateByJsonPath(t_ch, "$.arg_map.xpath", str_id);
                    } else if (str_id.startsWith("name=")) {
                        str_id = str_id.substring(5);
                        Fson.updateByJsonPath(t_ch, "$.arg_map.name", str_id);
                    }
                    t_list.add(t_ch);
                }
                x_act.setUnitedActions(t_list);
                return x_act;
            }
            if (s.startsWith("<panel")) {
                String p_name = (String)t_map.get("id");
                if (p_name == null) {
                    p_name = panelName;
                }
                String btn_name = (String)t_map.get("action");
                String param_name = (String)t_map.get("param");
                MacroActions x_act = new MacroActions();
                Fson.updateByJsonPath(x_act, "$.key4actions", String.valueOf(p_name) + "\t" + param_name + "\t" + btn_name);
                return x_act;
            }
            if (s.startsWith("<jqexec")) {
                JQExec x_act = new JQExec();
                if (t_map.containsKey("script")) {
                    String t_script = (String)t_map.get("script");
                    Fson.updateByJsonPath(x_act, "$.arg_map.script", "(java.lang.String)" + t_script);
                    String t_args = (String)t_map.get("args");
                    String[] arg_array = t_args.split(",\t", 0);
                    ArrayList<String> t_list = new ArrayList<String>();
                    int i = 0;
                    while (i < arg_array.length) {
                        t_list.add(arg_array[i]);
                        ++i;
                    }
                    Fson.updateByJsonPath(x_act, "$.arg_map.arg_values", Tool.getJSONfromObject(t_list));
                    Fson.updateByJsonPath(x_act, "$.arg_map.xpath", (String)t_map.get("xpath"));
                } else {
                    Tool.alertMSG(null, "No Javascript.");
                }
                if (t_map.containsKey("value")) {
                    Fson.updateByJsonPath(x_act, "$.arg_map.value", (String)t_map.get("value"));
                }
                return x_act;
            }
            if (s.startsWith("<dbtest")) {
                t_act = new DBGetter();
                Fson.updateByJsonPath(t_act, "$.arg_map.jpath", "(java.lang.String)dbtest " + (String)t_map.get("jpath"));
                Fson.updateByJsonPath(t_act, "$.arg_map.value", "(java.lang.String)" + (String)t_map.get("value"));
                return t_act;
            }
            if (s.startsWith("<dbset")) {
                t_act = new DBSetter();
                Fson.updateByJsonPath(t_act, "$.arg_map.jpath", "(java.lang.String)dbset " + (String)t_map.get("jpath"));
                Fson.updateByJsonPath(t_act, "$.arg_map.value", "(java.lang.String)" + (String)t_map.get("setter"));
                return t_act;
            }
            if (s.startsWith("<after")) {
                t_act = new AfterAction();
                ArrayList<String> t_arg = new ArrayList<String>();
                t_arg.add("(java.lang.String)" + (String)t_map.get("path"));
                t_arg.add("(java.lang.String)" + (String)t_map.get("cmd"));
                Fson.updateByJsonPath(t_act, "$.arg_map.value", Tool.getJSONfromObject(t_arg));
                return t_act;
            }
            if (s.startsWith("<before")) {
                t_act = new BeforeAction();
                ArrayList<String> t_arg = new ArrayList<String>();
                t_arg.add("(java.lang.String)" + (String)t_map.get("path"));
                t_arg.add("(java.lang.String)" + (String)t_map.get("cmd"));
                Fson.updateByJsonPath(t_act, "$.arg_map.value", Tool.getJSONfromObject(t_arg));
                return t_act;
            }
            if (s.matches("^<[\\w\\.]+\\.[A^Z]\\w+\\s.*$")) {
                String c_name = s.replaceFirst("^<([\\w\\.]+\\.[A^Z]\\w+)\\s.*$", "$1");
                try {
                    Class<?> t_c = Tool.forName(c_name);
                    t_act = (PageAction)Tool.newObject(t_c, new Class[0], new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    Tool.logIfDebug(e, null);
                }
            }
        }
        for (Map.Entry entry : t_map.entrySet()) {
            Fson.updateByJsonPath(t_act, "$.arg_map." + (String)entry.getKey(), (String)entry.getValue());
        }
        if (t_act == null) {
            Tool.logIfDebug(null, String.valueOf(Messages.getString("WebTestCreator.41")) + s);
        }
        return t_act;
    }

    private String createTestCase(HashMap<String, MacroActions> xmacros, String attr, String s, ArrayList<String> testCases) {
        HashMap<Integer, TestCaseRecord> t_casemap;
        String t_message = "";
        HashMap<String, String> t_map = new HashMap<String, String>();
        Matcher t_m = attribute_pat.matcher(attr);
        while (t_m.find()) {
            t_map.put(t_m.group(1), t_m.group(2));
        }
        HashMap<String, Object> v_map = new HashMap<String, Object>();
        Pattern dbadd_pat = Pattern.compile("<dbadd>([\\s\\S]+?)</dbadd>");
        t_m = dbadd_pat.matcher(s);
        if (t_m.find()) {
            String[] init_cmds = t_m.group(1).split("\n", -1);
            int i = 0;
            while (i < init_cmds.length) {
                String v_key = "dbadd ";
                Pattern db_pat1 = Pattern.compile("(\\w+):=([^,\\[]+?)(,|:\\[)");
                t_m = db_pat1.matcher(init_cmds[i]);
                while (t_m.find()) {
                    String t_key = t_m.group(1);
                    String t_val = t_m.group(2);
                    v_key = String.valueOf(v_key) + "[?(@." + t_key + "='" + t_val + "')]";
                }
                Pattern db_pat2 = Pattern.compile(":(\\[.*)\\s*$");
                t_m = db_pat2.matcher(init_cmds[i]);
                if (t_m.find()) {
                    v_map.put(v_key, Tool.getObjectfromJSON(ArrayList.class, t_m.group(1)));
                }
                ++i;
            }
        }
        ArrayList<String> cmd_datalist = new ArrayList<String>();
        Pattern cmd_pat = Pattern.compile("<testcmd\\s+key=\"([^\"]+)\"\\s*/>");
        t_m = cmd_pat.matcher(s);
        while (t_m.find()) {
            cmd_datalist.add(t_m.group(1).trim());
        }
        String[] casename_parts = ((String)t_map.get("name")).split("_\t", -1);
        String caseName = casename_parts[0];
        if (t_map.containsKey("type")) {
            caseName = ((String)t_map.get("type")).toString().equals("_submit") ? "S." + caseName : "C." + caseName;
        }
        if (casename_parts.length == 2) {
            caseName = String.valueOf(caseName) + "." + casename_parts[1];
        }
        if ((t_casemap = this.lookupTestCaseWithLength(caseName, cmd_datalist.size())) == null) {
            return Messages.getString("WebTestCreator.144");
        }
        HashMap<Integer, TestCommandRecord> t_cmds = new HashMap<Integer, TestCommandRecord>();
        HashMap<String, ObjectRecord> t_objs = new HashMap<String, ObjectRecord>();
        HashMap<Integer, AssertRecord> t_asserts = new HashMap<Integer, AssertRecord>();
        int t_id = 0;
        TestCaseRecord t_case = t_casemap.get(0);
        if (t_case == null) {
            t_case = t_casemap.get(1);
        }
        t_case.changed();
        String xoptions = (String)t_map.get("type");
        if (xoptions == null) {
            xoptions = "";
        }
        if (v_map.size() != 0) {
            TestCommandRecord t_cmd = new TestCommandRecord(2);
            t_cmd.id = t_case.begin + t_id;
            t_cmd.className = "com.ftinc.si.assist.run.VCentral";
            t_cmd.enable = true;
            t_cmd.methodName = "prepare";
            t_cmd.subject = "null";
            t_cmd.setArgTypes("[[java.util.HashMap,$1]]");
            t_cmd.argStatus = "[true,true,true]";
            t_cmd.returnType = "void";
            t_cmd.testCase = t_case.name;
            t_cmds.put(t_id, t_cmd);
            ObjectRecord t_obj = new ObjectRecord(2);
            t_obj.className = "java.util.HashMap";
            t_obj.id = String.valueOf(Integer.toString(t_cmd.id)) + "$1";
            t_obj.stack = "$1";
            t_obj.testCase = t_case.name;
            t_obj.testID = t_cmd.id;
            t_obj.jSON = Tool.getJSONfromObject(v_map);
            t_objs.put(t_obj.id, t_obj);
            AssertRecord t_ast = new AssertRecord(2);
            t_ast.enable = false;
            t_ast.id = t_cmd.id;
            t_asserts.put(t_cmd.id, t_ast);
            ++t_id;
        }
        String browser_json = "null";
        Pattern browser_pat = Pattern.compile("<browser>[\\s\\S]*?</browser>");
        t_m = browser_pat.matcher(s);
        if (t_m.find()) {
            browser_json = t_m.group(1);
        }
        int i = 0;
        while (i < cmd_datalist.size()) {
            TestCommandRecord t_cmd = new TestCommandRecord(2);
            t_cmd.id = t_case.begin + t_id;
            t_cmd.className = "com.ftinc.si.assist.test.web.PagePlayer";
            t_cmd.enable = true;
            t_cmd.methodName = "play";
            t_cmd.subject = "$0";
            t_cmd.setArgTypes("[[java.util.HashMap,$1]]");
            t_cmd.argStatus = "[true,true,true]";
            t_cmd.returnType = "java.util.ArrayList";
            t_cmd.testCase = t_case.name;
            t_cmds.put(t_id, t_cmd);
            ObjectRecord t_obj0 = new ObjectRecord(2, t_case.name, t_cmd.id, 0, PagePlayer.class.getName(), "$0");
            MacroActions t_macro = xmacros.get(String.valueOf(casename_parts[0]) + xoptions);
            if (t_macro == null) {
                JSONRecord t_jdata = JSONRecord.getJSONRec(MacroActions.class.getName(), String.valueOf(casename_parts[0]) + xoptions);
                if (t_jdata == null) {
                    return String.valueOf(Messages.getString("WebTestCreator.164")) + casename_parts[0] + Messages.getString("WebTestCreator.165");
                }
                t_macro = (MacroActions)Tool.getObjectfromJSON(MacroActions.class, t_jdata.content);
            }
            MacroActions r_macro = new MacroActions((String)cmd_datalist.get(i), t_macro, xoptions);
            PagePlayer t_player = new PagePlayer();
            t_player.actions = new ArrayList();
            t_player.actions.add(r_macro);
            t_player.actions.add(new ResetBrowser());
            t_obj0.setJSON(Tool.getJSONfromObject(t_player, "(^actions$|key4actions|arg_map|history|options|path|title|value)"));
            t_objs.put(t_obj0.id, t_obj0);
            ObjectRecord t_obj1 = new ObjectRecord(2, t_case.name, t_cmd.id, 1, "java.util.HashMap", "$1");
            t_obj1.setJSON(browser_json);
            t_objs.put(t_obj1.id, t_obj1);
            ++t_id;
            ++i;
        }
        try {
            WebTestCreator.setStatus("Saving TestSuite=" + t_case.name);
            ArrayList<Record> removings = null;
            if (t_casemap.containsKey(0)) {
                t_message = String.valueOf(Messages.getString("WebTestCreator.0")) + t_case.name + ".";
                Tool._db().clearCase(t_case, true);
            } else if (t_casemap.containsKey(-1)) {
                removings = new ArrayList<Record>();
                removings.add(t_casemap.get(-1));
                Tool._db().clearCase(t_case, true);
            }
            t_message = String.valueOf(Messages.getString("WebTestCreator.184")) + t_case.name + ".";
            if (Tool._db().saveTestCase(t_case, removings, t_cmds, t_objs, t_asserts)) {
                t_message = "";
            }
            if (testCases.contains(t_case.name)) {
                testCases.remove(t_case.name);
            }
        }
        catch (SQLException e) {
            t_message = String.valueOf(t_message) + "\nException=" + e.getMessage();
        }
        return t_message;
    }

    public static void setStatus(String msg) {
        if (s_viewer.isVisible()) {
            s_viewer.update(msg);
        }
    }
}

