package sample;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Servlet implementation class HelloWorld
 */
@WebServlet("/HelloWorld")
public class HelloWorld extends HttpServlet {
	private static final long serialVersionUID = 1L;
	@SuppressWarnings("unused")
	private HttpServletRequest m_request;
	@SuppressWarnings("unused")
	private HttpServletResponse m_response;
	
	@SuppressWarnings("unused")
	private String[] m_regs;
	@SuppressWarnings("unused")
	private ArrayList<String> m_reglist;
	

    /**
     * Default constructor. 
     */
    public HelloWorld() {
        // TODO Auto-generated constructor stub
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		m_request = request;
		m_response = response;
		
		response.setContentType("text/html; charset=Shift_JIS");
		PrintWriter out = response.getWriter();
		
		String i_str = "GET:";
//		i_str += ": getContect = " + response.getContentType() + ":";

		out.println(createHTML(request, i_str));

		out.close();
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		m_request = request;
		m_response = response;

		response.setContentType("text/html; charset=Shift_JIS");
		PrintWriter out = response.getWriter();
		
		String i_str = "POST:";
		i_str += ": getContect = " + response.getContentType() + ":";
		i_str += ": age = " + request.getParameter("age") + ":";
		i_str += ": premium = " + request.getParameter("premium") + ":";
//		i_str += ": cookie = " + request.getCookies()[0].getValue() + ":";

		out.println(createHTML(request, i_str));

		out.close();
	}

	private String createHTML(HttpServletRequest request, String methodType){
		StringBuffer sb = new StringBuffer();

		sb.append("<!DOCTYPE html><html>");
		sb.append("<head>");
		sb.append("<title>Hello!</title>");
		sb.append("</head>");
		sb.append("<body>");

		sb.append("<p>");
		sb.append(methodType);
		sb.append("メソッドで呼び出されました</p>");

		String str_age = request.getParameter("age");
		
		int age = new Integer(str_age);
		String str_premimum = request.getParameter("premium");
		boolean b_prem = new Boolean(str_premimum);
		String str_off = "";

		if (str_age != null && str_age.matches("^[0-9]+$")) {
			if ("true".equals(str_premimum)) {
				b_prem = true;
			}
			
			if (age > 50) {
				//年齢がシニア
				if (b_prem) {
					//優良会員
					str_off = "40";
				} else {
					str_off = "20";
				}
			} else {
				//シニア以前
				if (b_prem) {
					//優良会員
					str_off = "30";
				} else {
					str_off = "10";
				}
			}
			
		}
		sb.append("<p id='premium'>会員割引=" + Boolean.toString(b_prem) + "</p>");
		sb.append("<p id='senior'>シニア割引=" + Boolean.toString(age > 50) + ";</p>");
		sb.append("<p id='offrate'>割引率=" + str_off + ";</p>");

		sb.append("<p><a href=\"/HelloWorld\">リンク</a></p>");

		sb.append("<form action=\"/HelloWorld\" method=\"post\">");
		sb.append("<input id=\"001\" type=\"submit\" value=\"POSTで送信\"></input>");
		sb.append("</form>");
		
		sb.append(m_value);

		sb.append("</body>");
		sb.append("</html>");

		return (new String(sb));

	}
	
	private String m_value;
	public void setValue(String astr) {
		m_value = astr;
	}
	
}
