package com.ftinc.si.assist.test.web;

import java.util.ArrayList;
import java.util.HashMap;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

import com.ftinc.si.assist.test.Tool;

public class FileUpload extends PageAction {

	
	@Override
	protected void doCore(WebDriver drv, WebElement elm) {
		if (elm != null) {
			Object t_file = arg_map.get("file");
			elm.sendKeys(t_file.toString() + "\n");
		} else {
			throw new NotFoundException("FileNotFound:" + getTarget()); //$NON-NLS-1$
		}
	}

	
	//WebElementGetterのArgument欄の値を指定する。
	protected ArrayList<String> getLabelAndParams() {
		ArrayList<String> t_list2 = new ArrayList<String>();
		t_list2.add("File Name");
		Object t_keys = arg_map.get("file"); //$NON-NLS-1$
		if (t_keys != null) {
			t_list2.add(t_keys.toString());
		}
		return t_list2;
	}

	
	//このPageActionが対象とするXPathの配列を返す。入力可能なタグ以外対象外なので引数に影響されない。
	protected String[] getFocussingXPaths(String xpath) {
		if (xpath != null && xpath.length() > 0) {
			//target欄が何かしらタグ検索情報を指定している場合に、この分岐に入る。
			if (xpath.startsWith("//")) { //$NON-NLS-1$
				return new String[] {xpath};
			}
			return new String[] {"//" + xpath}; //$NON-NLS-1$
		}
		String[] t_result = {"//input[@type='file']"}; //$NON-NLS-1$
		return t_result;
	}
	
	//PageActionEditorの第二列に書き込む内容を合成する。
	@SuppressWarnings("unchecked")
	protected String getJsonElement(String target, String arg) {
		if (target != null && arg != null) {
			//targetからMapを作り、keysを加えて、Json化した方が安全。
			arg_map = (HashMap<String, Object>)Tool.getObjectfromJSON(HashMap.class, "{" + target + "}"); //$NON-NLS-1$ //$NON-NLS-2$
			arg_map.put("file", arg); //$NON-NLS-1$
		}

		return super.getJsonElement(null, null);
	}
	
	//WebElementGetterから呼ばれる。
	protected JPopupMenu getPopup(WebElementGetter wg, String cur_str) {
		if (hasPath()) {
			JPopupMenu t_pop = new JPopupMenu();
			t_pop.add(new JMenuItem(new InsertAction("Select File", "SelectFile", wg, cur_str))); //$NON-NLS-1$ //$NON-NLS-2$
			return t_pop;
		}
		return null;
	}

}
