package com.ftinc.si.assist.test;

import java.sql.ResultSet;
import java.sql.SQLException;

// String, ArrayListなどはあらかじめRawとして登録しておくこと。
public class ObjectRecord extends Record implements ArgumentIF {
	public ObjectRecord() {
		super(0);
	}

	public ObjectRecord(int i) {
		super(i);
	}
	
	public ObjectRecord(int i, String caseName, int testid, int position, String cname, String xstack) {
		super(i);
		
		testCase = caseName;
		testID = testid;
		
		id = Integer.toString(testid) + "$" + Integer.toString(position);
		className = cname;
		stack = xstack;
	}
	

	public String id; // testID(current)$n
	public String stack;  //$n, testID(past)$n, callstack
	public int testID;
	public String testCase;
	public String className;
	public String jSON; // CustomArgsやエディタなどで編集後のJSON。
	public boolean isPOJO = true; // このオブジェクトが本来のクラスかどうか。FakeならFalse。
	public boolean completed = false;
	
	public String typeName;//ArgumentEditor用
	
	//DBの結果を読み込む
	public void read(ResultSet r) throws SQLException {
		id = r.getString("ID");
		stack = r.getString("Stack");
		isPOJO = r.getBoolean("IsPOJO");
		testID = r.getInt("TestID");
		jSON = r.getString("JSON");
		testCase = r.getString("TestCase");
		className = r.getString("ClassName");
		completed = r.getBoolean("Completed");
	}
	
	// IDはコピーしない。
	public ObjectRecord _dup(boolean not_new) {
		ObjectRecord t_rec = new ObjectRecord(2);
		t_rec.testCase = testCase;
		t_rec.className = className;
		t_rec.isPOJO = isPOJO;
		t_rec.jSON = jSON;
		t_rec.stack = stack;
		if (not_new) {
			t_rec.m_status = m_status;
		}
		t_rec.id = id;
		t_rec.testID = testID;
		t_rec.removed = removed;
		t_rec.completed = completed;//JSONが完成したかどうか。
		
		return t_rec;
	}
	
	public boolean equals(Object xrec) {
		if (xrec == null) {
			return false;
		}
		ObjectRecord rec = (ObjectRecord)xrec;
		
		boolean res = true;
		if (!testCase.equals(rec.testCase)) {
			res = false;
		}
		if (!className.equals(rec.className)) {
			res = false;
		}
		if (jSON == null) {
			if (rec.jSON != null) {
				res = false;
			}
		} else if (!jSON.equals(rec.jSON)) {
			res = false;
		}
		if (!stack.equals(rec.stack)) {
			res = false;
		}
		if (isPOJO != rec.isPOJO) {
			res = false;
		}
		
		return res;
	}
	
	//ダミー
	public int hashCode() {
		assert false;
		return 0;
	}
	
	public String _id() {
		return id;
	}
	
	//DBに格納するためのSQL文では「'」はエスケープ処理のため「''」とする必要がある。
	private String _jSON() {
		return esq(jSON);
	}
	
	public String getUpdateSQL() {
		if (removed && isNew()) {
			return null;//DBに未登録のまま削除
		}

		if (_id() == null) return null;
		
		String t_sql = null;
		if (removed) {
			return "delete from \"tbl_ObjectRecord\" where \"ID\"='" + _id() + "'";
		}

		if (isNew()) {
			// insert
			t_sql = "insert into \"tbl_ObjectRecord\" (\"ID\", \"Stack\", \"IsPOJO\", \"JSON\", \"TestID\", \"TestCase\", "
					+ "\"ClassName\", \"Completed\")"
					+ "values ('" + _id() + "','" + stack + "'," + Boolean.toString(isPOJO) + ",'"	+ _jSON() + "',"
					+ Integer.toString(testID) + ",'" + testCase + "','" + className + "','" + Boolean.toString(isCompleted()) + "')";
		} else if (isUpdated()) {
			// update
			t_sql = "update \"tbl_ObjectRecord\" set \"IsPOJO\"=" + Boolean.toString(isPOJO) + ", \"JSON\"='" + _jSON() + "',\"Stack\"='" + stack
					+ "', \"TestCase\"='" + testCase + "', \"Completed\"='" + Boolean.toString(isCompleted()) + "' where \"ID\"='" + _id() + "'";
		
		}
		return t_sql;
	}
	
	
	public boolean isCompleted() {
		if (completed || stack.matches("^[0-9]+\\$[0-9_]+$") || !isPOJO) {
			return true;
		}
		return false;
	}

	@Override
	public String getTestCase() {
		return testCase;
	}

	@Override
	public String getId() {
		return id;
	}

	@Override
	public int getTestID() {
		return testID;
	}

	@Override
	public String getStack() {
		return stack;
	}

	@Override
	public void setStack(String s) {
		stack = s;
		changed();
	}

	@Override
	public String getClassName() {
		return className;
	}

	@Override
	public void setClassName(String s) {
		className = s;
	}

	@Override
	public String getJSON() {
		return jSON;
	}

	@Override
	public void setJSON(String s) {
		jSON = s;
		if (s != null && s.length() > 0) {
			completed = true;
		} else {
			completed = false;
		}
		changed();
	}

	@Override
	public boolean isPOJO() {
		return isPOJO;
	}

	@Override
	public void setPOJO(boolean b) {
		isPOJO = b;
		changed();
	}
}
