package com.ftinc.si.assist.test.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;

import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.TestCommandRecord;

public class ReuseArguments extends JDialog {
	private ArrayList<Integer> m_ids;
	private HashMap<Integer, TestCommandRecord> m_cmds;
	private HashMap<Integer, String[]> m_args;
	private int target_id;
	private String target_arg;

	public ReuseArguments(JDialog owner, ArrayList<Integer> tlist, HashMap<Integer, TestCommandRecord> cmds, HashMap<Integer, String[]> map) {
		super(owner, true); // modalにする。

		m_ids = tlist;
		m_cmds = cmds;
		m_args = map;

		setResizable(false);
		setTitle(Messages.getString("ReuseArguments.0")); //$NON-NLS-1$
		getContentPane().setLayout(null);
		setBounds(owner.getX() + 100, owner.getY() + 100, 600, 451);

		JLabel lblTestcommands = new JLabel(Messages.getString("ReuseArguments.1")); //$NON-NLS-1$
		lblTestcommands.setBounds(12, 10, 123, 13);
		getContentPane().add(lblTestcommands);


		JButton btnCancel = new JButton(Messages.getString("ReuseArguments.2")); //$NON-NLS-1$
		btnCancel.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				target_id = -1;
				setVisible(false);
			}
		});
		btnCancel.setBounds(306, 391, 73, 21);
		getContentPane().add(btnCancel);

		DefaultListModel<String> model = new DefaultListModel<String>();

		for (int i = 0; i < m_ids.size(); i ++) {
			TestCommandRecord t_rec = m_cmds.get(i);
			model.addElement(Integer.valueOf(t_rec.id).toString() + "\t" + t_rec.className + "\t" + t_rec.methodName); //$NON-NLS-1$ //$NON-NLS-2$
		}

		final JList<String> list = new JList<String>(model);
		list.setBounds(12, 33, 570, 177);
		getContentPane().add(list);

		JLabel lblArguments = new JLabel(Messages.getString("ReuseArguments.5")); //$NON-NLS-1$
		lblArguments.setBounds(12, 234, 73, 13);
		getContentPane().add(lblArguments);

		//引数のリスト
		final JList<String> list_1 = new JList<String>();
		list_1.setBounds(12, 257, 570, 124);
		getContentPane().add(list_1);

		//クラスメソッドのリストが選択されたら、引数をlist_1に展開する。
		list.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				String t_str = (String) list.getSelectedValue();
				String[] temp = t_str.split("\t"); //$NON-NLS-1$
				Integer t_i = Integer.valueOf(temp[0]);

				String[] t_args = m_args.get(t_i);
				DefaultListModel<String> t_model = new DefaultListModel<String>();
				for (int i = 0; i < t_args.length; i++) {
					t_model.addElement(t_args[i]);
				}
				list_1.setModel(t_model);

				target_id = t_i;
			}
		});
		list_1.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				target_arg = (String) list_1.getSelectedValue();
				target_arg = target_arg.replaceFirst("^\\[[^,]+,([^,]+)\\]$", "$1");
			}
		});

		JButton btnOk = new JButton(Messages.getString("ReuseArguments.7")); //$NON-NLS-1$
		btnOk.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				setVisible(false);
			}
		});
		btnOk.setBounds(217, 391, 61, 21);
		getContentPane().add(btnOk);

	}

	public int getID() {
		return target_id;
	}

	public String getArg() {
		return target_arg;
	}


}
