package com.ftinc.si.assist.test.gui;

import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.Tool;

public class SimpleTextEditor extends JDialog {
	private final JTextArea textArea = new JTextArea();
	private boolean is_ok = false;

	public SimpleTextEditor(JDialog owner, String src, boolean isModal) {
		super(owner, isModal);
		setResizable(false);
		setTitle(Messages.getString("SimpleTextEditor.0")); //$NON-NLS-1$
		getContentPane().setLayout(null);
		
		int x = 0, y = 0;
		if (owner != null) {
			x = owner.getX();
			y = owner.getY();
		}
		setBounds(x + 100, y + 100, 500, 300);
		
		JButton btnOk = new JButton(Messages.getString("SimpleTextEditor.1")); //$NON-NLS-1$
		btnOk.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				is_ok = true;
				setVisible(false);
			}
		});
		btnOk.setBounds(141, 240, 91, 21);
		getContentPane().add(btnOk);
		
		JButton btnCancel = new JButton(Messages.getString("SimpleTextEditor.2")); //$NON-NLS-1$
		btnCancel.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				setVisible(false);
			}
		});
		btnCancel.setBounds(248, 240, 91, 21);
		getContentPane().add(btnCancel);
		
		if (!isModal) {
			btnCancel.setEnabled(false);
//			textArea.setEditable(false);
		}
		
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setBounds(0, 0, 492, 234);
		getContentPane().add(scrollPane);
		textArea.addMouseWheelListener(new MouseWheelListener() {
			public void mouseWheelMoved(MouseWheelEvent e) {
				//マウスホイールの操作により、フォントサイズを変える。
				Font t_font = Tool.resizeFont(e, textArea.getFont());
				if (t_font != null) {
					textArea.setFont(t_font);
				}
			}
		});
		scrollPane.setViewportView(textArea);
		
		textArea.setText(src);
	}
	
	public void setText(String str) {
		textArea.setText(str);
	}
	
	public String getText() {
		if (is_ok && textArea.getText().length() > 0) {
			return textArea.getText();
		}
		return null;
	}
}
