package com.ftinc.si.assist.test.web;

import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

import com.ftinc.si.assist.run.Messages;

//フォーカス移動を行う。
public class Hover extends PageAction {
	
	@Override
	protected void doCore(WebDriver drv, WebElement elm) {
		if (elm != null) {
			if ("input".equals(elm.getTagName())) {
				elm.sendKeys("");
			} else {
				new Actions(drv).moveToElement(elm).perform();
			}
		} else {
			String target = getTarget();
			if (arg_map.containsKey("itemID")) {
				target += " itemID=" + arg_map.get("itemID").toString();
			}
			throw new NotFoundException("\t\thover " + Messages.getString("Click.1") + target); //$NON-NLS-1$
		}
	}
}
