/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.gui;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.gui.EnvironmentData;
import com.ftinc.si.assist.test.gui.Plugin;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class EnvironmentDialog
extends JDialog {
    private JTextField serverName;
    private JTextField port;
    private JTextField dbName;
    private JTextField encode;
    private JTextField uID;
    private JTextField pwd;
    private JList<String> rootDirs;
    private boolean hiddenMode = false;
    private boolean processMode = false;
    private JTextField textFakeDir;
    private JTextField textLogFile;
    private JTextField caseUnitSize;
    private JList<String> pluginList;
    private HashMap<String, HashMap<String, String>> plugins_properties;
    private JCheckBox chckbxRemote;
    private JTextField textGroupCode;
    private JTextArea aliasNames;
    private JCheckBox chckbxDebugmode;
    private JButton btnCreateTable;
    private EnvironmentData old_env;
    private boolean checkedResult;
    private JTextField versionText;
    public boolean is_ok = false;

    public EnvironmentDialog(JFrame owner, EnvironmentData env) {
        super((Frame)owner, true);
        this.hiddenMode = env.hiddenMode;
        this.processMode = env.process_mode;
        this.old_env = (EnvironmentData)Tool.getObjectfromJSON(EnvironmentData.class, Tool.getJSONfromObject(env));
        this.setResizable(false);
        if (owner != null) {
            this.setBounds(owner.getX() + 100, owner.getY() + 100, 450, 300);
        } else {
            this.setBounds(100, this.getY() + 100, 450, 300);
        }
        this.setTitle(Messages.getString("EnvironmentDialog.0"));
        this.getContentPane().setLayout(null);
        this.plugins_properties = env.plugins_properties == null ? new HashMap() : env.plugins_properties;
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.setBounds(0, 0, 444, 271);
        this.getContentPane().add(tabbedPane);
        JPanel panel = new JPanel();
        tabbedPane.addTab(Messages.getString("EnvironmentDialog.1"), null, panel, null);
        panel.setLayout(null);
        JButton btnApply = new JButton(Messages.getString("EnvironmentDialog.2"));
        btnApply.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EnvironmentDialog.this.is_ok = true;
                EnvironmentDialog.this.setVisible(false);
            }
        });
        btnApply.setBounds(336, 213, 91, 21);
        panel.add(btnApply);
        JCheckBox chckbxHideDisabled = new JCheckBox(Messages.getString("EnvironmentDialog.3"), this.hiddenMode);
        chckbxHideDisabled.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EnvironmentDialog.this.hiddenMode = !EnvironmentDialog.this.hiddenMode;
            }
        });
        chckbxHideDisabled.setBounds(8, 21, 103, 21);
        panel.add(chckbxHideDisabled);
        JLabel lblRootDirectoryFor = new JLabel(Messages.getString("EnvironmentDialog.4"));
        lblRootDirectoryFor.setBounds(8, 75, 224, 13);
        panel.add(lblRootDirectoryFor);
        this.textFakeDir = new JTextField(env.fakedir);
        this.textFakeDir.setBounds(18, 98, 341, 19);
        panel.add(this.textFakeDir);
        this.textFakeDir.setColumns(10);
        JButton dirButton = new JButton(Messages.getString("EnvironmentDialog.5"));
        dirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser f_dlg = new JFileChooser(Tool.getPrevPath());
                f_dlg.setFileSelectionMode(1);
                int i = f_dlg.showSaveDialog(null);
                if (i == 0) {
                    File t_file = f_dlg.getSelectedFile();
                    EnvironmentDialog.this.textFakeDir.setText(String.valueOf(t_file.getAbsolutePath()) + "\\");
                    Tool.setPrevPath(t_file.getAbsolutePath());
                }
            }
        });
        dirButton.setBounds(370, 97, 57, 21);
        panel.add(dirButton);
        JLabel lblLogFile = new JLabel(Messages.getString("EnvironmentDialog.8"));
        lblLogFile.setBounds(8, 143, 103, 13);
        panel.add(lblLogFile);
        this.textLogFile = new JTextField(env.logdir);
        this.textLogFile.setBounds(18, 166, 341, 19);
        panel.add(this.textLogFile);
        this.textLogFile.setColumns(10);
        JButton btnLogButton = new JButton(Messages.getString("EnvironmentDialog.9"));
        btnLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser f_dlg = new JFileChooser(Tool.getPrevPath());
                f_dlg.setFileSelectionMode(1);
                int i = f_dlg.showSaveDialog(null);
                if (i == 0) {
                    File t_file = f_dlg.getSelectedFile();
                    EnvironmentDialog.this.textLogFile.setText(String.valueOf(t_file.getAbsolutePath()) + "\\");
                    Tool.setPrevPath(t_file.getAbsolutePath());
                }
            }
        });
        btnLogButton.setBounds(370, 165, 57, 21);
        panel.add(btnLogButton);
        JLabel lblUnitSizeOf = new JLabel(Messages.getString("EnvironmentDialog.lblUnitSizeOf.text"));
        lblUnitSizeOf.setBounds(199, 25, 109, 13);
        panel.add(lblUnitSizeOf);
        this.caseUnitSize = new JTextField(Integer.toString(env.caseSize));
        this.caseUnitSize.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                EnvironmentDialog.this.checkedResult = Tool.checkInteger(EnvironmentDialog.this.caseUnitSize.getText(), e, 1000, 0);
                if (!EnvironmentDialog.this.checkedResult) {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!EnvironmentDialog.this.checkedResult) {
                    e.consume();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (!EnvironmentDialog.this.checkedResult) {
                    e.consume();
                }
            }
        });
        this.caseUnitSize.enableInputMethods(false);
        this.caseUnitSize.setHorizontalAlignment(4);
        this.caseUnitSize.setText(Integer.toString(env.caseSize));
        this.caseUnitSize.setBounds(302, 22, 96, 19);
        panel.add(this.caseUnitSize);
        this.caseUnitSize.setColumns(10);
        JCheckBox chckbxProcessMode = new JCheckBox(Messages.getString("EnvironmentDialog.chckbxRemoteMode.text"), this.processMode);
        chckbxProcessMode.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EnvironmentDialog.this.processMode = !EnvironmentDialog.this.processMode;
            }
        });
        chckbxProcessMode.setBounds(8, 213, 156, 21);
        panel.add(chckbxProcessMode);
        this.chckbxDebugmode = new JCheckBox(Messages.getString("EnvironmentDialog.chckbxDebugmode.text"));
        this.chckbxDebugmode.setBounds(194, 213, 103, 21);
        panel.add(this.chckbxDebugmode);
        this.chckbxDebugmode.setSelected(env.debug_mode);
        JPanel panel_1 = new JPanel();
        tabbedPane.addTab(Messages.getString("EnvironmentDialog.11"), null, panel_1, null);
        panel_1.setLayout(null);
        JLabel lblTargetRootFolder = new JLabel(Messages.getString("EnvironmentDialog.12"));
        lblTargetRootFolder.setBounds(12, 10, 188, 13);
        panel_1.add(lblTargetRootFolder);
        final DefaultListModel<String> rootModel = new DefaultListModel<String>();
        int i = 0;
        while (i < env.rootDirs.size()) {
            rootModel.addElement(env.rootDirs.get(i));
            ++i;
        }
        this.rootDirs = new JList(rootModel);
        this.rootDirs.setBounds(12, 33, 317, 175);
        panel_1.add(this.rootDirs);
        JButton btnAddDir = new JButton(Messages.getString("EnvironmentDialog.13"));
        btnAddDir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JFileChooser t_fc = new JFileChooser(Tool.getPrevPath());
                t_fc.setFileSelectionMode(2);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Jar(*.jar)", "jar");
                t_fc.addChoosableFileFilter(filter);
                if (t_fc.showOpenDialog(null) == 0) {
                    int i;
                    File t_file = t_fc.getSelectedFile();
                    String t_path = t_file.getAbsolutePath();
                    Tool.setPrevPath(t_file.getAbsolutePath());
                    if (t_file.isDirectory()) {
                        t_path = String.valueOf(t_path) + "\\";
                    }
                    if ((i = rootModel.indexOf(t_path)) < 0) {
                        rootModel.addElement(t_path);
                    }
                }
            }
        });
        btnAddDir.setBounds(339, 33, 88, 21);
        panel_1.add(btnAddDir);
        JButton btnRemove = new JButton(Messages.getString("EnvironmentDialog.15"));
        btnRemove.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!EnvironmentDialog.this.rootDirs.isSelectionEmpty()) {
                    int index = EnvironmentDialog.this.rootDirs.getSelectedIndex();
                    rootModel.removeElementAt(index);
                }
            }
        });
        btnRemove.setBounds(339, 71, 88, 21);
        panel_1.add(btnRemove);
        JButton btnApply_1 = new JButton(Messages.getString("EnvironmentDialog.16"));
        btnApply_1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EnvironmentDialog.this.is_ok = true;
                EnvironmentDialog.this.setVisible(false);
            }
        });
        btnApply_1.setBounds(336, 213, 91, 21);
        panel_1.add(btnApply_1);
        JPanel panel_3 = new JPanel();
        tabbedPane.addTab(Messages.getString("EnvironmentDialog.panel_3.title"), null, panel_3, null);
        panel_3.setLayout(null);
        JLabel lblNewLabel = new JLabel(Messages.getString("EnvironmentDialog.lblNewLabel.text"));
        lblNewLabel.setBounds(12, 10, 115, 13);
        panel_3.add(lblNewLabel);
        final DefaultListModel<String> pluginModel = new DefaultListModel<String>();
        int i2 = 0;
        while (i2 < env.plugins.size()) {
            pluginModel.addElement(env.plugins.get(i2));
            ++i2;
        }
        this.pluginList = new JList(pluginModel);
        this.pluginList.setBounds(12, 33, 312, 174);
        panel_3.add(this.pluginList);
        JButton addPlugin = new JButton(Messages.getString("EnvironmentDialog.btnNewButton_1.text"));
        addPlugin.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String cname = Tool.findClassName(Tool.getParent((Component)e.getSource(), "JDialog"), Tool.target_dirs);
                if (cname != null && cname.length() > 0) {
                    try {
                        Class<?> t_c = Tool.forName(cname);
                        if (Plugin.class.isAssignableFrom(t_c)) {
                            pluginModel.addElement(cname);
                        }
                    }
                    catch (ClassNotFoundException e1) {
                        Tool.alertMSG(null, e1.getMessage());
                    }
                }
            }
        });
        addPlugin.setBounds(336, 33, 91, 21);
        panel_3.add(addPlugin);
        JButton removePlugin = new JButton(Messages.getString("EnvironmentDialog.btnNewButton_2.text"));
        removePlugin.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!EnvironmentDialog.this.pluginList.isSelectionEmpty()) {
                    int index = EnvironmentDialog.this.pluginList.getSelectedIndex();
                    pluginModel.removeElementAt(index);
                    EnvironmentDialog.this.pluginList.remove(index);
                }
            }
        });
        removePlugin.setBounds(336, 68, 91, 21);
        panel_3.add(removePlugin);
        JButton btnClosePlugin = new JButton(Messages.getString("EnvironmentDialog.btnNewButton_1.text_1"));
        btnClosePlugin.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EnvironmentDialog.this.is_ok = true;
                EnvironmentDialog.this.setVisible(false);
            }
        });
        btnClosePlugin.setBounds(336, 213, 91, 21);
        panel_3.add(btnClosePlugin);
        JButton btnEdit = new JButton(Messages.getString("EnvironmentDialog.btnEdit.text"));
        btnEdit.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int i;
                if (!EnvironmentDialog.this.pluginList.isSelectionEmpty() && (i = EnvironmentDialog.this.pluginList.getSelectedIndex()) >= 0) {
                    String c_name = (String)pluginModel.getElementAt(i);
                    HashMap<String, String> t_map = EnvironmentDialog.this.plugins_properties.get(c_name);
                    if (t_map == null) {
                        t_map = new HashMap();
                    }
                    try {
                        Class<?> t_c = Tool.forName(c_name);
                        Plugin t_plugin = (Plugin)Tool.newObject(t_c, null, null);
                        t_plugin.editProperties(t_map);
                    }
                    catch (ClassNotFoundException e1) {
                        Tool.alertMSG(null, "ClassNotFoundException:pluginEdit@EnvironmentDialog:" + e1.getMessage());
                    }
                    catch (SecurityException e1) {
                        Tool.alertMSG(null, "SecurityException:pluginEdit@EnvironmentDialog:" + e1.getMessage());
                    }
                    catch (IllegalArgumentException e1) {
                        Tool.alertMSG(null, "IllegalArgumentException:pluginEdit@EnvironmentDialog:" + e1.getMessage());
                    }
                    catch (NoSuchMethodException e1) {
                        Tool.alertMSG(null, "NoSuchMethodException:pluginEdit@EnvironmentDialog:" + e1.getMessage());
                    }
                    catch (InstantiationException e1) {
                        Tool.alertMSG(null, "InstantiationException:pluginEdit@EnvironmentDialog:" + e1.getMessage());
                    }
                    catch (IllegalAccessException e1) {
                        Tool.alertMSG(null, "IllegalAccessException:pluginEdit@EnvironmentDialog:" + e1.getMessage());
                    }
                    catch (InvocationTargetException e1) {
                        Tool.alertMSG(null, "InvocationTargetException:pluginEdit@EnvironmentDialog:" + e1.getMessage());
                    }
                    if (t_map.size() == 0) {
                        if (EnvironmentDialog.this.plugins_properties.containsKey(c_name)) {
                            EnvironmentDialog.this.plugins_properties.remove(c_name);
                        }
                    } else {
                        EnvironmentDialog.this.plugins_properties.put(c_name, t_map);
                    }
                }
            }
        });
        btnEdit.setBounds(336, 108, 91, 21);
        panel_3.add(btnEdit);
        JPanel panel_2 = new JPanel();
        tabbedPane.addTab(Messages.getString("EnvironmentDialog.17"), null, panel_2, null);
        panel_2.setLayout(null);
        JLabel lblServer = new JLabel(Messages.getString("EnvironmentDialog.18"));
        lblServer.setBounds(12, 10, 69, 13);
        panel_2.add(lblServer);
        this.serverName = new JTextField(env.serverName);
        this.serverName.setBounds(103, 7, 224, 19);
        panel_2.add(this.serverName);
        this.serverName.setColumns(10);
        JLabel lblPort = new JLabel(Messages.getString("EnvironmentDialog.19"));
        lblPort.setBounds(12, 39, 50, 13);
        panel_2.add(lblPort);
        this.port = new JTextField();
        this.port.setText(env.port);
        this.port.setBounds(103, 36, 107, 19);
        panel_2.add(this.port);
        this.port.setColumns(10);
        this.port.enableInputMethods(false);
        this.port.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                EnvironmentDialog.this.checkedResult = Tool.checkInteger(EnvironmentDialog.this.port.getText(), e, 0, 0);
                if (!EnvironmentDialog.this.checkedResult) {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!EnvironmentDialog.this.checkedResult) {
                    e.consume();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (!EnvironmentDialog.this.checkedResult) {
                    e.consume();
                }
            }
        });
        JLabel lblDatabase = new JLabel(Messages.getString("EnvironmentDialog.20"));
        lblDatabase.setBounds(12, 77, 90, 13);
        panel_2.add(lblDatabase);
        if (env.dbName == null || env.dbName.length() == 0) {
            env.dbName = "db_TestCase";
        }
        this.dbName = new JTextField(env.dbName);
        this.dbName.setBounds(103, 74, 224, 19);
        panel_2.add(this.dbName);
        this.dbName.setColumns(10);
        JLabel lblEncoding = new JLabel(Messages.getString("EnvironmentDialog.21"));
        lblEncoding.setBounds(12, 111, 69, 13);
        panel_2.add(lblEncoding);
        this.encode = new JTextField();
        this.encode.setText(env.encode);
        this.encode.setBounds(103, 108, 96, 19);
        panel_2.add(this.encode);
        this.encode.setColumns(10);
        JLabel lblUserid = new JLabel(Messages.getString("EnvironmentDialog.22"));
        lblUserid.setBounds(12, 150, 50, 13);
        panel_2.add(lblUserid);
        JLabel lblPassword = new JLabel(Messages.getString("EnvironmentDialog.23"));
        lblPassword.setBounds(235, 150, 69, 13);
        panel_2.add(lblPassword);
        this.uID = new JTextField(env.uID);
        this.uID.setText(Messages.getString("EnvironmentDialog.24"));
        this.uID.setBounds(101, 147, 109, 19);
        panel_2.add(this.uID);
        this.uID.setColumns(10);
        this.pwd = new JTextField(env.pwd);
        this.pwd.setText(Messages.getString("EnvironmentDialog.25"));
        this.pwd.setBounds(318, 147, 109, 19);
        panel_2.add(this.pwd);
        this.pwd.setColumns(10);
        JButton btnApply_2 = new JButton(Messages.getString("EnvironmentDialog.26"));
        btnApply_2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EnvironmentDialog.this.is_ok = true;
                EnvironmentDialog.this.setVisible(false);
            }
        });
        btnApply_2.setBounds(336, 213, 91, 21);
        panel_2.add(btnApply_2);
        this.chckbxRemote = new JCheckBox(Messages.getString("EnvironmentDialog.chckbxRemote.text"), env.remote_db);
        this.chckbxRemote.setBounds(12, 186, 103, 21);
        panel_2.add(this.chckbxRemote);
        this.btnCreateTable = new JButton(Messages.getString("EnvironmentDialog.btnNewButton.text"));
        this.btnCreateTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Tool._db().createTable();
                if (Tool._db().isReady()) {
                    EnvironmentDialog.this.btnCreateTable.setEnabled(false);
                }
            }
        });
        this.btnCreateTable.setBounds(103, 213, 107, 21);
        panel_2.add(this.btnCreateTable);
        if (Tool._db() != null && Tool._db().isReady()) {
            this.btnCreateTable.setEnabled(false);
        }
        JPanel panel_4 = new JPanel();
        tabbedPane.addTab(Messages.getString("EnvironmentDialog.6"), null, panel_4, null);
        panel_4.setLayout(null);
        JLabel lblGroupCode = new JLabel(Messages.getString("EnvironmentDialog.lblTeamid.text"));
        lblGroupCode.setBounds(12, 21, 107, 13);
        panel_4.add(lblGroupCode);
        this.textGroupCode = new JTextField();
        this.textGroupCode.setText(env.groupCode);
        this.textGroupCode.setBounds(117, 18, 99, 19);
        panel_4.add(this.textGroupCode);
        this.textGroupCode.setColumns(10);
        this.textGroupCode.enableInputMethods(false);
        this.textGroupCode.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                EnvironmentDialog.this.checkedResult = Tool.checkInteger(EnvironmentDialog.this.textGroupCode.getText(), e, 100, 0);
                if (!EnvironmentDialog.this.checkedResult) {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!EnvironmentDialog.this.checkedResult) {
                    e.consume();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (!EnvironmentDialog.this.checkedResult) {
                    e.consume();
                }
            }
        });
        JButton btnClose = new JButton(Messages.getString("EnvironmentDialog.btnClose.text"));
        btnClose.setBounds(336, 213, 91, 21);
        btnClose.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EnvironmentDialog.this.is_ok = true;
                EnvironmentDialog.this.setVisible(false);
            }
        });
        panel_4.add(btnClose);
        JLabel lblAliasNames = new JLabel(Messages.getString("EnvironmentDialog.lblAliasNames.text"));
        lblAliasNames.setBounds(12, 62, 85, 13);
        panel_4.add(lblAliasNames);
        String t_txt = "";
        if (env.aliasNames != null) {
            for (Map.Entry<String, String> entry : env.aliasNames.entrySet()) {
                if (t_txt.length() > 0) {
                    t_txt = String.valueOf(t_txt) + "\n";
                }
                t_txt = String.valueOf(t_txt) + entry.getKey() + "=" + entry.getValue();
            }
        }
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(117, 44, 299, 166);
        panel_4.add(scrollPane);
        this.aliasNames = new JTextArea();
        scrollPane.setViewportView(this.aliasNames);
        this.aliasNames.setText(t_txt);
        JLabel lblVersion = new JLabel(Messages.getString("EnvironmentDialog.lblVersion.text"));
        lblVersion.setBounds(228, 21, 50, 13);
        panel_4.add(lblVersion);
        this.versionText = new JTextField();
        this.versionText.setText(env.version);
        this.versionText.setBounds(290, 18, 126, 19);
        panel_4.add(this.versionText);
        this.versionText.setColumns(10);
    }

    public EnvironmentData getEnvData() {
        String n_env;
        EnvironmentData t_d = new EnvironmentData();
        t_d.dbName = this.dbName.getText();
        t_d.encode = this.encode.getText();
        t_d.port = this.port.getText();
        t_d.pwd = this.pwd.getText();
        t_d.serverName = this.serverName.getText();
        t_d.uID = this.uID.getText();
        t_d.hiddenMode = this.hiddenMode;
        t_d.fakedir = this.textFakeDir.getText();
        t_d.logdir = this.textLogFile.getText();
        t_d.caseSize = Integer.valueOf(this.caseUnitSize.getText());
        t_d.process_mode = this.processMode;
        t_d.remote_db = this.chckbxRemote.isSelected();
        t_d.groupCode = this.textGroupCode.getText();
        t_d.version = this.versionText.getText();
        t_d.debug_mode = this.chckbxDebugmode.isSelected();
        t_d.rootDirs = new ArrayList();
        int i = 0;
        while (i < this.rootDirs.getModel().getSize()) {
            t_d.rootDirs.add(this.rootDirs.getModel().getElementAt(i));
            ++i;
        }
        t_d.plugins = new ArrayList();
        i = 0;
        while (i < this.pluginList.getModel().getSize()) {
            t_d.plugins.add(this.pluginList.getModel().getElementAt(i));
            ++i;
        }
        if (t_d.plugins.size() > 0 && this.plugins_properties != null) {
            t_d.plugins_properties = (HashMap)this.plugins_properties.clone();
        }
        if (this.aliasNames.getText().length() > 0) {
            t_d.aliasNames = new HashMap();
            String[] t_lines = this.aliasNames.getText().split("\n");
            int i2 = 0;
            while (i2 < t_lines.length) {
                String[] temp = t_lines[i2].split("=");
                t_d.aliasNames.put(temp[0].trim(), temp[1].trim());
                ++i2;
            }
        }
        if ((n_env = Tool.getJSONfromObject(t_d)) != null && !n_env.equals(Tool.getJSONfromObject(this.old_env))) {
            int t_res;
            if (this.old_env.groupCode != null && this.old_env.groupCode.length() > 0 && t_d.groupCode.length() == 0 && (t_res = JOptionPane.showConfirmDialog(this, Messages.getString("EnvironmentDialog.10"))) != 0) {
                Tool.logIfDebug(null, String.valueOf(Messages.getString("EnvironmentDialog.7")) + this.old_env.groupCode + Messages.getString("EnvironmentDialog.14") + t_d.groupCode);
                t_d.groupCode = this.old_env.groupCode;
            }
            if (t_d.groupCode.length() > 0 && t_d.version.length() == 0) {
                t_d.version = this.old_env.version;
            }
            return t_d;
        }
        return null;
    }
}

