/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.web;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.AssertRecord;
import com.ftinc.si.assist.test.Fson;
import com.ftinc.si.assist.test.ObjectRecord;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.gui.ArgumentEditor;
import com.ftinc.si.assist.test.gui.SimpleTextEditor;
import com.ftinc.si.assist.test.gui.TestCaseEditor;
import com.ftinc.si.assist.test.web.AfterAction;
import com.ftinc.si.assist.test.web.BeforeAction;
import com.ftinc.si.assist.test.web.PageAction;
import com.ftinc.si.assist.test.web.PagePlayer;
import com.ftinc.si.assist.test.web.WebElementGetter;
import java.awt.Dialog;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class PageActionEditor
extends JDialog {
    private HashMap<String, String> m_cmap = new HashMap();
    private JTable m_table;
    private DefaultTableModel m_table_model;
    private JScrollPane m_tableScrollPane;
    private JRadioButton m_rdbtnParentHide;
    private ObjectRecord m_rec;
    private AssertRecord m_asrec;
    private WebElementGetter m_elmgetter = null;
    private SimpleTextEditor m_editor = null;
    private ArrayList<String> m_assertings = null;
    private int m_browser_y;
    private int m_caseeditor_y;
    private int m_screenOY;

    public PageActionEditor(JDialog owner, ObjectRecord rec, AssertRecord ast, String[] regs) {
        super((Dialog)owner, true);
        this.setResizable(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (PageActionEditor.this.m_elmgetter != null && PageActionEditor.this.m_table.isShowing()) {
                    Point op = PageActionEditor.this.m_table.getLocationOnScreen();
                    PageActionEditor.this.m_elmgetter.setLocation(op.x + PageActionEditor.this.m_table.getWidth(), op.y);
                    PageActionEditor.this.m_editor.setLocation(op.x + PageActionEditor.this.m_table.getWidth(), op.y);
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (PageActionEditor.this.m_elmgetter != null) {
                    PageActionEditor.this.m_elmgetter.closing();
                }
                if (PageActionEditor.this.m_rdbtnParentHide.isSelected()) {
                    PageActionEditor.this.resoreParent();
                }
            }
        });
        this.m_rec = rec;
        this.m_asrec = ast;
        this.m_elmgetter = new WebElementGetter(this);
        this.m_editor = new SimpleTextEditor(this, "", false);
        this.m_assertings = new ArrayList();
        if (regs != null) {
            int i = 0;
            while (i < regs.length) {
                this.m_assertings.add(regs[i]);
                ++i;
            }
        }
        this.setTitle(Messages.getString("PageActionEditor.0"));
        this.getContentPane().setLayout(null);
        this.setBounds(owner.getX() + 50, owner.getY() + 50, 590, 265);
        JLabel lblActions = new JLabel(Messages.getString("PageActionEditor.2"));
        lblActions.setBounds(12, 10, 60, 13);
        this.getContentPane().add(lblActions);
        this.m_tableScrollPane = new JScrollPane();
        this.m_tableScrollPane.setBounds(12, 33, 549, 156);
        this.getContentPane().add(this.m_tableScrollPane);
        Object[] colNames = new String[]{Messages.getString("PageActionEditor.1"), Messages.getString("PageActionEditor.6"), ""};
        this.m_table_model = new DefaultTableModel(colNames, 0);
        this.m_table = new JTable(this.m_table_model);
        this.m_table.setColumnSelectionAllowed(false);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setSelectionMode(0);
        TableColumn col0 = this.m_table.getColumnModel().getColumn(0);
        col0.setMinWidth(100);
        col0.setMaxWidth(100);
        TableColumn col2 = this.m_table.getColumnModel().getColumn(2);
        col2.setMinWidth(1);
        col2.setMaxWidth(1);
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point t_pt = e.getPoint();
                int ir = PageActionEditor.this.m_table.rowAtPoint(t_pt);
                int ic = PageActionEditor.this.m_table.columnAtPoint(t_pt);
                if (e.getClickCount() == 1 && ic == 1) {
                    if (PageActionEditor.this.m_elmgetter.m_selectedRow != ir) {
                        PageAction t_act;
                        String val = (String)PageActionEditor.this.m_table_model.getValueAt(ir, 1);
                        String assertAndIndex = (String)PageActionEditor.this.m_table_model.getValueAt(ir, 2);
                        if (assertAndIndex != null && assertAndIndex.length() < 2) {
                            assertAndIndex = null;
                        }
                        if ((t_act = PageActionEditor.this.getPageAction(ir, val)) != null) {
                            PageActionEditor.this.m_elmgetter.initParams(ir, t_act, assertAndIndex);
                            if (PageActionEditor.this.m_elmgetter.initTags()) {
                                PageActionEditor.this.m_editor.setVisible(false);
                                Point op = PageActionEditor.this.m_table.getLocationOnScreen();
                                PageActionEditor.this.m_elmgetter.setLocation(op.x + PageActionEditor.this.m_table.getWidth(), op.y);
                                PageActionEditor.this.m_elmgetter.setVisible(true);
                            } else {
                                PageActionEditor.this.m_elmgetter.setVisible(false);
                                PageActionEditor.this.m_editor.setText(val);
                                PageActionEditor.this.m_editor.setVisible(true);
                                String t_result = PageActionEditor.this.m_editor.getText();
                                if (t_result != null && t_result.length() > 0) {
                                    PageActionEditor.this.m_table_model.setValueAt(t_result, ir, 1);
                                }
                            }
                        }
                    }
                } else {
                    PageActionEditor.this.m_elmgetter.setVisible(false);
                }
            }
        });
        this.m_tableScrollPane.setViewportView(this.m_table);
        final JButton btnOk = new JButton(Messages.getString("PageActionEditor.9"));
        btnOk.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!btnOk.isEnabled()) {
                    return;
                }
                PageActionEditor.this.setJson();
                PageActionEditor.this.setAssertStrings();
                if (PageActionEditor.this.m_elmgetter != null) {
                    PageActionEditor.this.m_elmgetter.setVisible(false);
                    PageActionEditor.this.m_elmgetter.closing();
                    PageActionEditor.this.m_elmgetter = null;
                }
                if (PageActionEditor.this.m_rdbtnParentHide.isSelected()) {
                    PageActionEditor.this.resoreParent();
                }
                PageActionEditor.this.setVisible(false);
            }
        });
        btnOk.setBounds(372, 205, 91, 21);
        btnOk.setEnabled(!TestCaseEditor.unableMode);
        this.getContentPane().add(btnOk);
        JButton btnCancel = new JButton(Messages.getString("PageActionEditor.10"));
        btnCancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PageActionEditor.this.m_elmgetter != null) {
                    PageActionEditor.this.m_elmgetter.setVisible(false);
                    PageActionEditor.this.m_elmgetter.closing();
                    PageActionEditor.this.m_elmgetter = null;
                }
                if (PageActionEditor.this.m_rdbtnParentHide.isSelected()) {
                    PageActionEditor.this.resoreParent();
                }
                PageActionEditor.this.setVisible(false);
            }
        });
        btnCancel.setBounds(470, 205, 91, 21);
        this.getContentPane().add(btnCancel);
        JButton btnAdd = new JButton(Messages.getString("PageActionEditor.btnAdd.text"));
        btnAdd.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int i = PageActionEditor.this.m_table.getSelectedRow();
                PageActionEditor.this.addRow(i);
                if (PageActionEditor.this.m_elmgetter != null) {
                    PageActionEditor.this.m_elmgetter.setVisible(false);
                }
            }
        });
        btnAdd.setBounds(84, 6, 92, 21);
        this.getContentPane().add(btnAdd);
        JButton btnDelete = new JButton(Messages.getString("PageActionEditor.btnNewButton.text"));
        btnDelete.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int t_option;
                int i;
                if (PageActionEditor.this.m_elmgetter != null) {
                    PageActionEditor.this.m_elmgetter.setVisible(false);
                }
                if ((i = PageActionEditor.this.m_table.getSelectedRow()) >= 0 && (t_option = JOptionPane.showConfirmDialog(null, Messages.getString("PageActionEditor.8"), Messages.getString("PageActionEditor.12"), 0)) == 0) {
                    PageActionEditor.this.m_table_model.removeRow(i);
                }
            }
        });
        btnDelete.setBounds(188, 6, 73, 21);
        this.getContentPane().add(btnDelete);
        JButton btnUp = new JButton(Messages.getString("PageActionEditor.btnUp.text"));
        btnUp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int i;
                if (PageActionEditor.this.m_elmgetter != null) {
                    PageActionEditor.this.m_elmgetter.setVisible(false);
                }
                if ((i = PageActionEditor.this.m_table.getSelectedRow()) > 0) {
                    PageActionEditor.this.m_table_model.moveRow(i, i, i - 1);
                    PageActionEditor.this.m_table.changeSelection(i - 1, 1, false, false);
                    if (PageActionEditor.this.m_elmgetter != null) {
                        PageActionEditor.this.m_elmgetter.m_selectedRow = PageActionEditor.this.m_elmgetter.m_selectedRow - 1;
                    }
                }
            }
        });
        btnUp.setBounds(405, 6, 73, 21);
        this.getContentPane().add(btnUp);
        JButton btnDown = new JButton(Messages.getString("PageActionEditor.btnDown.text"));
        btnDown.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int i;
                String nextAction;
                if (PageActionEditor.this.m_elmgetter != null) {
                    PageActionEditor.this.m_elmgetter.setVisible(false);
                }
                if ((nextAction = PageActionEditor.this.getAction((i = PageActionEditor.this.m_table.getSelectedRow()) + 1)) != null && nextAction.length() > 0) {
                    PageActionEditor.this.m_table_model.moveRow(i, i, i + 1);
                    PageActionEditor.this.m_table.changeSelection(i + 1, 1, false, false);
                    if (PageActionEditor.this.m_elmgetter != null) {
                        PageActionEditor.this.m_elmgetter.m_selectedRow = PageActionEditor.this.m_elmgetter.m_selectedRow + 1;
                    }
                }
            }
        });
        btnDown.setBounds(482, 6, 79, 21);
        this.getContentPane().add(btnDown);
        JLabel lblMove = new JLabel(Messages.getString("PageActionEditor.lblMove.text"));
        lblMove.setBounds(361, 10, 50, 13);
        this.getContentPane().add(lblMove);
        this.m_rdbtnParentHide = new JRadioButton(Messages.getString("PageActionEditor.phideRadioButton.text"));
        this.m_rdbtnParentHide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestCaseEditor t_owner = ArgumentEditor.s_owner;
                Window t_frame = t_owner.getOwner();
                if (PageActionEditor.this.m_rdbtnParentHide.isSelected()) {
                    PageActionEditor.this.m_browser_y = t_frame.getY();
                    PageActionEditor.this.m_caseeditor_y = t_owner.getY();
                    t_frame.setLocation(t_frame.getX(), PageActionEditor.this.m_screenOY + 1 - t_frame.getHeight());
                    t_owner.setLocation(t_owner.getX(), PageActionEditor.this.m_screenOY + 1 - t_owner.getHeight());
                } else {
                    t_frame.setLocation(t_frame.getX(), PageActionEditor.this.m_browser_y);
                    t_owner.setLocation(t_owner.getX(), PageActionEditor.this.m_caseeditor_y);
                }
            }
        });
        this.m_rdbtnParentHide.setBounds(12, 205, 113, 21);
        this.getContentPane().add(this.m_rdbtnParentHide);
        JButton btnAddTemplate = new JButton(Messages.getString("PageActionEditor.btnNewButton.text_2"));
        btnAddTemplate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PageActionEditor.this.setJson();
                if (PageActionEditor.this.m_rec.jSON.length() > 0) {
                    PageActionEditor.this.m_elmgetter.registerTargetFromPopup("com.ftinc.si.assist.test.web.PagePlayer", PageActionEditor.this.m_rec.jSON);
                }
            }
        });
        btnAddTemplate.setBounds(137, 205, 159, 21);
        this.getContentPane().add(btnAddTemplate);
        this.getScreenRange();
        this.initModel();
    }

    private void getScreenRange() {
        Rectangle vBounds = new Rectangle();
        GraphicsEnvironment g_env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gdlist = g_env.getScreenDevices();
        int j = 0;
        while (j < gdlist.length) {
            GraphicsDevice g_d = gdlist[j];
            GraphicsConfiguration[] g_conf = g_d.getConfigurations();
            int i = 0;
            while (i < g_conf.length) {
                vBounds = vBounds.union(g_conf[i].getBounds());
                ++i;
            }
            ++j;
        }
        this.m_screenOY = vBounds.y;
    }

    private void resoreParent() {
        TestCaseEditor t_owner = ArgumentEditor.s_owner;
        Window t_frame = t_owner.getOwner();
        t_frame.setLocation(t_frame.getX(), this.m_browser_y);
        t_owner.setLocation(t_owner.getX(), this.m_caseeditor_y);
    }

    private void addRow(int r) {
        Object[] t_data = new Object[]{"", "", ""};
        int n = -1;
        if (r < 0 || r == this.m_table_model.getRowCount() - 1) {
            this.m_table_model.addRow(t_data);
            n = this.m_table_model.getRowCount() - 1;
        } else {
            this.m_table_model.insertRow(r + 1, t_data);
            n = r + 1;
        }
        JComboBox t_combo = (JComboBox)((DefaultCellEditor)this.m_table.getCellEditor(n, 0)).getComponent();
        t_combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PageActionEditor.this.m_elmgetter.m_selectedRow = -1;
                PageActionEditor.this.m_elmgetter.setVisible(false);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JScrollBar t_scrollBar = PageActionEditor.this.m_tableScrollPane.getVerticalScrollBar();
                t_scrollBar.setValue(t_scrollBar.getMaximum());
            }
        });
    }

    private void initModel() {
        JComboBox<String> t_actions = new JComboBox<String>();
        t_actions.addItem("LoadURL");
        this.m_cmap.put("LoadURL", "com.ftinc.si.assist.test.web.LoadURL");
        t_actions.addItem("SendKeys");
        this.m_cmap.put("SendKeys", "com.ftinc.si.assist.test.web.SendKeys");
        t_actions.addItem("Click");
        this.m_cmap.put("Click", "com.ftinc.si.assist.test.web.Click");
        t_actions.addItem("Snap");
        this.m_cmap.put("Snap", "com.ftinc.si.assist.test.web.Snap");
        t_actions.addItem("Reset");
        this.m_cmap.put("Reset", "com.ftinc.si.assist.test.web.ResetBrowser");
        t_actions.addItem("JQExec");
        this.m_cmap.put("JQExec", "com.ftinc.si.assist.test.web.JQExec");
        t_actions.addItem("ByHand");
        this.m_cmap.put("ByHand", "com.ftinc.si.assist.test.web.UseHand");
        t_actions.addItem("ToFrame");
        this.m_cmap.put("ToFrame", "com.ftinc.si.assist.test.web.ToFrame");
        t_actions.addItem("CheckFor");
        this.m_cmap.put("CheckFor", "com.ftinc.si.assist.test.web.CheckFor/CheckFor");
        t_actions.addItem("ToWindow");
        this.m_cmap.put("ToWindow", "com.ftinc.si.assist.test.web.CheckFor/ToWindow");
        t_actions.addItem("Alert");
        this.m_cmap.put("Alert", "com.ftinc.si.assist.test.web.CheckFor/Alert");
        t_actions.addItem("Prompt");
        this.m_cmap.put("Prompt", "com.ftinc.si.assist.test.web.Prompt");
        t_actions.addItem("FileUpload");
        this.m_cmap.put("Prompt", "com.ftinc.si.assist.test.web.FileUpload");
        t_actions.addItem("Macro");
        this.m_cmap.put("Macro", "com.ftinc.si.assist.test.web.MacroActions");
        DefaultCellEditor cell_combo1 = new DefaultCellEditor(t_actions);
        this.m_table.getColumnModel().getColumn(0).setCellEditor(cell_combo1);
        if (this.m_rec.jSON != null && this.m_rec.jSON.length() > 0) {
            PageAction t_act1;
            PagePlayer t_play = (PagePlayer)Tool.getObjectfromJSON(PagePlayer.class, this.m_rec.jSON);
            HashMap<String, Object> f_map = Tool.getCommentMapFromJson(true, this.m_rec.jSON);
            int n = 0;
            for (Map.Entry<String, Object> entry : f_map.entrySet()) {
                if (entry.getKey().startsWith("dbset")) {
                    t_act1 = new BeforeAction();
                    String t_jpath = entry.getKey().replaceFirst("dbset.*?\\$\\.", "");
                    t_act1.arg_map.put("jpath", t_jpath);
                    t_act1.arg_map.put("key_value", entry.getValue());
                    t_act1.options = "SetDB";
                    t_play.actions.add(n, t_act1);
                    ++n;
                    continue;
                }
                if (!entry.getKey().matches("^exec\\sbefore.*$")) continue;
                t_act1 = new BeforeAction();
                t_act1.arg_map.put("jpath", entry.getKey());
                t_act1.arg_map.put("key_value", entry.getValue());
                t_act1.options = "Before";
                t_play.actions.add(n, t_act1);
                ++n;
            }
            f_map = Tool.getCommentMapFromJson(true, this.m_rec.jSON);
            for (Map.Entry<String, Object> entry : f_map.entrySet()) {
                if (entry.getKey().startsWith("dbtest")) {
                    AfterAction t_act2 = new AfterAction();
                    t_act2.arg_map.put("jpath", entry.getKey().replaceFirst("dbtest.*?\\$\\.", ""));
                    t_act2.arg_map.put("value", entry.getValue());
                    t_act2.options = "TestDB";
                    t_play.actions.add(t_act2);
                    continue;
                }
                if (!entry.getKey().matches("^exec\\safter.*$")) continue;
                t_act1 = new AfterAction();
                ((AfterAction)t_act1).arg_map.put("jpath", entry.getKey());
                ((AfterAction)t_act1).arg_map.put("key_value", entry.getValue());
                ((AfterAction)t_act1).options = "After";
                t_play.actions.add(n, t_act1);
                ++n;
            }
            int n_asserting = 0;
            int i = 0;
            while (i < t_play.actions.size()) {
                PageAction t_pact = t_play.actions.get(i);
                this.addRow(-1);
                String cname = t_pact.options;
                cname = cname != null && cname.length() > 0 && !cname.startsWith("_") ? String.valueOf(t_pact.getClass().getName()) + "/" + t_pact.options : t_pact.getClass().getName();
                String act_name = this.getActionFromClass(cname);
                this.m_table_model.setValueAt(act_name, i, 0);
                String t_targets = t_pact.getJsonElement(null, null);
                this.m_table_model.setValueAt(t_targets, i, 1);
                if (n_asserting > this.m_assertings.size()) {
                    Tool.alertMSG(null, "# of regular exps not match to assertables.");
                } else if (t_pact.assertable() && this.m_assertings.size() > 0) {
                    String str_assert = null;
                    if (this.m_assertings.size() > n_asserting) {
                        str_assert = this.m_assertings.get(n_asserting);
                    }
                    if (str_assert != null && str_assert.length() > 0) {
                        this.m_table_model.setValueAt(str_assert, i, 2);
                    }
                    ++n_asserting;
                }
                ++i;
            }
        } else {
            this.addRow(-1);
        }
    }

    private String getActionFromClass(String cname) {
        for (Map.Entry<String, String> e : this.m_cmap.entrySet()) {
            if (!e.getValue().equals(cname)) continue;
            return e.getKey();
        }
        return null;
    }

    protected PageAction getPageAction(int r, String val) {
        String cname = this.m_cmap.get(this.m_table_model.getValueAt(r, 0));
        if (cname == null) {
            return null;
        }
        String[] temp = cname.split("/");
        String t_option = "";
        if (temp.length > 1) {
            cname = temp[0];
            t_option = temp[1];
        }
        try {
            PageAction t_act = (PageAction)Tool.newObject(Tool.forName(cname), new Class[0], new Object[0]);
            t_act.options = t_option;
            Fson.updateFromJson(t_act, "{\"arg_map\":{" + val + "}}");
            return t_act;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Tool.alertMSG(null, String.valueOf(e.getMessage()) + "@getPageAction");
            return null;
        }
    }

    protected void setAssertStrings() {
        if (this.m_assertings != null && this.m_assertings.size() > 0) {
            String t_regs = "[";
            int i = 0;
            while (this.m_assertings.size() > i) {
                String t_str = this.m_assertings.get(i);
                if (t_str.matches("^\".*\"$")) {
                    t_str = t_str.replaceFirst("^\"(.*)\"$", "$1");
                }
                if (t_regs.length() > 1) {
                    t_regs = String.valueOf(t_regs) + ",";
                }
                t_regs = String.valueOf(t_regs) + "\"" + t_str + "\"";
                ++i;
            }
            this.m_asrec.criteriaRex = t_regs = String.valueOf(t_regs) + "]";
            this.m_asrec.changed();
        }
    }

    protected void setJson() {
        String part1_json = "{";
        String part2_json = "";
        this.m_assertings.clear();
        if (this.m_table_model.getRowCount() > 0) {
            part2_json = String.valueOf(part2_json) + "\"actions\":[";
            int i = 0;
            while (i < this.m_table_model.getRowCount()) {
                PageAction t_act = this.getPageAction(i, "");
                if ("SetDB".equals(this.m_table_model.getValueAt(i, 0))) {
                    part1_json = String.valueOf(part1_json) + "//?dbset \"$." + t_act.arg_map.get("jpath") + "\":{" + t_act.arg_map.get("key_value") + "},\n";
                } else if ("TestDB".equals(this.m_table_model.getValueAt(i, 0))) {
                    part1_json = String.valueOf(part1_json) + "//?dbtest \"$." + t_act.arg_map.get("jpath") + "\":" + Tool.getJSONfromObject(t_act.arg_map.get("value")) + ",\n";
                } else if ("Before".equals(this.m_table_model.getValueAt(i, 0)) || "After".equals(this.m_table_model.getValueAt(i, 0))) {
                    part1_json = String.valueOf(part1_json) + "//?" + t_act.arg_map.get("jpath") + "\":" + t_act.arg_map.get("key_value") + ",\n";
                } else {
                    String t_reg;
                    if (i > 0) {
                        part2_json = String.valueOf(part2_json) + ",";
                    }
                    if ((t_reg = this.m_table_model.getValueAt(i, 2).toString()) != null && t_reg.length() > 0) {
                        if (t_act.assertable()) {
                            this.m_assertings.add(t_reg);
                        } else {
                            this.m_assertings.add(".*");
                        }
                    }
                    part2_json = String.valueOf(part2_json) + this.makeJsonAt(i, this.m_table_model.getValueAt(i, 1).toString());
                }
                ++i;
            }
            part2_json = String.valueOf(part2_json) + "]";
        }
        part2_json = String.valueOf(part2_json) + "}";
        this.m_rec.setJSON(String.valueOf(part1_json) + part2_json);
    }

    protected String makeJsonAt(int i, String str) {
        String t_json = "";
        String action_name = (String)this.m_table_model.getValueAt(i, 0);
        if (action_name != null && action_name.length() > 0) {
            String c_name = this.m_cmap.get(action_name);
            String[] temp = c_name.split("/");
            String t_option = "";
            if (temp.length > 1) {
                c_name = temp[0];
                t_option = temp[1];
            }
            t_json = String.valueOf(t_json) + "(" + c_name + ")";
            t_json = String.valueOf(t_json) + "{";
            if (str.length() > 0) {
                if (t_option.length() > 0) {
                    t_json = String.valueOf(t_json) + "\"options\":\"" + t_option + "\",";
                }
                if (str.matches("^.*?\"arg_map\"\\s*:\\s*\\{[\\s\\S]*\\}.*$")) {
                    t_json = String.valueOf(t_json) + str;
                } else if ("ByHand".equals(action_name) || "Snap".equals(action_name)) {
                    String t_attr = Fson.escape(str);
                    t_json = String.valueOf(t_json) + "\"arg_map\":{\"message\":\"" + t_attr + "\"}";
                } else {
                    t_json = String.valueOf(t_json) + "\"arg_map\":{" + str + "}";
                }
            } else {
                t_json = String.valueOf(t_json) + "\"arg_map\":{}";
            }
            t_json = String.valueOf(t_json) + "}";
        } else if (str.length() == 0) {
            Tool.alertMSG(null, String.valueOf(Integer.toString(i)) + "th row not specified.");
        }
        return t_json;
    }

    void setArgumentAt(int r, String value, String assertAndIndex) {
        if (this.m_table.getValueAt(r, 0) != null) {
            this.m_table_model.setValueAt(value, r, 1);
            if (assertAndIndex != null) {
                this.m_table_model.setValueAt(assertAndIndex, r, 2);
            }
        }
    }

    int numArgument() {
        int max = 1000;
        int n = 0;
        while (this.m_table_model.getValueAt(n, 0) != null || max > n) {
            ++n;
        }
        return n - 1;
    }

    String getArgument(int r) {
        if (this.m_table.getValueAt(r, 0) != null) {
            return this.m_table_model.getValueAt(r, 1).toString();
        }
        return null;
    }

    String getAction(int r) {
        return this.m_table.getValueAt(r, 0).toString();
    }
}

