/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Preconditions;
import com.google.common.reflect.AbstractInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.BaseAugmenter;
import org.openqa.selenium.remote.InterfaceImplementation;
import org.openqa.selenium.remote.RemoteExecuteMethod;
import org.openqa.selenium.remote.RemoteWebDriver;

@Beta
public class JdkAugmenter
extends BaseAugmenter {
    @Override
    protected RemoteWebDriver extractRemoteWebDriver(WebDriver driver) {
        InvocationHandler handler;
        if (driver instanceof RemoteWebDriver) {
            return (RemoteWebDriver)driver;
        }
        if (Proxy.isProxyClass(driver.getClass()) && (handler = Proxy.getInvocationHandler(driver)) instanceof JdkHandler) {
            return ((JdkHandler)handler).driver;
        }
        return null;
    }

    @Override
    protected <X> X create(RemoteWebDriver driver, Map<String, AugmenterProvider> augmentors, X objectToAugment) {
        Map<String, Object> capabilities = driver.getCapabilities().asMap();
        HashMap<Method, InterfaceImplementation> augmentationHandlers = new HashMap<Method, InterfaceImplementation>();
        HashSet proxiedInterfaces = new HashSet();
        for (Class<?> superClass = objectToAugment.getClass(); null != superClass; superClass = superClass.getSuperclass()) {
            proxiedInterfaces.addAll(Arrays.asList(superClass.getInterfaces()));
        }
        for (Map.Entry<String, Object> capabilityName : capabilities.entrySet()) {
            Object value;
            AugmenterProvider augmenter = augmentors.get(capabilityName.getKey());
            if (augmenter == null || (value = capabilityName.getValue()) instanceof Boolean && !((Boolean)value).booleanValue()) continue;
            Class<?> interfaceProvided = augmenter.getDescribedInterface();
            Preconditions.checkState((boolean)interfaceProvided.isInterface(), (String)"JdkAugmenter can only augment interfaces. %s is not an interface.", interfaceProvided);
            proxiedInterfaces.add(interfaceProvided);
            InterfaceImplementation augmentedImplementation = augmenter.getImplementation(value);
            for (Method method : interfaceProvided.getMethods()) {
                InterfaceImplementation oldHandler = augmentationHandlers.put(method, augmentedImplementation);
                Preconditions.checkState((null == oldHandler ? 1 : 0) != 0, (String)"Both %s and %s attempt to define %s.", (Object)oldHandler, augmentedImplementation.getClass(), (Object)method.getName());
            }
        }
        if (augmentationHandlers.isEmpty()) {
            return objectToAugment;
        }
        JdkHandler proxyHandler = new JdkHandler(driver, objectToAugment, augmentationHandlers);
        Object augmentedProxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), proxiedInterfaces.toArray(new Class[proxiedInterfaces.size()]), proxyHandler);
        return (X)augmentedProxy;
    }

    private static class JdkHandler<X>
    extends AbstractInvocationHandler
    implements InvocationHandler {
        private final RemoteWebDriver driver;
        private final X realInstance;
        private final Map<Method, InterfaceImplementation> handlers;

        private JdkHandler(RemoteWebDriver driver, X realInstance, Map<Method, InterfaceImplementation> handlers) {
            this.driver = (RemoteWebDriver)Preconditions.checkNotNull((Object)driver);
            this.realInstance = Preconditions.checkNotNull(realInstance);
            this.handlers = (Map)Preconditions.checkNotNull(handlers);
        }

        public Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            InterfaceImplementation handler = this.handlers.get(method);
            try {
                if (null == handler) {
                    return method.invoke(this.realInstance, args);
                }
                return handler.invoke(new RemoteExecuteMethod(this.driver), proxy, method, args);
            }
            catch (InvocationTargetException i) {
                throw i.getCause();
            }
        }
    }
}

