package com.ftinc.si.assist.test.web;

import java.util.ArrayList;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

import com.ftinc.si.assist.test.Tool;

public class UseHand extends PageAction {
	//画面の準備ができるまで待つ。Actionごとに待ち方が異なる。
	protected WebElement waitUntil(WebDriver drv) {
		return null;
	}

	@Override
	protected void doCore(WebDriver drv, WebElement elm) {
		if (PagePlayer.isRemote()) {
			Tool.alertAndStop("UseHand not supported on Grid");
			return;
		}

		Object t_msg = arg_map.get("value");
		if (t_msg == null) {
			t_msg = arg_map.get("message");
		}
		if (t_msg == null || t_msg.toString().length() == 0) {
			t_msg = "Do it your self.";
		}

		//文字数の制限をなくすためにJTextAreaとJScrollPaneを使う。
		JTextArea t_area = new JTextArea(6, 40);
		t_area.setText(t_msg.toString());
		t_area.setEditable(false);

		JScrollPane s_pane = new JScrollPane(t_area);
		JOptionPane optionPane = new JOptionPane(s_pane, JOptionPane.DEFAULT_OPTION, JOptionPane.PLAIN_MESSAGE);
		JDialog t_dialog = optionPane.createDialog(null, "Use Hand");
		t_dialog.setLocation(0, 0);
		t_dialog.setVisible(true);
	}

	//PageActionEditorのTableの第２列の各セルに埋め込む文字列を作成する。
	protected String getJsonElement() {
		String t_msg = (String)arg_map.get("message");
		if (t_msg == null) {
			return "";
		}
		return super.getJsonElement(null, null);
	}

	//このPageActionではフォーカスする対象を持たない。あるいは、WebDriverから情報を取得する必要はない。
	protected boolean getFocussingElements(WebDriver drv, ArrayList<WebElement> el_list, ArrayList<String> xp_list, String xpaths) {
		return false;//WebElementGetterを開かないサイン
	}

	//通常のPageActionは全自動だが、これは手動。
	public boolean isAutomatic() {
		return false;
	}
}
