/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.run;

import com.ftinc.si.assist.run.FakeEditorOnRun;
import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.run.SnapshotCommandRecord;
import com.ftinc.si.assist.test.AssertRecord;
import com.ftinc.si.assist.test.TestCaseRecord;
import com.ftinc.si.assist.test.TestCommandRecord;
import com.ftinc.si.assist.test.TestLogger;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.gui.Plugin;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;

public class TestCommander {
    private static int count_try = 0;
    private ArrayList<TestCommandRecord> m_cmdlist = null;
    private TestCaseRecord m_rec;
    private static int s_snapshot = 0;
    private boolean m_enableAssert;
    private String m_idPrefix = "";
    private static String m_version = "";
    public boolean is_stopping = false;
    public ArrayList<String> m_fakeStack;
    public String m_lastCallofFake = "";
    private static boolean only_auto = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void runCase(HashMap<String, Object> args) {
        if (args.size() >= 2) {
            Boolean child_mode;
            String x_version = Tool.version;
            Boolean edit_mode = (Boolean)args.get("editmode");
            if (edit_mode == null) {
                edit_mode = false;
            }
            if ((child_mode = (Boolean)args.get("child_mode")) != null && child_mode.booleanValue()) {
                Tool.child_mode = true;
            }
            Tool.init(edit_mode);
            if (args.containsKey("v")) {
                Tool.version = m_version = args.get("v").toString();
            } else {
                m_version = Tool.version;
            }
            if (args.containsKey("onlyauto")) {
                only_auto = Boolean.valueOf(args.get("onlyauto").toString());
            }
            try {
                String t_arg = args.get("caseName").toString().replaceAll("'", "\"");
                ArrayList<TestCaseRecord> t_list = Tool._db().getTestCaseList(t_arg, 0, 0, "", m_version);
                if (t_list.size() > 0) {
                    ArrayList<String> t_case = new ArrayList<String>();
                    t_case.add(edit_mode.toString());
                    t_case.add(t_list.get(0).getCmdArgsStyle());
                    TestCommander.execute(t_case);
                    return;
                }
                Tool.logForTesting(null, "TestCase=" + t_arg + Messages.getString("TestCommander.5") + m_version);
                if (Tool.child_mode) return;
                Tool.alertMSG(null, "TestCase=" + t_arg + Messages.getString("TestCommander.7") + m_version);
                return;
            }
            finally {
                if (Tool.child_mode) {
                    Tool.destroy();
                    System.exit(0);
                }
                Tool.version = x_version;
            }
        } else {
            Tool.logForTesting(null, Messages.getString("TestCommander.1"));
            if (Tool.child_mode) return;
            Tool.alertMSG(null, Messages.getString("TestCommander.2"));
        }
    }

    public TestCommander(TestCaseRecord rec, boolean logFlag) {
        this.m_rec = rec;
        this.m_enableAssert = logFlag;
        this.m_fakeStack = new ArrayList();
    }

    public static void execute(ArrayList<String> args) {
        block8: {
            s_snapshot = 0;
            if (count_try > 0) {
                Tool.alertMSG(null, Messages.getString("TestCommander.10"));
                return;
            }
            ++count_try;
            try {
                try {
                    String[] t_data = (String[])Tool.getObjectfromJSON(String[].class, args.get(1));
                    if (t_data == null) {
                        Tool.alertMSG(null, String.valueOf(args.get(1)) + Messages.getString("TestCommander.11"));
                        break block8;
                    }
                    TestCaseRecord t_rec = new TestCaseRecord(0, t_data);
                    TestLogger.beginTestSuite(t_rec);
                    TestCommander tester = new TestCommander(t_rec, t_rec.loggable);
                    if (t_rec.snapshot > 0) {
                        s_snapshot = t_rec.snapshot;
                    }
                    Tool.curCommander(tester);
                    tester.execTestCase(null);
                    Tool.logForTesting(null, TestLogger.endTestSuite());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Tool.logForTesting(e, "Exception=" + e.getClass().getName() + " message=" + e.getMessage() + " Case=" + Tool.curCase + " ID=" + Integer.toString(Tool.curID));
                    Tool.displayResult(null);
                    Tool.clearCase();
                }
            }
            finally {
                Tool.displayResult(null);
                Tool.clearCase();
            }
        }
    }

    public void execTestCase(Integer snapid) {
        FakeEditorOnRun.reset();
        String inc_name = Tool.convert2Alias(this.m_rec.include);
        if (inc_name.length() > 0 && !"NONE".equals(inc_name)) {
            String[] inc_names = inc_name.split(",");
            int i = 0;
            while (i < inc_names.length) {
                ArrayList<TestCaseRecord> t_inc = Tool._db().getTestCaseList(inc_names[i], 0, 0, "", m_version);
                if (t_inc.size() == 0) {
                    Tool.alertAndExit("TestCase=\"" + inc_names[i] + "\" not exists.", null, 0);
                    return;
                }
                TestCaseRecord inc_rec = t_inc.get(0);
                if (!this.m_rec.loggable) {
                    inc_rec.loggable = false;
                }
                TestCommander tester = new TestCommander(inc_rec, false);
                if (this.m_idPrefix.length() > 0) {
                    tester.m_idPrefix = String.valueOf(this.m_idPrefix) + ".";
                }
                tester.m_idPrefix = String.valueOf(tester.m_idPrefix) + this.m_rec.name;
                tester.execTestCase(inc_rec.snapshot);
                if (inc_rec.snapshot > 0) {
                    s_snapshot = inc_rec.snapshot;
                }
                if (this.is_stopping) {
                    return;
                }
                ++i;
            }
        }
        ArrayList<TestCommandRecord> t_casecmdlist = Tool._db().getTestCmdList(this.m_rec.name, null, null, m_version);
        this.m_cmdlist = TestCommandRecord.convertToObject(t_casecmdlist, this.m_rec.snapshot);
        if (this.m_cmdlist != null) {
            int j = 0;
            while (j < this.m_cmdlist.size()) {
                TestCommandRecord t_rec = this.m_cmdlist.get(j);
                SnapshotCommandRecord.s_id_snapshot = s_snapshot > 0 ? Integer.valueOf(s_snapshot) : null;
                String prev_name = Tool.curCase;
                int prev_id = Tool.curID;
                this.execCommand(this.setCommandIfExtended(t_rec));
                if (snapid != null && snapid == t_rec.id) {
                    Tool.setCurID(prev_name, prev_id);
                    return;
                }
                if (this.is_stopping) {
                    return;
                }
                ++j;
            }
        }
    }

    private TestCommandRecord setCommandIfExtended(TestCommandRecord rec) {
        int k = 0;
        while (k < Tool.plugins.size()) {
            Plugin t_plug = Tool.plugins.get(k);
            TestCommandRecord t_rec = (TestCommandRecord)t_plug.extendCommand(rec);
            if (t_rec != null) {
                return t_rec;
            }
            ++k;
        }
        return rec;
    }

    private void execCommand(TestCommandRecord rec) {
        this.m_lastCallofFake = null;
        this.m_fakeStack = new ArrayList();
        TestLogger.cmdPrepare(rec.getName4Log());
        if (!rec.enable) {
            TestLogger.cmdDisabled(0L, this.m_idPrefix);
            return;
        }
        if (!rec.isComplete()) {
            TestLogger.cmdSkipped(0L, this.m_idPrefix);
            return;
        }
        rec.preExec();
        Tool.setCurID(this.m_rec.name, rec.id);
        Method t_verb = null;
        Object s_obj = null;
        Class<?>[] arg_classes = null;
        int phase = 0;
        try {
            arg_classes = Tool.getArgClasses(rec);
            ++phase;
            if (!rec.className.equals(rec.getMethodName())) {
                s_obj = rec.getTObject(0);
                if (s_obj == null && !rec.isStatic()) {
                    TestLogger.cmdCauseError(0L, String.valueOf(Integer.toString(rec.id)) + ", @new=" + rec.className + "\n", this.m_idPrefix, new Throwable[0]);
                    Tool.alertAndExit("@execMethod $0 is null and the method is not static.", null, rec.id);
                } else if (rec.isStatic()) {
                    s_obj = null;
                }
                ++phase;
            }
        }
        catch (Exception e) {
            Object[] t_msg = new String[]{"failed to getTObject", "wrong argument types", "failed to identify method"};
            TestLogger.cmdCauseError(0L, String.valueOf(Integer.toString(rec.id)) + Messages.getString("TestCommander.19") + " " + e.getClass().getSimpleName() + ", message=" + Arrays.toString(t_msg) + "\n", this.m_idPrefix, e.getCause());
            Tool.alertAndExit("@execMethod " + (String)t_msg[phase] + ": ", e, rec.id);
        }
        Object _ret = null;
        Object[] t_objs = null;
        boolean assert_skipped = false;
        try {
            t_objs = this.getArgObjs(rec);
        }
        catch (Exception e) {
            String eclass = e.getClass().getName();
            String msg = e.getMessage();
            if (msg == null && e.getCause() != null) {
                eclass = e.getCause().getClass().getName();
                msg = e.getCause().getMessage();
            }
            TestLogger.cmdCauseError(0L, String.valueOf(Integer.toString(rec.id)) + Messages.getString("TestCommander.19") + eclass + ", message=" + msg + "\n", this.m_idPrefix, e.getCause());
            return;
        }
        AssertRecord.setStart(new Date());
        try {
            phase = 100;
            Class<?> t_c = Tool.forName(rec.className);
            if (rec.className.equals(rec.getMethodName())) {
                phase = 120;
                _ret = Tool.newObject(t_c, arg_classes, t_objs);
                ++phase;
            } else {
                phase = 150;
                t_verb = t_c.getDeclaredMethod(rec.getMethodName(), arg_classes);
                phase = 151;
                t_verb.setAccessible(true);
                phase = 152;
                if (!rec.isAutomatic() && only_auto) {
                    TestLogger.cmdSkipped(0L, this.m_idPrefix);
                    return;
                }
                if (s_snapshot == rec.id) {
                    assert_skipped = true;
                } else {
                    if (this.m_enableAssert) {
                        TestLogger.cmdBegin(rec.getName4Log());
                    }
                    _ret = t_verb.invoke(s_obj, t_objs);
                }
                ++phase;
                AssertRecord.setEnd(new Date());
            }
        }
        catch (Error e) {
            AssertRecord.setEnd(new Date());
            this.evaluateException(phase, rec, e);
            return;
        }
        catch (Exception e) {
            AssertRecord.setEnd(new Date());
            this.evaluateException(phase, rec, e);
            return;
        }
        phase = 200;
        if (_ret != null) {
            Tool.addInstance(String.valueOf(Integer.toString(Tool.curID)) + "$_", Tool.primitive2ToObject(_ret));
        }
        if (s_obj != null) {
            Tool.addInstance(String.valueOf(Integer.toString(Tool.curID)) + "$0", s_obj);
        }
        Tool.addInstanceArgs(Integer.toString(Tool.curID), t_objs, rec.varArgsPos());
        ++phase;
        if (this.m_enableAssert && !assert_skipped) {
            this.execAssert(phase, rec);
        }
    }

    private void evaluateException(int phase, TestCommandRecord rec, Throwable e0) {
        AssertRecord ar = null;
        try {
            ar = rec.getAssert();
        }
        catch (Exception e) {
            ar = Tool._db().getAssert(rec.id);
            ar.evaluateException(phase, rec, null, e0, e);
            return;
        }
        if (ar == null) {
            TestLogger.cmdSkipped(0L, this.m_idPrefix);
            return;
        }
        if (!ar.isCompleted()) {
            TestLogger.cmdSkipped(ar.getMiliSec(), this.m_idPrefix);
            return;
        }
        if (!ar.enable && !"Exception".equals(ar.criteriaType)) {
            TestLogger.cmdSkipped(ar.getMiliSec(), this.m_idPrefix);
            return;
        }
        ar.m_prefix = this.m_idPrefix;
        String fake_info = null;
        fake_info = this.m_fakeStack.size() > 0 ? String.valueOf(Messages.getString("TestCommander.0")) + this.m_fakeStack.get(this.m_fakeStack.size() - 1) + ")" : String.valueOf(Messages.getString("TestCommander.25")) + this.m_lastCallofFake + ")";
        Throwable t_e = e0;
        if (e0.getCause() != null) {
            t_e = e0.getCause();
        }
        ar.evaluateException(phase, rec, fake_info, t_e);
        if (ar.criteriaType.equals("Exception")) {
            ar.criteriaRex.equals("\\$null");
        }
    }

    private void execAssert(int phase, TestCommandRecord rec) {
        AssertRecord ar = null;
        try {
            ar = rec.getAssert();
        }
        catch (Exception e) {
            ar = Tool._db().getAssert(rec.id);
            ar.evaluateException(phase, rec, null, e);
            return;
        }
        if (ar == null) {
            TestLogger.cmdSkipped(0L, this.m_idPrefix);
            return;
        }
        if (!ar.isCompleted()) {
            TestLogger.cmdSkipped(ar.getMiliSec(), this.m_idPrefix);
            return;
        }
        if (!ar.enable && !"Exception".equals(ar.criteriaType)) {
            TestLogger.cmdSkipped(ar.getMiliSec(), this.m_idPrefix);
            return;
        }
        ar.m_prefix = this.m_idPrefix;
        if (ar.targetObj != null && ar.targetObj.length() > 0 && !ar.criteriaType.equals("Exception")) {
            ar.evaluate(phase, rec);
        } else if (ar.criteriaType.equals("Exception") && ar.criteriaRex.equals("\\$null")) {
            ar.evaluate(phase, rec);
        }
    }

    public Object[] getArgObjs(TestCommandRecord testRec) throws Exception {
        int len = testRec.numArgs();
        int pos = testRec.varArgsPos();
        int n = 0;
        ArrayList<Object> t_list = new ArrayList<Object>();
        try {
            if (pos >= 0) {
                String vcname = testRec.getArgClass(pos);
                Class<?> compClass = Tool.forName(vcname);
                Object t_arry = Array.newInstance(compClass, len - pos);
                int j = 0;
                while (j < len - pos) {
                    n = pos + j;
                    Object j_obj = testRec.getTObject(pos + j + 1);
                    Array.set(t_arry, j, j_obj);
                    ++j;
                }
                t_list.add(t_arry);
            } else {
                pos = len;
            }
            int i = pos - 1;
            while (i >= 0) {
                n = i + 1;
                Object i_obj = testRec.getTObject(i + 1);
                t_list.add(0, i_obj);
                --i;
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Messages.getString("TestCommander.33")) + Integer.toString(n) + Messages.getString("TestCommander.34") + e.getMessage());
        }
        return t_list.toArray(new Object[t_list.size()]);
    }
}

