/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.run;

import com.ftinc.si.assist.run.DBMediator;
import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.run.TestCommander;
import com.ftinc.si.assist.run.VCentral;
import com.ftinc.si.assist.test.TestCaseRecord;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.gui.EnvironmentData;
import com.ftinc.si.assist.test.gui.TestCaseBrowser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public final class TestSubMain {
    private static File s_cmdfile = null;
    private static boolean b_contMode = false;

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equalsIgnoreCase("-daemon")) {
            EnvironmentData t_env = Tool.readEnvironment(false);
            s_cmdfile = Tool._libfile("$LIBDIR\\cmds.q");
            try {
                if (s_cmdfile.exists()) {
                    s_cmdfile.delete();
                }
                s_cmdfile.createNewFile();
                s_cmdfile.deleteOnExit();
                Long xtime = s_cmdfile.lastModified();
                System.out.println(Messages.getString("TestSubMain.1"));
                int target = 0;
                int i = 0;
                while (i < 43200) {
                    if (xtime.longValue() != s_cmdfile.lastModified()) {
                        try {
                            List<String> xcontents = Files.readAllLines(Paths.get(s_cmdfile.getPath(), new String[0]), Charset.forName("UTF-8"));
                            if (target < xcontents.size()) {
                                String str_cmd = xcontents.get(target);
                                ++target;
                                if (str_cmd.contains("-qed")) {
                                    String[] xstrs = str_cmd.split("\\t");
                                    System.out.println(String.valueOf(str_cmd) + ">> doing.");
                                    int t_res = -1;
                                    if (Tool.s_jarname.length() > 0) {
                                        String[] xoptions = xstrs[1].trim().split("\\s");
                                        String[] xcmds = new String[xoptions.length + 3];
                                        xcmds[0] = "java";
                                        xcmds[1] = "-jar";
                                        xcmds[2] = String.valueOf(Tool.s_jarname) + ".jar";
                                        int j = 0;
                                        while (j < xoptions.length) {
                                            xcmds[j + 3] = xoptions[j];
                                            ++j;
                                        }
                                        t_res = Tool.executeCommand(new StringBuilder(), Tool.s_userdir, xcmds);
                                    } else {
                                        b_contMode = true;
                                        TestSubMain.main(xstrs[1].trim().split("\\s"));
                                        t_res = 0;
                                    }
                                    xcontents = Files.readAllLines(Paths.get(s_cmdfile.getPath(), new String[0]), Charset.forName("UTF-8"));
                                    String[] res_strs = xcontents.toArray(new String[xcontents.size()]);
                                    int j = 0;
                                    while (j < res_strs.length) {
                                        res_strs[j] = res_strs[j].replace("-qed\t" + xstrs[1].trim(), "-done\t" + xstrs[1].trim());
                                        ++j;
                                    }
                                    if (!Tool.writeAllLines(s_cmdfile.getPath(), res_strs)) {
                                        System.out.println(String.valueOf(str_cmd) + ">> Failed to write the result.");
                                    } else {
                                        System.out.println(String.valueOf(str_cmd) + ">> successfully done.");
                                    }
                                    xtime = s_cmdfile.lastModified();
                                }
                            }
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        } else if (args.length > 0 && args[0].length() > 0) {
            HashMap<String, Object> t_map;
            EnvironmentData t_env = Tool.readEnvironment(true);
            if (Tool.debug_mode) {
                Tool.alertMSG(null, String.valueOf(Messages.getString("TestSubMain.18")) + args[0]);
            }
            if (!(t_map = TestSubMain.parseArgs(args)).containsKey("verb")) {
                Tool.alertMSG(null, "verb option not specified");
                TestSubMain.exitingFromFaceless(-1);
            } else if ("execCase".equals(t_map.get("verb"))) {
                if (t_map.containsKey("$")) {
                    HashMap t_gvar = (HashMap)Tool.getObjectfromJSON(HashMap.class, t_map.get("$").toString());
                    VCentral.prepare(t_gvar);
                }
                TestCommander.runCase(t_map);
            } else if ("exec&wait".equals(t_map.get("verb"))) {
                TestSubMain.execProcessMode(t_map, "close&ContMode");
            } else if ("display".equals(t_map.get("verb"))) {
                TestSubMain.execProcessMode(t_map, "close&ExitMode");
            } else if ("nodisplay".equals(t_map.get("verb"))) {
                TestSubMain.execProcessMode(t_map, "logonly");
            } else if (t_map.get("verb").toString().startsWith("#")) {
                try {
                    Tool.logIfDebug(null, "<ftmsg msg=\"invoking creator in main.\"/>");
                    Class<?> x_c = Tool.forName(t_map.get("creator").toString());
                    Method x_m = x_c.getMethod("command", HashMap.class);
                    Object t_ret = x_m.invoke(Tool.newObject(x_c, null, null), t_map);
                    if ((Integer)t_ret != 5) {
                        TestSubMain.exitingFromFaceless((Integer)t_ret);
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    String e_msg = "msg=" + e.getMessage() + "\nstack=" + Tool.getStackMessage(e, 0, 10);
                    Tool.alertMSG(null, e_msg);
                    TestSubMain.exitingFromFaceless(-1);
                }
            } else if ("delete".equals(t_map.get("verb"))) {
                String t_name = t_map.get("caseName").toString();
                int t_res = JOptionPane.showConfirmDialog(null, String.valueOf(t_name) + Messages.getString("TestCaseBrowser.53"));
                if (t_res == 0) {
                    try {
                        Tool._db().removeCase(t_name, Tool.version);
                        JOptionPane.showMessageDialog(null, Messages.getString("TestCaseBrowser.38"));
                    }
                    catch (SQLException e) {
                        Tool.alertMSG(null, String.valueOf(Messages.getString("TestCaseBrowser.51")) + e.getMessage());
                    }
                }
            } else if ("env".equals(t_map.get("verb"))) {
                if ((t_env = Tool.openEnvironmentDialog(null, t_env)) != null) {
                    Tool.saveEnvironment(t_env);
                }
                TestSubMain.exitingFromFaceless(0);
            } else if ("remoteDB".equals(t_map.get("verb"))) {
                DBMediator t_db = new DBMediator();
                t_db.execMain(t_map);
            }
        } else {
            TestCaseBrowser mFrame = new TestCaseBrowser();
            if (!b_contMode) {
                mFrame.setDefaultCloseOperation(3);
            }
            mFrame.setLocationRelativeTo(null);
            mFrame.setBounds(12, 12, 800, 480);
            mFrame.setVisible(true);
        }
    }

    private static HashMap<String, Object> parseArgs(String[] args) {
        HashMap<String, Object> t_map = new HashMap<String, Object>();
        Pattern t_pat = Pattern.compile("^\\-([^:\\s]+?):(.*)$");
        int i = 0;
        while (i < args.length) {
            Matcher t_m = t_pat.matcher(args[i]);
            if (t_m.find()) {
                String t_key = t_m.group(1);
                String t_val = t_m.group(2);
                t_val = t_val.replaceFirst("^(')(.*)(')$", "$2");
                if (!t_key.equals("testcase")) {
                    t_val = Tool.rest4CMD(t_val);
                }
                if (t_key.equals("properties") && t_val.startsWith("{") && t_val.endsWith("}")) {
                    HashMap p_map = (HashMap)Tool.getObjectfromJSON(HashMap.class, t_val);
                    for (Map.Entry entry : p_map.entrySet()) {
                        if (((String)entry.getValue()).startsWith("$LIBDIR")) {
                            File t_path = Tool._libfile((String)entry.getValue());
                            System.setProperty((String)entry.getKey(), t_path.getAbsolutePath());
                            continue;
                        }
                        System.setProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                t_map.put(t_key, Tool.getObjectfromJSON(null, t_val));
            } else if (args[i].startsWith("-") && !t_map.containsKey("verb")) {
                t_map.put("verb", args[i].substring(1));
            }
            ++i;
        }
        Tool.logIfDebug(null, "<ftmsg msg=\"end of the parsing arguments.\"/>");
        return t_map;
    }

    private static void exitingFromFaceless(int status) {
        Tool.logIfDebug(null, "<ftmsg msg=\"exiting now.\"/>");
        if (!b_contMode) {
            Tool.destroy();
            System.exit(status);
        }
    }

    private static void execProcessMode(HashMap<String, Object> args, String mode) {
        Tool.logIfDebug(null, "<ftmsg msg=\"start in execProcessMode. mode=" + mode + "\"/>");
        String j_path = Tool.s_userdir;
        ArrayList<TestCaseRecord> t_cases = null;
        String logfile_name = "log.txt";
        String t_version = Tool.version;
        String casename = "";
        if (args.containsKey("v")) {
            t_version = args.get("v").toString();
        }
        if (args.containsKey("testcase")) {
            Object t_array = args.get("testcase");
            String[] t_strs = null;
            if (List.class.isAssignableFrom(t_array.getClass())) {
                ArrayList temp_list = (ArrayList)t_array;
                t_strs = new String[temp_list.size()];
                int i = 0;
                while (i < t_strs.length) {
                    t_strs[i] = temp_list.get(i).toString();
                    ++i;
                }
            } else {
                t_strs = (String[])Tool.getObjectfromJSON(String[].class, t_array.toString());
            }
            TestCaseRecord t_rec = new TestCaseRecord(0, t_strs);
            casename = t_rec.name;
            t_cases = Tool._db().getTestCaseList(t_rec.name, t_rec.begin, t_rec.end, "", t_version);
            if (t_rec.description != null && t_rec.description.length() > 0) {
                logfile_name = t_rec.description;
            }
            if (logfile_name.indexOf(".") < 0) {
                logfile_name = String.valueOf(logfile_name) + ".txt";
            }
            if (t_cases.size() == 0) {
                Tool.alertMSG(null, String.valueOf(args.get("testcase").toString()) + Messages.getString("TestSubMain.35"));
                Tool.destroy();
                System.exit(1);
            }
        } else if (args.containsKey("caseName")) {
            casename = args.get("caseName").toString();
            t_cases = Tool._db().getTestCaseList(casename, 0, 0, "", t_version);
            if (t_cases.size() == 0) {
                Tool.alertMSG(null, String.valueOf(casename) + Messages.getString("TestSubMain.36"));
                Tool.destroy();
                System.exit(1);
            }
        } else {
            t_cases = Tool._db().getTestCaseList("%", 0, 0, "", t_version);
            casename = "all";
            if (t_cases.size() == 0) {
                Tool.alertMSG(null, Messages.getString("TestSubMain.38"));
                Tool.destroy();
                System.exit(1);
            }
        }
        if ("close&ExitMode".equals(mode)) {
            Tool.initStatusWin(true);
        } else if ("close&ContMode".equals(mode)) {
            Tool.initStatusWin(false);
        }
        if (logfile_name.indexOf("\\") < 0) {
            logfile_name = String.valueOf(Tool.logFolder) + "\\" + logfile_name;
        }
        File f_log = new File(logfile_name);
        PrintStream t_log = null;
        try {
            if (!f_log.exists()) {
                f_log.createNewFile();
            }
            t_log = new PrintStream(new FileOutputStream(f_log, false));
        }
        catch (IOException e) {
            Tool.alertMSG(null, "filename=" + logfile_name + " msg=" + e.getMessage());
            e.printStackTrace();
            return;
        }
        String t_head = "<?xml version=\"1.0\" ?>";
        t_head = String.valueOf(t_head) + "<testsuites disabled=\"$DISABLED\" skipped=\"$SKIPPED\" assertions=\"$ASSERTIONS\" errors=\"$ERRORS\" failures=\"$FAILURES\" name=\"" + casename + "\" tests=\"$TESTS\">";
        String options = "";
        if (args.containsKey("$")) {
            options = "-$:" + Tool.esq4CMD(Tool.getJSONfromObject(args.get("$")));
        }
        if (args.containsKey("v")) {
            if (options.length() > 0) {
                options = String.valueOf(options) + " ";
            }
            options = String.valueOf(options) + "-v:" + args.get("v");
        }
        if (args.containsKey("properties")) {
            if (options.length() > 0) {
                options = String.valueOf(options) + " ";
            }
            options = String.valueOf(options) + "-properties:" + Tool.esq4CMD(Tool.getJSONfromObject(args.get("properties")));
        }
        if (Tool.process_mode || "close&ExitMode".equals(mode) || "logonly".equals(mode)) {
            if (options.length() > 0) {
                options = String.valueOf(options) + " ";
            }
            options = String.valueOf(options) + "-child_mode:true";
        }
        int n_error = 0;
        int n_fail = 0;
        int n_skip = 0;
        int n_disabled = 0;
        int n_assert = 0;
        int n_all = 0;
        String t_result = "";
        int i = 0;
        while (i < t_cases.size()) {
            block63: {
                block62: {
                    String str_rec = t_cases.get((int)i).name;
                    str_rec = Tool.esq4CMD(str_rec);
                    StringBuilder str_b = new StringBuilder();
                    if (!Tool.process_mode && !"close&ExitMode".equals(mode) && !"logonly".equals(mode)) break block62;
                    String cmd = String.valueOf(Tool.s_jarname) + ".jar";
                    String eMode = (String)args.get("editmode");
                    if (eMode == null) {
                        eMode = "false";
                    }
                    Tool.logIfDebug(null, "execCase in execProcessMode. cmd=" + cmd + " " + str_rec);
                    int t_res = Tool.executeCommand(str_b, j_path, "java", "-jar", cmd, "-execCase", "-editmode:" + eMode, "-caseName:" + str_rec, options);
                    if (t_res > 1000) {
                        Tool.alertMSG(null, String.valueOf(Messages.getString("TestCaseBrowser.56")) + Integer.toString(t_res - 1000) + "!");
                    } else if (t_res > 0) {
                        Tool.alertMSG(null, String.valueOf(cmd) + " failed in " + j_path + ".(ExitCode=" + Integer.toString(t_res) + ")\n" + str_b);
                    }
                    if (str_b.length() <= 0) break block63;
                    t_log.append(str_b);
                    Pattern t_pat = Pattern.compile("(errors|tests|failures|skipped|disabled|assertions)=\"(\\d+)\"");
                    Matcher t_m = t_pat.matcher(str_b);
                    while (t_m.find()) {
                        int num = Integer.valueOf(t_m.group(2));
                        switch (t_m.group(1)) {
                            case "errors": {
                                n_error += num;
                                break;
                            }
                            case "tests": {
                                n_all += num;
                                break;
                            }
                            case "failures": {
                                n_fail += num;
                                break;
                            }
                            case "assertions": {
                                n_assert += num;
                                break;
                            }
                            case "disabled": {
                                n_disabled += num;
                                break;
                            }
                            case "skipped": {
                                n_skip += num;
                            }
                        }
                    }
                    if (!mode.equals("logonly")) {
                        t_result = String.valueOf(t_result) + str_b;
                        Tool.displayResult(t_result);
                    }
                    break block63;
                }
                TestCommander.runCase(args);
            }
            ++i;
        }
        Tool.logIfDebug(null, Messages.getString("TestSubMain.57"));
        if (t_log != null) {
            t_log.append("</testsuites>");
            t_log.close();
            t_head = t_head.replace("$SKIPPED", Integer.toString(n_skip));
            t_head = t_head.replace("$DISABLED", Integer.toString(n_disabled));
            t_head = t_head.replace("$TESTS", Integer.toString(n_all));
            t_head = t_head.replace("$ASSERTIONS", Integer.toString(n_assert / 2));
            t_head = t_head.replace("$FAILURES", Integer.toString(n_fail));
            t_head = t_head.replace("$ERRORS", Integer.toString(n_error));
            BufferedReader next_in = null;
            BufferedWriter next_out = null;
            try {
                String t_buff;
                next_in = new BufferedReader(new FileReader(logfile_name));
                next_out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(String.valueOf(logfile_name) + "2")));
                next_out.write(t_head);
                while ((t_buff = next_in.readLine()) != null) {
                    next_out.write(t_buff);
                }
                next_in.close();
                next_out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            File temp_f = new File(logfile_name);
            temp_f.delete();
            File t_f = new File(String.valueOf(logfile_name) + "2");
            t_f.renameTo(new File(logfile_name));
        }
        if (!mode.equals("close&ContMode")) {
            if ("close&ExitMode".equals(mode)) {
                Tool.waitDisplayEvent();
            }
            Tool.destroy();
            System.exit(0);
        }
    }
}

