/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test;

import com.ftinc.si.assist.run.DBMediator;
import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.run.VCentral;
import com.ftinc.si.assist.test.DBService;
import com.ftinc.si.assist.test.JSONRecord;
import com.ftinc.si.assist.test.Tool;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.CannotCompileException;
import javassist.NotFoundException;

public class Fson {
    static final Pattern p_map = Pattern.compile("\\A\\{(.*)\\}\\s*\\z", 32);
    static final Pattern p_array = Pattern.compile("\\A\\s*\\[(.*)\\]\\s*\\z", 32);
    static final Pattern p_float = Pattern.compile("\\A\\s*\\-?([1-9][0-9]*|0)\\.[0-9]+\\s*\\z");
    static final Pattern p_int = Pattern.compile("\\A\\s*\\-?([1-9][0-9]*|0)\\s*\\z");
    static final Pattern p_bool = Pattern.compile("\\A\\s*(true|false)\\s*\\z");
    static final Pattern p_string = Pattern.compile("\\A\\s*\"(.*?)\"\\s*\\z", 32);
    static final Pattern p_object = Pattern.compile("\\A\\s*\\{(.*)\\}\\s*\\z", 32);
    static final Pattern p_withCast = Pattern.compile("\\A\\s*\\(([\\w\\.\\$\\[\\]]+)\\)(.*)\\s*\\Z", 32);
    static final Pattern p_byJsontemplate = Pattern.compile("\\A\\s*\\(([\\w\\.\\[\\]<>,]+)\\([\\w\\-@]+\\)\\)([\\{\\]]?.*[\\}\\]]?)\\s*\\Z", 32);
    public static HashMap<String, String> s_defaultParams = null;
    private static ArrayList<Object> o_stack = new ArrayList();
    static final Pattern p_consArg = Pattern.compile("\"?arg([0-9]+)\\(([\\w\\.\\[\\]]+)\\)\"?");
    public static Class<?>[] _c_list;
    public static Object[] _o_list;
    static final Pattern p_dqt;
    static final Pattern p_braket1;
    static final Pattern p_braket2;
    static final Pattern p_braket3;
    static final Pattern p_braket4;
    private static Object s_outer;

    static {
        p_dqt = Pattern.compile("\"([^\"]*)\"");
        p_braket1 = Pattern.compile("\\{([^\\{\\}]*?)\\}");
        p_braket2 = Pattern.compile("\\[([^\\[\\]]*?)\\]");
        p_braket3 = Pattern.compile("\\(([^\\(\\)]*?)\\)");
        p_braket4 = Pattern.compile("'([^']*?)'");
        s_outer = null;
    }

    public static void initDefaultParams() {
        s_defaultParams = new HashMap();
        if (s_defaultParams == null) {
            Connection t_con = DBService.s_connect;
            if (t_con == null) {
                t_con = DBMediator.s_connect;
            }
            if (t_con != null) {
                String t_sql = "select * from \"tbl_JSONRecord\" where \"Name\"='CONSTRUCTOR'";
                try {
                    Statement t_state = t_con.createStatement();
                    ResultSet t_res = t_state.executeQuery(t_sql);
                    while (t_res.next()) {
                        String cname = t_res.getString("ClassName");
                        String json = t_res.getString("Content");
                        if (s_defaultParams == null || !s_defaultParams.containsKey(cname)) continue;
                        s_defaultParams.put(cname, json);
                    }
                    t_res.close();
                    t_state.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void pushed(Object o) {
        if (o != null) {
            o_stack.add(o);
        }
    }

    private static void popped(Object o) {
        if (o != null && o.equals(o_stack.get(o_stack.size() - 1))) {
            o_stack.remove(o_stack.size() - 1);
        }
    }

    private static boolean isLooped(Object obj) {
        return obj != null && o_stack.contains(obj);
    }

    public static String toJson(Object obj, Class<?> c) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalAccessException, NoSuchFieldException, NotSupportedClassException {
        return Fson.toJson(obj, c, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toJson(Object obj, Class<?> c, String regs) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalAccessException, NoSuchFieldException, NotSupportedClassException {
        if (Fson.isLooped(obj)) return "null";
        if (obj == null) {
            return "null";
        }
        String result = "";
        if (c == null) {
            return Fson.toJson(obj, obj.getClass(), regs);
        }
        Fson.pushed(obj);
        try {
            String cname = c.getSimpleName();
            if (cname.equals("int") || cname.equals("Integer")) {
                result = Integer.toString((Integer)obj);
                return result;
            } else if (cname.equals("long") || cname.equals("Long")) {
                result = Long.toString((Long)obj);
                return result;
            } else if (cname.equals("boolean") || cname.equals("Boolean")) {
                result = Boolean.toString((Boolean)obj);
                return result;
            } else if (cname.equals("char") || cname.equals("Character")) {
                result = "(java.lang.Character)" + Character.toString(((Character)obj).charValue());
                return result;
            } else if (cname.equals("float") || cname.equals("Float")) {
                result = Float.toString(((Float)obj).floatValue());
                return result;
            } else if (cname.equals("byte") || cname.equals("Byte")) {
                result = "(java.lang.Byte)" + Byte.toString((Byte)obj);
                return result;
            } else if (cname.equals("double") || cname.equals("Double")) {
                result = "(java.lang.Double)" + Double.toString((Double)obj);
                return result;
            } else if (cname.equals("AtomicInteger")) {
                result = "(java.util.concurrent.atomic.AtomicInteger)" + obj.toString();
                return result;
            } else if (cname.equals("AtomicLong")) {
                result = "(java.util.concurrent.atomic.AtomicLong)" + obj.toString();
                return result;
            } else if (cname.equals("BigDecimal")) {
                result = "(java.math.BigDecimal)" + obj.toString();
                return result;
            } else if (cname.equals("BigInteger")) {
                result = "(java.math.BigInteger)" + obj.toString();
                return result;
            } else {
                if (cname.equals("Class")) {
                    String string = String.valueOf(((Class)obj).getName()) + ".class";
                    return string;
                }
                if (cname.equals("String")) {
                    Matcher t_m = p_string.matcher(obj.toString());
                    result = t_m.find() ? Fson.escape(obj.toString()) : "\"" + Fson.escape(obj.toString()) + "\"";
                    return result;
                } else if (c.isArray()) {
                    Class<?> c_obj = obj.getClass();
                    if (!c_obj.isArray()) throw new IllegalAccessException(String.valueOf(c_obj.getName()) + Messages.getString("Fson.0") + c.getName() + ".");
                    Class<?> t_c = c.getComponentType();
                    String json = "[";
                    int i = 0;
                    while (i < Array.getLength(obj)) {
                        json = String.valueOf(json) + Fson.toJson(Array.get(obj, i), t_c, regs);
                        if (i < Array.getLength(obj) - 1) {
                            json = String.valueOf(json) + ",";
                        }
                        ++i;
                    }
                    result = String.valueOf(json) + "]";
                    return result;
                } else if (c.isEnum()) {
                    ?[] en_list = c.getEnumConstants();
                    String t_json = null;
                    int i = 0;
                    while (i < en_list.length) {
                        if (obj.equals(en_list[i])) {
                            t_json = "(" + c.getName() + ")" + Integer.toString(i);
                        }
                        ++i;
                    }
                    if (t_json == null) throw new IllegalAccessException(String.valueOf(c.getName()) + "has not " + obj.toString() + ".");
                    result = t_json;
                    return result;
                } else if (obj instanceof Map) {
                    String json = "{";
                    Map t_map = (Map)obj;
                    for (Map.Entry entry : t_map.entrySet()) {
                        String t_key;
                        if (json.length() > 1) {
                            json = String.valueOf(json) + ",";
                        }
                        if ((t_key = Fson.toJson(entry.getKey(), null)) == null || t_key.equals("null")) continue;
                        json = String.valueOf(json) + Fson.toJson(entry.getKey(), null, regs) + ":" + Fson.toJson(entry.getValue(), null, regs);
                    }
                    result = String.valueOf(json) + "}";
                    return result;
                } else if (List.class.isAssignableFrom(c)) {
                    String json = "[";
                    Object[] t_array = ((List)obj).toArray();
                    int i = 0;
                    while (i < t_array.length) {
                        Object x_obj = t_array[i];
                        String s_json = "null";
                        String t_cast = "";
                        if (x_obj != null && ((s_json = Fson.toJson(x_obj, null, regs)).startsWith("{") || s_json.startsWith("["))) {
                            String xcname = x_obj.getClass().getName();
                            if (x_obj.getClass().isArray()) {
                                xcname = String.valueOf(x_obj.getClass().getComponentType().getName()) + "[]";
                            }
                            t_cast = "(" + xcname + ")";
                        }
                        json = String.valueOf(json) + t_cast + s_json;
                        if (i < t_array.length - 1) {
                            json = String.valueOf(json) + ",";
                        }
                        ++i;
                    }
                    result = String.valueOf(json) + "]";
                    return result;
                } else {
                    if (Collection.class.isAssignableFrom(c)) {
                        throw new NotSupportedClassException(String.valueOf(c.getName()) + ">>Fson cuurently not support.");
                    }
                    if (Tool.isFake(cname)) {
                        ArrayList<Object> t_fakes = Fson.valueByJsonPath(obj, "$");
                        if (t_fakes.size() <= 0) return result;
                        result = Fson.toJson(t_fakes.get(0), HashMap.class, regs);
                        return result;
                    } else {
                        if (cname.indexOf("$") >= 0) return result;
                        String t_cast = "";
                        if (obj != null && c != null && c != obj.getClass()) {
                            if (!c.isInstance(obj)) {
                                throw new IllegalAccessException(String.valueOf(obj.getClass().getName()) + Messages.getString("Fson.1") + c.getName() + ".");
                            }
                            t_cast = "(" + obj.getClass().getName() + ")";
                        }
                        boolean bskip = false;
                        if (!Tool.hasDefaultConstructor(obj.getClass().getName(), true) && !s_defaultParams.containsKey(obj.getClass().getName())) {
                            bskip = true;
                            Tool.logForTesting(null, "FSON_WARNING: " + obj.getClass().getName() + " " + Messages.getString("Fson.2"));
                        }
                        if (bskip) return result;
                        String json = "{";
                        HashMap<String, String> f_map = Fson.getFields(c);
                        for (Map.Entry<String, String> entry : f_map.entrySet()) {
                            String s_json;
                            Matcher t_m;
                            Pattern t_pat;
                            Matcher t_m2;
                            String key = entry.getKey();
                            Object t_obj = null;
                            if (regs != null && !(t_m2 = (t_pat = Pattern.compile(regs)).matcher(key)).find()) continue;
                            t_obj = Tool.getFieldValue(obj, key);
                            Class<?> t_c = Tool.forName(entry.getValue());
                            if (regs != null && (t_obj == null || t_obj.toString().length() == 0)) continue;
                            json = t_obj == null ? String.valueOf(json) + "\"" + key + "\":null," : (t_c == t_obj.getClass() ? String.valueOf(json) + "\"" + key + "\":" + Fson.toJson(t_obj, t_obj.getClass(), regs) + "," : (t_c.isArray() ? String.valueOf(json) + "\"" + key + "\":(" + t_obj.getClass().getComponentType().getName() + "[])" + Fson.toJson(t_obj, t_obj.getClass(), regs) + "," : ((t_m = p_object.matcher(s_json = Fson.toJson(t_obj, t_obj.getClass(), regs))).find() && !t_c.equals(t_obj.getClass()) ? String.valueOf(json) + "\"" + key + "\":(" + t_obj.getClass().getName() + ")" + s_json + "," : String.valueOf(json) + "\"" + key + "\":" + s_json + ",")));
                        }
                        result = String.valueOf(t_cast) + json.replaceFirst(",\\z", "") + "}";
                    }
                }
            }
            return result;
        }
        finally {
            Fson.popped(obj);
        }
    }

    public static Object fromJson(String json, Class<?> cl) throws ClassNotFoundException, InstantiationException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ParseException, NotSupportedClassException {
        if (json == null || "null".equals(json) || json.length() == 0 && !String.class.equals(cl)) {
            return null;
        }
        if (json.matches("^[0-9]+\\$[_0-9]+$")) {
            Object t_obj = Tool.instance_table.get(json);
            if (cl == null || cl.isInstance(t_obj)) {
                return t_obj;
            }
            return json;
        }
        Matcher t_m = p_withCast.matcher(json = Fson.removeComments(json));
        if (t_m.find() && (cl == null || !String.class.equals(cl))) {
            String xcname = t_m.group(1);
            String xjson = t_m.group(2);
            Object t_obj = Fson.fromJson(xjson, Tool.forName(xcname));
            if (cl == null) {
                return t_obj;
            }
            if (t_obj != null && cl.isArray()) {
                if (Array.getLength(t_obj) > 0) {
                    Object x_obj = Array.get(t_obj, 0);
                    Class<?> x_cl = cl.getComponentType();
                    if (x_cl.isInstance(x_obj)) {
                        return t_obj;
                    }
                }
            } else if (cl.isInstance(t_obj)) {
                return t_obj;
            }
            throw new IllegalAccessException(String.valueOf(t_m.group(1)) + Messages.getString("Fson.3") + cl.getName() + ".");
        }
        if ((cl == null || cl.getName().equals("java.lang.Object")) && json.indexOf("\"initialize\"") < 0) {
            if (json.endsWith(".class")) {
                return Tool.forName(json.substring(0, json.length() - 6));
            }
            t_m = p_array.matcher(json);
            if (t_m.find()) {
                return Fson.fromJson(json, ArrayList.class);
            }
            t_m = p_int.matcher(json);
            if (t_m.find()) {
                try {
                    return Integer.valueOf(json);
                }
                catch (NumberFormatException e) {
                    return Long.valueOf(json);
                }
            }
            t_m = p_float.matcher(json);
            if (t_m.find()) {
                try {
                    return Float.valueOf(json);
                }
                catch (NumberFormatException e) {
                    return Double.valueOf(json);
                }
            }
            t_m = p_bool.matcher(json);
            if (t_m.find()) {
                return Boolean.valueOf(json);
            }
            t_m = p_string.matcher(json);
            if (t_m.find()) {
                return Fson.execCodeInString(Fson.restore(t_m.group(1)));
            }
            t_m = p_object.matcher(json);
            if (t_m.find()) {
                return Fson.fromJson(json, HashMap.class);
            }
            t_m = p_byJsontemplate.matcher(json);
            if (t_m.find()) {
                String t_cname = t_m.group(1);
                String t_subname = t_m.group(2);
                String t_json = t_m.group(3);
                JSONRecord j_rec = JSONRecord.getJSONRec(t_cname, t_subname);
                if (j_rec != null) {
                    Object t_obj = Fson.fromJson(j_rec.content, Tool.forName(t_cname));
                    HashMap<String, String> t_map = Fson.getFieldMapOfJson(t_json);
                    for (Map.Entry<String, String> entry : t_map.entrySet()) {
                        Fson.updateByJsonPath(t_obj, entry.getKey(), entry.getValue());
                    }
                    return t_obj;
                }
            }
            return Fson.execCodeInString(Fson.restore(json));
        }
        String cname = cl.getSimpleName();
        HashMap<String, String> t_map = Fson.getFieldMapOfJson(json);
        Object t_obj = null;
        if (t_map.containsKey("initialize")) {
            try {
                t_obj = Fson.newFromJson(cl, t_map);
            }
            catch (CannotCompileException | NotFoundException e) {
                throw new IllegalArgumentException(String.valueOf(Messages.getString("Fson.18")) + json + "." + e.getMessage());
            }
        }
        if (!cname.equals("String") && (t_m = p_string.matcher(json)).find()) {
            json = t_m.group(1);
        }
        if (cl.isArray()) {
            t_m = p_array.matcher(json);
            if (t_m.find()) {
                Class<?> t_cl;
                String src = t_m.group(1);
                ArrayList<String> t_list = Fson.escapeBraket(src, null);
                String temp = t_list.get(0);
                String[] sub_srcs = temp == null || temp.length() == 0 ? new String[]{} : t_list.get(0).split(",", -1);
                int t_len = sub_srcs.length;
                if (src.length() == 0) {
                    t_len = 0;
                }
                if ("java.lang.Class".equals((t_cl = cl.getComponentType()).getName())) {
                    t_cl = null;
                }
                Object t_array = t_obj;
                if (t_obj == null) {
                    t_array = Array.newInstance(t_cl, t_len);
                    int i = 0;
                    while (i < t_len) {
                        Array.set(t_array, i, Fson.fromJson(Fson.restoreBraket(sub_srcs[i], t_list), t_cl));
                        ++i;
                    }
                }
                return t_array;
            }
            if (t_obj != null) {
                return t_obj;
            }
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Fson.5")) + json + ".");
        }
        if (cl.isInterface()) {
            throw new InstantiationException(Messages.getString("Fson.4"));
        }
        if (List.class.isAssignableFrom(cl)) {
            t_m = p_array.matcher(json);
            if (t_m.find()) {
                String src = t_m.group(1);
                ArrayList<String> t_list = Fson.escapeBraket(src, null);
                String temp = t_list.get(0);
                String[] sub_srcs = temp == null || temp.length() == 0 ? new String[]{} : t_list.get(0).split(",", -1);
                List x_list = (List)t_obj;
                if (x_list == null) {
                    x_list = (List)Tool.newObject(cl, new Class[0], new Object[0]);
                    int i = 0;
                    while (i < sub_srcs.length) {
                        String s_json = Fson.restoreBraket(sub_srcs[i], t_list);
                        Object l_obj = Fson.fromJson(s_json, null);
                        x_list.add(l_obj);
                        ++i;
                    }
                }
                return x_list;
            }
            if (t_obj != null) {
                return t_obj;
            }
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Fson.6")) + json + ".");
        }
        if (Collection.class.isAssignableFrom(cl)) {
            throw new NotSupportedClassException(String.valueOf(cl.getName()) + ">>Fson cuurently not support.");
        }
        if (cname.equals("int") || cname.equals("Integer")) {
            t_m = p_int.matcher(json);
            if (t_m.find()) {
                return Integer.valueOf(json);
            }
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Fson.7")) + json + ".");
        }
        if (cname.equals("long") || cname.equals("Long")) {
            t_m = p_int.matcher(json);
            if (t_m.find()) {
                return Long.valueOf(json);
            }
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Fson.8")) + json + ".");
        }
        if (cname.equals("byte") || cname.equals("Byte")) {
            return Byte.valueOf(json);
        }
        if (cname.equals("boolean") || cname.equals("Boolean")) {
            t_m = p_bool.matcher(json);
            if (t_m.find()) {
                return Boolean.valueOf(json);
            }
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Fson.9")) + json + ".");
        }
        if (cname.equals("char") || cname.equals("Character")) {
            if (json.length() == 1) {
                return Character.valueOf(json.charAt(0));
            }
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Fson.10")) + json + ".");
        }
        if (cname.equals("float") || cname.equals("Float")) {
            t_m = p_float.matcher(json);
            if (t_m.find()) {
                return Float.valueOf(json);
            }
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Fson.11")) + json + ".");
        }
        if (cname.equals("double") || cname.equals("Double")) {
            t_m = p_float.matcher(json);
            if (t_m.find()) {
                return Double.valueOf(json);
            }
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Fson.12")) + json + ".");
        }
        if (cname.equals("BigDecimal")) {
            t_m = p_float.matcher(json);
            if (t_m.find()) {
                return new BigDecimal(json);
            }
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Fson.13")) + json + ".");
        }
        if (cname.equals("BigInteger")) {
            t_m = p_int.matcher(json);
            if (t_m.find()) {
                return new BigInteger(json);
            }
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Fson.14")) + json + ".");
        }
        if (cname.equals("AtomicInteger")) {
            t_m = p_int.matcher(json);
            if (t_m.find()) {
                return new AtomicInteger(Integer.valueOf(json));
            }
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Fson.15")) + json + ".");
        }
        if (cname.equals("AtomicLong")) {
            t_m = p_int.matcher(json);
            if (t_m.find()) {
                return new AtomicLong(Long.valueOf(json));
            }
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Fson.16")) + json + ".");
        }
        if (cname.equals("String")) {
            if (json.length() == 0) {
                return null;
            }
            t_m = p_string.matcher(json);
            if (t_m.find()) {
                json = t_m.group(1);
            }
            return Fson.execCodeInString(Fson.restore(json));
        }
        if (cl.isEnum()) {
            String t_i = json.replaceFirst("^\\s*\\([^\\)]*?\\)\\s*", "");
            return Fson.getEnumByInt(cl, t_i);
        }
        if (Map.class.isAssignableFrom(cl)) {
            HashMap<String, String> temp_map = Fson.getFieldMapOfJson(json);
            HashMap<Object, Object> t_result = (HashMap<Object, Object>)t_obj;
            if (t_result == null) {
                t_result = new HashMap<Object, Object>();
            }
            if (t_result != null) {
                for (Map.Entry<String, String> entry : temp_map.entrySet()) {
                    Object t_key = Fson.fromJson(entry.getKey(), null);
                    Object t_value = Fson.fromJson(entry.getValue(), null);
                    t_result.put(t_key, t_value);
                }
            }
            return t_result;
        }
        try {
            if (Tool.isFake(cl.getName())) {
                ArrayList<String> vals = new ArrayList<String>();
                vals.add(cl.getName());
                Pattern fake_mem = Pattern.compile("\\(([^\\)]+?)\\)(.*)");
                for (Map.Entry<String, String> entry : t_map.entrySet()) {
                    t_m = fake_mem.matcher(entry.getValue());
                    if (t_m.find()) {
                        vals.add(String.valueOf(entry.getKey()) + "=" + entry.getValue());
                        continue;
                    }
                    vals.add(String.valueOf(entry.getKey()) + "=(java.lang.String)" + entry.getValue());
                }
                t_obj = Tool.getFakeInstance(vals.toArray(new String[vals.size()]));
            } else {
                if (t_obj == null) {
                    t_obj = Fson.newFromJson(cl, t_map);
                }
                Fson.setAttrFromMap(t_obj, t_map);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Fson.18")) + json + ".");
        }
        return t_obj;
    }

    public static String _escape(String str) {
        str = str.replaceAll(Pattern.quote("\\''"), Matcher.quoteReplacement("\\''''"));
        str = str.replaceAll(Pattern.quote("\""), Matcher.quoteReplacement("\\''"));
        return str;
    }

    public static String _restore(String str) {
        str = str.replaceAll(Pattern.quote("\\''"), Matcher.quoteReplacement("\""));
        str = str.replaceAll(Pattern.quote("\"''"), Matcher.quoteReplacement("\\''"));
        return str;
    }

    public static String escape(String str) {
        String _bs = "%_@_BS_@_%";
        str = str.replaceAll("\t", String.valueOf(_bs) + "t");
        str = str.replaceAll("\b", String.valueOf(_bs) + "b");
        str = str.replaceAll("\f", String.valueOf(_bs) + "f");
        str = str.replaceAll("\n", String.valueOf(_bs) + "n");
        str = str.replaceAll("\r", String.valueOf(_bs) + "r");
        str = str.replaceAll(Pattern.quote("\\"), Matcher.quoteReplacement(String.valueOf(_bs) + _bs));
        str = str.replaceAll("/", Matcher.quoteReplacement(String.valueOf(_bs) + "/"));
        str = str.replaceAll("\"", Matcher.quoteReplacement(String.valueOf(_bs) + "\""));
        str = str.replaceAll(_bs, Matcher.quoteReplacement("\\"));
        return str;
    }

    public static String restore(String str) {
        String _bs = "%_@_BS_@_%";
        str = Tool.replaceB(str, "\\\\", _bs);
        str = str.replaceAll(Pattern.quote("\\t"), "\t");
        str = str.replaceAll(Pattern.quote("\\b"), "\b");
        str = str.replaceAll(Pattern.quote("\\f"), "\f");
        str = str.replaceAll(Pattern.quote("\\n"), "\n");
        str = str.replaceAll(Pattern.quote("\\r"), "\r");
        str = str.replaceAll(Pattern.quote("\\/"), Matcher.quoteReplacement("/"));
        str = str.replaceAll(Pattern.quote("\\\""), "\"");
        str = Tool.replaceB(str, _bs, "\\");
        return str;
    }

    private static String removeComments(String json) throws ParseException {
        String t_src;
        ArrayList<String> t_esqList = Fson.escapeBraket(json, "\"");
        String t_str = t_src = t_esqList.get(0);
        Pattern t_pat = Pattern.compile("//(\\s|\\?)[^\n]*");
        Matcher t_m = t_pat.matcher(t_src);
        if (t_m.find()) {
            t_str = t_m.replaceAll("");
        }
        t_str = t_str.replaceAll("^\\s*([\\s\\S]*?)\\s*$", "$1");
        return Fson.restoreBraket(t_str.toString(), t_esqList);
    }

    public static void setParameters(HashMap<String, String> map) throws ClassNotFoundException, SecurityException, IllegalArgumentException, InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, ParseException, NotSupportedClassException {
        Matcher t_m;
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            t_m = p_consArg.matcher(entry.getKey());
            if (!t_m.find()) continue;
            ++n;
        }
        _c_list = new Class[n];
        _o_list = new Object[n];
        for (Map.Entry<String, String> entry : map.entrySet()) {
            t_m = p_consArg.matcher(entry.getKey());
            if (!t_m.find()) continue;
            Integer num = Integer.valueOf(t_m.group(1)) - 1;
            String cname = t_m.group(2);
            if (num >= n) {
                throw new IllegalArgumentException("arg" + t_m.group(1) + Messages.getString("Fson.19"));
            }
            Fson._c_list[num.intValue()] = Tool.forName(cname);
            Fson._o_list[num.intValue()] = Fson.fromJson(entry.getValue(), Tool.forName(Tool.primitiveToFQN(cname)));
            if (entry.getValue() == null || _o_list[num] != null) continue;
            throw new IllegalArgumentException("arg" + t_m.group(1) + "(" + cname + Messages.getString("Fson.20"));
        }
    }

    public static Object newFromJson(Class<?> c, HashMap<String, String> map) throws SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, ParseException, NotSupportedClassException, CannotCompileException, NotFoundException {
        if (map.containsKey("initialize")) {
            return Tool.constructObject(c.getName(), Fson.fromJson(map.get("initialize").toString(), String.class).toString());
        }
        _c_list = new Class[0];
        _o_list = new Object[0];
        Object t_obj = Tool.tryDefaultConstructor(c);
        if (t_obj != null) {
            return t_obj;
        }
        Fson.setParameters(map);
        if (_c_list.length == 0) {
            String sname = c.getName();
            String paramsStr = s_defaultParams.get(sname);
            if (paramsStr != null) {
                HashMap<String, String> temp_map = Fson.getFieldMapOfJson(paramsStr);
                if (temp_map.containsKey("initialize")) {
                    return Tool.constructObject(c.getName(), Fson.fromJson(temp_map.get("initialize").toString(), String.class).toString());
                }
                Fson.setParameters(temp_map);
            } else {
                throw new NoSuchMethodException("FSON_FAIL: " + sname + Messages.getString("Fson.21"));
            }
        }
        if (s_outer != null) {
            ArrayList tc_list = new ArrayList();
            ArrayList<Object> to_list = new ArrayList<Object>();
            tc_list.add(s_outer.getClass());
            to_list.add(s_outer);
            int i = 0;
            while (i < _c_list.length) {
                tc_list.add(_c_list[i]);
                to_list.add(_o_list[i]);
                ++i;
            }
            _c_list = tc_list.toArray(new Class[tc_list.size()]);
            _o_list = to_list.toArray(new Object[to_list.size()]);
        }
        return Tool.newObject(c, _c_list, _o_list);
    }

    public static ArrayList<String> escapeBraket(String src, String filter) throws ParseException {
        String t_str;
        String str_q = "__%%__";
        Pattern t_pat = Pattern.compile(String.valueOf(Pattern.quote(str_q)) + "[0-9]+__");
        Matcher __m = t_pat.matcher(src);
        if (__m.find()) {
            Tool.logForTesting(null, "WARNING:" + Messages.getString("Fson.22") + src);
        }
        ArrayList<String> t_list = new ArrayList<String>();
        Integer i = 1;
        String _ddbs = "%_@_BSBS_@_%";
        String _ddq = "%_@_DQ_@_%";
        String t_src = src;
        t_src = t_src.replaceAll(Pattern.quote("\\\\"), _ddbs);
        t_src = t_src.replaceAll(Pattern.quote("\\\""), _ddq);
        Matcher t_m = null;
        if (filter == null || filter.contains("\"")) {
            t_m = p_dqt.matcher(t_src);
            while (t_m.find()) {
                t_str = t_m.group();
                t_src = t_src.replaceFirst(Pattern.quote(t_str), Matcher.quoteReplacement(String.valueOf(str_q) + i.toString() + "__"));
                t_list.add(t_str);
                t_m = p_dqt.matcher(t_src);
                i = i + 1;
            }
        }
        if (filter == null || filter.contains("'")) {
            t_m = p_braket4.matcher(t_src);
            while (t_m.find()) {
                t_str = t_m.group();
                t_list.add(t_str);
                t_src = t_src.replaceFirst(Pattern.quote(t_str), Matcher.quoteReplacement(String.valueOf(str_q) + i.toString() + "__"));
                t_m = p_braket4.matcher(t_src);
                i = i + 1;
            }
        }
        if (filter == null || filter.contains("{")) {
            t_m = p_braket1.matcher(t_src);
            while (t_m.find()) {
                t_str = t_m.group();
                if (t_str.matches("^" + Pattern.quote(str_q) + Integer.toString(i - 1) + "__" + "$")) {
                    throw new ParseException(Messages.getString("Fson.23"), i - 1);
                }
                t_list.add(t_str);
                t_src = t_src.replaceFirst(Pattern.quote(t_str), Matcher.quoteReplacement(String.valueOf(str_q) + i.toString() + "__"));
                t_m = p_braket1.matcher(t_src);
                i = i + 1;
            }
        }
        if (filter == null || filter.contains("[")) {
            t_m = p_braket2.matcher(t_src);
            while (t_m.find()) {
                t_str = t_m.group();
                t_list.add(t_str);
                t_src = t_src.replaceFirst(Pattern.quote(t_str), Matcher.quoteReplacement(String.valueOf(str_q) + i.toString() + "__"));
                t_m = p_braket2.matcher(t_src);
                i = i + 1;
            }
        }
        if (filter == null || filter.contains("(")) {
            t_m = p_braket3.matcher(t_src);
            while (t_m.find()) {
                t_str = t_m.group();
                t_list.add(t_str);
                t_src = t_src.replaceFirst(Pattern.quote(t_str), Matcher.quoteReplacement(String.valueOf(str_q) + i.toString() + "__"));
                t_m = p_braket3.matcher(t_src);
                i = i + 1;
            }
        }
        t_list.add(0, t_src);
        return t_list;
    }

    public static String restoreBraket(String str, ArrayList<String> list) {
        if (str == null) {
            return null;
        }
        String str_q = "__%%__";
        String t_src = str;
        Integer i = list.size() - 1;
        while (i > 0) {
            String d_str = list.get(i);
            t_src = t_src.replaceFirst(Pattern.quote(String.valueOf(str_q) + i.toString() + "__"), Matcher.quoteReplacement(d_str));
            i = i - 1;
        }
        String _ddbs = "%_@_BSBS_@_%";
        String _ddq = "%_@_DQ_@_%";
        t_src = t_src.replaceAll(_ddbs, Matcher.quoteReplacement("\\\\"));
        t_src = t_src.replaceAll(_ddq, Matcher.quoteReplacement("\\\""));
        return t_src;
    }

    public static HashMap<String, String> getFieldMapOfJson(String src) throws ParseException {
        HashMap<String, String> t_map = new HashMap<String, String>();
        Matcher t_m = p_object.matcher(src);
        if (t_m.find()) {
            ArrayList<String> t_list = Fson.escapeBraket(t_m.group(1), null);
            String temp = t_list.get(0);
            String[] t_elms = temp == null || temp.length() == 0 ? new String[]{} : t_list.get(0).split("\\s*,\\s*", -1);
            Pattern t_pat = Pattern.compile("^([^:]+?)\\s*:\\s*(.*?)$", 32);
            int i = 0;
            while (i < t_elms.length) {
                if (t_elms[i].length() > 0) {
                    t_m = t_pat.matcher(t_elms[i]);
                    if (t_m.find()) {
                        String key = Fson.restoreBraket(t_m.group(1), t_list);
                        key = key.replaceFirst("^\\s*([\\s\\S]+?)\\s*$", "$1");
                        key = key.replaceFirst("^\"(.*)\"$", "$1");
                        String val = Fson.restoreBraket(t_m.group(2), t_list);
                        val = val.replaceFirst("^\\s*([\\s\\S]+?)\\s*$", "$1");
                        t_map.put(key, val);
                    } else {
                        return null;
                    }
                }
                ++i;
            }
        }
        return t_map;
    }

    private static HashMap<String, String> getFields(Class<?> c) {
        if (c == null) {
            return null;
        }
        if (c.getName().equals("java.lang.Object")) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> t_map = Fson.getFields(c.getSuperclass());
        Field[] f_list = c.getDeclaredFields();
        int i = 0;
        while (i < f_list.length) {
            Class<?> t_c = f_list[i].getType();
            if (!Modifier.isFinal(f_list[i].getModifiers()) || !Modifier.isStatic(f_list[i].getModifiers())) {
                if (t_c.isArray()) {
                    t_c = t_c.getComponentType();
                    t_map.put(f_list[i].getName(), String.valueOf(t_c.getName()) + "[]");
                } else {
                    t_map.put(f_list[i].getName(), t_c.getName());
                }
            }
            ++i;
        }
        return t_map;
    }

    private static void setAttrFromMap(Object obj, HashMap<String, String> map) {
        if (obj != null && map != null) {
            try {
                if (obj instanceof Map) {
                    Map res_map = (Map)obj;
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        Object t_key = Fson.fromJson(entry.getKey(), null);
                        Object t_obj = res_map.get(t_key);
                        String t_restored = entry.getValue();
                        if (t_obj == null) {
                            t_obj = Fson.fromJson(t_restored, null);
                        } else if (Tool.isPrimitive2(t_obj.getClass()) || t_obj.getClass().isEnum()) {
                            t_obj = Fson.fromJson(t_restored, t_obj.getClass());
                        } else {
                            Fson.updateFromJson(t_obj, t_restored);
                        }
                        if (t_obj == null && res_map.containsKey(t_key)) continue;
                        res_map.put(t_key, t_obj);
                    }
                } else {
                    HashMap<String, String> f_map = Fson.getFields(obj.getClass());
                    for (Map.Entry<String, String> entry : f_map.entrySet()) {
                        String key = entry.getKey();
                        Field t_f = Tool.getField(obj.getClass(), key);
                        if (t_f == null) continue;
                        Class<?> f_c = t_f.getType();
                        String t_val = map.get(key);
                        if (f_c.isMemberClass()) {
                            s_outer = obj;
                        }
                        Object f_obj = t_f.get(obj);
                        if (Modifier.isFinal(t_f.getModifiers())) {
                            if (!Tool.isPrimitive2(f_c)) {
                                Fson.updateFromJson(f_obj, t_val);
                            }
                        } else if (f_obj == null || Tool.isPrimitive2(f_c) || f_c.isEnum()) {
                            f_obj = Fson.fromJson(t_val, f_c);
                        } else {
                            Fson.updateFromJson(f_obj, t_val);
                        }
                        s_outer = null;
                        if (f_obj == null) continue;
                        t_f.setAccessible(true);
                        t_f.set(obj, f_obj);
                    }
                }
            }
            catch (Exception e) {
                Tool.logIfDebug(e, "@setAttrFromMap.\n");
            }
        }
    }

    private static void setArrayElementFromJson(Object obj, String json) {
        if (obj != null && json != null) {
            try {
                Class<?> t_c = obj.getClass();
                String[] a_jsons = (String[])Fson.fromJson(json, String[].class);
                int i = 0;
                while (i < a_jsons.length) {
                    if (a_jsons[i] != null) {
                        String json2 = a_jsons[i];
                        Object obj2 = null;
                        if (t_c.isArray()) {
                            Class<String> t_cl = t_c.getComponentType();
                            obj2 = Array.get(obj, i);
                            if (t_cl.isAssignableFrom(String.class)) {
                                obj2 = json2;
                            } else if (obj2 == null) {
                                obj2 = Fson.fromJson(json2, null);
                            } else if (Tool.isPrimitive2(obj2.getClass()) || obj2.getClass().isEnum()) {
                                obj2 = Fson.fromJson(json2, obj2.getClass());
                            } else {
                                Fson.updateFromJson(obj2, json2);
                            }
                            Array.set(obj, i, obj2);
                        } else {
                            List t_list = (List)obj;
                            Pattern t_pat = Pattern.compile("^(\\{.*\\}|\\[.*\\]|[0-9\\.\\+\\-]+|true|false|\\([^\\)]+\\).+)$", 32);
                            Matcher t_m = t_pat.matcher(json2);
                            if (t_list.size() > i) {
                                obj2 = t_list.get(i);
                                if (!t_m.find()) {
                                    obj2 = json2;
                                } else if (obj2 == null) {
                                    obj2 = Fson.fromJson(json2, null);
                                } else if (Tool.isPrimitive2(obj2.getClass()) || obj2.getClass().isEnum()) {
                                    obj2 = Fson.fromJson(json2, obj2.getClass());
                                } else {
                                    Fson.updateFromJson(obj2, json2);
                                }
                                t_list.set(i, obj2);
                            } else if (t_list.size() >= i) {
                                obj2 = t_m.find() ? Fson.fromJson(json2, null) : json2;
                                t_list.add(obj2);
                            } else {
                                Tool.logIfDebug(null, String.valueOf(Messages.getString("Fson.24")) + obj.toString() + Messages.getString("Fson.25"));
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Tool.logIfDebug(e, "@setArrayElementFromJson.\n");
            }
        }
    }

    public static void updateFromJson(Object obj, String str_json) {
        if (obj != null && str_json != null) {
            try {
                String json = Fson.removeComments(str_json);
                Class<?> t_c = obj.getClass();
                if (t_c.isArray() || List.class.isAssignableFrom(t_c)) {
                    Fson.setArrayElementFromJson(obj, json);
                } else if (Tool.isPrimitive2(t_c)) {
                    Tool.logIfDebug(null, "@updateFromJson.\n");
                } else {
                    HashMap<String, String> _map = Fson.getFieldMapOfJson(json);
                    Fson.setAttrFromMap(obj, _map);
                }
            }
            catch (Exception e) {
                Tool.logIfDebug(e, "@updateFromJson.\n");
            }
        }
    }

    public static Boolean updateByJsonPath(Object obj, String jpath, String json) {
        Class<?> t_c;
        if (obj != null && ((t_c = obj.getClass()).isArray() || !Tool.isPrimitive2(t_c))) {
            String[] t_route;
            ArrayList<Object> t_list;
            if (jpath.startsWith("\"") && jpath.endsWith("\"")) {
                jpath = jpath.substring(1, jpath.length() - 1);
            }
            String t_path = Fson.esqDot(jpath);
            if (Tool.isFake(t_c.getName())) {
                if (t_path.equals("$")) {
                    t_path = "";
                } else if (!t_path.startsWith(".")) {
                    t_path = "." + t_path;
                }
                t_path = "$._impl._table" + t_path;
            }
            if ((t_list = Fson.hitFieldByJsonPaths(0, t_route = t_path.split("\\."), obj, json)) != null) {
                return true;
            }
            Tool.logForTesting(null, "Failed to update Object <<" + obj.toString() + ">> since not found xpath=" + jpath + "\n");
        }
        return false;
    }

    public static ArrayList<Object> valueByJsonPath(Object obj, String jpath) {
        String t_path = Fson.esqDot(jpath);
        Class<?> t_c = obj.getClass();
        if (t_c.getName().startsWith("test.fake.")) {
            if (t_path.equals("$")) {
                t_path = "";
            } else if (t_path.startsWith("$.")) {
                t_path = t_path.substring(1);
            } else if (!t_path.startsWith(".")) {
                t_path = "." + t_path;
            }
            t_path = "$._impl._table" + t_path;
        } else if (t_c.getName().startsWith("test.impl.")) {
            if (t_path.equals("$")) {
                t_path = "";
            } else if (t_path.startsWith("$.")) {
                t_path = t_path.substring(1);
            } else if (!t_path.startsWith(".")) {
                t_path = "." + t_path;
            }
            t_path = "$._table" + t_path;
        }
        if (t_path.length() == 0) {
            ArrayList<Object> t_result = new ArrayList<Object>();
            t_result.add(obj);
            return t_result;
        }
        String[] t_rooute = t_path.split("\\.");
        return Fson.hitFieldByJsonPaths(0, t_rooute, obj, null);
    }

    private static ArrayList<Object> hitFieldByJsonPaths(int n, String[] route, Object obj, String json) {
        if (n > route.length - 1) {
            return null;
        }
        String a_name = route[n];
        if (a_name == null) {
            a_name = "";
        } else if ("$".equals(a_name) && n < route.length - 1) {
            return Fson.hitFieldByJsonPaths(n + 1, route, obj, json);
        }
        ArrayList<Object> t_result = new ArrayList<Object>();
        if (n == 0 && route.length == 1) {
            Integer ii = null;
            if (a_name.length() > 2 && a_name.substring(1, a_name.length() - 1).matches("^\\d+$")) {
                ii = Integer.parseInt(a_name.substring(1, a_name.length() - 1));
            }
            if (a_name.equals("-") || a_name.equals("$")) {
                if (json != null) {
                    Fson.updateFromJson(obj, json);
                }
                t_result.add(obj);
            } else if (obj.getClass().isArray()) {
                try {
                    if (json != null) {
                        Array.set(obj, ii, Fson.fromJson(json, null));
                    }
                    t_result.add(Array.get(obj, ii));
                }
                catch (NotSupportedClassException | ArrayIndexOutOfBoundsException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | ParseException e) {
                    return null;
                }
            } else if (obj instanceof List) {
                try {
                    if (json != null) {
                        ((List)obj).add(ii, Fson.fromJson(json, null));
                        ((List)obj).remove(ii + 1);
                    }
                    t_result.add(((List)obj).get(ii));
                }
                catch (NotSupportedClassException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | ParseException e) {
                    return null;
                }
            } else if (obj instanceof Map) {
                try {
                    if (json != null) {
                        ((Map)obj).put(a_name, Fson.fromJson(json, null));
                    }
                    t_result.add(((Map)obj).get(a_name));
                }
                catch (NotSupportedClassException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | ParseException e) {
                    return null;
                }
            } else {
                return Fson.hitFieldByJsonPaths(0, new String[]{"$", a_name}, obj, json);
            }
            return t_result;
        }
        if (a_name.length() == 0) {
            if (obj instanceof Map) {
                Map t_map = (Map)obj;
                for (Map.Entry entry : t_map.entrySet()) {
                    t_result = Fson.hitFieldByJsonPaths(n, route, entry.getValue(), json);
                }
            } else {
                ArrayList<Field> t_list = new ArrayList<Field>();
                Tool.getAllFields(obj.getClass(), t_list);
                int i = 0;
                while (i < t_list.size()) {
                    try {
                        Object n_obj = Tool.getFieldValue(obj, t_list.get(i).getName());
                        if (n_obj != null) {
                            t_result = Fson.hitFieldByJsonPaths(n, route, n_obj, json);
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        } else {
            String f_name = a_name.replaceFirst("^([\\w\\$]*)\\[.*\\]$", "$1");
            String f_cond = a_name.replaceFirst("^[\\w\\$]*\\[(.*)\\]$", "$1");
            if (a_name.endsWith("]")) {
                Object f_obj = null;
                if (obj instanceof Map) {
                    Map t_map = (Map)obj;
                    f_obj = t_map.get(Tool.getObjectfromJSON(null, f_name));
                } else if (f_name.length() == 0 || f_name.equals("$")) {
                    f_obj = obj;
                } else {
                    try {
                        f_obj = Tool.getFieldValue(obj, f_name);
                        if (f_obj == null) {
                            Field t_fld = Tool.getField(obj.getClass(), f_name);
                            if (f_cond.matches("^(0|\\*)$")) {
                                Class<?> f_class = t_fld.getType();
                                Class g_class = null;
                                g_class = f_class.isArray() ? f_class.getComponentType() : (Class)t_fld.getGenericType();
                                String t_json = "";
                                t_json = g_class.isArray() || List.class.isAssignableFrom(g_class) ? "[]" : (Tool.isPrimitive2(g_class) ? json : "{}");
                                f_obj = Fson.fromJson("[" + t_json + "]", t_fld.getType());
                            }
                        }
                    }
                    catch (NotSupportedClassException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException | ParseException e1) {
                        return null;
                    }
                }
                if (f_obj != null) {
                    String[] f_conds = Fson.restDot(f_cond).split("\\]\\[");
                    if (n == route.length - 1) {
                        if (json != null && f_cond.matches("^[0-9,:\\[\\]]+$")) {
                            f_obj = Fson.resolveNext(f_obj, 0, f_conds, t_result, json);
                        } else if (json == null) {
                            f_obj = Fson.resolveNext(f_obj, 0, f_conds, t_result, null);
                        }
                    } else {
                        ArrayList<Object> next_objs = new ArrayList<Object>();
                        f_obj = Fson.resolveNext(f_obj, 0, f_conds, next_objs, null);
                        int i = 0;
                        while (i < next_objs.size()) {
                            ArrayList<Object> t_list = Fson.hitFieldByJsonPaths(n + 1, route, next_objs.get(i), json);
                            if (t_list != null) {
                                t_result.addAll(t_list);
                            }
                            ++i;
                        }
                    }
                }
            } else if ("*".equals(a_name)) {
                if (!(obj instanceof List) && !obj.getClass().isArray()) {
                    if (obj instanceof Map) {
                        Map t_map = (Map)obj;
                        for (Map.Entry entry : t_map.entrySet()) {
                            if (n == route.length - 1) {
                                Object t_val = entry.getValue();
                                if (json != null) {
                                    if (t_val == null || Tool.isPrimitive2(t_val.getClass()) || t_val.getClass().isEnum() || json.indexOf("\"initialize\"") > 0) {
                                        t_val = Tool.getObjectfromJSON(entry.getValue().getClass(), json);
                                    } else {
                                        Fson.updateFromJson(t_val, json);
                                    }
                                    t_map.put((String)entry.getKey(), t_val);
                                    continue;
                                }
                                t_result.add(t_map.get(entry.getKey()));
                                continue;
                            }
                            if (entry.getValue() == null) continue;
                            t_result = Fson.hitFieldByJsonPaths(n + 1, route, entry.getValue(), json);
                        }
                    } else {
                        ArrayList<Field> f_list = new ArrayList<Field>();
                        Tool.getAllFields(obj.getClass(), f_list);
                        int i = 0;
                        while (i < f_list.size()) {
                            block118: {
                                Object n_obj;
                                if (n == route.length - 1) {
                                    f_list.get(i).setAccessible(true);
                                    try {
                                        n_obj = Tool.getFieldValue(obj, f_list.get(i).getName());
                                        if (json != null) {
                                            if (n_obj == null || Tool.isPrimitive2(n_obj.getClass()) || n_obj.getClass().isEnum() || json.indexOf("\"initialize\"") > 0) {
                                                n_obj = Tool.getObjectfromJSON(f_list.get(i).getType(), json);
                                            } else {
                                                Fson.updateFromJson(n_obj, json);
                                            }
                                            f_list.get(i).set(obj, n_obj);
                                            break block118;
                                        }
                                        t_result.add(f_list.get(i).get(obj));
                                    }
                                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException t_val) {}
                                } else {
                                    try {
                                        n_obj = Tool.getFieldValue(obj, f_list.get(i).getName());
                                        if (n_obj != null) {
                                            t_result = Fson.hitFieldByJsonPaths(n + 1, route, n_obj, json);
                                        }
                                    }
                                    catch (NoSuchFieldException t_val) {
                                        // empty catch block
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                }
            } else if (n == route.length - 2 && json != null) {
                Map t_map2;
                String f_name2 = route[n + 1].replaceFirst("^([\\w\\$]*)\\[.*\\]$", "$1");
                Object target = null;
                if (obj instanceof Map) {
                    t_map2 = (Map)obj;
                    target = t_map2.get(f_name);
                } else {
                    try {
                        target = Tool.getFieldValue(obj, f_name);
                    }
                    catch (NoSuchFieldException t_map2) {
                        // empty catch block
                    }
                }
                if (target != null) {
                    if (target instanceof Map) {
                        t_map2 = (Map)target;
                        Object prev_obj = t_map2.get(f_name2);
                        Class<?> t_c = null;
                        if (prev_obj != null) {
                            t_c = prev_obj.getClass();
                        }
                        if (prev_obj == null || json != null && (Tool.isPrimitive2(prev_obj.getClass()) || prev_obj.getClass().isEnum() || json.indexOf("\"initialize\"") > 0)) {
                            t_map2.put(Tool.getObjectfromJSON(null, f_name2), Tool.getObjectfromJSON(t_c, json));
                        } else {
                            Fson.updateFromJson(prev_obj, json);
                        }
                        t_result.add(prev_obj);
                    } else if (Tool.isFake(target.getClass().getName())) {
                        t_result = Fson.hitFieldByJsonPaths(n + 1, route, target, json);
                    } else {
                        Field t_f = Tool.getField(target.getClass(), f_name2);
                        try {
                            if (json != null) {
                                Object n_obj = Tool.getFieldValue(target, t_f.getName());
                                if (n_obj == null || Tool.isPrimitive2(n_obj.getClass()) || n_obj.getClass().isEnum() || json.indexOf("\"initialize\"") > 0) {
                                    n_obj = Tool.getObjectfromJSON(t_f.getType(), json);
                                } else {
                                    Fson.updateFromJson(n_obj, json);
                                }
                                t_f.set(target, n_obj);
                            }
                            t_result.add(t_f.get(target));
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException n_obj) {}
                    }
                }
            } else if (n == route.length - 1) {
                Object target;
                block119: {
                    target = null;
                    if (obj instanceof Map) {
                        Map t_map = (Map)obj;
                        target = t_map.get(f_name);
                        Class<?> t_c = null;
                        if (target != null) {
                            t_c = target.getClass();
                        }
                        if (target == null || json != null && (Tool.isPrimitive2(target.getClass()) || target.getClass().isEnum() || json.indexOf("\"initialize\"") > 0)) {
                            t_map.put(f_name, Tool.getObjectfromJSON(t_c, json));
                        } else {
                            Fson.updateFromJson(target, json);
                        }
                    } else {
                        block120: {
                            target = Tool.getFieldValue(obj, f_name);
                            if (json == null) break block119;
                            Field t_fld = Tool.getField(obj.getClass(), f_name);
                            Class<?> f_class = t_fld.getType();
                            if (target != null && !json.matches("^\\([\\.\\w]+\\).+$") && !Tool.isPrimitive2(f_class)) break block120;
                            try {
                                target = Fson.fromJson(json, f_class);
                                t_fld.set(obj, target);
                                break block119;
                            }
                            catch (NotSupportedClassException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | ParseException e) {
                                return null;
                            }
                        }
                        try {
                            Fson.updateFromJson(target, json);
                        }
                        catch (NoSuchFieldException t_fld) {
                            // empty catch block
                        }
                    }
                }
                t_result.add(target);
            } else if (obj instanceof Map) {
                Map t_map = (Map)obj;
                Object f_obj = t_map.get(Tool.getObjectfromJSON(null, f_name));
                t_result = Fson.hitFieldByJsonPaths(n + 1, route, f_obj, json);
            } else {
                try {
                    Object f_obj = Tool.getFieldValue(obj, f_name);
                    if (f_obj == null) {
                        Field t_fld = Tool.getField(obj.getClass(), f_name);
                        Class<?> f_class = t_fld.getType();
                        Class g_class = null;
                        String f_json = "{@}";
                        if (f_class.isArray()) {
                            g_class = f_class.getComponentType();
                        } else if (List.class.isAssignableFrom(f_class)) {
                            g_class = (Class)t_fld.getGenericType();
                        } else if (Tool.isPrimitive2(f_class)) {
                            f_json = json;
                        }
                        String t_json = "{}";
                        if (g_class != null) {
                            if (g_class.isArray() || List.class.isAssignableFrom(g_class)) {
                                t_json = "[]";
                            } else if (Tool.isPrimitive2(g_class)) {
                                t_json = json;
                            }
                        }
                        f_obj = Fson.fromJson(f_json.replaceFirst("@", Matcher.quoteReplacement(t_json)), t_fld.getType());
                        t_fld.set(obj, f_obj);
                    }
                    t_result = Fson.hitFieldByJsonPaths(n + 1, route, f_obj, json);
                }
                catch (NotSupportedClassException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException | ParseException e1) {
                    return null;
                }
            }
        }
        if (t_result.size() == 0) {
            return null;
        }
        return t_result;
    }

    private static Object resolveNext(Object obj, int i, String[] conditions, ArrayList<Object> list, String json) {
        String cond = conditions[i];
        if ("*".equals(cond)) {
            int n = -1;
            if (obj.getClass().isArray()) {
                n = Array.getLength(obj);
            } else if (obj instanceof List) {
                n = ((List)obj).size();
            }
            int j = 0;
            while (j < n) {
                obj = Fson.recursiveResolve(obj, j, i + 1, conditions, list, json);
                ++j;
            }
        } else if (cond.matches("^[0-9]+:[0-9]+$")) {
            Pattern range1 = Pattern.compile("^([\\-0-9]*):([0-9]+)$");
            Matcher t_m = range1.matcher(cond);
            if (t_m.find()) {
                String str_from = t_m.group(1);
                String str_to = t_m.group(2);
                Integer ifrom = 0;
                Integer ito = 0;
                if (str_from.length() > 0) {
                    ifrom = Integer.valueOf(str_from);
                    if (str_to.length() > 0) {
                        ito = Integer.valueOf(str_to);
                    }
                }
                if (ifrom < 0) {
                    ito = ifrom = Integer.valueOf(Array.getLength(obj) - 1);
                }
                int j = ifrom;
                while (ito >= i) {
                    obj = Fson.recursiveResolve(obj, j, i + 1, conditions, list, json);
                    ++i;
                }
            }
        } else if (cond.matches("^[\\-0-9,]+$")) {
            String[] str_nums = cond.split(",");
            int j = 0;
            while (j < str_nums.length) {
                Integer t_n = Integer.valueOf(str_nums[j]);
                obj = Fson.recursiveResolve(obj, t_n, i + 1, conditions, list, json);
                ++j;
            }
        } else if (cond.matches("^\\(.*\\)$")) {
            String exps = cond.replaceFirst("^\\?\\((.+)\\)$", "$1");
            String num_exps = Fson.evalFieldsOfNumber(obj, exps);
            Integer il = Fson.numberByExpression(num_exps);
            if (il != null) {
                obj = Fson.recursiveResolve(obj, il, i + 1, conditions, list, json);
            }
        } else if (cond.matches("^\\?\\(@\\.\\w+\\)$")) {
            String f_name = cond.replaceFirst("^\\?\\(@\\.(\\w+)\\)$", "$1");
            try {
                Tool.getFieldValue(obj, f_name);
                obj = Fson.resolveNext(obj, i + 1, conditions, list, null);
            }
            catch (NoSuchFieldException num_exps) {}
        } else if (cond.matches("^\\?\\(.+\\)$")) {
            String exps = cond.replaceFirst("^\\?\\((.+)\\)$", "$1");
            String num_exps = Fson.evalFieldsOfNumber(obj, exps);
            if (Fson.evalIfBoolean(num_exps)) {
                obj = Fson.resolveNext(obj, i + 1, conditions, list, null);
            }
        } else if (obj instanceof Map) {
            Map t_obj = (Map)obj;
            Object key = Tool.getObjectfromJSON(null, cond);
            Object n_obj = t_obj.get(key);
            if (i == conditions.length) {
                if (json == null) {
                    list.add(t_obj.get(key));
                } else {
                    if (n_obj == null || Tool.isPrimitive2(n_obj.getClass()) || n_obj.getClass().isEnum()) {
                        n_obj = Tool.getObjectfromJSON(null, json);
                    } else {
                        Fson.updateFromJson(n_obj, json);
                    }
                    t_obj.put(key, n_obj);
                }
            } else {
                n_obj = Fson.resolveNext(n_obj, i + 1, conditions, list, json);
                t_obj.put(key, n_obj);
            }
        }
        return obj;
    }

    private static Object recursiveResolve(Object obj, Integer pos, int i, String[] conditions, ArrayList<Object> list, String json) {
        if (obj.getClass().isArray()) {
            Class<?> a_c = obj.getClass().getComponentType();
            Object n_obj = null;
            if (Array.getLength(obj) > pos) {
                n_obj = Array.get(obj, pos);
                if (i == conditions.length) {
                    if (json == null) {
                        list.add(n_obj);
                    } else if (n_obj == null || Tool.isPrimitive2(a_c) || a_c.isEnum()) {
                        n_obj = Tool.getObjectfromJSON(a_c, json);
                    } else {
                        Fson.updateFromJson(n_obj, json);
                    }
                } else {
                    n_obj = Fson.resolveNext(n_obj, i, conditions, list, json);
                }
                Array.set(obj, pos, n_obj);
            }
        } else if (obj instanceof Map) {
            Map t_obj = (Map)obj;
            if (i == conditions.length) {
                if (json == null) {
                    list.add(t_obj.get(pos));
                } else {
                    Object n_obj = t_obj.get(pos);
                    if (n_obj == null || Tool.isPrimitive2(n_obj.getClass()) || n_obj.getClass().isEnum()) {
                        n_obj = Tool.getObjectfromJSON(null, json);
                    } else {
                        Fson.updateFromJson(n_obj, json);
                    }
                    t_obj.put(pos, n_obj);
                }
            } else {
                Tool.logIfDebug(null, "json=" + json + "\ncan not be applied to " + obj.toString() + " with conditions " + conditions[i] + ".");
                obj = null;
            }
        } else if (obj instanceof List) {
            List t_obj = (List)obj;
            if (i == conditions.length) {
                if (json == null) {
                    list.add(t_obj.get(pos));
                } else {
                    Object n_obj = t_obj.get(pos);
                    if (n_obj == null || Tool.isPrimitive2(n_obj.getClass()) || n_obj.getClass().isEnum()) {
                        n_obj = Tool.getObjectfromJSON(null, json);
                    } else {
                        Fson.updateFromJson(n_obj, json);
                    }
                    if (pos < t_obj.size()) {
                        t_obj.set(pos, n_obj);
                    } else if (pos.intValue() == t_obj.size()) {
                        t_obj.add(n_obj);
                    }
                }
            } else {
                obj = Fson.resolveNext(t_obj.get(pos), i, conditions, list, json);
            }
        }
        return obj;
    }

    private static String esqDot(String str) {
        String t_str = str;
        ArrayList<String> t_list = new ArrayList<String>();
        Integer i = 0;
        Pattern t_pat = Pattern.compile("\\([^\\(\\)]+\\)");
        Matcher t_m = t_pat.matcher(t_str);
        while (t_m.find()) {
            String w_str = t_m.group();
            if (!w_str.contains(".")) continue;
            t_str = t_str.replaceFirst(Pattern.quote(w_str), "__ESCAPED_STRING__" + i.toString());
            w_str = w_str.replaceAll(Pattern.quote("."), "__ESCAPED_DOT__");
            t_list.add(w_str);
            i = i + 1;
            t_m = t_pat.matcher(t_str);
        }
        Integer j = 0;
        while (j < t_list.size()) {
            t_str = t_str.replaceFirst("__ESCAPED_STRING__" + j.toString(), Matcher.quoteReplacement((String)t_list.get(j)));
            j = j + 1;
        }
        return t_str;
    }

    private static String restDot(String str) {
        str = str.replaceAll("__ESCAPED_DOT__", Matcher.quoteReplacement("."));
        return str;
    }

    private static boolean evalIfBoolean(String exps) {
        Pattern t_pat = Pattern.compile("^(.+)([<>]=*)(.+)$");
        Matcher t_m = t_pat.matcher(exps);
        if (t_m.find()) {
            String ex1 = t_m.group(1);
            String op = t_m.group(2);
            String ex2 = t_m.group(3);
            Integer x1 = Fson.numberByExpression(ex1);
            Integer x2 = Fson.numberByExpression(ex2);
            if (x1 != null && x2 != null) {
                if (">=".equals(op)) {
                    return x1 >= x2;
                }
                if (">".equals(op)) {
                    return x1 > x2;
                }
                if ("<=".equals(op)) {
                    return x1 <= x2;
                }
                if ("<".equals(op)) {
                    return x1 < x2;
                }
                if ("==".equals(op)) {
                    return x1.equals(x2);
                }
            }
        }
        return false;
    }

    public static Integer numberByExpression(String exps) {
        exps = exps.replaceAll("\\s", "");
        Pattern t_pat = Pattern.compile("^(\\d+)(\\+|\\-)(.+)$");
        Matcher t_m = t_pat.matcher(exps);
        if (t_m.find()) {
            String num = t_m.group(1);
            String op = t_m.group(2);
            String nextexp = t_m.group(3);
            if ("+".equals(op)) {
                return Integer.valueOf(num) + Fson.numberByExpression(nextexp);
            }
            if ("-".equals(op)) {
                return Integer.valueOf(num) - Fson.numberByExpression(nextexp);
            }
        } else if (exps.matches("^[0-9]$")) {
            return Integer.valueOf(exps);
        }
        return null;
    }

    private static String evalFieldsOfNumber(Object obj, String exps) {
        Pattern t_pat = Pattern.compile("@\\.(\\w+)");
        Matcher t_m = t_pat.matcher(exps);
        String t_result = exps;
        while (t_m.find()) {
            String t_target = t_m.group();
            String f_name = t_m.group();
            if (obj.getClass().isArray() && "length".equals(f_name)) {
                t_result = Integer.toString(Array.getLength(obj));
                continue;
            }
            if (obj instanceof List && "length".equals(f_name)) {
                t_result = Integer.toString(((List)obj).size());
                continue;
            }
            try {
                Object f_obj = Tool.getFieldValue(obj, f_name);
                if (f_obj == null || !f_obj.toString().matches("^[0-9]+$")) continue;
                t_result = t_result.replaceFirst(Pattern.quote(t_target), Matcher.quoteReplacement(f_obj.toString()));
            }
            catch (NoSuchFieldException e) {
                Tool.logIfDebug(e, "FSON_FAIL: evalFieldsOfNumber>>" + f_name + " not found in " + obj.getClass().getName());
            }
        }
        return t_result;
    }

    public static String toDefaultJson(Class<?> c) {
        String t_result = null;
        String cname = c.getSimpleName();
        if ("String".equals(cname)) {
            t_result = "\"\"";
        } else if (Modifier.isAbstract(c.getModifiers()) || Modifier.isInterface(c.getModifiers())) {
            t_result = "(Class Name){}";
        } else if (Tool.isPrimitive2(c)) {
            t_result = "";
        } else if (c.isEnum()) {
            t_result = "(" + c.getName() + ")Number";
        } else if (c.isArray() || List.class.isAssignableFrom(c)) {
            t_result = "[]";
        } else if (Map.class.isAssignableFrom(c)) {
            t_result = "{}";
        } else {
            t_result = "{\n";
            Field[] f_list = c.getDeclaredFields();
            int i = 0;
            while (i < f_list.length) {
                if (t_result.length() > 0) {
                    t_result = String.valueOf(t_result) + ",\n";
                }
                t_result = String.valueOf(t_result) + "\"" + f_list[i].getName() + "\":";
                Class<?> t_c = f_list[i].getType();
                t_result = String.valueOf(t_result) + Fson.toDefaultJson(t_c);
                ++i;
            }
            t_result = String.valueOf(t_result) + "\n}";
        }
        return t_result;
    }

    private static String execCodeInString(String str) {
        String t_src = str;
        if (Tool.curCase != null) {
            Pattern t_pat1 = Pattern.compile("\\(\\$(\\w[\\w\\.]+)\\.([\\w]+)\\(([^\\(\\)]*)\\)\\)");
            Matcher t_m = t_pat1.matcher(t_src);
            while (t_m.find()) {
                String cname = t_m.group(1);
                String mname = t_m.group(2);
                String temp = t_m.group(3);
                String[] targs = new String[]{};
                if (!Tool.existClass(cname)) continue;
                if (temp != null && temp.length() > 0) {
                    try {
                        ArrayList<String> t_escs = Fson.escapeBraket(temp, "\"");
                        targs = t_escs.get(0).split(",");
                        int i = 0;
                        while (i < targs.length) {
                            targs[i] = Fson.restoreBraket(targs[i], t_escs).trim();
                            targs[i] = targs[i].replaceFirst("^\"?(.*)\"?$", "$1");
                            ++i;
                        }
                    }
                    catch (ParseException e) {
                        t_src = t_m.replaceFirst("(ERROR:msg=" + e.getMessage() + ")");
                        Tool.logIfDebug(e, "FSON_FAIL: execCodeInString>>" + str);
                    }
                }
                try {
                    Class<?> x_c = Tool.forName(cname);
                    Method x_m = x_c.getMethod(mname, new String[0].getClass());
                    Object[] t_arry = new Object[]{targs};
                    Object t_ret = x_m.invoke(null, t_arry);
                    t_src = t_ret != null ? t_m.replaceFirst(Matcher.quoteReplacement(t_ret.toString())) : t_m.replaceFirst("null");
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    t_src = t_m.replaceFirst("(ERROR:msg=" + e.getMessage() + ")");
                    Tool.logIfDebug(e, "FSON_FAIL: execCodeInString>>" + str);
                }
                t_m = t_pat1.matcher(t_src);
            }
            Pattern t_pat2 = Pattern.compile("\\(\\$\\.([\\w\\.]+)\\)");
            t_m = t_pat2.matcher(t_src);
            while (t_m.find()) {
                String key = t_m.group(1);
                Object t_obj = VCentral.getValue(key);
                t_src = t_obj != null ? t_m.replaceFirst(Matcher.quoteReplacement(t_obj.toString())) : t_m.replaceFirst("null");
                t_m = t_pat2.matcher(t_src);
            }
        }
        return t_src;
    }

    private static Object getEnumByInt(Class<?> c, String i) {
        ?[] t_objs = c.getEnumConstants();
        return t_objs[Integer.valueOf(i)];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toXML(Object obj, Class<?> c, Integer depth) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalAccessException, NoSuchFieldException, NotSupportedClassException {
        if (obj == null) return "";
        if (Fson.isLooped(obj)) {
            return "";
        }
        String result = "";
        String head_str = "";
        if (o_stack.size() == 0) {
            head_str = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><root>";
        } else if (depth != null && o_stack.size() > depth) {
            return "";
        }
        if (c == null && obj != null) {
            result = Fson.toXML(obj, obj.getClass(), depth);
        } else if (c != null) {
            Fson.pushed(c);
            try {
                String cname = c.getSimpleName();
                if (cname.equals("int") || cname.equals("Integer")) {
                    if (obj != null) {
                        result = Integer.toString((Integer)obj);
                    }
                } else if (cname.equals("long") || cname.equals("Long")) {
                    if (obj != null) {
                        result = Long.toString((Long)obj);
                    }
                } else if (cname.equals("boolean") || cname.equals("Boolean")) {
                    if (obj != null) {
                        result = Boolean.toString((Boolean)obj);
                    }
                } else if (cname.equals("char") || cname.equals("Character")) {
                    if (obj != null) {
                        Character ch = (Character)obj;
                        int ic = Character.getNumericValue(ch.charValue());
                        result = ic > 0 ? Character.toString(((Character)obj).charValue()) : "";
                    }
                } else if (cname.equals("float") || cname.equals("Float")) {
                    if (obj != null) {
                        result = Float.toString(((Float)obj).floatValue());
                    }
                } else if (cname.equals("byte") || cname.equals("Byte")) {
                    if (obj != null) {
                        result = Byte.toString((Byte)obj);
                    }
                } else if (cname.equals("double") || cname.equals("Double")) {
                    if (obj != null) {
                        result = Double.toString((Double)obj);
                    }
                } else if (cname.equals("AtomicInteger")) {
                    if (obj != null) {
                        result = obj.toString();
                    }
                } else if (cname.equals("AtomicLong")) {
                    if (obj != null) {
                        result = obj.toString();
                    }
                } else if (cname.equals("BigDecimal")) {
                    if (obj != null) {
                        result = obj.toString();
                    }
                } else if (cname.equals("BigInteger")) {
                    if (obj != null) {
                        result = obj.toString();
                    }
                } else if (cname.equals("String")) {
                    if (obj != null) {
                        result = obj.toString();
                    }
                } else if (c.isArray()) {
                    Class<?> t_c = c.getComponentType();
                    String xml = "";
                    if (obj != null) {
                        int i = 0;
                        while (i < Array.getLength(obj)) {
                            xml = String.valueOf(xml) + "<_" + Integer.toString(i) + " name=\"" + t_c.getName() + "\">" + Fson.toXML(Array.get(obj, i), t_c, depth) + "</_" + Integer.toString(i) + ">";
                            ++i;
                        }
                    }
                    result = xml;
                } else if (c.isEnum()) {
                    if (obj != null) {
                        ?[] en_list = c.getEnumConstants();
                        String t_xml = null;
                        int i = 0;
                        while (i < en_list.length) {
                            if (obj.equals(en_list[i])) {
                                t_xml = Integer.toString(i);
                            }
                            ++i;
                        }
                        if (t_xml == null) throw new IllegalAccessException(String.valueOf(c.getName()) + "has not " + obj.toString() + ".");
                        result = t_xml;
                    }
                } else if (Map.class.isAssignableFrom(c)) {
                    String xml = "";
                    if (obj != null) {
                        Map t_map = (Map)obj;
                        for (Map.Entry entry : t_map.entrySet()) {
                            String t_key = entry.getKey().toString();
                            if (t_key == null || t_key.equals("null") || t_key.endsWith("_class")) continue;
                            String tc_name = "unknown";
                            if (entry.getValue() != null) {
                                tc_name = entry.getValue().getClass().getName();
                            } else if (t_map.containsKey(entry.getKey() + "_class")) {
                                tc_name = t_map.get(entry.getKey() + "_class").toString();
                            }
                            if (xml.length() > 1) {
                                xml = String.valueOf(xml) + ",";
                            }
                            xml = String.valueOf(xml) + "<" + t_key + " name=\"" + tc_name + "\">" + Fson.toXML(entry.getValue(), null, depth) + "</" + t_key + ">";
                        }
                    }
                    result = xml;
                } else if (List.class.isAssignableFrom(c)) {
                    String xml = "";
                    if (obj != null) {
                        Object[] t_array = ((List)obj).toArray();
                        int i = 0;
                        while (i < t_array.length) {
                            Object x_obj = t_array[i];
                            String s_xml = "null";
                            if (x_obj != null) {
                                s_xml = String.valueOf(s_xml) + "<_" + Integer.toString(i) + " name=\"" + x_obj.getClass().getName() + "\">" + Fson.toXML(x_obj, null, depth) + "</_" + x_obj.getClass().getName() + ">";
                            }
                            xml = String.valueOf(xml) + s_xml;
                            ++i;
                        }
                    }
                    result = xml;
                } else {
                    if (Collection.class.isAssignableFrom(c)) {
                        throw new NotSupportedClassException(String.valueOf(c.getName()) + ">>Fson cuurently not support.");
                    }
                    if (Tool.isFake(cname)) {
                        ArrayList<Object> t_fakes = Fson.valueByJsonPath(obj, "$");
                        if (t_fakes.size() > 0) {
                            result = Fson.toXML(t_fakes.get(0), HashMap.class, depth);
                        }
                    } else {
                        String xml = "";
                        HashMap<String, String> f_map = Fson.getFields(c);
                        for (Map.Entry<String, String> entry : f_map.entrySet()) {
                            String key = entry.getKey();
                            Object t_obj = null;
                            Field t_f = Tool.getField(c, key);
                            t_obj = Tool.getFieldValue(obj, key);
                            Class<?> t_c = t_f.getType();
                            if (t_c.isArray()) {
                                Class<?> comp_class = t_c.getComponentType();
                                xml = String.valueOf(xml) + "<" + entry.getKey() + " name=\"" + comp_class.getName() + "[]\">";
                                if (t_obj != null && Array.getLength(t_obj) > 0 && Array.get(t_obj, 0) != null) {
                                    xml = String.valueOf(xml) + Fson.toXML(Array.get(t_obj, 0), comp_class, depth);
                                }
                                xml = String.valueOf(xml) + "</" + entry.getKey() + ">";
                                continue;
                            }
                            xml = String.valueOf(xml) + "<" + entry.getKey() + " name=\"" + t_c.getName() + "\">";
                            if (t_obj != null) {
                                xml = String.valueOf(xml) + Fson.toXML(t_obj, t_c, depth);
                            }
                            xml = String.valueOf(xml) + "</" + entry.getKey() + ">";
                        }
                        result = xml;
                    }
                }
            }
            finally {
                Fson.popped(c);
            }
        }
        if (head_str.length() <= 0) return result;
        return String.valueOf(head_str) + result + "</root>";
    }

    public static class NotSupportedClassException
    extends Exception {
        public NotSupportedClassException(String msg) {
            super(msg);
        }
    }
}

