/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.gui;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.ClassOutLine;
import com.ftinc.si.assist.test.CodeProcessor;
import com.ftinc.si.assist.test.FakeMethodRecord;
import com.ftinc.si.assist.test.TestCommandRecord;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.gui.ClassReadDialog;
import com.ftinc.si.assist.test.gui.CodingAssistMenu;
import com.ftinc.si.assist.test.gui.TestCaseEditor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;

public class MethodEditor
extends JDialog {
    public static JDialog s_owner;
    private JTextField className;
    private JTextField methodName;
    private JTextArea argTypes;
    private JTextArea textSource;
    private JTextArea fields;
    private JTextArea resultText;
    private String returntype;
    public boolean is_OK = false;
    private HashMap<String, Class<?>> m_cmap = null;
    private String m_checked;
    private boolean m_removing = false;
    private boolean is_fake = false;

    public MethodEditor(JDialog owner, String cname, String mname, String[] atypes, String src) {
        super((Dialog)owner, true);
        this.setTitle(Messages.getString("MethodEditorInBrowser.0"));
        this.getContentPane().setLayout(null);
        if (owner != null) {
            this.setBounds(owner.getX() + 100, owner.getY() + 100, 1000, 485);
        } else {
            this.setBounds(100, 100, 1000, 485);
        }
        JLabel lblNewLabel = new JLabel(Messages.getString("MethodEditorInBrowser.1"));
        lblNewLabel.setBounds(12, 104, 162, 13);
        this.getContentPane().add(lblNewLabel);
        JLabel lblNewLabel_1 = new JLabel(Messages.getString("MethodEditorInBrowser.2"));
        lblNewLabel_1.setBounds(12, 165, 132, 13);
        this.getContentPane().add(lblNewLabel_1);
        final JButton btnUpdate = new JButton(Messages.getString("MethodEditorInBrowser.3"));
        btnUpdate.setBounds(406, 415, 91, 21);
        btnUpdate.setEnabled(!TestCaseEditor.unableMode);
        this.getContentPane().add(btnUpdate);
        JButton btnCancel = new JButton(Messages.getString("MethodEditorInBrowser.4"));
        btnCancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MethodEditor.this.className.setText("");
                MethodEditor.this.setVisible(false);
            }
        });
        btnCancel.setBounds(556, 415, 91, 21);
        this.getContentPane().add(btnCancel);
        this.className = new JTextField();
        this.className.setBounds(12, 75, 267, 19);
        this.getContentPane().add(this.className);
        this.className.setColumns(10);
        if (cname != null) {
            this.className.setText(cname);
        }
        JButton btnFindClassmethod = new JButton(Messages.getString("MethodEditorInBrowser.5"));
        btnFindClassmethod.setBounds(12, 10, 138, 21);
        this.getContentPane().add(btnFindClassmethod);
        JLabel lblClassname = new JLabel(Messages.getString("MethodEditorInBrowser.6"));
        lblClassname.setBounds(12, 52, 98, 13);
        this.getContentPane().add(lblClassname);
        this.methodName = new JTextField();
        this.methodName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    int option;
                    if (MethodEditor.this.textSource.getText().length() > 0 && (option = JOptionPane.showConfirmDialog(null, Messages.getString("MethodEditor.0"), Messages.getString("MethodEditor.22"), 2, 3)) == 2) {
                        return;
                    }
                    try {
                        CtMethod t_m = Tool.getCtMethod(null, MethodEditor.this.className.getText(), MethodEditor.this.methodName.getText(), null);
                        if (t_m != null) {
                            CtClass[] atypes = t_m.getParameterTypes();
                            MethodEditor.this.returntype = t_m.getReturnType().getName();
                            String t_str = "$0=" + MethodEditor.this.className.getText();
                            int i = 0;
                            while (i < atypes.length) {
                                t_str = String.valueOf(t_str) + "\n$" + Integer.toString(i + 1) + "=" + atypes[i].getName();
                                ++i;
                            }
                            MethodEditor.this.argTypes.setText(t_str);
                        }
                    }
                    catch (NotFoundException e1) {
                        Tool.alertMSG(null, e1.getMessage());
                    }
                }
            }
        });
        this.methodName.setBounds(12, 127, 273, 19);
        this.getContentPane().add(this.methodName);
        this.methodName.setColumns(10);
        JLabel lblDeclaredFields = new JLabel(Messages.getString("MethodEditorInBrowser.7"));
        lblDeclaredFields.setBounds(12, 315, 113, 13);
        this.getContentPane().add(lblDeclaredFields);
        JScrollPane scrollPane_2 = new JScrollPane();
        scrollPane_2.setBounds(12, 333, 273, 91);
        this.getContentPane().add(scrollPane_2);
        this.fields = new JTextArea();
        scrollPane_2.setViewportView(this.fields);
        JLabel lblSource = new JLabel(Messages.getString("MethodEditorInBrowser.8"));
        lblSource.setBounds(297, 14, 50, 13);
        this.getContentPane().add(lblSource);
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setBounds(297, 37, 675, 185);
        this.getContentPane().add(scrollPane_1);
        this.textSource = new JTextArea();
        this.textSource.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    MethodEditor.this.showPopup(e);
                }
            }
        });
        this.textSource.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Font t_font = Tool.resizeFont(e, MethodEditor.this.textSource.getFont());
                if (t_font != null) {
                    MethodEditor.this.textSource.setFont(t_font);
                }
            }
        });
        this.textSource.setFont(new Font("MS UI Gothic", 0, 14));
        this.textSource.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '.') {
                    MethodEditor.this.popupCandidate(e);
                }
            }
        });
        this.textSource.setEditable(!TestCaseEditor.unableMode);
        scrollPane_1.setViewportView(this.textSource);
        JButton btnCompile = new JButton(Messages.getString("MethodEditorInBrowser.10"));
        btnCompile.setBounds(822, 10, 132, 21);
        this.getContentPane().add(btnCompile);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(297, 250, 675, 155);
        this.getContentPane().add(scrollPane);
        this.resultText = new JTextArea();
        scrollPane.setViewportView(this.resultText);
        JLabel lblResult = new JLabel(Messages.getString("MethodEditorInBrowser.11"));
        lblResult.setBounds(297, 232, 132, 13);
        this.getContentPane().add(lblResult);
        JScrollPane scrollPane_3 = new JScrollPane();
        scrollPane_3.setBounds(12, 188, 273, 117);
        this.getContentPane().add(scrollPane_3);
        this.argTypes = new JTextArea();
        scrollPane_3.setViewportView(this.argTypes);
        final JButton btnRemove = new JButton(Messages.getString("MethodEditor.btnRemove.text"));
        btnRemove.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!btnRemove.isEnabled()) {
                    return;
                }
                int opt = JOptionPane.showConfirmDialog(null, Messages.getString("MethodEditor.1"), Messages.getString("MethodEditor.3"), 0);
                if (opt == 0) {
                    MethodEditor.this.m_removing = true;
                }
                MethodEditor.this.setVisible(false);
            }
        });
        btnRemove.setBounds(881, 415, 91, 21);
        btnRemove.setEnabled(!TestCaseEditor.unableMode);
        this.getContentPane().add(btnRemove);
        if (s_owner == null) {
            btnRemove.setEnabled(false);
        }
        btnCompile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MethodEditor.this.check();
            }
        });
        btnFindClassmethod.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int option;
                if (MethodEditor.this.textSource.getText().length() > 0 && (option = JOptionPane.showConfirmDialog(null, Messages.getString("MethodEditor.2"), Messages.getString("MethodEditor.22"), 2, 3)) == 2) {
                    return;
                }
                ClassReadDialog t_dial = new ClassReadDialog((JDialog)Tool.getParent((Component)e.getSource(), "JDialog"), Tool.target_dirs, null);
                if (MethodEditor.this.is_fake) {
                    t_dial.setClassName("test.impl." + MethodEditor.this.className.getText());
                } else {
                    t_dial.setClassName(MethodEditor.this.className.getText());
                }
                t_dial.setVisible(true);
                if (t_dial.methodName != null && t_dial.methodName.matches("^.*(final|abstract).*$")) {
                    Tool.alertMSG(null, Messages.getString("MethodEditor.5"));
                } else if (t_dial.className != null && t_dial.methodName != null) {
                    String cname = t_dial.className;
                    if (cname.matches("^test\\.fake\\..*|^test\\.impl\\..*")) {
                        MethodEditor.this.className.setText(cname.substring(10));
                        MethodEditor.this.is_fake = true;
                    } else {
                        MethodEditor.this.className.setText(cname);
                        MethodEditor.this.is_fake = false;
                    }
                    String mname = t_dial.methodName;
                    if (mname.matches("^test\\.fake\\..*|^test\\.impl\\..*")) {
                        MethodEditor.this.methodName.setText(mname.substring(10));
                    } else {
                        MethodEditor.this.methodName.setText(mname);
                    }
                    if (cname.equals(mname) && s_owner == null) {
                        Tool.alertMSG(null, Messages.getString("MethodEditor.4"));
                        return;
                    }
                    MethodEditor.this.methodName.setText(t_dial.methodName);
                    String atype = t_dial.getArgTypes();
                    Pattern t_pat = Pattern.compile("\\$_=(.*?),");
                    Matcher t_m = t_pat.matcher(atype);
                    if (t_m.find()) {
                        MethodEditor.this.returntype = t_m.group(1);
                    }
                    atype = atype.replaceFirst("\\$_=.*?,\n", "");
                    MethodEditor.this.argTypes.setText(atype.replaceAll(",", ""));
                    atype = atype.replaceAll("\\$_=[\\w\\.\\[\\]]*,?", "");
                    atype = atype.replaceAll("\\$0=[\\w\\.\\[\\]]+,?", "");
                    atype = atype.replaceAll("\\$[0-9]+=", "");
                    atype = atype.replaceAll("\\s", "");
                    String[] alist = (String[])Tool.getObjectfromJSON(String[].class, "[" + atype + "]");
                    TestCommandRecord t_cmd = new TestCommandRecord(0);
                    t_cmd.methodName = MethodEditor.this.methodName.getText();
                    FakeMethodRecord t_f = new FakeMethodRecord(0);
                    t_f = Tool._db().getMethodSource(MethodEditor.this.className.getText(), t_cmd.getMethodName(), alist, Tool.version);
                    if (t_f != null) {
                        MethodEditor.this.textSource.setText(t_f.source);
                        MethodEditor.this.check();
                    } else {
                        MethodEditor.this.textSource.setText("");
                        MethodEditor.this.resultText.setText("");
                    }
                }
            }
        });
        btnUpdate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!btnUpdate.isEnabled()) {
                    return;
                }
                if (MethodEditor.this.isSyntaxOK()) {
                    MethodEditor.this.is_OK = true;
                    MethodEditor.this.setVisible(false);
                } else {
                    int option = JOptionPane.showConfirmDialog(null, String.valueOf(MethodEditor.this.m_checked) + Messages.getString("MethodEditor.21"), Messages.getString("MethodEditor.22"), 2, 3);
                    if (option == 0) {
                        MethodEditor.this.is_OK = true;
                        MethodEditor.this.setVisible(false);
                    }
                }
            }
        });
        this.init(cname, mname, atypes, src);
    }

    private boolean isSyntaxOK() {
        ClassOutLine t_clo;
        if (this.textSource.getText().length() == 0) {
            return false;
        }
        if (this.m_cmap == null) {
            this.m_cmap = new HashMap();
            try {
                String t_args = this.argTypes.getText();
                Pattern t_pat = Pattern.compile("\\$[1-9][0-9]*=([\\w\\.]+?)$");
                Matcher t_m = t_pat.matcher(t_args);
                int i = 1;
                while (t_m.find()) {
                    String cname = t_m.group(1);
                    this.m_cmap.put("$" + Integer.toString(i), Tool.forName(Tool.primitiveToFQN(cname)));
                    ++i;
                }
                TestCommandRecord t_rec = new TestCommandRecord(0);
                t_rec.methodName = this.methodName.getText();
                Field[] f_list = Tool.forName(this.className.getText()).getDeclaredFields();
                int j = 0;
                while (j < f_list.length) {
                    f_list[j].setAccessible(true);
                    if (t_rec.isStatic()) {
                        if (Modifier.isStatic(f_list[j].getModifiers())) {
                            this.m_cmap.put(f_list[j].getName(), f_list[j].getType());
                        }
                    } else {
                        this.m_cmap.put(f_list[j].getName(), f_list[j].getType());
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                Tool.logIfDebug(e, "@MethodEditor#isSyntaxOK");
                return false;
            }
        }
        if ((t_clo = Tool.getClassOutLine(this.className.getText())).getDeclaredFields(this.getFakeMethodRecord()) == null) {
            this.m_checked = Messages.getString("MethodEditor.26");
            return false;
        }
        try {
            String t_src = CodeProcessor.preProcessMain(null, null, this.textSource.getText());
            this.m_checked = CodeProcessor.checkReturnType(this.returntype, t_src, this.m_cmap);
            return this.m_checked == null;
        }
        catch (SecurityException e) {
            Tool.logIfDebug(e, "@MethodEditor#isSyntaxOK >>" + this.m_checked);
            return false;
        }
    }

    private void init(String cname, String mname, String[] atypes, String src) {
        if (src == null && cname != null && mname != null) {
            TestCommandRecord t_rec = new TestCommandRecord(0);
            t_rec.methodName = mname;
            FakeMethodRecord t_f = Tool._db().getMethodSource(cname, t_rec.getMethodName(), atypes, Tool.version);
            src = t_f.source;
        }
        if (src != null) {
            if (src.startsWith("{")) {
                src = src.substring(1, src.length() - 1);
            }
            this.textSource.setText(src);
            this.methodName.setText(mname);
            this.className.setText(cname);
            String t_str = "";
            try {
                CtMethod t_m = Tool.getCtMethod(null, cname, mname, atypes);
                this.returntype = t_m.getReturnType().getName();
                t_str = String.valueOf(t_str) + "$_=" + this.returntype + "\n";
            }
            catch (NotFoundException e) {
                Tool.logIfDebug(e, "@MethodEditor#init");
            }
            t_str = String.valueOf(t_str) + "$0=" + cname + "\n";
            int i = 0;
            while (i < atypes.length) {
                if (i > 0) {
                    t_str = String.valueOf(t_str) + "\n";
                }
                t_str = String.valueOf(t_str) + "$" + Integer.toString(i + 1) + "=" + atypes[i];
                ++i;
            }
            this.argTypes.setText(t_str);
            this.check();
        }
    }

    public FakeMethodRecord getFakeMethodRecord() {
        if (this.className.getText().length() > 0) {
            String a_type = "";
            Pattern t_pat = Pattern.compile("\\$[1-9][0-9]*=([\\w\\.\\[\\]]+?)$");
            Matcher t_m = t_pat.matcher(this.argTypes.getText());
            String t_sep = "";
            while (t_m.find()) {
                String cname = t_m.group(1);
                a_type = String.valueOf(a_type) + t_sep + cname;
                if (t_sep.length() != 0) continue;
                t_sep = ",";
            }
            TestCommandRecord t_cmd = new TestCommandRecord(0);
            t_cmd.methodName = this.methodName.getText();
            FakeMethodRecord t_f = Tool._db().getMethodSource(this.className.getText(), t_cmd.getMethodName(), a_type.split(","), Tool.version);
            if (t_f == null) {
                t_f = new FakeMethodRecord(2);
                t_f.className = this.className.getText();
                t_f.methodName = t_cmd.getMethodName();
                t_f.argTypes = a_type.split(",");
            }
            t_f.source = this.textSource.getText();
            t_f.changed();
            if (this.m_removing) {
                t_f.removed = true;
            }
            CodeProcessor.preProcessMain(null, null, t_f.source);
            if (CodeProcessor._memVars != null) {
                for (Map.Entry<String, String> entry : CodeProcessor._memVars.entrySet()) {
                    if (entry.getValue() == null) continue;
                    t_f.addField(entry.getValue(), entry.getKey());
                }
            }
            return t_f;
        }
        return null;
    }

    protected void check() {
        String src = this.textSource.getText();
        src = CodeProcessor.preProcessMain(null, null, src);
        this.resultText.setText("");
        String t_str = CodeProcessor.checkSyntaxOfCode(this.textSource.getText());
        if (t_str != null) {
            this.resultText.setText(t_str);
        }
        t_str = "";
        for (Map.Entry<String, String> entry : CodeProcessor._memVars.entrySet()) {
            t_str = String.valueOf(t_str) + entry.getValue() + " " + entry.getKey() + ";\n";
        }
        this.fields.setText(t_str);
        this.resultText.setText(String.valueOf(this.resultText.getText()) + src);
    }

    private void popupCandidate(KeyEvent e) {
        String src = CodeProcessor.preProcess4Import(this.textSource.getText());
        CodeProcessor.preProcess4MemInfos(src);
        HashMap<String, String> mems = CodeProcessor._memVars;
        HashMap _cmap = new HashMap();
        for (Map.Entry<String, String> entry : mems.entrySet()) {
            String t_var = entry.getKey();
            String t_cname = entry.getValue();
            try {
                if (t_cname == null) continue;
                Class<?> t_c = Tool.forName(Tool.primitiveToFQN(t_cname));
                _cmap.put(t_var, t_c);
            }
            catch (ClassNotFoundException e1) {
                Tool.alertMSG(null, String.valueOf(t_cname) + Messages.getString("MethodEditor.45"));
            }
        }
        String[] t_args = this.argTypes.getText().split("\n");
        int j = 0;
        while (j < t_args.length) {
            String t_$ = t_args[j];
            String t_name = t_$.replaceAll("=.*", "");
            String c_name = t_$.replaceAll("\\$[_0-9]+=\\s*([\\w\\.\\$\\[\\]]+)[,]?", "$1");
            try {
                Class<?> t_c = Tool.forName(Tool.primitiveToFQN(c_name));
                _cmap.put(t_name, t_c);
            }
            catch (ClassNotFoundException e1) {
                Tool.logIfDebug(e1, "@MethodEditor#popupCandidate");
            }
            ++j;
        }
        Caret tc = this.textSource.getCaret();
        Point op = this.textSource.getLocationOnScreen();
        Point pt = tc.getMagicCaretPosition();
        Point pos = new Point(op.x + pt.x, op.y + pt.y);
        final CodingAssistMenu _popup = new CodingAssistMenu(this, this.getFakeMethodRecord(), this.textSource.getText(), this.textSource.getCaretPosition(), _cmap, pos, null);
        if (_popup.countCandidate() > 0) {
            Thread t_thread = new Thread(){

                @Override
                public void run() {
                    try {
                        10.sleep(1000L);
                        SwingUtilities.getWindowAncestor(_popup).toFront();
                        _popup.requestFocusInWindow();
                    }
                    catch (InterruptedException e) {
                        Tool.logIfDebug(e, "@MethodEditor#popupCandidate>run");
                    }
                }
            };
            t_thread.start();
            _popup.setVisible(true);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MethodEditor.this.insertAtCaret(_popup.m_answer, _popup.m_target, _popup.m_catches);
                }
            });
        }
    }

    public void insertAtCaret(String str, String tgt, String ctch) {
        if (str != null) {
            int pos = this.textSource.getCaretPosition();
            String str_h = this.textSource.getText();
            String str_tail = str_h.substring(pos);
            str_h = str_h.substring(0, pos);
            if (ctch != null) {
                str_h = str_h.replaceFirst(String.valueOf(Pattern.quote(String.valueOf(tgt) + ".")) + "$", Matcher.quoteReplacement("try{\n" + tgt + "."));
                str_h = String.valueOf(str_h) + ctch + str_tail;
            } else {
                str_h = String.valueOf(str_h) + str + str_tail;
            }
            this.textSource.setText(str_h);
            this.textSource.setCaretPosition(pos + str.length());
        }
    }

    private void showPopup(MouseEvent e) {
        JPopupMenu t_pop = new JPopupMenu();
        t_pop.add(new JMenuItem(new MethodEditorAction("insert 'MOCK(...)'", this)));
        t_pop.add(new JMenuItem(new MethodEditorAction("insert 'VGET(...)'", this)));
        t_pop.show(e.getComponent(), e.getX(), e.getY());
    }

    class MethodEditorAction
    extends AbstractAction {
        MethodEditor m_editor;
        String m_cmd;

        MethodEditorAction(String menu_str, MethodEditor ed) {
            this.m_editor = ed;
            this.m_cmd = menu_str;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.m_cmd.matches("^.*insert.*OBJECT.*$")) {
                this.m_editor.insertAtCaret("MOCK(\"" + MethodEditor.this.returntype + "\")", null, null);
            } else if (this.m_cmd.matches("^.*insert.*VGET.*$")) {
                String cname = MethodEditor.this.className.getText().replaceFirst("^.*\\.([^\\.]+)$", "$1");
                this.m_editor.insertAtCaret("VGET(\"" + cname + "#" + cname + "\")", null, null);
            }
        }
    }
}

