#!/usr/bin/env python
# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#
#   ftg.py : It is a tool that ,
#            you can capture and anlyze.
#

__version__ = "1.0"

import sys
import os
import re
from optparse import OptionParser, OptionGroup
from ftg.grapher import Grapher
from ftg.utils.common import CommonUtils
from ftg.formatter.graphviz_tb import GraphvizTBFormatter
from ftg.formatter.csv import CSVFormatter
from ftg.formatter.tsv import TSVFormatter


if __name__ == "__main__":
    # init program options
    p = OptionParser(version="ver: %s" % __version__)
    p.add_option(
        '-i', '--dump_file', dest='dump_file',
        help="specify Open vSwitch dump-flows FILE", metavar="FILE")
    p.add_option(
        '-f', '--formatter', dest='formatter',
        help="specify formatter (graphviz, csv, tsv)", default="graphviz")
    p.add_option(
        '-b', '--entries_per_block', dest='entries_per_block', type='int',
        help="specify number of entries in priority block", default=10)
    p.add_option(
        '-v', '--verbose', dest='verbose', action="store_true", default=False,
        help="verbose output")
    p.add_option(
        '-s', '--output_summary', dest='output_summary', action="store_true", default=False,
        help="output summary informations")
    p.add_option(
        '-d', '--debug', dest='debug', action="store_true", default=False,
        help="debug output")
    (opts, args) = p.parse_args()

    util = CommonUtils(opts)

    if  opts.formatter == "graphviz":
        formatter = GraphvizTBFormatter(util)
        formatter.set_entries_per_block(opts.entries_per_block)
        formatter.set_output_summary(opts.output_summary)
    elif  opts.formatter == "csv":
        formatter = CSVFormatter(util)
    elif  opts.formatter == "tsv":
        formatter = TSVFormatter(util)
    else:
        util.error_out("specify valid formatter.")
        sys.exit(1)

    if opts.dump_file is not None and opts.dump_file != "":
        grapher = Grapher(util, opts.dump_file, formatter)
        grapher.run()
    else:
        util.error_out("specify Open vSwitch dump-flows file with -i option.")
        sys.exit(1)
        

     
