#!/usr/local/bin/python

# ftpy is ftp clone.

import ftpui,sys,getpass,string,socket
from ftpy_define import *

class ftpy:
	
	#Class Initial
	def __init__(self,hostname="",portno=21,ui=C_CUI,pasv=C_OFF):
		if ui == C_GUI:
			self.ftpui = ftpui.ftpgui(hostname,portno,pasv)
			self.ftpui.mainloop()
		else:
			self.ftpui = ftpui.ftpcui(pasv)
			if hostname <> "":
				self.ftpui.connect(hostname,portno)
			self.ftpui.main()

#Initial
def init():
	#Arg Check
	hostname,portno,ui,pasv,result = checkArgv()
	if result == C_OK:
		if hostname <> "":
			if checkHostname(hostname) <> C_OK:
				print "Could not find server."
				return None,None,None,None,C_NG
		if portno <> "":
			if checkPortno(portno) <> C_OK:
				print "Portno not Integer."
				return None,None,None,None,C_NG
		return hostname,portno,ui,pasv,result
	else:
		print "usage: ftpy [-gp] [hostname] [portno]"
		return None,None,None,None,C_NG
	
#Check Argv
def checkArgv():
	hostname = ""
	portno = 21
	ui = ""
	pasv = C_OFF
	result = C_OK
	if len(sys.argv) == 1:
		ui = C_CUI
	elif len(sys.argv) == 2:
		if sys.argv[1][0] == "-":
			ui,pasv,ret = checkOption(sys.argv[1])
			if ret == C_NG:
				return C_NG
		else:
			ui = C_CUI
			hostname = sys.argv[1]
	elif len(sys.argv) == 3:
		if sys.argv[1][0] == "-":
			ui,pasv,ret = checkOption(sys.argv[1])
			if ret == C_NG:
				return C_NG
			hostname = sys.argv[2]
		else:
			ui = C_CUI
			hostname = sys.argv[1]
			portno = sys.argv[2]
	elif len(sys.argv) == 4:
		if sys.argv[1][0] == "-":
			ui,pasv,ret = checkOption(sys.argv[1])
			if ret == C_NG:
				return C_NG
			hostname = sys.argv[2]
			portno = sys.argv[3]
		else:
			result = C_NG
	elif len(sys.argv) > 4:
		result = C_NG
		
	return hostname,portno,ui,pasv,result
	
#Check option
def checkOption(argv1):
	ui = pasv = ""
	if string.find(argv1,"g") >= 0:
		ui = C_GUI
	if string.find(argv1,"p") >= 0:
		pasv = C_ON
	if string.find(argv1,"g") < 0 and  string.find(argv1,"p") < 0:
		return None,None,C_NG
	return ui,pasv,C_OK
	
#Check hostname
def checkHostname(hostname):
	try:
		socket.gethostbyname(hostname)
		return C_OK
	except Exception, e:
		return C_NG
		
#Check port no
def checkPortno(portno):	
	try:
		portno = int(portno)
		return C_OK
	except Exception, e:
		result = C_NG

if __name__ == "__main__":
	hostname,portno,ui,pasv,result = init()
	if result == C_OK:
		app = ftpy(hostname,portno,ui,pasv)
		
