#ifndef INCLUDE_H_ACTIONLISTENER
#define INCLUDE_H_ACTIONLISTENER

#include "FileInfo.hpp"
#include "SettingInfo.hpp"

#include "tstring.hpp"

#include "ActionInvoker.hpp"
#include "EventListener.hpp"

#include "CriticalSection.hpp"

#include <list>
#include <utility>

/*!
 * EventListenert@CCxg󂯎AActionInvokerN܂B
 */
class ActionListener : public virtual EventListener
{
private:
	ActionListener( const ActionListener& ); //<! Ȃ
	void operator=( const ActionListener& ); //<! Ȃ

public:
	ActionListener( const ActionSettingParameter& v_settingInfo );
	virtual ~ActionListener() throw();

	virtual void tickEventCycle() throw();

	virtual void notifyFileEvent( EventListener::EventType v_eventId, const tstring& v_absolutePath, const FileInfo& v_fileInfo ) throw();
	virtual void notifyStateEvent( EventListener::StateEventType v_eventId ) throw();

	virtual tstring getDescription() const throw();

private:
	void removeEntry( const tstring& v_absolutePath ) throw();
	bool invokeQueingEntry() throw();

	typedef std::pair< tstring, FileInfo> NamedFileInfo;
	typedef std::list<NamedFileInfo> NamedFileInfoQueue;

	CriticalSection lock_;
	//unsigned int maxProcess_; //TODO: t@N^OɂvZX͂ĂB

	ActionInvokerPtr pActionInvoker_;

	NamedFileInfoQueue queue_;
};

#endif
