#include "stdafx.hpp"

#include "ActionSettingParameter.hpp"

#include <assert.h>

ActionSettingParameter::ActionSettingParameter()
{
}

ActionSettingParameter::ActionSettingParameter( const ActionSettingParameter& v_other )
	: actionTypeName_( v_other.actionTypeName_ )
	, parameters_( v_other.parameters_ )
{
}

ActionSettingParameter& ActionSettingParameter::operator=( const ActionSettingParameter& v_other )
{
	if( this != &v_other ) {
		actionTypeName_ = v_other.actionTypeName_;
		parameters_ = v_other.parameters_;
	}
	return *this;
}

ActionSettingParameter::~ActionSettingParameter()
{
}

tstring ActionSettingParameter::getActionType() const
{
	return actionTypeName_;
}

void ActionSettingParameter::setActionType( const tstring& v_actionTypeName )
{
	actionTypeName_ = v_actionTypeName;
}

tstring ActionSettingParameter::getParameter( const tstring& v_name ) const
{
	const tstring_map::const_iterator ite = parameters_.find( v_name );
	if( ite != parameters_.end() ) {
		return ite->second;
	}
	return tstring();
}

void ActionSettingParameter::setParameter( const tstring& v_name, const tstring& v_value )
{
	parameters_.insert( tstring_map::value_type( v_name, v_value ) );
}

size_t ActionSettingParameter::size() const
{
	return parameters_.size();
}

void ActionSettingParameter::savePersistence() const
{
	assert( false && "ĂȂ" ); //TODO:ĂȂB
}

void ActionSettingParameter::loadPersistence()
{
	assert( false && "ĂȂ" ); //TODO:ĂȂB
}


