#ifndef INCLUDE_H_DELAYSIGNAL
#define INCLUDE_H_DELAYSIGNAL

#include <atltime.h>

class DelaySignal {
public:
	DelaySignal( const CFileTimeSpan& v_span, const bool v_initialState = false ) throw();
	~DelaySignal() throw();
	void setSignalDelay( const CFileTime& v_now ) throw();
	void setSignalImmediate() throw();
	void clear() throw();
	bool isSignaled( const CFileTime& v_now ) const throw();
	bool isSignaledImmediate() const throw();
private:
	const CFileTimeSpan span_;
	CFileTime lastTick_;
	bool delaySignal_;
	mutable bool signaled_;
};

#endif
