#ifndef INCLUDE_H_DIRWATCHOBJECT
#define INCLUDE_H_DIRWATCHOBJECT

#include "PassiveTimer.hpp"
#include "tstring.hpp"

#include <list>

#include <atltime.h>

#include "DirWatchObjectListener.hpp"

class DirWatchObject
{
public:
	DirWatchObject(
		const tstring& v_watchDir,
		bool v_enableSubDir,
		const CFileTimeSpan& v_retrySpan,
		const CFileTimeSpan& v_expirySpan,
		bool enableAPI_
		);
	virtual ~DirWatchObject();
	
	void expireCreationRetrySpan();

	HANDLE getHandle();
	
	void next();

	void appendListener( DirWatchObjectListener* const v_listener );

	void removeListener( DirWatchObjectListener* const v_listener );

private:
	
	void notifyEvent( DirWatchObjectListener::DirWatchObjectEventType v_event );

	typedef std::list<DirWatchObjectListener*> DirWatchObjectListenerList;
	DirWatchObjectListenerList listeners_;

	const tstring watchDir_;
	const bool enableSubDir_;
	const bool enableAPI_;

	HANDLE hWatchHandle_;

	PassiveTimer expiryTimer_;
	PassiveTimer retryTimer_;
};

#endif
