#ifndef INCLUDE_H_EVENTDISPATCHER
#define INCLUDE_H_EVENTDISPATCHER

#include "EventListener.hpp"

#include <map>

#include "tstring.hpp"

class EventDispatcher : public virtual EventListener
{
public:
	typedef std::map< EventListener*, bool > EventListenerMap;

	EventDispatcher( const tstring& v_description );
	virtual ~EventDispatcher() throw();

	virtual void tickEventCycle() throw();

	virtual void notifyFileEvent( EventListener::EventType v_eventId, const tstring& v_absolutePath, const FileInfo& v_fileInfo ) throw();
	virtual void notifyStateEvent( EventListener::StateEventType v_eventId ) throw();

	virtual void appendEventListener( EventListener* v_pEventListener, bool v_autoRemove = false ) throw();
	virtual void removeEventListener( EventListener* v_pEventListener ) throw();

	virtual tstring getDescription() const throw();
	
	virtual const EventListenerMap& eventListeners() const throw();

private:
	tstring description_;
	EventListenerMap eventListeners_;
};

#endif
