#include "stdafx.hpp"
#include "FWatchApp.hpp"
#include "resource.h"

#include "FWatchSettingDlg.hpp"

#include "TaskSettingDialog.hpp"
#include "tstringUty.hpp"
#include "ThreadGroupProfileSettingDialog.hpp"
#include "ShellInvokeActionSettingDialog.hpp"

#include "ShellExecActionInvokerFactory.hpp"

#include "EventListenerFactoryChoiceDialog.hpp"

#include <assert.h>

#include "WaitCursor.hpp"

FWatchSettingDlg::FWatchSettingDlg( WatchTaskGroupCollection& v_watchTaskGroupCollection )
	: hDlg_( NULL )
	, hRootItem_( NULL )
	, watchTaskGroupCollection_( v_watchTaskGroupCollection )
{
	hImageList_ = ImageList_Create( 16, 16, ILC_COLOR4 | ILC_MASK, 4, 0 );
	assert( hImageList_ != NULL );
	ImageList_AddIcon( hImageList_, ::LoadIcon( pApp->getInstanceHandle(), MAKEINTRESOURCE( IDI_FWATCH ) ) );
	ImageList_AddIcon( hImageList_, ::LoadIcon( pApp->getInstanceHandle(), MAKEINTRESOURCE( IDI_FOLDERS ) ) );
	ImageList_AddIcon( hImageList_, ::LoadIcon( pApp->getInstanceHandle(), MAKEINTRESOURCE( IDI_FOLDER ) ) );
	ImageList_AddIcon( hImageList_, ::LoadIcon( pApp->getInstanceHandle(), MAKEINTRESOURCE( IDI_LIGHTNING ) ) );
}

FWatchSettingDlg::~FWatchSettingDlg()
{
	ImageList_Destroy( hImageList_ );
}

void FWatchSettingDlg::show( HWND hWnd )
{
	if( ::DialogBoxParam(
		pApp->getInstanceHandle(),
		MAKEINTRESOURCE( IDD_TASKLISTDIALOG ),
		hWnd,
		DlgProc,
		(LPARAM) this
		) == IDOK )
	{
		if( watchTaskGroupCollection_.isModified() ) {
			watchTaskGroupCollection_.save( pApp->getInfPath() );
		}
	}
}

void FWatchSettingDlg::onInitDialog()
{
	assert( hDlg_ != NULL );

	// EBhEnh̎擾

	hTree_ = ::GetDlgItem( hDlg_, IDC_CONFIG_TREE );
	assert( hTree_ != NULL );

	TreeView_SetImageList( hTree_, hImageList_, TVSIL_NORMAL );

	hStatus_ = ::GetDlgItem( hDlg_, IDC_THREADGROUP_STATUS );
	assert( hStatus_ != NULL );

	// ACe̓o^
	makeTree();

	// Xe[^X̕\

	displayStatus();

	// CAEg}l[W̓o^

	layout_.setParent( hDlg_ );
	layout_.addChild( hTree_, DialogLayoutExpander::MOVE_RIGHT | DialogLayoutExpander::MOVE_BOTTOM );
	layout_.addChild( hStatus_, DialogLayoutExpander::MOVE_TOP | DialogLayoutExpander::MOVE_BOTTOM | DialogLayoutExpander::MOVE_RIGHT | DialogLayoutExpander::MOVE_BOTTOM );

	layout_.addChild( ::GetDlgItem( hDlg_, IDOK ), DialogLayoutExpander::MOVE_TOP | DialogLayoutExpander::MOVE_BOTTOM | DialogLayoutExpander::MOVE_LEFT | DialogLayoutExpander::MOVE_RIGHT );
	layout_.addChild( ::GetDlgItem( hDlg_, IDCANCEL ), DialogLayoutExpander::MOVE_TOP | DialogLayoutExpander::MOVE_BOTTOM | DialogLayoutExpander::MOVE_LEFT | DialogLayoutExpander::MOVE_RIGHT );
}

void FWatchSettingDlg::makeTree() throw()
{
	assert( hRootItem_ == NULL );

	ItemData itemData = { ItemData::itemtype_root, ItemData::listenertype_none, { &watchTaskGroupCollection_, NULL, NULL, NULL } };
	itemDataList_.push_back( itemData );

	TVINSERTSTRUCT rootItem = { 0 };
	rootItem.hParent = TVI_ROOT;
	rootItem.hInsertAfter = TVI_LAST;
	rootItem.itemex.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	rootItem.itemex.lParam = 0;
	rootItem.itemex.iImage = 0;
	rootItem.itemex.iSelectedImage = 0;
	rootItem.itemex.pszText = _TEXT("root");
	hRootItem_ = TreeView_InsertItem( hTree_, &rootItem );
	assert( hRootItem_ != NULL );

	// [g̃Xi̕\
	for( EventDispatcher::EventListenerMap::const_iterator
			root_eventIte  = watchTaskGroupCollection_.eventListeners().begin(),
			root_eventLast = watchTaskGroupCollection_.eventListeners().end();
		root_eventIte != root_eventLast;
		++root_eventIte )
	{
		if( ! root_eventIte->second ) {
			continue;
		}

		EventListener* pEventListener = root_eventIte->first;
		assert( pEventListener != NULL );

		ItemData listenerItemData = { ItemData::itemtype_root, ItemData::listenertype_eventlistener, { &watchTaskGroupCollection_, NULL, NULL, pEventListener } };
		itemDataList_.push_back( listenerItemData );
		const size_t listenerIdx = itemDataList_.size() - 1;

		const tstring listenerCaption = pEventListener->getDescription();

		TVINSERTSTRUCT listenerItem = { 0 };
		listenerItem.hParent = hRootItem_;
		listenerItem.hInsertAfter = TVI_FIRST;
		listenerItem.itemex.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
		listenerItem.itemex.iImage = 3;
		listenerItem.itemex.iSelectedImage = 3;
		listenerItem.itemex.lParam = listenerIdx;
		listenerItem.itemex.pszText = const_cast<LPTSTR>( listenerCaption.c_str() );
		HTREEITEM hListenerItem = TreeView_InsertItem( hTree_, &listenerItem );
		assert( hListenerItem != NULL );
	}

	// O[v̗
	for( WatchTaskGroupCollection::const_iterator groupIte = watchTaskGroupCollection_.begin(), groupLast = watchTaskGroupCollection_.end();
		groupIte != groupLast;
		++groupIte )
	{
		WatchTaskGroup* pWatchTaskGroup = *groupIte;
		assert( pWatchTaskGroup != NULL );

		// O[v̕\
		ItemData grpItemData = { ItemData::itemtype_group, ItemData::listenertype_none, { &watchTaskGroupCollection_, pWatchTaskGroup, NULL, NULL } };
		itemDataList_.push_back( grpItemData );
		const size_t groupIdx = itemDataList_.size() - 1;

		const tstring groupCaption = getGroupCaption( pWatchTaskGroup->getThreadGroupProfile() );

		TVINSERTSTRUCT groupItem = { 0 };
		groupItem.hParent = hRootItem_;
		groupItem.hInsertAfter = TVI_LAST;
		groupItem.itemex.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
		groupItem.itemex.iImage = 1;
		groupItem.itemex.iSelectedImage = 1;
		groupItem.itemex.lParam = groupIdx;
		groupItem.itemex.pszText = const_cast<LPTSTR>( groupCaption.c_str() );

		HTREEITEM groupTreeItem = TreeView_InsertItem( hTree_, &groupItem );
		assert( groupTreeItem != NULL );

		// O[ṽXi̕\
		for( EventDispatcher::EventListenerMap::const_iterator
				group_eventIte  = pWatchTaskGroup->eventListeners().begin(),
				group_eventLast = pWatchTaskGroup->eventListeners().end();
			group_eventIte != group_eventLast;
			++group_eventIte )
		{
			if( ! group_eventIte->second ) {
				continue;
			}

			EventListener* pEventListener = group_eventIte->first;
			assert( pEventListener != NULL );

			ItemData listenerItemData = { ItemData::itemtype_group, ItemData::listenertype_eventlistener, { &watchTaskGroupCollection_, pWatchTaskGroup, NULL, pEventListener } };
			itemDataList_.push_back( listenerItemData );
			const size_t listenerIdx = itemDataList_.size() - 1;

			const tstring listenerCaption = pEventListener->getDescription();

			TVINSERTSTRUCT listenerItem = { 0 };
			listenerItem.hParent = groupTreeItem;
			listenerItem.hInsertAfter = TVI_FIRST;
			listenerItem.itemex.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
			listenerItem.itemex.iImage = 3;
			listenerItem.itemex.iSelectedImage = 3;
			listenerItem.itemex.lParam = listenerIdx;
			listenerItem.itemex.pszText = const_cast<LPTSTR>( listenerCaption.c_str() );
			HTREEITEM hListenerItem = TreeView_InsertItem( hTree_, &listenerItem );
			assert( hListenerItem != NULL );
		}

		// ^XN̗
		for( WatchTaskGroup::const_iterator taskIte = pWatchTaskGroup->begin(), taskLast = pWatchTaskGroup->end();
			taskIte != taskLast;
			++taskIte )
		{
			WatchTask* pWatchTask = *taskIte;
			assert( pWatchTask != NULL );

			// ^XN̕\
			ItemData taskItemData = { ItemData::itemtype_task, ItemData::listenertype_none, { &watchTaskGroupCollection_, pWatchTaskGroup, pWatchTask, NULL } };
			itemDataList_.push_back( taskItemData );
			const size_t taskIdx = itemDataList_.size() - 1;

			const tstring taskCaption = getTaskCaption( pWatchTask->getSettingInfo() );

			TVINSERTSTRUCT taskItem = { 0 };
			taskItem.hParent = groupTreeItem;
			taskItem.hInsertAfter = TVI_LAST;
			taskItem.itemex.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
			taskItem.itemex.iImage = 2;
			taskItem.itemex.iSelectedImage = 2;
			taskItem.itemex.lParam = taskIdx;
			taskItem.itemex.pszText = const_cast<LPTSTR>( taskCaption.c_str() );

			HTREEITEM taskTreeItem = TreeView_InsertItem( hTree_, &taskItem );
			assert( taskTreeItem != NULL );

			// ^XÑXi̕\
			for( EventDispatcher::EventListenerMap::const_iterator
					task_eventIte  = pWatchTask->eventListeners().begin(),
					task_eventLast = pWatchTask->eventListeners().end();
				task_eventIte != task_eventLast;
				++task_eventIte )
			{
				if( ! task_eventIte->second ) {
					continue;
				}

				EventListener* pEventListener = task_eventIte->first;
				assert( pEventListener != NULL );

				ItemData listenerItemData = { ItemData::itemtype_task, ItemData::listenertype_eventlistener, { &watchTaskGroupCollection_, pWatchTaskGroup, pWatchTask, pEventListener } };
				itemDataList_.push_back( listenerItemData );
				const size_t listenerIdx = itemDataList_.size() - 1;

				const tstring listenerCaption = pEventListener->getDescription();

				TVINSERTSTRUCT listenerItem = { 0 };
				listenerItem.hParent = taskTreeItem;
				listenerItem.hInsertAfter = TVI_FIRST;
				listenerItem.itemex.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
				listenerItem.itemex.iImage = 3;
				listenerItem.itemex.iSelectedImage = 3;
				listenerItem.itemex.lParam = listenerIdx;
				listenerItem.itemex.pszText = const_cast<LPTSTR>( listenerCaption.c_str() );
				HTREEITEM hListenerItem = TreeView_InsertItem( hTree_, &listenerItem );
				assert( hListenerItem != NULL );
			}
			TreeView_Expand( hTree_, taskTreeItem, TVE_EXPAND );
		}

		TreeView_Expand( hTree_, groupTreeItem, TVE_EXPAND );
	}

	TreeView_Expand( hTree_, hRootItem_, TVE_EXPAND );
	TreeView_SelectItem( hTree_, hRootItem_ );
}

void FWatchSettingDlg::onSize( WPARAM wParam, LPARAM lParam )
{
	RECT rct;
	::GetWindowRect( hDlg_, &rct );
	layout_.layout( &rct );
}

void FWatchSettingDlg::onSizing( WPARAM wParam, LPARAM lParam )
{
	RECT* pRect = (RECT*) lParam;
	layout_.layout( pRect );
}

void FWatchSettingDlg::displayStatus() const
{
	tstring status = pApp->LoadString( watchTaskGroupCollection_.isDryRun() ? IDS_TASKMES_MODEDRYRUN : IDS_TASKMES_MODESTANDALONE );
	if( watchTaskGroupCollection_.isModified() ) {
		status += pApp->LoadString( IDS_TASKMES_SETTINGDIRTY );
	}
	SetWindowText( hStatus_, status.c_str() );
}

void FWatchSettingDlg::onAddTask()
{
	HTREEITEM treeItem = TreeView_GetSelection( hTree_ );
	if( treeItem == NULL ) {
		::MessageBeep( MB_OK );
		return;
	}

	TVITEMEX item = { 0 };
	item.hItem = treeItem;
	item.mask = TVIF_PARAM;
	if( ! TreeView_GetItem( hTree_, &item ) ) {
		::MessageBeep( MB_OK );
		return;
	}

	const ItemData& itemData = itemDataList_[ item.lParam ];
	if( itemData.itemType != ItemData::itemtype_group || itemData.listenerType != ItemData::listenertype_none ) {
		::MessageBeep( MB_OK );
		return;
	}

	WatchTaskGroup* pWatchTaskGroup = itemData.ptr.pWatchTaskGroup;
	assert( pWatchTaskGroup != NULL );

	TaskSettingInfo settingInfo;
	TaskSettingDialog settingDlg( settingInfo );
	if( settingDlg.show( hDlg_ ) ) {
		settingInfo = settingDlg.createSettingInfo();
		
		WatchTask* pWatchTask = pWatchTaskGroup->createWatchTask( settingInfo );
		
		ItemData itemData = { ItemData::itemtype_task, ItemData::listenertype_none, { &watchTaskGroupCollection_, pWatchTaskGroup, pWatchTask, NULL } };
		itemDataList_.push_back( itemData );
		const size_t idx = itemDataList_.size() - 1;

		const tstring taskCaption = getTaskCaption( settingInfo );

		TVINSERTSTRUCT item = { 0 };
		item.hParent = treeItem;
		item.hInsertAfter = TVI_LAST;
		item.itemex.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
		item.itemex.lParam = idx;
		item.itemex.iImage = 2;
		item.itemex.iSelectedImage = 2;
		item.itemex.pszText = const_cast<LPTSTR>( taskCaption.c_str() );
		HTREEITEM treeItem = TreeView_InsertItem( hTree_, &item );
		if( treeItem != NULL ) {
			TreeView_SelectItem( hTree_, treeItem );
		}
	}
}

EventDispatcher* FWatchSettingDlg::getEventDispatcher( const ItemData& v_itemData )
{
	EventDispatcher* pEventDispatcher = NULL;
	switch( v_itemData.itemType )
	{
	case ItemData::itemtype_root:
		pEventDispatcher = v_itemData.ptr.pWatchTaskGroupCollection;
		break;

	case ItemData::itemtype_group:
		pEventDispatcher = v_itemData.ptr.pWatchTaskGroup;;
		break;

	case ItemData::itemtype_task:
		pEventDispatcher = v_itemData.ptr.pWatchTask;;
		break;

	default:
		assert( false && "sȃ^CvłB" );
		break;
	}
	assert( pEventDispatcher != NULL );

	return pEventDispatcher;
}

void FWatchSettingDlg::onAddEventListener()
{
	HTREEITEM treeItem = TreeView_GetSelection( hTree_ );
	if( treeItem == NULL ) {
		::MessageBeep( MB_OK );
		return;
	}

	TVITEMEX item = { 0 };
	item.hItem = treeItem;
	item.mask = TVIF_PARAM;
	if( ! TreeView_GetItem( hTree_, &item ) ) {
		::MessageBeep( MB_OK );
		return;
	}

	const ItemData& targetItemData = itemDataList_[ item.lParam ];
	if( targetItemData.listenerType != ItemData::listenertype_none ) {
		::MessageBeep( MB_OK );
		return;
	}

	EventListenerFactoryChoiceDialog eventListenerFactoryChoice;
	const ActionInvokerFactory* const pFactory = eventListenerFactoryChoice.selectFactory( hDlg_ );
	if( pFactory == NULL ) {
		// LZꂽ
		return;
	}
	
	ActionSettingParameter actionSettingParameter( pFactory->getDefaultParameter() );
	if( ! pFactory->showEditParameter( hDlg_, actionSettingParameter ) ) {
		// LZꂽ
		return;
	}

	//TODO: ActionInvokerł͂ȂAځAActionListenerԂ悤ɂׂłB
	// pFactory->create( actionSettingParameter );

	EventDispatcher* pEventDispatcher = getEventDispatcher( targetItemData );

	EventListener* pEventListener = new ActionListener( actionSettingParameter );
	pEventDispatcher->appendEventListener( pEventListener, true );

	ItemData listenerItemData( targetItemData );
	listenerItemData.listenerType = ItemData::listenertype_eventlistener;
	listenerItemData.ptr.pEventListener = pEventListener;
	itemDataList_.push_back( listenerItemData );
	const size_t listenerIdx = itemDataList_.size() - 1;

	const tstring listenerCaption = pEventListener->getDescription();

	TVINSERTSTRUCT listenerItem = { 0 };
	listenerItem.hParent = treeItem;
	listenerItem.hInsertAfter = TVI_FIRST;
	listenerItem.itemex.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	listenerItem.itemex.lParam = listenerIdx;
	listenerItem.itemex.iImage = 3;
	listenerItem.itemex.iSelectedImage = 3;
	listenerItem.itemex.pszText = const_cast<LPTSTR>( listenerCaption.c_str() );
	HTREEITEM hListenerItem = TreeView_InsertItem( hTree_, &listenerItem );
	assert( hListenerItem != NULL );

	TreeView_SelectItem( hTree_, hListenerItem );


	//ExecuteActionSettingInfo settingInfo( pFactory->getDefaultParameter() );
	//ShellInvokeActionSettingDialog settingDlg( settingInfo );
	//if( settingDlg.show( hDlg_ ) ) {
	//	settingInfo = settingDlg.getSettingInfo();
	//}
}

void FWatchSettingDlg::onAddGroup()
{
	ThreadGroupProfile prof;
	ThreadGroupProfileSettingDialog profileDlg( prof );

	if( profileDlg.show( hDlg_ ) ) {
		prof = profileDlg.getProfile();

		WatchTaskGroup* pWatchTaskGroup = watchTaskGroupCollection_.createWatchTaskGroup( prof );

		ItemData itemData = { ItemData::itemtype_group, ItemData::listenertype_none, { &watchTaskGroupCollection_, pWatchTaskGroup, NULL, NULL } };
		itemDataList_.push_back( itemData );
		const size_t idx = itemDataList_.size() - 1;

		const tstring groupCaption = getGroupCaption( prof );

		TVINSERTSTRUCT item = { 0 };
		item.hParent = hRootItem_;
		item.hInsertAfter = TVI_LAST;
		item.itemex.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
		item.itemex.iImage = 1;
		item.itemex.iSelectedImage = 1;
		item.itemex.lParam = idx;
		item.itemex.pszText = const_cast<LPTSTR>( groupCaption.c_str() );
		HTREEITEM treeItem = TreeView_InsertItem( hTree_, &item );
		if( treeItem != NULL ) {
			TreeView_SelectItem( hTree_, treeItem );
		}
	}
}

void FWatchSettingDlg::onEdit()
{
	HTREEITEM treeItem = TreeView_GetSelection( hTree_ );
	if( treeItem == NULL ) {
		::MessageBeep( MB_OK );
		return;
	}

	TVITEMEX item = { 0 };
	item.hItem = treeItem;
	item.mask = TVIF_PARAM;
	if( ! TreeView_GetItem( hTree_, &item ) ) {
		::MessageBeep( MB_ICONEXCLAMATION );
		return;
	}

	ItemData& itemData = itemDataList_[ item.lParam ];
	switch( itemData.listenerType )
	{
	case ItemData::listenertype_none:
		// 񃊃Xi̕ҏW
		switch( itemData.itemType )
		{
		case ItemData::itemtype_group:
			onEditGroup( treeItem, itemData );
			return;

		case ItemData::itemtype_task:
			onEditTask( treeItem, itemData );
			return;

		case ItemData::itemtype_root:
		default:
			break;
		}
		break;

	case ItemData::listenertype_eventlistener:
		onEditListener( treeItem, itemData );
		break;

	default:
		assert( false && "sȃ^Cv" );
		break;
	}

	::MessageBeep( MB_OK );
}

void FWatchSettingDlg::onEditGroup( HTREEITEM v_hTreeItem, ItemData& v_itemData )
{
	assert( v_hTreeItem != NULL );

	WatchTaskGroup* pWatchTaskGroup = v_itemData.ptr.pWatchTaskGroup;
	assert( pWatchTaskGroup != NULL );

	ThreadGroupProfile prof = pWatchTaskGroup->getThreadGroupProfile();
	ThreadGroupProfileSettingDialog profileDlg( prof );

	if( profileDlg.show( hDlg_ ) ) {
		prof = profileDlg.getProfile();
		pWatchTaskGroup->setThreadGroupProfile( prof );

		const tstring groupCaption = getGroupCaption( prof );

		TVITEMEX item = { 0 };
		item.hItem = v_hTreeItem;
		item.mask = TVIF_TEXT;
		item.pszText = const_cast<LPTSTR>( groupCaption.c_str() );

		TreeView_SetItem( hTree_, &item );
	}
}

void FWatchSettingDlg::onEditTask( HTREEITEM v_hTreeItem, ItemData& v_itemData )
{
	assert( v_hTreeItem != NULL );

	WatchTaskGroup* pWatchTaskGroup = v_itemData.ptr.pWatchTaskGroup;
	WatchTask* pWatchTask = v_itemData.ptr.pWatchTask;

	assert( pWatchTaskGroup != NULL );
	assert( pWatchTask != NULL );

	TaskSettingInfo settingInfo = pWatchTask->getSettingInfo();
	TaskSettingDialog settingDlg( settingInfo );
	if( settingDlg.show( hDlg_ ) ) {
		settingInfo = settingDlg.createSettingInfo();
		
		const size_t groupIdx = pWatchTaskGroup->find( pWatchTask );
		assert( groupIdx >= 0 );

		WatchTask* pNewTask = pWatchTaskGroup->replace( groupIdx, settingInfo );
		v_itemData.ptr.pWatchTask = pNewTask;

		const tstring taskCaption = getTaskCaption( settingInfo );

		TVITEMEX item = { 0 };
		item.hItem = v_hTreeItem;
		item.mask = TVIF_TEXT;
		item.pszText = const_cast<LPTSTR>( taskCaption.c_str() );

		TreeView_SetItem( hTree_, &item );
	}
}

void FWatchSettingDlg::onEditListener( HTREEITEM v_hTreeItem, ItemData& v_itemData )
{
	assert( v_hTreeItem != NULL );
	assert( v_itemData.listenerType == ItemData::listenertype_eventlistener );

	EventListener* pEventListener = v_itemData.ptr.pEventListener;
	assert( pEventListener != NULL );

	EventDispatcher* pEventDispatcher = getEventDispatcher( v_itemData );
	::MessageBox( NULL, "Ă܂B", NULL, MB_ICONERROR | MB_OK ); //TODO: 
}

void FWatchSettingDlg::onDeleteListener( HTREEITEM v_hTreeItem, ItemData& v_itemData )
{
	assert( v_hTreeItem != NULL );
	assert( v_itemData.listenerType == ItemData::listenertype_eventlistener );

	EventListener* pEventListener = v_itemData.ptr.pEventListener;
	assert( pEventListener != NULL );

	EventDispatcher* pEventDispatcher = getEventDispatcher( v_itemData );

	if( TreeView_DeleteItem( hTree_, v_hTreeItem ) ) {
		pEventDispatcher->removeEventListener( pEventListener );

		// o^ς݃ACef[^Xg̍ڂ̓Z`lŖ߂B
		// CfbNXύXĂ͂ȂȂߍ폜͂ȂB
		v_itemData.ptr.pEventListener = NULL;
	}
}

void FWatchSettingDlg::onDelete()
{
	HTREEITEM treeItem = TreeView_GetSelection( hTree_ );
	if( treeItem == NULL ) {
		::MessageBeep( MB_OK );
		return;
	}

	TVITEMEX item = { 0 };
	item.hItem = treeItem;
	item.mask = TVIF_PARAM;
	if( ! TreeView_GetItem( hTree_, &item ) ) {
		::MessageBeep( MB_ICONEXCLAMATION );
		return;
	}

	ItemData& itemData = itemDataList_[ item.lParam ];
	switch( itemData.listenerType )
	{
	case ItemData::listenertype_none:
		switch( itemData.itemType )
		{
		case ItemData::itemtype_group:
			onDeleteGroup( treeItem, itemData );
			return;

		case ItemData::itemtype_task:
			onDeleteTask( treeItem, itemData );
			return;

		case ItemData::itemtype_root:
			break;

		default:
			assert( false && "sȃ^Cv" );
			break;
		}
		break;

	case ItemData::listenertype_eventlistener:
		onDeleteListener( treeItem, itemData );
		return;

	default:
		assert( false && "sȃ^Cv" );
		break;
	}
	::MessageBeep( MB_ICONEXCLAMATION );
}

void FWatchSettingDlg::onDeleteGroup( HTREEITEM v_hTreeItem, ItemData& v_itemData )
{
	assert( v_hTreeItem != NULL );

	WatchTaskGroupCollection* pWatchTaskGroupCollection = v_itemData.ptr.pWatchTaskGroupCollection;
	WatchTaskGroup* pWatchTaskGroup = v_itemData.ptr.pWatchTaskGroup;
	assert( pWatchTaskGroupCollection != NULL );
	assert( pWatchTaskGroup != NULL );

	const tstring groupCaption = getGroupCaption( pWatchTaskGroup->getThreadGroupProfile() );
	if( pApp->showMessageBox( MB_ICONWARNING | MB_YESNO | MB_DEFBUTTON2, _TEXT("confirm"), IDS_CONFIRM_DELETEGROUP, groupCaption.c_str() ) == IDYES ) {
		const BOOL ret = TreeView_DeleteItem( hTree_, v_hTreeItem );
		assert( ret );
		if( ret ) {
			const size_t collectionIdx = pWatchTaskGroupCollection->find( pWatchTaskGroup );
			assert( collectionIdx >= 0 );

			pWatchTaskGroupCollection->erase( collectionIdx );

			// o^ς݃ACef[^Xg̍ڂ̓Z`lŖ߂B
			// CfbNXύXĂ͂ȂȂߍ폜͂ȂB
			v_itemData.ptr.pWatchTaskGroup = NULL;
		}
	}
}

void FWatchSettingDlg::onDeleteTask( HTREEITEM v_hTreeItem,  ItemData& v_itemData )
{
	assert( v_hTreeItem != NULL );

	WatchTaskGroup* pWatchTaskGroup = v_itemData.ptr.pWatchTaskGroup;
	WatchTask* pWatchTask = v_itemData.ptr.pWatchTask;

	assert( pWatchTaskGroup != NULL );
	assert( pWatchTask != NULL );

	const tstring taskCaption = getTaskCaption( pWatchTask->getSettingInfo() );
	if( pApp->showMessageBox( MB_ICONWARNING | MB_YESNO | MB_DEFBUTTON2, _TEXT("confirm"), IDS_CONFIRM_DELETETASK, taskCaption.c_str() ) == IDYES ) {
		const BOOL ret = TreeView_DeleteItem( hTree_, v_hTreeItem );
		assert( ret );
		if( ret ) {
			const size_t groupIdx = pWatchTaskGroup->find( pWatchTask );
			assert( groupIdx >= 0 );

			pWatchTaskGroup->erase( groupIdx );

			// o^ς݃ACef[^Xg̍ڂ̓Z`lŖ߂B
			// CfbNXύXĂ͂ȂȂߍ폜͂ȂB
			v_itemData.ptr.pWatchTask = NULL;
		}
	}
}

void FWatchSettingDlg::onSaveAsConfig()
{
	tstring filter = pApp->LoadString( IDS_SETTINGMES_FWATCHCONFFILE );
	tstring::size_type pos;
	while( ( pos = filter.find( '|' ) ) != tstring::npos ) {
		filter.replace( pos, 1, 1, '\0' );
	}
	filter.push_back( '\0' );

	TCHAR savename[MAX_PATH] = { 0 };
	OPENFILENAME ofn = {0};
	ofn.lStructSize = sizeof( OPENFILENAME );
	ofn.hwndOwner = hDlg_;
	ofn.hInstance = pApp->getInstanceHandle();
	ofn.lpstrFilter = filter.data();
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter = 0;
	ofn.nFilterIndex = 0;
	ofn.lpstrFile = savename;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrTitle = NULL;
	ofn.Flags = OFN_FILEMUSTEXIST;
	ofn.lpstrDefExt = _TEXT("log");
	if( ::GetSaveFileName( &ofn ) ){
		watchTaskGroupCollection_.save( savename );
	}
}

BOOL FWatchSettingDlg::onCommand( UINT btn ) throw()
{
	BOOL result = TRUE;
	switch(btn)
	{
	case IDOK:
		::EndDialog(hDlg_, IDOK);
		break;

	case IDCANCEL:
		::EndDialog(hDlg_, IDCANCEL);
		break;

	case ID_ADD:
		onAddTask();
		break;

	case IDC_APPENDEVENTLISTENER:
		onAddEventListener();
		break;

	case ID_ADD_GROUP:
		onAddGroup();
		break;

	case ID_EDIT:
		onEdit();
		break;

	case ID_DEL:
		onDelete();
		break;

	case ID_SAVE_AS_CONFIG:
		onSaveAsConfig();
		break;

	default:
		result = FALSE;
		break;
	}
	return result;
}

void FWatchSettingDlg::onSelectChanged( LPNMTREEVIEW pnmtv ) throw()
{
	assert( pnmtv != NULL );

	TVITEMEX item = { 0 };
	item.hItem = pnmtv->itemNew.hItem;
	item.mask = TVIF_PARAM;
	if( ! TreeView_GetItem( hTree_, &item ) ) {
		::MessageBeep( MB_ICONEXCLAMATION );
		return;
	}

	const ItemData& targetItemData = itemDataList_[ item.lParam ];

	HMENU hMenu = GetMenu( hDlg_ );
	assert( hMenu != NULL );

	if( targetItemData.listenerType == ItemData::listenertype_none ) {
		EnableMenuItem( hMenu, ID_ADD_LISTENER_SHELLINVOKE, MF_BYCOMMAND | MF_ENABLED );
		EnableMenuItem( hMenu, ID_ADD_LISTENER_LOGGING, MF_BYCOMMAND | MF_ENABLED );

		switch( targetItemData.itemType )
		{
		case ItemData::itemtype_root:
			EnableMenuItem( hMenu, ID_ADD, MF_BYCOMMAND | MF_GRAYED );
			EnableMenuItem( hMenu, ID_EDIT, MF_BYCOMMAND | MF_GRAYED );
			EnableMenuItem( hMenu, ID_DEL, MF_BYCOMMAND | MF_GRAYED );
			EnableMenuItem( hMenu, ID_ADD_GROUP, MF_BYCOMMAND | MF_ENABLED );
			break;

		case ItemData::itemtype_group:
			EnableMenuItem( hMenu, ID_ADD, MF_BYCOMMAND | MF_ENABLED );
			EnableMenuItem( hMenu, ID_EDIT, MF_BYCOMMAND | MF_ENABLED );
			EnableMenuItem( hMenu, ID_DEL, MF_BYCOMMAND | MF_ENABLED );
			EnableMenuItem( hMenu, ID_ADD_GROUP, MF_BYCOMMAND | MF_GRAYED );
			break;

		case ItemData::itemtype_task:
			EnableMenuItem( hMenu, ID_ADD, MF_BYCOMMAND | MF_GRAYED );
			EnableMenuItem( hMenu, ID_EDIT, MF_BYCOMMAND | MF_ENABLED );
			EnableMenuItem( hMenu, ID_DEL, MF_BYCOMMAND | MF_ENABLED );
			EnableMenuItem( hMenu, ID_ADD_GROUP, MF_BYCOMMAND | MF_GRAYED );
			break;

		default:
			assert( false );
			break;
		}
	}
	else if( targetItemData.listenerType == ItemData::listenertype_eventlistener ) {
		EnableMenuItem( hMenu, ID_ADD, MF_BYCOMMAND | MF_GRAYED );
		EnableMenuItem( hMenu, ID_EDIT, MF_BYCOMMAND | MF_ENABLED );
		EnableMenuItem( hMenu, ID_DEL, MF_BYCOMMAND | MF_ENABLED );
		EnableMenuItem( hMenu, ID_ADD_GROUP, MF_BYCOMMAND | MF_GRAYED );

		EnableMenuItem( hMenu, ID_ADD_LISTENER_SHELLINVOKE, MF_BYCOMMAND | MF_GRAYED );
		EnableMenuItem( hMenu, ID_ADD_LISTENER_LOGGING, MF_BYCOMMAND | MF_GRAYED );
	}
	else {
		assert( false );
	}

}

BOOL FWatchSettingDlg::onNotify( WPARAM wParam, LPARAM lParam ) throw()
{
	const UINT uID = (UINT) wParam;
	const NMHDR* pNMHeader = (NMHDR*) lParam;
	
	if( uID == IDC_CONFIG_TREE ) {
		if( pNMHeader->code == TVN_SELCHANGED ) {
			onSelectChanged( reinterpret_cast<LPNMTREEVIEW>( lParam ) );
		}
		else if( pNMHeader->code == NM_RCLICK ) {
			HTREEITEM hDropItem = TreeView_GetDropHilight( hTree_ );
			if( hDropItem != NULL ) {
				TreeView_SelectItem( hTree_, hDropItem );
			}

			HMENU hMenu = ::GetMenu( hDlg_ );
			assert( hMenu != NULL );
			HMENU hSubMenu = ::GetSubMenu( hMenu, 1 );
			assert( hSubMenu != NULL );
			const DWORD pos = ::GetMessagePos();
			::TrackPopupMenu(
				hSubMenu,
				TPM_LEFTALIGN | TPM_TOPALIGN | TPM_RIGHTBUTTON,
				LOWORD( pos ),
				HIWORD( pos ),
				0,
				hDlg_,
				NULL
				); 
		}
		return TRUE;
	}

	return FALSE;
}

INT_PTR CALLBACK FWatchSettingDlg::DlgProc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
#pragma warning( push )
#pragma warning( disable : 4312 4244 )

	FWatchSettingDlg* me = reinterpret_cast<FWatchSettingDlg*>( ::GetWindowLongPtr( hDlg, DWLP_USER ) );
	assert( ( me == NULL || me->hDlg_ == hDlg ) && "QƂsłB" );

	if( message == WM_INITDIALOG ) {
		me = (FWatchSettingDlg*) lParam;
		assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
		::SetWindowLongPtr( hDlg, DWLP_USER, reinterpret_cast<LONG_PTR>( me ) );
		me->hDlg_ = hDlg;
		me->onInitDialog();
	}
	else {
		if( message == WM_COMMAND ) {
			assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
			return me->onCommand( LOWORD(wParam) );
		}
		else if( message == WM_NOTIFY ) {
			assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
			return me->onNotify( wParam, lParam );
		}
		else if( message == WM_SIZING ) {
			assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
			me->onSizing( wParam, lParam );
			return TRUE;
		}
		else if( message == WM_SIZE ) {
			assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
			me->onSize( wParam, lParam );
			return TRUE;
		}
	}
    return FALSE;

#pragma warning( pop )
}

tstring FWatchSettingDlg::getTaskCaption( const TaskSettingInfo& v_settingInfo ) throw()
{
	return pApp->LoadStringFormat(
		IDS_TASKCAPTION,
		v_settingInfo.getWatchDir().c_str(),
		v_settingInfo.getMaxDepth(),
		v_settingInfo.getWatchFile().c_str()
		);
}


tstring FWatchSettingDlg::getGroupCaption( const ThreadGroupProfile& v_profile ) throw()
{
	return pApp->LoadStringFormat( IDS_THREADGROUPCAPTION, v_profile.getBaseCycleSpan() );
}
