#include "stdafx.hpp"

#include "FileInfo.hpp"

FileInfo::FileInfo()
	: writetime_( 0 )
	, size_( 0 )
	, bExist_( false )
	, detectModified_( false )
	, actionPendingStartTime_( 0 )
	, deletePending_( false )
	, deletePendingStartTime_( 0 )
{
}

FileInfo::FileInfo( const FileInfo& v_other )
	: writetime_( v_other.writetime_ )
	, size_( v_other.size_ )
	, bExist_( v_other.bExist_ )
	, detectModified_( v_other.detectModified_ )
	, actionPendingStartTime_( v_other.actionPendingStartTime_ )
	, deletePending_( v_other.deletePending_ )
	, deletePendingStartTime_( v_other.deletePendingStartTime_ )
{
}

FileInfo& FileInfo::operator=( const FileInfo& v_other )
{
	if( this == &v_other ) {
		return *this;
	}

	writetime_ = v_other.writetime_;
	size_ = v_other.size_;
	bExist_ = v_other.bExist_;
	detectModified_ = v_other.detectModified_;
	actionPendingStartTime_ = v_other.actionPendingStartTime_;
	deletePending_ = v_other.deletePending_;
	deletePendingStartTime_ = v_other.deletePendingStartTime_;

	return *this;
}

FileInfo::~FileInfo()
{
}

void FileInfo::update( const WIN32_FIND_DATA& v_finddata )
{
	writetime_ = v_finddata.ftLastWriteTime;
	size_ = ( v_finddata.nFileSizeHigh << 32 ) | v_finddata.nFileSizeLow;
}

void FileInfo::setExist( bool v_exist )
{
	bExist_ = v_exist;
}

void FileInfo::setDeletePending( bool v_deletePending ) 
{
	deletePending_ = v_deletePending;
}

void FileInfo::setDeletePendingStartTime( const CFileTime& v_deletePendingStartTime )
{
	deletePendingStartTime_ = v_deletePendingStartTime;
}

void FileInfo::setDetectModified( bool v_detectModified )
{
	detectModified_ = v_detectModified;
}

void FileInfo::setLastModified( const CFileTime& v_filetime )
{
	writetime_ = v_filetime;
}

void FileInfo::setActionPendingStartTime( const CFileTime& v_actionPendingStartTime )
{
	actionPendingStartTime_ = v_actionPendingStartTime;
}

void FileInfo::setSize( unsigned long long v_size )
{
	size_ = v_size;
}
