#ifndef INCLUDE_H_FILEINFO
#define INCLUDE_H_FILEINFO

#include <atltime.h>

#include "tstring.hpp"

class FileInfo
{
public:
	FileInfo();

	FileInfo( const FileInfo& v_other );

	FileInfo& operator=( const FileInfo& v_other );

	~FileInfo();

	inline const CFileTime& getLastModified() const
	{
		return writetime_;
	}

	inline unsigned long long getSize() const
	{
		return size_;
	}

	inline bool isExist() const
	{
		return bExist_;
	}

	inline bool isDeletePending() const
	{
		return deletePending_;
	}

	inline const CFileTime& getDeletePendingStartTime() const
	{
		return deletePendingStartTime_;
	}

	inline bool isDetectModified() const
	{
		return detectModified_;
	}

	inline const CFileTime& getActionPendingStartTime() const
	{
		return actionPendingStartTime_;
	}

	void update( const WIN32_FIND_DATA& v_finddata );

	void setExist( bool v_exist );

	void setLastModified( const CFileTime& v_filetime );

	void setSize( unsigned long long v_size );

	void setDetectModified( bool v_detectModified );

	void setActionPendingStartTime( const CFileTime& v_actionPendingStartTime );

	void setDeletePending( bool v_deletePending );

	void setDeletePendingStartTime( const CFileTime& v_deletePendingStartTime );

private:
	CFileTime writetime_;
	unsigned long long size_;

	bool bExist_;

	bool detectModified_;
	CFileTime actionPendingStartTime_;

	bool deletePending_;
	CFileTime deletePendingStartTime_;
};

#endif
