#ifndef INCLUDE_H_RESOURCEACCESSOR
#define INCLUDE_H_RESOURCEACCESSOR

class AbstractResourceAccessor
{
public:
	virtual ~AbstractResourceAccessor() {}

	virtual HINSTANCE getInstanceHandle() const = 0;

	int LoadString( UINT uMessageID, LPTSTR buffer, int nBufferMax ) const;
	int LoadInteger( UINT uMessageID ) const;
	tstring LoadString( UINT uMessageID ) const;

	tstring LoadStringFormat( UINT uMessageID, ... ) const;
};

class ResourceAccessor : public AbstractResourceAccessor
{
private:
	HINSTANCE hInstance_;

public:
	ResourceAccessor( HINSTANCE v_hInstance );
	virtual ~ResourceAccessor() {}

	virtual HINSTANCE getInstanceHandle() const;
};

#endif
