#ifndef INCLUDE_H_SAXPARSER
#define INCLUDE_H_SAXPARSER

#include <memory>

#include "SAXContentHandler.hpp"
#include "SAXContentHandlerAdaptor.hpp"

class SAXParser
{
public:
	virtual ~SAXParser() {};
	virtual void parse( const tstring& v_url, SAXContentHandler& v_handler ) = 0;
};

typedef std::auto_ptr<SAXParser> SAXParserPtr;

class SAXParserFactory
{
private:
	SAXParserFactory( const SAXParserFactory& ); //<! Ȃ
	void operator=( const SAXParserFactory& ); //<! Ȃ

public:
	SAXParserFactory();
	virtual ~SAXParserFactory();
	virtual SAXParserPtr create();
};

#endif
