#include "stdafx.hpp"

#include "ShellExecActionInvokerFactory.hpp"
#include "ShellExecActionInvoker.hpp"

#include "FWatchApp.hpp"
#include "resource.h"

#include "ExecuteActionSettingInfo.hpp"
#include "ShellInvokeActionSettingDialog.hpp"

#include <exception>

ShellExecActionInvokerFactory::ShellExecActionInvokerFactory()
	: refCount_( 1 )
{
	defaultParameter_.setActionType( getActionType() );
	defaultParameter_.setParameter( _TEXT("ACTION"     ), pApp->LoadString( IDS_DEFAULTPARAM_ACTION ) );
	defaultParameter_.setParameter( _TEXT("PARAMETER"  ), pApp->LoadString( IDS_DEFAULTPARAM_PARAM  ) );
	defaultParameter_.setParameter( _TEXT("SHOW_WINDOW"), pApp->LoadString( IDS_DEFAULTPARAM_SHOW   ) );
	defaultParameter_.setParameter( _TEXT("CURRENT_DIR"), pApp->LoadString( IDS_DEFAULTPARAM_APPCURRENTDIR ) );
	defaultParameter_.setParameter( _TEXT("MAX_PROCESS"), pApp->LoadString( IDS_DEFAULTPARAM_MAXPROCESS ) );
}

ShellExecActionInvokerFactory::~ShellExecActionInvokerFactory()
{
}

void ShellExecActionInvokerFactory::addRef()
{
	::InterlockedIncrement( &refCount_ );
}

void ShellExecActionInvokerFactory::release()
{
	if( ::InterlockedDecrement( &refCount_ ) == 0 ) {
		delete this;
	}
}

LPCTSTR ShellExecActionInvokerFactory::getActionType() const
{
	return _TEXT("SHELLEXECACTIONINVOKER");
}

LPCTSTR ShellExecActionInvokerFactory::getDescription() const
{
	return _TEXT("Shell Execute");
}


ActionInvokerPtr ShellExecActionInvokerFactory::create( const ActionSettingParameter& v_actionSettingParameter ) const
{
	return ActionInvokerPtr( new ShellExecActionInvoker( ExecuteActionSettingInfo( v_actionSettingParameter ) ) );
}

const ActionSettingParameter& ShellExecActionInvokerFactory::getDefaultParameter() const
{
	return defaultParameter_;
}

bool ShellExecActionInvokerFactory::showEditParameter( HWND v_parent, ActionSettingParameter& v_parameter) const
{
	ExecuteActionSettingInfo settingInfo( v_parameter );
	ShellInvokeActionSettingDialog settingDlg( settingInfo );
	if( settingDlg.show( v_parent ) ) {
		settingInfo = settingDlg.getSettingInfo();
		v_parameter = settingInfo.getParameters();
		return true;
	}
	return false;
}

