#ifndef INCLUDE_H_STRINGEXPANDER
#define INCLUDE_H_STRINGEXPANDER

#include "tstring.hpp"
#include <map>

class StringExpander
{
public:
	StringExpander();
	virtual ~StringExpander() throw() {}
	virtual tstring expandString( const tstring& v_template ) const throw();

	void setUnresolveEmpty( const bool v_mode );
	inline bool isUnresolveEmpty() const
	{
		return unresolveEmpty_;
	}

protected:
	virtual tstring resolveParameter( const tstring& v_name, bool* v_pResolved ) const throw() = 0;

private:
	bool unresolveEmpty_;
};

class PropertyStringExpander : public StringExpander
{
public:
	PropertyStringExpander() throw();
	PropertyStringExpander( const PropertyStringExpander& v_other ) throw();
	PropertyStringExpander& operator=( const PropertyStringExpander& v_other ) throw();

	virtual ~PropertyStringExpander() throw();

	virtual void addProperty( const tstring& v_name, const tstring& v_value ) throw();

protected:
	virtual tstring resolveParameter( const tstring& v_name, bool* v_pFound ) const throw();
	virtual tstring getKeyName( const tstring& v_name ) const throw();

protected:
	typedef std::map< tstring, tstring> PropertyMap;
	PropertyMap propertyMap_;
};

#endif
