#include "stdafx.hpp"

#include <process.h>
#include <assert.h>

#include "FWatchApp.hpp"
#include "resource.h"

#include "Thread.hpp"


BasicThread::BasicThread()
	: nThreadID_( 0 )
	, hThread_( NULL )
{
	hStopEvent_ = ::CreateEvent( NULL, TRUE, FALSE, NULL );
	assert( hStopEvent_ != NULL && "Cxgnh擾ł܂B" );
	hStartedEvent_ = ::CreateEvent( NULL, TRUE, FALSE, NULL );
	assert( hStartedEvent_ != NULL && "Cxgnh擾ł܂B" );
}

BasicThread::~BasicThread()
{
	assert( ! isRunning() && "Xbh~Ă܂B" );
	stop();
	::CloseHandle( hStopEvent_ );
}

bool BasicThread::isRunning() const
{
	if( hThread_ == NULL ) {
		return false;
	}
	return ( ::WaitForSingleObject( hThread_, 0 ) == WAIT_TIMEOUT );
}

void BasicThread::sendStopInterrupt()
{
	if( hThread_ == NULL ) {
		return;
	}

	::SetEvent( hStopEvent_ );
}

void BasicThread::stop()
{
	if( hThread_ == NULL ) {
		return;
	}

	sendStopInterrupt();
	::WaitForSingleObject( hThread_, INFINITE );
	hThread_ = NULL;
}

void BasicThread::start()
{
	//required:
	assert( hThread_ == NULL && "Xbh͂łɊJnĂ܂B" );

	//do:
	stop();

	::ResetEvent( hStopEvent_ );
	::ResetEvent( hStartedEvent_ );
	hThread_ = (HANDLE) _beginthreadex( NULL, 0, threadProc, this, CREATE_SUSPENDED, (unsigned int*) &nThreadID_ );
	if( hThread_ == NULL ) {
		assert( false && "Xbh̊JnɎs܂B" );
		return; //TODO: O
	}
	const resumeCount = ::ResumeThread( hThread_ );
	assert( resumeCount >= 0 && resumeCount <= 1 && "Xbh̃TXyhJEgsłB" );

	// XbhۂɎsJn܂őҋ@܂B
	::WaitForSingleObject( hStartedEvent_, INFINITE );
}

unsigned __stdcall BasicThread::threadProc( void* pParam )
{
	BasicThread* me = (BasicThread*) pParam;
	::SetEvent( me->hStartedEvent_ );

	if( SUCCEEDED( ::CoInitializeEx( NULL, COINIT_APARTMENTTHREADED ) ) ) {
		me->run(); //TODO: O
		::CoUninitialize();
	}
	//else { //TODO: Xbh̃G[
	//	pApp->showMessageBox( MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_COINITFAILED );
	//}

	return 0;
}

