#include "stdafx.hpp"

#include "FWatchApp.hpp"
#include "resource.h"

#include "ThreadGroupProfileSettingDialog.hpp"
#include "tstringUty.hpp"

ThreadGroupProfileSettingDialog::ThreadGroupProfileSettingDialog( const ThreadGroupProfile& v_profile )
	: profile_( v_profile )
{
}

ThreadGroupProfileSettingDialog::~ThreadGroupProfileSettingDialog()
{
}

bool ThreadGroupProfileSettingDialog::show( HWND v_hParent )
{
	return ::DialogBoxParam(
		pApp->getInstanceHandle(),
		MAKEINTRESOURCE( IDD_THREADPROFILEDIALOG ),
		v_hParent,
		dlgProc,
		reinterpret_cast<LPARAM>( this )
		) == IDOK;
}

bool ThreadGroupProfileSettingDialog::updateData() throw()
{
	const long baseCycleSpan = tstringuty::atol( getWindowText( hBaseCycleSpan_ ) );

	if( baseCycleSpan < 1 ) {
		pApp->showMessageBox( MB_ICONERROR | MB_OK, NULL, IDS_BASECYCLESPAN_RANGEERROR );
		return false;
	}

	profile_.setBaseCycleSpan( baseCycleSpan );
	return true;
}

BOOL ThreadGroupProfileSettingDialog::onCommand( UINT v_id ) throw()
{
	switch( v_id )
	{
	case IDOK:
		if( updateData() ) {
			::EndDialog( hDlg_, IDOK );
		}
		return TRUE;

	case IDCANCEL:
		::EndDialog( hDlg_, IDCANCEL );
		return TRUE;
	}
	return FALSE;
}

void ThreadGroupProfileSettingDialog::onInitDialog() throw()
{
	assert( hDlg_ != NULL );

	hBaseCycleSpan_ = GetDlgItem( hDlg_, IDC_BASECYCLESPAN );
	assert( hBaseCycleSpan_ != NULL );

	setWindowText( hBaseCycleSpan_, tstringuty::ToString( _TEXT("%ld"), profile_.getBaseCycleSpan() ) );
}

const ThreadGroupProfile& ThreadGroupProfileSettingDialog::getProfile() const throw()
{
	return profile_;
}

INT_PTR CALLBACK ThreadGroupProfileSettingDialog::dlgProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam ) throw()
{
#pragma warning( push )
#pragma warning( disable : 4312 4244 )

	ThreadGroupProfileSettingDialog* me = reinterpret_cast<ThreadGroupProfileSettingDialog*>( ::GetWindowLongPtr( hDlg, DWLP_USER ) );
	assert( ( me == NULL || me->hDlg_ == hDlg ) && "QƂsłB" );

	if( uMsg == WM_INITDIALOG ) {
		me = (ThreadGroupProfileSettingDialog*) lParam;
		assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
		::SetWindowLongPtr( hDlg, DWLP_USER, reinterpret_cast<LONG_PTR>( me ) );
		me->hDlg_ = hDlg;
		me->onInitDialog();
		return TRUE;
	}
	else if( uMsg == WM_COMMAND ) {
		assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
		return me->onCommand( LOWORD(wParam) );
	}

	return FALSE;

#pragma warning( pop )
}
