#ifndef INCLUDE_H_WATCHTASK
#define INCLUDE_H_WATCHTASK

#include "SettingInfo.hpp"

#include "tstring.hpp"
#include <map>
#include <list>

#include "FileInfo.hpp"
#include "FileInfoMap.hpp"

#include "ActionInvoker.hpp"
#include "ActionListener.hpp"
#include "EventDispatcher.hpp"
#include "PatternMatch.hpp"
#include "Task.hpp"

#include "DirWatchObject.hpp"
#include "DelaySignal.hpp"
#include "PassiveTimer.hpp"
#include "FileTimeComparator.hpp"

class WatchTask : public virtual Task, public virtual EventDispatcher, private DirWatchObjectListener
{
private:
	WatchTask( const WatchTask& ); //<! Ȃ
	void operator=( const WatchTask& ); //<! Ȃ

public:
	WatchTask( const TaskSettingInfo& v_settingInfo );

	virtual ~WatchTask();

	const TaskSettingInfo& getSettingInfo() const;

public: // Task Implements

	virtual void onThreadBinded();

	virtual void onThreadUnbinded();

	virtual void onThreadSignal();

	virtual void onThreadTick();

	virtual HANDLE getWaitableHandle();

private:

	void prepareDeleteEntries();

	void sweepDeletedEntries();

	void EnumFile(const bool v_enableEvent );

	bool EnumFileRecursive( const tstring& v_baseDir, const int v_depth, const bool v_enableEvent );

	static bool getFileSize( const tstring& v_path, unsigned long long* v_pSize );

	virtual void notifyDirWatchObjectEvent( DirWatchObjectEventType v_event );

private:

	DirWatchObject dirChangeNotification_;
	
	DelaySignal enumerationSignal_;

	DelaySignal persistenceRequest_;
	
	PassiveTimer forceEnumerationTimer_;

	FileInfoMap fileInfoMap_;

	typedef std::list<tstring> FileNameList;

	FileNameList deletePendingList_;

	PatternMatchCollection nameFilter_;

	const FileTimeComparator fileTimeComparator_;

	TaskSettingInfo settingInfo_;
};


#endif
