#ifndef INCLUDE_H_WATCHTASKGROUPHOLDER
#define INCLUDE_H_WATCHTASKGROUPHOLDER

#include <vector>

#include "EventDispatcher.hpp"
#include "WatchTaskGroup.hpp"

#include "tstring.hpp"

#include <assert.h>

class WatchTaskGroupCollection : public virtual EventDispatcher
{
private:
	WatchTaskGroupCollection( const WatchTaskGroupCollection& ); //<! Ȃ
	void operator=( const WatchTaskGroupCollection& ); //<! Ȃ

	typedef std::vector<WatchTaskGroup*> WatchTaskGroupList;

public:
	typedef WatchTaskGroupList::value_type value_type;
	typedef WatchTaskGroupList::reference reference;
	typedef WatchTaskGroupList::const_reference const_reference;
	typedef WatchTaskGroupList::iterator iterator;
	typedef WatchTaskGroupList::const_iterator const_iterator;

	iterator begin();
	const_iterator begin() const;
	iterator end();
	const_iterator end() const;

	WatchTaskGroupCollection( bool v_dryRun = false );
	virtual ~WatchTaskGroupCollection() throw();

	WatchTaskGroup* createWatchTaskGroup( const ThreadGroupProfile& v_threadGroupProfile );
	
	/*!
	 * w肵^XNO[ṽCfbNX擾܂B
	 * ݂Ȃꍇ-1Ԃ܂B
	 */
	size_t find( const WatchTaskGroup* v_watchTaskGroup ) const throw();

	void erase( size_t idx ) throw();

	WatchTaskGroup*& operator[]( size_t idx ) throw();
	WatchTaskGroup* const & operator[]( size_t idx ) const throw();
	
	size_t size() const throw();

	void clear() throw();
	bool empty() const throw();

	bool isModified() const throw();
	
	bool isDryRun() const throw();
	void load( const tstring& v_fileName );
	void save( const tstring& v_fileName ) const;

	void startWatch();
	void stopWatch();

private:
	bool dryRun_;
	bool runnung_;
	mutable bool modified_;
	WatchTaskGroupList watchTaskGroups_;
};

#endif
