#include "stdafx.hpp"

#include "WindowUtility.hpp"

#include <assert.h>
#include <vector>

tstring WindowUtility::getWindowText( HWND v_hWnd ) const throw()
{
	//required:
	assert( v_hWnd != NULL && "v_hWndNULL͎wł܂B" );

	//do:
	const int len = ::GetWindowTextLength( v_hWnd );
	if( len > 0 ) {
		std::vector< tstring::value_type > buffer( len + 1 );
		::GetWindowText( v_hWnd, &buffer[0], len + 1 );
		return tstring( &buffer[0] );
	}
	return tstring( _TEXT("") );
}

void WindowUtility::setWindowText( HWND v_hWnd, const tstring& v_text ) const throw()
{
	//required:
	assert( v_hWnd != NULL && "v_hWndNULL͎wł܂B" );

	//do:
	::SetWindowText( v_hWnd, v_text.c_str() );
}

tstring WindowUtility::getCBLBText( HWND v_hWnd, int v_index ) const throw()
{
	//required:
	assert( v_hWnd != NULL && "v_hWndNULL͎wł܂B" );
	
	//do:
	const LRESULT len = ::SendMessage( v_hWnd, CB_GETLBTEXTLEN, v_index, 0 );
	if( len != CB_ERR && len > 0 ) {
		std::vector< tstring::value_type > buffer( len + 1 );
		if( ::SendMessage( v_hWnd, CB_GETLBTEXT, v_index, (LPARAM) &buffer[0] ) != CB_ERR ) {
			return tstring( &buffer[0] );
		}
	}
	return tstring( _TEXT("") );
}

