#pragma once

#include "../include/FWatchCore2Obj.hpp"

/**
 * t@C
 */
struct FILE_INFO
{
	/**
	 * ŏIXV
	 */
	FILETIME lastModified_;

	/**
	 * t@CTCY
	 */
	ULARGE_INTEGER fileSize_;

	/**
	 * t@C̑
	 */
	DWORD attributes_;
};

class __declspec(uuid("A3147C85-9D20-430f-BE70-3BF57C7F4078")) CFileInfo
	: public IFileInfo
	, public CComObjectRoot
	, public CComCoClass<CFileInfo>
{
public:
	DECLARE_OBJECT_DESCRIPTION("CFileInfo")
	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()

	BEGIN_COM_MAP(CFileInfo)
		COM_INTERFACE_ENTRY(IFileInfo)
	END_COM_MAP()

	/// PRIVATE

	HRESULT Init(const WIN32_FIND_DATA* v_pFindData) throw();
	HRESULT Init(const FILE_INFO* v_pFindInfo) throw();

	/// IFileInfo

	HRESULT __stdcall get_LastModified(FILETIME* v_pFileTime) throw();
	HRESULT __stdcall get_FileSize(ULARGE_INTEGER* v_pFileSize) throw();
	HRESULT __stdcall get_Attributes(DWORD* v_pAttributes) throw();

private:
	FILE_INFO fileInfo_;
};

class __declspec(uuid("89FEAC95-AD1E-44f6-B4E3-E5FB4BAFEA49")) CW32FindDataToFileInfoAdaptor
	: public IW32FindDataReceiver
	, public CComObjectRoot
	, public CComCoClass<CW32FindDataToFileInfoAdaptor>
{
public:
	DECLARE_OBJECT_DESCRIPTION("CW32FindDataToFileInfoAdaptor")
	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()

	BEGIN_COM_MAP(CW32FindDataToFileInfoAdaptor)
		COM_INTERFACE_ENTRY(IW32FindDataReceiver)
	END_COM_MAP()

	HRESULT Init(IFileInfoReceiver* v_pFileInfoReceiver) throw();

	/**
	 * W32_FIND_DATA󂯎܂B
	 * @param v_pPath pX
	 * @param v_pFindData t@C񂪊i[Ă|C^
	 * @return ܂͎s\HRESULT
	 */
	HRESULT __stdcall ReceiveW32FindData(LPCWSTR v_pPath, const WIN32_FIND_DATA* v_pFindData) throw();

private:

	CComPtr<IFileInfoReceiver> pFileInfoReceiver_;
};
