#include "stdafx.h"

#include "FWatchCore2Test.hpp"

#include "../include/FWatchCore2Obj.hpp"

void TestEnumDir2(void) throw()
{
	HRESULT hr;

	CComPtr<INameMatcherFactory> pNameMatcherFactory;
	hr = CreateNameMatcherFactoryObject(&pNameMatcherFactory);
	TEST(SUCCEEDED(hr));
	
	CComPtr<INameMatcher> pNameMatcher;
	hr = pNameMatcherFactory->CreateAcceptDeny(L"*.txt;*.doc", L"*readme.txt", &pNameMatcher);
	TEST(SUCCEEDED(hr));

	// 

	CComPtr<IFileInfoCollection> pFileInfoMap;
	hr = CreateFileInfoCollectionObject(&pFileInfoMap);
	TEST(SUCCEEDED(hr));

	//

	CComPtr<IPersistStreamInit> pPersistStreamInit;
	hr = pFileInfoMap->QueryInterface(&pPersistStreamInit);
	TEST(SUCCEEDED(hr));

	hr = pPersistStreamInit->IsDirty();
	TEST(hr == S_FALSE);

	//

	CComPtr<IFileInfoReceiver> pFileInfoReceiver;
	hr = pFileInfoMap->QueryInterface(&pFileInfoReceiver);
	TEST(SUCCEEDED(hr));

	//

	CComPtr<IW32FindDataReceiver> pW32FindDataReceiver;
	hr = CreateW32FindDataToFileInfoAdaptor(pFileInfoReceiver, &pW32FindDataReceiver);
	TEST(SUCCEEDED(hr));

	//

	CComPtr<IEnumDirFilterFactory> pEnumDirFilterFactory;
	hr = CreateEnumDirFilterFactoryObject(&pEnumDirFilterFactory);
	TEST(SUCCEEDED(hr));

	UINT maxLevel = 0;
	hr = pEnumDirFilterFactory->get_MaxLevel(&maxLevel);
	TEST(SUCCEEDED(hr));
	TEST(maxLevel == 0);

	hr = pEnumDirFilterFactory->set_MaxLevel(1);
	TEST(SUCCEEDED(hr));

	hr = pEnumDirFilterFactory->get_MaxLevel(&maxLevel);
	TEST(SUCCEEDED(hr));
	TEST(maxLevel == 1);

	INameMatcher* pNameMatcher0 = NULL;
	hr = pEnumDirFilterFactory->get_NameFilter(&pNameMatcher0);
	TEST(hr == S_OK);
	TEST(pNameMatcher0 == NULL);

	hr = pEnumDirFilterFactory->set_NameFilter(pNameMatcher);
	TEST(SUCCEEDED(hr));

	hr = pEnumDirFilterFactory->get_NameFilter(&pNameMatcher0);
	TEST(hr == S_OK);
	TEST(pNameMatcher == pNameMatcher0);

	//

	CComPtr<IEnumDirHandler> pCallback;
	hr = pEnumDirFilterFactory->CreateFilter(pW32FindDataReceiver, &pCallback);
	TEST(hr == S_OK);

	//

	CComPtr<IEnumDir> pEnumDir;
	hr = CreateEnumDirObject(&pEnumDir);
	TEST(SUCCEEDED(hr));

	hr = pEnumDir->BeginEnumeration(L"c:\\", pCallback);

	//

	ULONG cnt;
	hr = pFileInfoMap->get_Length(&cnt);
	TEST(SUCCEEDED(hr));
	std::cout << "Count=" << cnt << std::endl;

	//

	hr = pPersistStreamInit->IsDirty();
	TEST(hr == S_OK);

	ULARGE_INTEGER needSize;
	hr = pPersistStreamInit->GetSizeMax(&needSize);
	TEST(SUCCEEDED(hr));

	CComPtr<IStream> pStm;
	hr = CreateStreamOnHGlobal(NULL, FALSE, &pStm);
	TEST(SUCCEEDED(hr));

	hr = pPersistStreamInit->Save(pStm, TRUE);
	TEST(SUCCEEDED(hr));

	LARGE_INTEGER filePos = {0, 0};

	ULARGE_INTEGER realSize;
	hr = pStm->Seek(filePos, STREAM_SEEK_END, &realSize);
	TEST(SUCCEEDED(hr));

	TEST(realSize.QuadPart == needSize.QuadPart);

	//

	hr = pStm->Seek(filePos, STREAM_SEEK_SET, NULL);
	TEST(SUCCEEDED(hr));

	CComPtr<IFileInfoCollection> pFileInfoMap2;
	hr = CreateFileInfoCollectionObject(&pFileInfoMap2);
	TEST(SUCCEEDED(hr));

	CComPtr<IPersistStreamInit> pPersistStreamInit2;
	hr = pFileInfoMap2->QueryInterface(&pPersistStreamInit2);
	TEST(SUCCEEDED(hr));

	pPersistStreamInit2->Load(pStm);

	ULARGE_INTEGER endPos;
	hr = pStm->Seek(filePos, STREAM_SEEK_END, &endPos);
	TEST(realSize.QuadPart == endPos.QuadPart);

	//

	CComPtr<IFileInfoComparatorFactory> pFileInfoComparatorFactory;
	hr = CreateFileInfoComparatorFactoryObject(&pFileInfoComparatorFactory);
	TEST(SUCCEEDED(hr));

	CComPtr<IFileInfoComparator> pFileInfoComparator;
	hr = pFileInfoComparatorFactory->Create(&pFileInfoComparator);
	TEST(SUCCEEDED(hr));

	//FILE_INFO findData0;
	//TEST(pFileInfoMap->get_Item(L"c:\\username.txt", &findData0) == S_OK);
	//TEST(pFileInfoMap->get_Item(L"c:\\username.txt2", NULL) == S_FALSE);

	CComPtr<IFileInfoEnumerator> pFileInfoEnumerator;
	hr = pFileInfoMap->new_Enum(&pFileInfoEnumerator);
	TEST(SUCCEEDED(hr));
	ULONG c = 0;
	while ((hr = pFileInfoEnumerator->HasNext()) == S_OK) {
		CComBSTR name;
		CComPtr<IFileInfo> pFileInfo;
		hr = pFileInfoEnumerator->Next(&name, &pFileInfo);
		TEST(SUCCEEDED(hr));

		CW2A printName(name);
		DWORD attributes;

		hr = pFileInfo->get_Attributes(&attributes);
		TEST(SUCCEEDED(hr));

		CComPtr<IFileInfo> pFileInfo2;
		hr = CreateFileInfoObject(name, &pFileInfo2);
		TEST(SUCCEEDED(hr));

		std::cout << printName << ":" << attributes << " @ ";

		hr = pFileInfoComparator->IsEquals(pFileInfo, pFileInfo2);

		std::cout << hr << std::endl;

		c += 1;
	}
	std::cout << "cnt=" << c << std::endl;

	CComPtr<IFileInfoCollection> pCollection2;
	hr = pFileInfoMap->Clone(&pCollection2);
	TEST(SUCCEEDED(hr));
	hr = pCollection2->get_Length(&cnt);
	TEST(SUCCEEDED(hr));

	std::cout << cnt << std::endl;

	pCollection2->Clear();
	hr = pCollection2->get_Length(&cnt);
	TEST(SUCCEEDED(hr));

	std::cout << cnt << std::endl;
	TEST(cnt == 0);

	hr = pFileInfoMap->get_Length(&cnt);
	TEST(SUCCEEDED(hr));
	std::cout << cnt << std::endl;
	TEST(cnt != 0);
}
