#include "stdafx.h"

#include "FWatchCore2Test.hpp"

#include "../include/FWatchCore2Obj.hpp"

void TestFileComparator(void) throw()
{
	HRESULT hr;
	CComPtr<IFileInfoComparatorFactory> pFileInfoComparatorFactory;
	hr = CreateFileInfoComparatorFactoryObject(&pFileInfoComparatorFactory);
	TEST(SUCCEEDED(hr));

	pFileInfoComparatorFactory->set_AttributesMask(1);
	pFileInfoComparatorFactory->set_FileTimeTolerance(1);

	CComPtr<IFileInfoComparator> pFileInfoComparator;
	hr = pFileInfoComparatorFactory->Create(&pFileInfoComparator);
	TEST(SUCCEEDED(hr));

	WIN32_FIND_DATA f1, f2;

	f1.dwFileAttributes = 0;
	f1.nFileSizeHigh = 0;
	f1.nFileSizeLow = 0;
	f1.ftLastWriteTime.dwHighDateTime = 0;
	f1.ftLastWriteTime.dwLowDateTime = 0;

	f2 = f1;

	f1.dwFileAttributes = 1;

	CComPtr<IFileInfo> pFileTime1, pFileTime2;

	hr = ConvertW32FindDataToFileInfo(&f1, &pFileTime1);
	TEST(SUCCEEDED(hr));
	hr = ConvertW32FindDataToFileInfo(&f2, &pFileTime2);
	TEST(SUCCEEDED(hr));

	hr = pFileInfoComparator->IsEquals(pFileTime1, pFileTime2);
	TEST(hr == S_FALSE);

	pFileTime2.Release();

	f2.dwFileAttributes = 3;

	hr = ConvertW32FindDataToFileInfo(&f2, &pFileTime2);
	TEST(SUCCEEDED(hr));

	hr = pFileInfoComparator->IsEquals(pFileTime1, pFileTime2);
	TEST(hr == S_OK);

	pFileTime2.Release();

	f2.nFileSizeLow = 1;

	hr = ConvertW32FindDataToFileInfo(&f2, &pFileTime2);
	TEST(SUCCEEDED(hr));

	hr = pFileInfoComparator->IsEquals(pFileTime1, pFileTime2);
	TEST(hr == S_FALSE);

	pFileTime2.Release();

	f2.nFileSizeLow = 0;
	f2.ftLastWriteTime.dwLowDateTime = 1;

	hr = ConvertW32FindDataToFileInfo(&f2, &pFileTime2);
	TEST(SUCCEEDED(hr));

	hr = pFileInfoComparator->IsEquals(pFileTime1, pFileTime2);
	TEST(hr == S_OK);

	pFileTime1.Release();
	pFileTime2.Release();

	f2.nFileSizeLow = 0;
	f1.ftLastWriteTime.dwLowDateTime = 1;
	f2.ftLastWriteTime.dwLowDateTime = 3;

	hr = ConvertW32FindDataToFileInfo(&f1, &pFileTime1);
	TEST(SUCCEEDED(hr));
	hr = ConvertW32FindDataToFileInfo(&f2, &pFileTime2);
	TEST(SUCCEEDED(hr));

	hr = pFileInfoComparator->IsEquals(pFileTime1, pFileTime2);
	TEST(hr == S_FALSE);

	pFileTime1.Release();
	pFileTime2.Release();

	f2.nFileSizeLow = 0;
	f1.ftLastWriteTime.dwLowDateTime = 3;
	f2.ftLastWriteTime.dwLowDateTime = 1;

	hr = ConvertW32FindDataToFileInfo(&f1, &pFileTime1);
	TEST(SUCCEEDED(hr));
	hr = ConvertW32FindDataToFileInfo(&f2, &pFileTime2);
	TEST(SUCCEEDED(hr));

	hr = pFileInfoComparator->IsEquals(pFileTime1, pFileTime2);
	TEST(hr == S_FALSE);

	pFileTime1.Release();
	pFileTime2.Release();

	f2.nFileSizeLow = 0;
	f1.ftLastWriteTime.dwLowDateTime = 3;
	f2.ftLastWriteTime.dwLowDateTime = 2;

	hr = ConvertW32FindDataToFileInfo(&f1, &pFileTime1);
	TEST(SUCCEEDED(hr));
	hr = ConvertW32FindDataToFileInfo(&f2, &pFileTime2);
	TEST(SUCCEEDED(hr));

	hr = pFileInfoComparator->IsEquals(pFileTime1, pFileTime2);
	TEST(hr == S_OK);

	pFileTime1.Release();
	pFileTime2.Release();

	f2.nFileSizeLow = 0;
	f1.ftLastWriteTime.dwLowDateTime = 2;
	f2.ftLastWriteTime.dwLowDateTime = 2;

	hr = ConvertW32FindDataToFileInfo(&f1, &pFileTime1);
	TEST(SUCCEEDED(hr));
	hr = ConvertW32FindDataToFileInfo(&f2, &pFileTime2);
	TEST(SUCCEEDED(hr));

	hr = pFileInfoComparator->IsEquals(pFileTime1, pFileTime2);
	TEST(hr == S_OK);

	pFileTime1.Release();
	pFileTime2.Release();
}
