#pragma once

#include "FileInfo.hpp"
#include "SettingInfo.hpp"

#include "Logger.hpp"
#include "ObjectReaderWriter.hpp"
#include "StringExpander.hpp"

#include <string>
#include <map>
#include <memory>


/*!
 * ANV̎sԂi邽߂̃C^[tFCX
 */
class ActionInvokerData
{
public:
	virtual ~ActionInvokerData() throw() = 0 {};

	/*!
	 * iԂZbg܂B
	 */
	virtual void Reset() = 0;

	/*!
	 * iԂǂݍ݂܂B
	 * \param reader IuWFNg[_
	 */
	virtual void Load(CObjectReader &reader) = 0;

	/*!
	 * iԂۑ܂B
	 * \param writer IuWFNgC^
	 */
	virtual void Save(CObjectWriter &writer) = 0;
};


/*!
 * ANVs܂B
 */
class ActionInvoker
	: public ActionInvokerData
{
protected:

	/*!
	 * K[Aݒ肳ĂȂnull
	 */
	Logger* pLogger_;

	/*!
	 * Ďݒ
	 */
	const CSettingInfo& settingInfo_;

private:
	ActionInvoker(const ActionInvoker&); //<! Ȃ
	ActionInvoker& operator=(const ActionInvoker&); //<! Ȃ

public:

	/*!
	 * Ďݒw肵ăANV\z܂B
	 * \param Ďݒ
	 */
	ActionInvoker(const CSettingInfo& v_settingInfo) throw();
	
	/*!
	 * fXgN^
	 */
	virtual ~ActionInvoker() throw();

	/*!
	 * ANVs܂B
	 * ANV̍ő吔𒴂Ă邩͔肳Ȃ߁A
	 * ĂяoƂœKXcanDoActionŃ`FbNKv܂B
	 * \param v_absolutePath ^[Qbgt@C̐΃pX
	 * \param fileInfo Ďt@C
	 * \return strueAłȂfalse
	 */
	virtual bool doAction(const tstring& v_absolutePath, const CFileInfo& fileInfo) throw();

	/*!
	 * ANVs\`FbN܂B
	 * \return ő吔w肳ĂȂAő吔𒴂ĂȂtrue
	 */
	virtual bool canDoAction() throw() = 0;

	/*!
	 * Kx[WRNg܂B
	 * Iς݂̃vZX`FbN邽߂ɒIɌĂяoKv܂B
	 * \return Nς݂ŏIҋ@ĂAvP[VԂ܂.
	 */
	virtual unsigned int sweepGarbage() throw() = 0;

public:

	/*!
	 * K[ݒ肵܂B
	 * \param pLogger K[Anull
	 */
	virtual void setLogger(Logger* pLogger) throw();

	/*!
	 * ݂̃K[擾܂B
	 * \return K[Anull
	 */
	virtual Logger* getLogger() const throw();

protected:

	/*!
	 * vZXsp[^̒B
	 * ANVɉēϐEϐ̓WJA󎚕␳ȂǂsB
	 * \param expander uϐ̓WJ
	 * \param v_absolutePath ΃pX
	 * \param fileInfo t@C
	 * \param verb ANV^Cvۑ
	 * \param appName AvP[Vۑ
	 * \param param p[^ۑB
	 * \param appCurrentDir JgfBNgۑB
	 */
	virtual void adjustParameters(
		PropertyStringExpander expander,
		const tstring &v_absoluePath,
		const CFileInfo &fileInfo,
		tstring& verb,
		tstring& appName, 
		tstring& param,
		tstring& appCurrentDir) throw();

	/*!
	 * vZX̎s
	 * \param v_absoluePath ^[Qbg̐΃pX
	 * \param v_fileInfo ^[Qbg̃t@C
	 * \param verb ANV^Cv
	 * \param appName AvP[V(WJς)
	 * \param param p[^(WJς)
	 * \param appCurrentDir JgfBNg(WJς)
	 * \return strueAłȂfalse
	 */
	virtual bool internalDoAction(
		const tstring v_absolutePath,
		const CFileInfo& v_fileInfo,
		const tstring& verb,
		const tstring& appName, 
		const tstring& param,
		const tstring& appCurrentDir) throw() = 0;

	/*!
	 * ϐCOUNT̓WJɎgp鑍s񐔂擾܂B
	 * \return s
	 */
	virtual DWORD internalGetRunCount() = 0;
};

/*!
 * ANV̎|C^
 */
typedef std::auto_ptr<ActionInvoker> ActionInvokerPtr;


/*!
 * Ďݒ̃ANV^CvAANV̎\z邽߂̃t@Ng
 */
class ActionInvokerFactory
{
private:
	ActionInvokerFactory(const ActionInvokerFactory&); //<! Ȃ
	ActionInvokerFactory& operator=(const ActionInvokerFactory&); //<! Ȃ

public:

	/*!
	 * t@Ng\z܂B
	 */
	ActionInvokerFactory();

	/*!
	 * fXgN^
	 */
	virtual ~ActionInvokerFactory() throw();

	/*!
	 * Ďݒ̃ANVݒ肩ANV\zĕԂ܂B
	 * \param v_settingInfo Ďݒ
	 */
	virtual ActionInvokerPtr create(const CSettingInfo& v_settingInfo) const;
};
