#include "stdafx.h"
#include "resource.h"

#include "UDPSendActionInvoker.hpp"

#include "Utility.hpp"

#include <vector>
#include <algorithm>

#pragma comment(lib, "Ws2_32.lib")



// UDPSendActionInvoker̎ʎq
// {75BB2D04-8C25-4fcf-8124-CF155D998AF2}
static const GUID UDP_SEND_ACTIONINVOKE_SIG =
	{ 0x75bb2d04, 0x8c25, 0x4fcf, { 0x81, 0x24, 0xcf, 0x15, 0x5d, 0x99, 0x8a, 0xf2 } };

/*!
 * Ďݒw肵ăANV\z܂B
 * \param Ďݒ
 */
UDPSendActionInvoker::UDPSendActionInvoker(const CSettingInfo& v_settingInfo) throw()
	: ActionInvoker(v_settingInfo)
	, initResult_(0)
	, msgid_(0)
{
	ZeroMemory(&wsaData_, sizeof(WSAData));
	initResult_ = WSAStartup(MAKEWORD(2,0), &wsaData_);
}

/*!
 * fXgN^
 */
UDPSendActionInvoker::~UDPSendActionInvoker() throw()
{
	if (initResult_ == 0) {
		WSACleanup();
	}
}

/*!
 * iԂZbg܂B
 */
void UDPSendActionInvoker::Reset()
{
	msgid_ = 0;
}

/*!
 * iԂǂݍ݂܂B
 * \param reader IuWFNg[_
 */
void UDPSendActionInvoker::Load(CObjectReader &reader)
{
	reader.VerifySig(UDP_SEND_ACTIONINVOKE_SIG);
	msgid_ = reader.ReadDWORD();
}

/*!
 * iԂۑ܂B
 * \param writer IuWFNgC^
 */
void UDPSendActionInvoker::Save(CObjectWriter &writer)
{
	writer.WriteSig(UDP_SEND_ACTIONINVOKE_SIG);
	writer.WriteDWORD(msgid_);
}

/*!
 * ANVs\`FbN܂B
 * \return ő吔w肳ĂȂAő吔𒴂ĂȂtrue
 */
bool UDPSendActionInvoker::canDoAction() throw()
{
	return true;
}

/*!
 * Kx[WRNg܂B
 *Iς݂̃vZX`FbN邽߂ɒIɌĂяoKv܂B
 */
unsigned int UDPSendActionInvoker::sweepGarbage() throw()
{
	return 0;
}

/*!
 * ϐCOUNT̓WJɎgp鑍s񐔂擾܂B
 * \return s
 */
DWORD UDPSendActionInvoker::internalGetRunCount()
{
	return msgid_;
}

/*!
 * UDPMp[^̒B
 * ANVɉēϐEϐ̓WJA󎚕␳ȂǂsB
 * p[^ɂĂ͔󎚕̋󔒒usȂB(̂܂܁B)
 * \param expander uϐ̓WJ
 * \param v_absolutePath ΃pX
 * \param fileInfo t@C
 * \param verb ANV^Cvۑ
 * \param appName AvP[Vۑ
 * \param param p[^ۑB
 * \param appCurrentDir JgfBNgۑB
 */
void UDPSendActionInvoker::adjustParameters(
	PropertyStringExpander expander,
	const tstring &, //v_absoluePath
	const CFileInfo &, //fileInfo
	tstring& verb,
	tstring& appName, 
	tstring& param,
	tstring& appCurrentDir) throw()
{
	verb = EliminateUnprintableChars(settingInfo_.getAction());

	appName = EliminateUnprintableChars(expander.expandString(settingInfo_.getAppName()));
	param = expander.expandString(settingInfo_.getParam()); // s͂̂܂܁B
	appCurrentDir = EliminateUnprintableChars(expander.expandString(settingInfo_.getAppCurrentDir()));
}

/*!
 * UDPM̎s
 * \param v_absoluePath ^[Qbg̐΃pX
 * \param v_fileInfo ^[Qbg̃t@C
 * \param verb ANV^Cv
 * \param appName AvP[V(WJς)
 * \param param p[^(WJς)
 * \param appCurrentDir JgfBNg(WJς)
 * \return ptOA(falseԂ܂)
 */
bool UDPSendActionInvoker::internalDoAction(
	const tstring v_absolutePath,
	const CFileInfo& , // v_fileInfo
	const tstring& , // verb
	const tstring& appName, 
	const tstring& param,
	const tstring& appCurrentDir) throw()
{
	if (initResult_) {
		// ɎsĂꍇ
		if (pLogger_) {
			pLogger_->LogMessage(0, NULL, (DWORD) initResult_, IDS_LOGMES_UDPSENDFAIL);
		}
		return false;
	}

	if (appName.empty()) {
		// AvP[VȗĂΑMȂƂĖ߂
		return false;
	}

	// zXgƃ|[gɕB
	tstring hostName;
	tstring serviceName;
	size_t pos = appName.find(_T(":"));
	if (pos == appName.npos) {
		hostName = appName;
		serviceName = _T("2425"); // IPMsg̃ftHg|[g
	}
	else {
		hostName = appName.substr(0, pos);
		serviceName = appName.substr(pos + 1);
	}

	// M҂ƑMƃzXg̕
	tstring senderName;
	tstring localHostName;
	if ( !appCurrentDir.empty() && appCurrentDir.find(_T(":")) == appCurrentDir.npos) {
		// appCurrentDirɁuuser@hostv΁ApB
		// R܂܂ꍇ͖ = w肳ĂȂ̂ƓƂ݂ȂB
		// (IpMsg̃tH[}bg`Ń[UƃzXgɃR邱Ƃ͂łȂ߁B)
		size_t pos = appCurrentDir.find(_T("@"));
		if (pos == appCurrentDir.npos) {
			senderName = appCurrentDir;
		}
		else {
			senderName = appCurrentDir.substr(0, pos);
			localHostName = appCurrentDir.substr(pos + 1);
		}
	}
	if (senderName.empty()) {
		TCHAR szUserName[MAX_PATH] = {0};
		DWORD szUserNameBufSiz = MAX_PATH;
		if (GetUserName(szUserName, &szUserNameBufSiz)) {
			senderName = szUserName;
		}
	}
	if (localHostName.empty()) {
		CHAR szLocalHostName[MAX_PATH] = {0};
		if (gethostname(szLocalHostName, MAX_PATH) == 0) {
			CA2T localHostNameT(szLocalHostName);
			localHostName = localHostNameT;
		}
	}
	if (senderName.empty()) {
		senderName = _T("fwatch");
	}
	if (localHostName.empty()) {
		localHostName = _T("fwatch");
	}
	

	// UNICODEȂANSIɕϊ
	CT2A hostNameA(hostName.c_str());
	CT2A serviceA(serviceName.c_str());

	// MAhXƃ|[ǧ
	sockaddr_in addr = {0};
	addr.sin_family = AF_INET;
	addr.sin_port = htons(2425);

	addrinfo addrHints = {0};
	addrHints.ai_family = AF_INET;
	addrHints.ai_socktype  = SOCK_DGRAM;
	addrHints.ai_protocol = IPPROTO_UDP;

	addrinfo *pAddrInfoHead = NULL;
	int addrErrCode = getaddrinfo(hostNameA, serviceA, &addrHints, &pAddrInfoHead);
	bool bFoundAddr = false;
	if (addrErrCode == 0) {
		addrinfo *pAddrInfo = pAddrInfoHead;
		while (pAddrInfo) {
			addr.sin_addr.S_un = ((struct sockaddr_in *)(pAddrInfo->ai_addr))->sin_addr.S_un;
			addr.sin_port = ((struct sockaddr_in *)(pAddrInfo->ai_addr))->sin_port;
			pAddrInfo = pAddrInfo->ai_next;
			bFoundAddr = true;
			break;
		}
		freeaddrinfo(pAddrInfoHead);
	}

	// AhXłȂꍇ
	if (addrErrCode || !bFoundAddr) {
		if (pLogger_) {
			pLogger_->LogMessage(0, NULL, (DWORD) addrErrCode, IDS_LOGMES_UDPSENDFAIL);
		}
		return false;
	}

	if (pLogger_) {
		CA2T receiverAddrTmp(inet_ntoa(addr.sin_addr));
		tstring receiverAddr(receiverAddrTmp);
		pLogger_->LogMessage(
			2,
			NULL,
			0,
			IDS_LOGMES_UDPSEND,
			hostName.c_str(), // receiver
			receiverAddr.c_str(), // receiver addr
			senderName.c_str(), // sender name
			localHostName.c_str(), // sender host
			param.c_str() // message
			);
	}

	// bZ[W̍\z
	msgid_++;
	tstring msg = ToString(
		_T("1:%d:%s:%s:%d:%s"),
		msgid_,
		senderName.c_str(),
		localHostName.c_str(),
		0x20, // bZ[WMR}h
		param.c_str() // bZ[W{
		);

	// CR̃TCY߂B
	std::string msgA = convertByteStrWithoutCR(msg);
	int lenMsgA = msgA.length();

	// UDP\Pbg̐
	int sendErrCode = 0;
	SOCKET sock = socket(AF_INET, SOCK_DGRAM, 0);
	if (sock != INVALID_SOCKET) {
		// UDPőM
		int sentLen = sendto(
			sock,
			&msgA[0],
			lenMsgA,
			0,
			(SOCKADDR *) &addr,
			sizeof(addr)
			);
		if (sentLen == SOCKET_ERROR) {
			sendErrCode = WSAGetLastError();
		}
		closesocket(sock);
	}
	else {
		// \Pbg̍\zɎs
		sendErrCode = WSAGetLastError();
	}
	if (sendErrCode) {
		// G[Oɏo͂
		if (pLogger_) {
			pLogger_->LogMessage(0, NULL, (DWORD) addrErrCode, IDS_LOGMES_UDPSENDFAIL);
		}
	}

	return false;
}

/*!
 * bZ[WLFs̃oCgɕϊ܂B
 * \param msg bZ[W
 * \return LFs̃oCg
 */
std::string UDPSendActionInvoker::convertByteStrWithoutCR(const tstring &msg)
{
	if (msg.empty()) {
		return "";
	}

#ifdef _UNICODE
	// bZ[WANSI(SJIS)őMB
	// UNICODESJISɕϊ邽߂ɕKvȃobt@TCY߂B
	int bufsiz = ::WideCharToMultiByte(
		CP_ACP,
		WC_COMPOSITECHECK | WC_DISCARDNS | WC_SEPCHARS | WC_DEFAULTCHAR,
		msg.c_str(),
		-1, // 
		NULL,
		0, // obt@TCYvZw
		NULL,
		NULL
		);
	if ( !bufsiz) {
		// \ʎsɂ胁bZ[WϊłȂB
		if (pLogger_) {
			DWORD err = GetLastError();
			pLogger_->LogMessage(0, NULL, err, IDS_LOGMES_UDPSENDFAIL);
		}
		return false;
	}
#else
	int bufsiz = msg.length() + 1; // I[܂߂obt@TCY
#endif

	// obt@m(SJISp)
	std::vector<CHAR> msgA(bufsiz + 1); // _ukI[ŃK[h

#ifdef _UNICODE
	if (!::WideCharToMultiByte(
		CP_ACP,
		WC_COMPOSITECHECK | WC_DISCARDNS | WC_SEPCHARS | WC_DEFAULTCHAR,
		msg.c_str(),
		-1, // 
		&msgA[0], // obt@
		bufsiz,
		NULL,
		NULL
		)) {
		// \ʎsɂ胁bZ[WϊłȂB
		if (pLogger_) {
			DWORD err = GetLastError();
			pLogger_->LogMessage(0, NULL, err, IDS_LOGMES_UDPSENDFAIL);
		}
		return false;
	}
#else
	memcpy(&msgA[0], msg.c_str(), bufsiz);
#endif

	// CRLFLFɂBCR̂LFȂꍇLFɂB
	// IpMsgłLFsłȂƉsƂ݂ȂȂ߁B
	LPSTR p = &msgA[0];
	LPSTR s = p;
	while (*s) {
		if (*s == '\r') {
			if (*(s + 1) != '\n') {
				*p++ = '\n';
			}
		}
		else {
			*p++ = *s;
		}
		s++;
	}
	*p = 0;

	return std::string(&msgA[0]);
}


