/*
 * Decompiled with CFR 0.152.
 */
package document;

import command.AddOutItemCommand;
import command.Command;
import command.CompositeCommand;
import command.EndCommand;
import command.EvaluateCommand;
import command.GotoCommand;
import command.HttpGetCommand;
import command.SetNextCommand;
import document.AbstractDoc;
import java.net.URI;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;
import main.ContentState;
import main.Debug;
import main.DocError;
import main.DocWarning;
import main.GrammarSet;
import main.StateMap;
import org.w3c.dom.Element;
import outitem.AudioOutItem;
import outitem.BreakOutItem;
import outitem.LogOutItem;
import outitem.NativeOutItem;
import outitem.VoiceOutItem;
import relaxer.vxml20.GramGrammar;
import relaxer.vxml20.GramRule;
import relaxer.vxml20.GramToken;
import relaxer.vxml20.IGramGrammarChoice;
import relaxer.vxml20.IGramRuleMixed;
import relaxer.vxml20.IVxmlChoiceMixed;
import relaxer.vxml20.IVxmlVxmlChoice;
import relaxer.vxml20.RString;
import relaxer.vxml20.RVisitorBase;
import relaxer.vxml20.URVisitor;
import relaxer.vxml20.VxmlAssign;
import relaxer.vxml20.VxmlAudio;
import relaxer.vxml20.VxmlBlock;
import relaxer.vxml20.VxmlBreak;
import relaxer.vxml20.VxmlCONTEXT;
import relaxer.vxml20.VxmlCatch;
import relaxer.vxml20.VxmlChoice;
import relaxer.vxml20.VxmlClear;
import relaxer.vxml20.VxmlDisconnect;
import relaxer.vxml20.VxmlEMPH;
import relaxer.vxml20.VxmlElse;
import relaxer.vxml20.VxmlElseif;
import relaxer.vxml20.VxmlEmotion;
import relaxer.vxml20.VxmlEmphasis;
import relaxer.vxml20.VxmlEnumerate;
import relaxer.vxml20.VxmlError;
import relaxer.vxml20.VxmlExit;
import relaxer.vxml20.VxmlField;
import relaxer.vxml20.VxmlFilled;
import relaxer.vxml20.VxmlForm;
import relaxer.vxml20.VxmlGoto;
import relaxer.vxml20.VxmlHelp;
import relaxer.vxml20.VxmlIf;
import relaxer.vxml20.VxmlInitial;
import relaxer.vxml20.VxmlJVOICE;
import relaxer.vxml20.VxmlLink;
import relaxer.vxml20.VxmlLog;
import relaxer.vxml20.VxmlMark;
import relaxer.vxml20.VxmlMenu;
import relaxer.vxml20.VxmlMeta;
import relaxer.vxml20.VxmlNative;
import relaxer.vxml20.VxmlNoinput;
import relaxer.vxml20.VxmlNomatch;
import relaxer.vxml20.VxmlObject;
import relaxer.vxml20.VxmlOption;
import relaxer.vxml20.VxmlP;
import relaxer.vxml20.VxmlPITCH;
import relaxer.vxml20.VxmlPRON;
import relaxer.vxml20.VxmlParagraph;
import relaxer.vxml20.VxmlParam;
import relaxer.vxml20.VxmlPhoneme;
import relaxer.vxml20.VxmlPrompt;
import relaxer.vxml20.VxmlProperty;
import relaxer.vxml20.VxmlProsody;
import relaxer.vxml20.VxmlRATE;
import relaxer.vxml20.VxmlRecord;
import relaxer.vxml20.VxmlReprompt;
import relaxer.vxml20.VxmlReturn;
import relaxer.vxml20.VxmlS;
import relaxer.vxml20.VxmlSILENCE;
import relaxer.vxml20.VxmlSPELL;
import relaxer.vxml20.VxmlSayAs;
import relaxer.vxml20.VxmlScript;
import relaxer.vxml20.VxmlSentence;
import relaxer.vxml20.VxmlSubmit;
import relaxer.vxml20.VxmlThrow;
import relaxer.vxml20.VxmlTransfer;
import relaxer.vxml20.VxmlVOLUME;
import relaxer.vxml20.VxmlValue;
import relaxer.vxml20.VxmlVar;
import relaxer.vxml20.VxmlVoice;
import relaxer.vxml20.VxmlVxml;
import util.GrammarUtil;
import util.HashArray;
import util.Util;

public class VXMLDoc
implements AbstractDoc {
    private static double promptTimeout_ = 10.0;
    private static double startupWait_ = 10.0;
    private Debug dbg = new Debug("VXMLDoc");
    private String docAddress_ = null;
    private GrammarSet grammarSet_ = null;
    private VxmlVxml vxml_ = null;
    private StateMap stateMap_ = null;
    private Vector docErrors_ = null;
    private Vector docWarnings_ = null;
    private int unique_ = 0;

    private String _getEvalWith(String string, String string2) {
        if (string == null) {
            return "true";
        }
        if (string2.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer("with(");
            stringBuffer.append(string2);
            stringBuffer.append("){");
            stringBuffer.append(string);
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        return string;
    }

    private String _getCSS2TimesAsMsec(String string) {
        String string2 = string;
        if (string.endsWith("ms")) {
            String string3 = string.substring(0, string.length() - 2);
            int n = Float.valueOf(string3).intValue();
            string2 = Integer.toString(n);
        } else if (string.endsWith("s")) {
            String string4 = string.substring(0, string.length() - 1);
            float f = Float.valueOf(string4).floatValue();
            int n = new Float((double)f * 1000.0).intValue();
            string2 = Integer.toString(n);
        }
        return string2;
    }

    private String _getUniqueId() {
        ++this.unique_;
        StringBuffer stringBuffer = new StringBuffer("$").append(this.unique_);
        return stringBuffer.toString();
    }

    public String getDocAddress() {
        return this.docAddress_;
    }

    public void setDocAddress(String string) {
        this.docAddress_ = string;
    }

    public String resolveAdrs(String string) {
        return Util.resolveAdrs(this.docAddress_, string);
    }

    public boolean isInsideDoc(String string) {
        return Util.isSameFile(this.docAddress_, string);
    }

    public String getDialogID(String string) {
        String string2 = "__default__";
        try {
            URI uRI = new URI(string);
            string2 = uRI.getFragment();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private String getFirstDialogID() {
        String string = null;
        this.dbg.print("vxml_:" + this.vxml_);
        int n = this.vxml_.sizeContent();
        this.dbg.print("nContent:" + n, 2);
        for (int i = 0; i < n; ++i) {
            IVxmlVxmlChoice iVxmlVxmlChoice = this.vxml_.getContent(i);
            if (iVxmlVxmlChoice instanceof VxmlForm) {
                VxmlForm vxmlForm = (VxmlForm)iVxmlVxmlChoice;
                string = vxmlForm.getId();
                if (string == null) {
                    vxmlForm.setId("__first_dialog__");
                    string = vxmlForm.getId();
                } else if (string.equals("")) {
                    vxmlForm.setId("__first_dialog__");
                    string = vxmlForm.getId();
                }
                this.dbg.print("firstId:" + string);
                break;
            }
            if (!(iVxmlVxmlChoice instanceof VxmlMenu)) continue;
            VxmlMenu vxmlMenu = (VxmlMenu)iVxmlVxmlChoice;
            string = vxmlMenu.getId();
            if (string == null) {
                vxmlMenu.setId("__first_dialog__");
                string = vxmlMenu.getId();
            } else if (string.equals("")) {
                vxmlMenu.setId("__first_dialog__");
                string = vxmlMenu.getId();
            }
            this.dbg.print("firstId:" + string);
            break;
        }
        return string;
    }

    private String getText(IVxmlChoiceMixed iVxmlChoiceMixed) {
        String string = "";
        if (iVxmlChoiceMixed instanceof RString) {
            RString rString = (RString)iVxmlChoiceMixed;
            string = Util.removeSpaces(rString.getText());
        } else if (iVxmlChoiceMixed instanceof GramGrammar) {
            GramGrammar gramGrammar = (GramGrammar)iVxmlChoiceMixed;
            for (int i = 0; i < gramGrammar.sizeContent(); ++i) {
                IGramGrammarChoice iGramGrammarChoice = gramGrammar.getContent(i);
                if (!(iGramGrammarChoice instanceof GramRule)) continue;
                GramRule gramRule = (GramRule)iGramGrammarChoice;
                for (int j = 0; j < gramRule.sizeContent(); ++j) {
                    IGramRuleMixed iGramRuleMixed = gramRule.getContent(j);
                    if (!(iGramRuleMixed instanceof GramToken)) continue;
                    GramToken gramToken = (GramToken)iGramRuleMixed;
                    string = Util.removeSpaces(gramToken.getContent());
                }
            }
        }
        return string;
    }

    private void _addJulianGrammarToGS(GrammarSet grammarSet, GramGrammar gramGrammar) throws Exception {
        String string = gramGrammar.getSrc();
        String string2 = null;
        string2 = string != null ? string : System.getProperty("GrammarName");
        grammarSet.setJulian(true);
        grammarSet.setJulianGramName(string2);
    }

    private void _addGrammarToGS(GrammarSet grammarSet, GramGrammar gramGrammar) throws Exception {
        String string = gramGrammar.getType();
        if (string == null) {
            string = "application/srgs+xml";
        }
        if (string.equals("application/julian") || string.equals("julian")) {
            this._addJulianGrammarToGS(grammarSet, gramGrammar);
        } else {
            this.dbg.ASSERT(string.equals("application/srgs+xml"), "grammar type error");
            GramGrammar gramGrammar2 = null;
            String string2 = null;
            String string3 = gramGrammar.getSrc();
            if (string3 == null) {
                gramGrammar2 = gramGrammar;
                string2 = this.docAddress_;
            } else {
                string2 = Util.resolveAdrs(this.docAddress_, string3);
                gramGrammar2 = new GramGrammar(string2);
            }
            GrammarUtil.makePhonemeFromSym(gramGrammar2);
            grammarSet.setJulian(false);
            grammarSet.addRules(gramGrammar2, string2);
        }
    }

    private void _addAppInitStates(String string, StateMap stateMap) throws Exception {
        String string2;
        Object object;
        Object object2;
        String string3 = "document = new Object();\ndialog = new Object();\n";
        if (string == null) {
            string3 = string3 + "session = new Object();\napplication = new Object();\n";
        } else {
            string3 = string3 + "var $root = '" + this.docAddress_ + "';\n" + "if ( $current_root == undefined ) {\n" + "  var $current_root;\n" + "}\n" + "if ( $current_root != $root ) {\n" + "  $current_root = $root;\n" + "  session = new Object();\n" + "  application = new Object();\n";
            object2 = this.resolveAdrs(string);
            this.dbg.print("rootVxml:" + (String)object2);
            object = new VxmlVxml((String)object2);
            this.dbg.print("Parsing applicationRoot...", 2);
            int n = ((VxmlVxml)object).sizeContent();
            for (int i = 0; i < n; ++i) {
                String string4;
                String string5;
                Cloneable cloneable;
                IVxmlVxmlChoice iVxmlVxmlChoice = ((VxmlVxml)object).getContent(i);
                if (iVxmlVxmlChoice instanceof VxmlVar) {
                    cloneable = (VxmlVar)iVxmlVxmlChoice;
                    string5 = ((VxmlVar)cloneable).getName();
                    string4 = ((VxmlVar)cloneable).getExpr();
                    String string6 = "  application." + string5 + "=" + string4 + ";\n";
                    string3 = string3 + string6;
                    continue;
                }
                if (!(iVxmlVxmlChoice instanceof VxmlLink)) continue;
                cloneable = (VxmlLink)iVxmlVxmlChoice;
                string5 = ((VxmlLink)cloneable).getNext();
                string4 = Util.resolveAdrs((String)object2, string5);
                this.dbg.print("link next=" + string4);
            }
            string3 = string3 + "}\n";
        }
        object2 = new ContentState();
        object = "@document";
        ((ContentState)object2).setName((String)object);
        if (string3.length() > 0) {
            ((ContentState)object2).addCommand(new EvaluateCommand(string3));
        }
        if ((string2 = this.getFirstDialogID()) == null) {
            throw new DocError("VXML leaf document " + this.docAddress_ + " has no menu or form.");
        }
        stateMap.add((ContentState)object2);
        stateMap.setFirstStateName((String)object);
        stateMap.setNext((String)object, "@" + string2);
        stateMap.addCommand((String)object, new AddOutItemCommand(new BreakOutItem(startupWait_ * 1000.0, false)));
        String string7 = "$prompt_timeout = " + Double.toString(promptTimeout_ * 1000.0);
        stateMap.addCommand((String)object, new EvaluateCommand(string7));
    }

    public VXMLDoc(Element element, String string) throws Exception {
        String string2 = System.getProperty("VXMLDoc.PromptTimeout", "10.0");
        promptTimeout_ = Double.parseDouble(string2);
        string2 = System.getProperty("VXMLDoc.StartupWait", "10.0");
        startupWait_ = Double.parseDouble(string2);
        this.docErrors_ = new Vector();
        this.docWarnings_ = new Vector();
        if (!VxmlVxml.isMatch(element)) {
            throw new DocError("Not a valid <vxml> document.");
        }
        this.vxml_ = new VxmlVxml(element);
        this.grammarSet_ = new GrammarSet();
        this.docAddress_ = string;
        this.stateMap_ = new StateMap();
        this._addAppInitStates(this.vxml_.getApplication(), this.stateMap_);
        Visitor visitor = new Visitor();
        URVisitor.traverse(this.vxml_, visitor);
        if (this.docErrors_.size() > 0) {
            String string3 = "";
            for (int i = 0; i < this.docErrors_.size(); ++i) {
                string3 = string3 + this.docErrors_.get(i).toString() + "\n";
            }
            throw new DocError("Leaf document has following error(s):\n" + string3);
        }
        if (this.docWarnings_.size() > 0) {
            String string4 = "";
            for (int i = 0; i < this.docWarnings_.size(); ++i) {
                System.err.println(element);
            }
        }
        this.stateMap_.setGrammarSet(this.grammarSet_);
    }

    public StateMap getStateMap() {
        return this.stateMap_;
    }

    protected class Visitor
    extends RVisitorBase {
        private Dialog dialog_ = new Dialog();
        private HashArray formItems_ = null;
        private String formVarInitScript_ = null;
        private Stack visitorStack_ = new Stack();
        private Vector promptList_ = null;
        Commands commands_ = new Commands();
        ExecContents execContents_ = new ExecContents();
        TextBuf textBuf_ = new TextBuf();
        private String currPromptCond_ = null;
        private String currPromptCount_ = null;
        private boolean currPromptBargein_ = true;
        private String currPromptBargeintype_ = "speech";
        private String currPromptTimeout_ = null;
        private String currIfCond_ = null;
        private String leaveProsodyTag_ = null;

        protected Visitor() {
        }

        public boolean enter(VxmlVxml vxmlVxml) {
            this.visitorStack_.push(vxmlVxml);
            return true;
        }

        public void leave(VxmlVxml vxmlVxml) {
            this.visitorStack_.pop();
        }

        private void _grammarProcState(String string) {
            String string2 = this.dialog_.getName() + "." + this.dialog_.getItemName();
            String string3 = "@" + this.dialog_.getName() + ".@process";
            String string4 = "@" + string2 + "." + VXMLDoc.this._getUniqueId();
            String string5 = VXMLDoc.this.stateMap_.newState(string4);
            VXMLDoc.this.stateMap_.addTrans("@" + string2, string5, string);
            VXMLDoc.this.stateMap_.addCommand(string5, new EvaluateCommand(string2 + "='" + string + "';\n"));
            VXMLDoc.this.stateMap_.addCommand(string5, new EvaluateCommand(string2 + "$.justfilled = true;\n"));
            VXMLDoc.this.stateMap_.setNext(string5, string3);
        }

        public boolean enter(GramGrammar gramGrammar) {
            try {
                VXMLDoc.this._addGrammarToGS(VXMLDoc.this.grammarSet_, gramGrammar);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.visitorStack_.peek() instanceof VxmlField) {
                for (int i = 0; i < gramGrammar.sizeContent(); ++i) {
                    IGramGrammarChoice iGramGrammarChoice = gramGrammar.getContent(i);
                    if (!(iGramGrammarChoice instanceof GramRule)) continue;
                    GramRule gramRule = (GramRule)iGramGrammarChoice;
                    for (int j = 0; j < gramRule.sizeContent(); ++j) {
                        IGramRuleMixed iGramRuleMixed = gramRule.getContent(j);
                        if (!(iGramRuleMixed instanceof GramToken)) continue;
                        GramToken gramToken = (GramToken)iGramRuleMixed;
                        String string = Util.removeSpaces(gramToken.getContent());
                        this._grammarProcState(string);
                    }
                }
            }
            return true;
        }

        private String _makeFormState() {
            String string = "@" + this.dialog_.getName();
            String string2 = VXMLDoc.this.stateMap_.newState(string);
            VXMLDoc.this.dbg.ASSERT(string2.equals(string), "VxmlForm#leave");
            String string3 = this.dialog_.getName() + " = new Object();\n";
            string3 = string3 + this.dialog_.getName() + ".next$ = undefined;\n";
            string3 = string3 + this.formVarInitScript_;
            VXMLDoc.this.stateMap_.addCommand(string, new EvaluateCommand(string3));
            for (int i = 0; i < this.formItems_.size(); ++i) {
                String string4 = this.formItems_.getKey(i);
                string3 = this.dialog_.getName() + "." + string4 + " = undefined;\n";
                VXMLDoc.this.stateMap_.addScriptCommand(string, string3);
                Object object = this.formItems_.get(i);
                String string5 = this.dialog_.getName() + "." + string4 + "$";
                if (!(object instanceof VxmlField)) continue;
                string3 = string5 + " = new Object();\n";
                string3 = string3 + string5 + ".promptcount = 1;\n";
                string3 = string3 + string5 + ".justfilled = false;\n";
                string3 = string3 + string5 + ".noprompt = false;\n";
                VXMLDoc.this.stateMap_.addScriptCommand(string, string3);
            }
            return string;
        }

        private String _makeFormSelectState() {
            String string;
            int n;
            String string2 = "@" + this.dialog_.getName() + ".@select";
            String string3 = VXMLDoc.this.stateMap_.newState(string2);
            VXMLDoc.this.dbg.ASSERT(string3.equals(string2), "VxmlForm#leave");
            String string4 = "";
            for (n = 0; n < this.formItems_.size(); ++n) {
                string = this.formItems_.getKey(n);
                if (n > 0) {
                    string4 = string4 + "} else ";
                }
                string4 = string4 + "if (" + this.dialog_.getName() + "." + string + " == undefined) {\n";
                string4 = string4 + this.dialog_.getName() + ".next$ = '@" + this.dialog_.getName() + "." + string + "';\n";
            }
            string4 = string4 + "}\n";
            VXMLDoc.this.stateMap_.addCommand(string2, new EvaluateCommand(string4));
            for (n = 0; n < this.formItems_.size(); ++n) {
                string = this.formItems_.getKey(n);
                Object object = this.formItems_.get(n);
                if (!(object instanceof VxmlField)) continue;
                string4 = this.dialog_.getName() + "." + string + "$.justfilled = false;";
                VXMLDoc.this.stateMap_.addCommand(string2, new EvaluateCommand(string4));
            }
            string4 = this.dialog_.getName() + ".next$";
            VXMLDoc.this.stateMap_.addCommand(string2, new SetNextCommand(string4));
            return string2;
        }

        private String _makeFormFilledState() {
            String string = "@" + this.dialog_.getName() + ".@process";
            String string2 = VXMLDoc.this.stateMap_.newState(string);
            VXMLDoc.this.dbg.ASSERT(string2.equals(string), "VxmlForm#leave");
            return string;
        }

        public boolean enter(VxmlForm vxmlForm) {
            this.dialog_.setName(vxmlForm.getId());
            this.formItems_ = new HashArray();
            this.formVarInitScript_ = "";
            this.visitorStack_.push(vxmlForm);
            return true;
        }

        public void leave(VxmlForm vxmlForm) {
            String string = this._makeFormState();
            String string2 = this._makeFormSelectState();
            String string3 = this._makeFormFilledState();
            VXMLDoc.this.stateMap_.setNext(string, string2);
            VXMLDoc.this.stateMap_.setNext(string3, string2);
            this.visitorStack_.pop();
        }

        public boolean enter(VxmlBlock vxmlBlock) {
            if (vxmlBlock.getName() == null) {
                this.dialog_.setItemName(VXMLDoc.this._getUniqueId());
            } else {
                this.dialog_.setItemName(vxmlBlock.getName());
            }
            String string = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            String string2 = VXMLDoc.this.stateMap_.newState(string);
            VXMLDoc.this.dbg.ASSERT(string2.equals(string), "VxmlBlock#enter");
            VXMLDoc.this.stateMap_.addCommand(string, new EvaluateCommand(this.dialog_.getName() + "." + this.dialog_.getItemName() + "= true;\n"));
            this.visitorStack_.push(vxmlBlock);
            this.formItems_.put(this.dialog_.getItemName(), vxmlBlock);
            this.commands_.setupCommands();
            this.execContents_.setupExecContent();
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlBlock vxmlBlock) {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String string = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            this.commands_.flushCommands(string);
            VXMLDoc.this.stateMap_.setNext(string, "@" + this.dialog_.getName() + ".@select");
            this.visitorStack_.pop();
        }

        public boolean enter(VxmlFilled vxmlFilled) {
            String string = "true";
            VXMLDoc.this.dbg.print("VXMLDoc:enter#VxmlFilled peek:" + this.visitorStack_.peek());
            this.commands_.setupCommands();
            if (this.visitorStack_.peek() instanceof VxmlField) {
                String string2 = this.dialog_.getName() + "." + this.dialog_.getItemName() + "$";
                string = string2 + ".justfilled";
            } else {
                string = "with(" + this.dialog_.getName() + "){";
                for (int i = 0; i < this.formItems_.size(); ++i) {
                    String string3 = this.formItems_.getKey(i);
                    if (i > 0) {
                        string = string + " && ";
                    }
                    string = string + string3 + "!=undefined";
                }
                string = string + "}";
            }
            this.execContents_.setupExecContent(string);
            this.textBuf_.setupSpeak();
            this.visitorStack_.push(vxmlFilled);
            return true;
        }

        public void leave(VxmlFilled vxmlFilled) {
            this.visitorStack_.pop();
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String string = "@" + this.dialog_.getName() + ".@process";
            this.commands_.flushCommands(string);
        }

        private void _makeInputEventHandler(String string) {
            String string2 = "@" + this.dialog_.getName() + ".@select";
            String string3 = VXMLDoc.this.stateMap_.newState(string + ".noinput");
            VXMLDoc.this.stateMap_.setNext(string, string3);
            VXMLDoc.this.stateMap_.setNext(string3, string2);
            String string4 = VXMLDoc.this.stateMap_.newState(string + ".nomatch");
            VXMLDoc.this.stateMap_.addTrans(string, string4, "<nomatch>");
            VXMLDoc.this.stateMap_.setNext(string4, string2);
            String string5 = VXMLDoc.this.stateMap_.newState(string + ".help");
            VXMLDoc.this.stateMap_.addTrans(string, string5, "HELP");
            VXMLDoc.this.stateMap_.setNext(string5, string2);
        }

        public boolean enter(VxmlField vxmlField) {
            if (vxmlField.getName() == null) {
                this.dialog_.setItemName(VXMLDoc.this._getUniqueId());
            } else {
                if (this.formItems_.has(vxmlField.getName())) {
                    VXMLDoc.this.docErrors_.add(new DocError("Field name dupulication."));
                    return false;
                }
                this.dialog_.setItemName(vxmlField.getName());
            }
            this.formItems_.put(this.dialog_.getItemName(), vxmlField);
            VXMLDoc.this.dbg.ASSERT(this.dialog_.getItemName() != null, "vxmlForm#enter");
            String string = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            String string2 = VXMLDoc.this.stateMap_.newState(string);
            this._makeInputEventHandler(string2);
            this.promptList_ = new Vector();
            this.visitorStack_.push(vxmlField);
            return true;
        }

        private void _makePromptSelect() {
            int n;
            Prompt prompt;
            int n2;
            String string = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            String string2 = "!" + this.dialog_.getName() + "." + this.dialog_.getItemName() + "$" + ".noprompt";
            CompositeCommand compositeCommand = new CompositeCommand(new Vector(), string2);
            if (this.promptList_ == null) {
                return;
            }
            String string3 = this.dialog_.getName() + "." + this.dialog_.getItemName() + "$";
            String string4 = "";
            for (n2 = 0; n2 < this.promptList_.size(); ++n2) {
                prompt = (Prompt)this.promptList_.get(n2);
                string4 = prompt.cond == null ? string4 + "p" + n2 + " = true;\n" : string4 + "p" + n2 + " = (" + prompt.cond + ");\n";
            }
            compositeCommand.addScriptCommand(string4, string3);
            string4 = "cc = 1;\n";
            for (n2 = 0; n2 < this.promptList_.size(); ++n2) {
                prompt = (Prompt)this.promptList_.get(n2);
                n = prompt.count;
                string4 = string4 + "if(" + n + "<=promptcount && cc<" + n + "){cc=" + n + "};\n";
            }
            compositeCommand.addScriptCommand(string4, string3);
            string4 = "";
            for (n2 = 0; n2 < this.promptList_.size(); ++n2) {
                prompt = (Prompt)this.promptList_.get(n2);
                n = prompt.count;
                string4 = string4 + "if(" + n + "!=cc){p" + n2 + "=false};\n";
            }
            compositeCommand.addScriptCommand(string4, string3);
            string4 = this.dialog_.getName() + "." + this.dialog_.getItemName() + "$" + ".promptcount++;\n";
            compositeCommand.addScriptCommand(string4);
            for (n2 = 0; n2 < this.promptList_.size(); ++n2) {
                Command command;
                prompt = (Prompt)this.promptList_.get(n2);
                String string5 = "with(" + string3 + "){p" + n2 + "}";
                if (prompt.commands.size() == 1 && prompt.commands.get(0) instanceof CompositeCommand) {
                    command = (Command)prompt.commands.get(0);
                    command.setCondition(string5);
                    compositeCommand.addCommand(command);
                    continue;
                }
                command = new CompositeCommand(prompt.commands, string5);
                compositeCommand.addCommand(command);
            }
            VXMLDoc.this.stateMap_.addCommand(string, compositeCommand);
            AddOutItemCommand addOutItemCommand = new AddOutItemCommand(new BreakOutItem("$prompt_timeout", this.currPromptBargein_));
            VXMLDoc.this.stateMap_.addCommand(string, addOutItemCommand);
        }

        public void leave(VxmlField vxmlField) {
            this.visitorStack_.pop();
            this._makePromptSelect();
        }

        public boolean enter(VxmlVar vxmlVar) {
            if (vxmlVar.getName() == null) {
                return false;
            }
            String string = vxmlVar.getName();
            String string2 = "undefined";
            if (vxmlVar.getExpr() != null) {
                string2 = vxmlVar.getExpr();
            }
            if (this.visitorStack_.peek() instanceof VxmlVxml) {
                String string3 = VXMLDoc.this._getEvalWith(string + "=" + string2, "document");
                this.formVarInitScript_ = this.formVarInitScript_ + string3 + ";\n";
            } else if (this.visitorStack_.peek() instanceof VxmlForm) {
                String string4 = VXMLDoc.this._getEvalWith(string + "=" + string2, this.dialog_.getName());
                this.formVarInitScript_ = this.formVarInitScript_ + string4 + ";\n";
            }
            return true;
        }

        public boolean enter(VxmlMenu vxmlMenu) {
            if (vxmlMenu.getId() == null) {
                this.dialog_.setName(VXMLDoc.this._getUniqueId());
            } else {
                this.dialog_.setName(vxmlMenu.getId());
            }
            this.dialog_.setItemName("_menu_");
            String string = "@" + this.dialog_.getName();
            String string2 = VXMLDoc.this.stateMap_.newState(string);
            VXMLDoc.this.dbg.ASSERT(string.equals(string2), "vxmlMenu#enter");
            String string3 = VXMLDoc.this.stateMap_.newState(string2 + ".@select");
            String string4 = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            String string5 = VXMLDoc.this.stateMap_.newState(string4);
            VXMLDoc.this.dbg.ASSERT(string4.equals(string5), "vxmlMenu#enter");
            VXMLDoc.this.stateMap_.setNext(string2, string3);
            VXMLDoc.this.stateMap_.setNext(string3, string5);
            this._makeInputEventHandler(string5);
            this.promptList_ = new Vector();
            this.visitorStack_.push(vxmlMenu);
            return true;
        }

        public void leave(VxmlMenu vxmlMenu) {
            this.visitorStack_.pop();
            String string = "@" + this.dialog_.getName();
            String string2 = string + "." + this.dialog_.getItemName();
            String string3 = this.dialog_.getName() + " = new Object();\n";
            String string4 = this.dialog_.getName() + "._menu_$";
            string3 = string3 + string4 + " = new Object();\n";
            string3 = string3 + string4 + ".promptcount = 1;\n";
            string3 = string3 + string4 + ".noprompt = false;\n";
            VXMLDoc.this.stateMap_.addScriptCommand(string, string3);
            VXMLDoc.this.stateMap_.setNext(string, string2);
            this._makePromptSelect();
        }

        public boolean enter(VxmlChoice vxmlChoice) {
            String string = null;
            String string2 = vxmlChoice.getNext();
            if (string2 == null) {
                VXMLDoc.this.docErrors_.add(new DocError("No next in choice."));
                return false;
            }
            string = Util.removeSpaces(string2);
            String string3 = "";
            String string4 = vxmlChoice.getImage();
            if (string4 != null) {
                string3 = Util.removeSpaces(string4);
                string3 = VXMLDoc.this.resolveAdrs(string3);
                VXMLDoc.this.dbg.ASSERT(string3 != null, "VxmlChoce#enter");
            }
            String string5 = "@" + this.dialog_.getName() + "._menu_";
            for (int i = 0; i < vxmlChoice.sizeContent(); ++i) {
                Object object;
                String string6 = VXMLDoc.this.getText(vxmlChoice.getContent(i));
                VXMLDoc.this.dbg.ASSERT(string6 != null, "VxmlChoce#enter");
                if (string6.length() <= 0) continue;
                if (string.startsWith("#")) {
                    object = "@" + string.substring(1);
                    VXMLDoc.this.stateMap_.addTrans(string5, (String)object, string6);
                    continue;
                }
                if (!string.startsWith("http://")) continue;
                object = null;
                try {
                    object = new HttpGetCommand(new URL(string));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                VXMLDoc.this.stateMap_.addCommand(string5, (Command)object);
            }
            return true;
        }

        public boolean enter(VxmlPrompt vxmlPrompt) {
            if (vxmlPrompt.getBargein() != null && vxmlPrompt.getBargein().equals("false")) {
                this.currPromptBargein_ = false;
            }
            if (vxmlPrompt.getBargeintype() != null) {
                this.currPromptBargeintype_ = vxmlPrompt.getBargeintype();
            }
            if (this.visitorStack_.peek() instanceof VxmlMenu || this.visitorStack_.peek() instanceof VxmlField) {
                this.currPromptCond_ = vxmlPrompt.getCond();
                this.currPromptCount_ = vxmlPrompt.getCount();
                this.commands_.setCommands(new Vector());
                this.execContents_.setupExecContent();
            }
            if (vxmlPrompt.getTimeout() != null) {
                String string = VXMLDoc.this._getCSS2TimesAsMsec(vxmlPrompt.getTimeout());
                String string2 = "$prompt_timeout = " + string;
                this.commands_.appendCommands(new EvaluateCommand(string2));
            }
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlPrompt vxmlPrompt) {
            this.textBuf_.flushSpeak();
            if (this.visitorStack_.peek() instanceof VxmlMenu || this.visitorStack_.peek() instanceof VxmlField) {
                this.execContents_.flushExecContent();
                Prompt prompt = new Prompt();
                prompt.cond = this.currPromptCond_ == null ? "true" : this.currPromptCond_;
                prompt.count = this.currPromptCount_ == null ? 1 : Integer.valueOf(this.currPromptCount_);
                prompt.commands = this.commands_.getCommands();
                this.commands_.clearCommands();
                this.promptList_.add(prompt);
            }
            this.currPromptBargein_ = true;
            this.currPromptBargeintype_ = "speech";
            this.currPromptTimeout_ = null;
        }

        private void _enterNomatch() {
            this.commands_.setupCommands();
            this.execContents_.setupExecContent();
            this.textBuf_.setupSpeak();
            String string = this.dialog_.getName() + "." + this.dialog_.getItemName() + "$";
            this.execContents_.appendExecContent(new EvaluateCommand("noprompt = true;", string));
        }

        public boolean enter(VxmlNomatch vxmlNomatch) {
            this._enterNomatch();
            this.visitorStack_.push(vxmlNomatch);
            return true;
        }

        private void _leaveNomatch() {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String string = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName() + ".nomatch";
            this.commands_.flushCommands(string);
        }

        public void leave(VxmlNomatch vxmlNomatch) {
            this._leaveNomatch();
            this.visitorStack_.pop();
        }

        private void _enterNoinput() {
            this.commands_.setupCommands();
            this.execContents_.setupExecContent();
            this.textBuf_.setupSpeak();
            String string = this.dialog_.getName() + "." + this.dialog_.getItemName() + "$";
            this.execContents_.appendExecContent(new EvaluateCommand("noprompt = true;", string));
        }

        public boolean enter(VxmlNoinput vxmlNoinput) {
            this._enterNoinput();
            this.visitorStack_.push(vxmlNoinput);
            return true;
        }

        private void _leaveNoinput() {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String string = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName() + ".noinput";
            this.commands_.flushCommands(string);
        }

        public void leave(VxmlNoinput vxmlNoinput) {
            this._leaveNoinput();
            this.visitorStack_.pop();
        }

        private void _enterHelp() {
            this.commands_.setupCommands();
            this.execContents_.setupExecContent();
            this.textBuf_.setupSpeak();
            String string = this.dialog_.getName() + "." + this.dialog_.getItemName() + "$";
            this.execContents_.appendExecContent(new EvaluateCommand("noprompt = true;", string));
        }

        public boolean enter(VxmlHelp vxmlHelp) {
            this._enterHelp();
            this.visitorStack_.push(vxmlHelp);
            return true;
        }

        private void _leaveHelp() {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String string = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName() + ".help";
            this.commands_.flushCommands(string);
        }

        public void leave(VxmlHelp vxmlHelp) {
            this._leaveHelp();
            this.visitorStack_.pop();
        }

        public boolean enter(VxmlCatch vxmlCatch) {
            if (vxmlCatch.getEvent() == null) {
                VXMLDoc.this.docErrors_.add(new DocError("No EVENT in <catch>"));
                return false;
            }
            String string = vxmlCatch.getEvent();
            if (string.equals("nomatch")) {
                this._enterNomatch();
            } else if (string.equals("noinput")) {
                this._enterNoinput();
            } else if (string.equals("help")) {
                this._enterHelp();
            } else {
                if (string.equals("error")) {
                    VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <catch event=error>"));
                    return false;
                }
                VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <catch>"));
                return false;
            }
            this.visitorStack_.push(vxmlCatch);
            return true;
        }

        public void leave(VxmlCatch vxmlCatch) {
            if (this.visitorStack_.peek() instanceof VxmlCatch && ((VxmlCatch)this.visitorStack_.peek()).getEvent() != null) {
                String string = ((VxmlCatch)this.visitorStack_.peek()).getEvent();
                if (string.equals("nomatch")) {
                    this._leaveNomatch();
                } else if (string.equals("noinput")) {
                    this._leaveNoinput();
                } else if (string.equals("help")) {
                    this._leaveHelp();
                }
            }
            this.visitorStack_.pop();
        }

        public boolean enter(VxmlReprompt vxmlReprompt) {
            this.textBuf_.flushSpeak();
            String string = this.dialog_.getName() + "." + this.dialog_.getItemName() + "$";
            String string2 = "noprompt = false;\n";
            this.execContents_.appendExecContent(new EvaluateCommand(string2, string));
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(RString rString) {
            String string = rString.getText();
            VXMLDoc.this.dbg.print("RString: " + string);
            this.textBuf_.appendString(string);
            return true;
        }

        public boolean enter(VxmlValue vxmlValue) {
            if (vxmlValue.getExpr() != null) {
                String string = vxmlValue.getExpr();
                this.textBuf_.appendValue("(" + string + ")");
            }
            return true;
        }

        public boolean enter(VxmlGoto vxmlGoto) {
            this.textBuf_.flushSpeak();
            String string = vxmlGoto.getNext();
            if (string == null) {
                VXMLDoc.this.docErrors_.add(new DocError("no next in <goto>"));
                return false;
            }
            String string2 = Util.removeSpaces(string);
            if (string2.startsWith("#")) {
                String string3 = "'@" + string2.substring(1) + "'";
                this.execContents_.appendExecContent(new GotoCommand(string3));
            } else {
                boolean bl = false;
                String string4 = "true";
                String string5 = "'" + string2 + "'";
                EndCommand endCommand = new EndCommand(string5, string4, bl);
                this.execContents_.appendExecContent(endCommand);
            }
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlExit vxmlExit) {
            this.textBuf_.flushSpeak();
            this.execContents_.appendExecContent(new EndCommand(false));
            return true;
        }

        public boolean enter(VxmlAssign vxmlAssign) {
            this.textBuf_.flushSpeak();
            String string = vxmlAssign.getName();
            String string2 = vxmlAssign.getExpr();
            if (string == null || string2 == null) {
                VXMLDoc.this.docErrors_.add(new DocError("<assign> needs NAME and EXPR."));
                return false;
            }
            String string3 = VXMLDoc.this._getEvalWith(string + "=" + string2, this.dialog_.getName());
            this.execContents_.appendExecContent(new EvaluateCommand(string3));
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlScript vxmlScript) {
            this.textBuf_.flushSpeak();
            String string = vxmlScript.getContent();
            String string2 = VXMLDoc.this._getEvalWith(string, this.dialog_.getName());
            this.execContents_.appendExecContent(new EvaluateCommand(string2));
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlIf vxmlIf) {
            this.currIfCond_ = vxmlIf.getCond();
            String string = VXMLDoc.this._getEvalWith(this.currIfCond_, this.dialog_.getName());
            this.execContents_.setupExecContent(string);
            return true;
        }

        public void leave(VxmlIf vxmlIf) {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
        }

        public boolean enter(VxmlElse vxmlElse) {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String string = VXMLDoc.this._getEvalWith("!(" + this.currIfCond_ + ")", this.dialog_.getName());
            this.execContents_.setupExecContent(string);
            return true;
        }

        public boolean enter(VxmlElseif vxmlElseif) {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String string = vxmlElseif.getCond();
            String string2 = VXMLDoc.this._getEvalWith(string, this.dialog_.getName());
            this.currIfCond_ = this.currIfCond_ + " || " + string;
            this.execContents_.setupExecContent(string2);
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlBreak vxmlBreak) {
            String string = vxmlBreak.getTime();
            String string2 = "500";
            if (string != null) {
                string2 = string.equals("large") ? "2000" : (string.equals("medium") ? "500" : (string.equals("small") ? "200" : (string.equals("none") ? "100" : VXMLDoc.this._getCSS2TimesAsMsec(string))));
            }
            this.textBuf_.appendString("<SILENCE MSEC=\"" + string2 + "\"/>");
            return true;
        }

        public boolean enter(VxmlClear vxmlClear) {
            if (vxmlClear.getNamelist() == null) {
                VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <clear/>"));
                return false;
            }
            this.textBuf_.flushSpeak();
            String[] stringArray = vxmlClear.getNamelist().split(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = "undefined";
                String string3 = VXMLDoc.this._getEvalWith(string + "=" + string2, this.dialog_.getName());
                this.execContents_.appendExecContent(new EvaluateCommand(string3));
            }
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlDisconnect vxmlDisconnect) {
            this.textBuf_.flushSpeak();
            this.execContents_.appendExecContent(new EndCommand(true));
            return true;
        }

        public boolean enter(VxmlEmphasis vxmlEmphasis) {
            if (vxmlEmphasis.getLevel() != null) {
                VXMLDoc.this.docWarnings_.add(new DocWarning("Ignored feature: <emphasis level>"));
                return false;
            }
            this.textBuf_.appendString("<EMPH>");
            return true;
        }

        public void leave(VxmlEmphasis vxmlEmphasis) {
            this.textBuf_.appendString("</EMPH>");
        }

        public boolean enter(VxmlEnumerate vxmlEnumerate) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <enumerate>"));
            return false;
        }

        public boolean enter(VxmlError vxmlError) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <error>"));
            return false;
        }

        public boolean enter(VxmlInitial vxmlInitial) {
            if (vxmlInitial.getName() == null) {
                this.dialog_.setItemName(VXMLDoc.this._getUniqueId());
            } else {
                this.dialog_.setItemName(vxmlInitial.getName());
            }
            String string = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            String string2 = VXMLDoc.this.stateMap_.newState(string);
            VXMLDoc.this.dbg.ASSERT(string2.equals(string), "VxmlInitial#enter");
            VXMLDoc.this.stateMap_.addCommand(string, new EvaluateCommand(this.dialog_.getName() + "." + this.dialog_.getItemName() + "= true;\n"));
            this.visitorStack_.push(vxmlInitial);
            this.formItems_.put(this.dialog_.getItemName(), vxmlInitial);
            this.commands_.setupCommands();
            this.execContents_.setupExecContent();
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlInitial vxmlInitial) {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String string = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            this.commands_.flushCommands(string);
            VXMLDoc.this.stateMap_.setNext(string, "@" + this.dialog_.getName() + ".@select");
            this.visitorStack_.pop();
        }

        public boolean enter(VxmlLink vxmlLink) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <link>"));
            return false;
        }

        public boolean enter(VxmlLog vxmlLog) {
            this.textBuf_.flushSpeak();
            this.textBuf_.setupLog();
            String string = vxmlLog.getExpr();
            if (string != null) {
                this.textBuf_.appendValue("(" + string + ")");
            }
            return true;
        }

        public void leave(VxmlLog vxmlLog) {
            this.textBuf_.flushLog();
            this.textBuf_.setupSpeak();
        }

        public boolean enter(VxmlNative vxmlNative) {
            this.textBuf_.flushSpeak();
            this.textBuf_.setupNative();
            String string = vxmlNative.getExpr();
            if (string != null) {
                this.textBuf_.appendValue("(" + string + ")");
            }
            return true;
        }

        public void leave(VxmlNative vxmlNative) {
            this.textBuf_.flushNative();
            this.textBuf_.setupSpeak();
        }

        public boolean enter(VxmlMark vxmlMark) {
            return true;
        }

        public boolean enter(VxmlMeta vxmlMeta) {
            VXMLDoc.this.docWarnings_.add(new DocWarning("Ignored feature: <meta>"));
            return true;
        }

        public boolean enter(VxmlObject vxmlObject) {
            VXMLDoc.this.docWarnings_.add(new DocWarning("Ignored feature: <object>"));
            return true;
        }

        public boolean enter(VxmlOption vxmlOption) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <option>"));
            return false;
        }

        public boolean enter(VxmlParam vxmlParam) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <param>"));
            return false;
        }

        public boolean enter(VxmlPhoneme vxmlPhoneme) {
            this.textBuf_.appendString("<PRON SYM=\"" + vxmlPhoneme.getPh() + "\">");
            return true;
        }

        public void leave(VxmlPhoneme vxmlPhoneme) {
            this.textBuf_.appendString("</PRON>");
        }

        public boolean enter(VxmlProperty vxmlProperty) {
            VXMLDoc.this.docWarnings_.add(new DocWarning("Ignored feature: <property>"));
            return true;
        }

        public boolean enter(VxmlRecord vxmlRecord) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <record>"));
            return false;
        }

        public boolean enter(VxmlReturn vxmlReturn) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <return>"));
            return false;
        }

        public boolean enter(VxmlSayAs vxmlSayAs) {
            VXMLDoc.this.docWarnings_.add(new DocWarning("Ignored feature: <say-as>"));
            return true;
        }

        public boolean enter(VxmlSubmit vxmlSubmit) {
            this.textBuf_.flushSpeak();
            String string = vxmlSubmit.getNext();
            if (string == null) {
                VXMLDoc.this.docErrors_.add(new DocError("No 'next' in <submit>"));
                return false;
            }
            String string2 = vxmlSubmit.getNamelist();
            if (string2 == null) {
                VXMLDoc.this.docErrors_.add(new DocError("No 'namelist' in <submit>"));
                return false;
            }
            String string3 = Util.removeSpaces(string);
            boolean bl = false;
            String string4 = "true";
            String string5 = "'" + string3 + "?'";
            String[] stringArray = string2.split(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    string5 = string5 + "+'&'";
                }
                string5 = string5 + "+'" + stringArray[i] + "='+" + stringArray[i];
            }
            String string6 = VXMLDoc.this._getEvalWith(string5, this.dialog_.getName());
            EndCommand endCommand = new EndCommand(string6, string4, bl);
            this.execContents_.appendExecContent(endCommand);
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlThrow vxmlThrow) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <throw>"));
            return false;
        }

        public boolean enter(VxmlTransfer vxmlTransfer) {
            VXMLDoc.this.docWarnings_.add(new DocWarning("Not supported feature: <transfer>"));
            this.textBuf_.flushSpeak();
            this.execContents_.appendExecContent(new EndCommand(false));
            return true;
        }

        public boolean enter(VxmlVoice vxmlVoice) {
            String string = "male01";
            if (vxmlVoice.getName() != null) {
                string = vxmlVoice.getName();
            } else if (vxmlVoice.getGender() != null) {
                if (vxmlVoice.getGender().equals("male")) {
                    string = "male01";
                } else if (vxmlVoice.getGender().equals("female")) {
                    string = "female01";
                }
            }
            this.textBuf_.appendString("<VOICE OPTIONAL=\"" + string + "\">");
            return true;
        }

        public void leave(VxmlVoice vxmlVoice) {
            this.textBuf_.appendString("</VOICE>");
        }

        public boolean enter(VxmlProsody vxmlProsody) {
            String string = "";
            this.leaveProsodyTag_ = "";
            if (vxmlProsody.getPitch() != null) {
                if (vxmlProsody.getPitch().equals("x-high")) {
                    string = string + "<PITCH LEVEL=\"140\">";
                } else if (vxmlProsody.getPitch().equals("high")) {
                    string = string + "<PITCH LEVEL=\"120\">";
                } else if (vxmlProsody.getPitch().equals("medium")) {
                    string = string + "<PITCH LEVEL=\"100\">";
                } else if (vxmlProsody.getPitch().equals("low")) {
                    string = string + "<PITCH LEVEL=\"80\">";
                } else if (vxmlProsody.getPitch().equals("x-low")) {
                    string = string + "<PITCH LEVEL=\"60\">";
                } else if (vxmlProsody.getPitch().equals("default")) {
                    string = string + "<PITCH LEVEL=\"100\">";
                }
                this.leaveProsodyTag_ = "</PITCH>" + this.leaveProsodyTag_;
            }
            if (vxmlProsody.getRange() != null) {
                if (vxmlProsody.getRange().equals("x-high")) {
                    string = string + "<PITCH RANGE=\"140\">";
                } else if (vxmlProsody.getRange().equals("high")) {
                    string = string + "<PITCH RANGE=\"120\">";
                } else if (vxmlProsody.getRange().equals("medium")) {
                    string = string + "<PITCH RANGE=\"100\">";
                } else if (vxmlProsody.getRange().equals("low")) {
                    string = string + "<PITCH RANGE=\"80\">";
                } else if (vxmlProsody.getRange().equals("x-low")) {
                    string = string + "<PITCH RANGE=\"60\">";
                } else if (vxmlProsody.getRange().equals("default")) {
                    string = string + "<PITCH RANGE=\"100\">";
                }
                this.leaveProsodyTag_ = "</PITCH>" + this.leaveProsodyTag_;
            }
            if (vxmlProsody.getVolume() != null) {
                if (vxmlProsody.getRange().equals("silent")) {
                    string = string + "<VOLUME LEVEL=\"0\">";
                } else if (vxmlProsody.getRange().equals("x-soft")) {
                    string = string + "<VOLUME LEVEL=\"60\">";
                } else if (vxmlProsody.getRange().equals("soft")) {
                    string = string + "<VOLUME LEVEL=\"80\">";
                } else if (vxmlProsody.getRange().equals("medium")) {
                    string = string + "<VOLUME LEVEL=\"100\">";
                } else if (vxmlProsody.getRange().equals("loud")) {
                    string = string + "<VOLUME LEVEL=\"120\">";
                } else if (vxmlProsody.getRange().equals("x-loud")) {
                    string = string + "<VOLUME LEVEL=\"140\">";
                } else if (vxmlProsody.getRange().equals("default")) {
                    string = string + "<VOLUME LEVEL=\"100\">";
                }
                this.leaveProsodyTag_ = "</VOLUME>" + this.leaveProsodyTag_;
            }
            this.textBuf_.appendString(string);
            return true;
        }

        public void leave(VxmlProsody vxmlProsody) {
            VXMLDoc.this.dbg.ASSERT(this.leaveProsodyTag_ != null, "leave VxmlProsody");
            this.textBuf_.appendString(this.leaveProsodyTag_);
            this.leaveProsodyTag_ = null;
        }

        public boolean enter(VxmlP vxmlP) {
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlP vxmlP) {
            this.textBuf_.appendString("<SILENCE MSEC=\"500\"/>");
            this.textBuf_.flushSpeak();
        }

        public boolean enter(VxmlParagraph vxmlParagraph) {
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlParagraph vxmlParagraph) {
            this.textBuf_.appendString("<SILENCE MSEC=\"500\"/>");
            this.textBuf_.flushSpeak();
        }

        public boolean enter(VxmlS vxmlS) {
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlS vxmlS) {
            this.textBuf_.flushSpeak();
        }

        public boolean enter(VxmlSentence vxmlSentence) {
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlSentence vxmlSentence) {
            this.textBuf_.flushSpeak();
        }

        public boolean enter(VxmlEMPH vxmlEMPH) {
            this.textBuf_.appendString("<EMPH>");
            return true;
        }

        public void leave(VxmlEMPH vxmlEMPH) {
            this.textBuf_.appendString("</EMPH>");
        }

        public boolean enter(VxmlSILENCE vxmlSILENCE) {
            this.textBuf_.appendString("<SILENCE MSEC=\"" + vxmlSILENCE.getMSEC() + "\"/>");
            return true;
        }

        public boolean enter(VxmlPRON vxmlPRON) {
            this.textBuf_.appendString("<PRON SYM=\"" + vxmlPRON.getSYM() + "\">");
            return true;
        }

        public void leave(VxmlPRON vxmlPRON) {
            this.textBuf_.appendString("</PRON>");
        }

        public boolean enter(VxmlJVOICE vxmlJVOICE) {
            String string;
            String string2 = vxmlJVOICE.getOPTIONAL();
            if (string2 == null && vxmlJVOICE.getREQUIRED() != null) {
                string2 = vxmlJVOICE.getREQUIRED().equals("FEMALE") || vxmlJVOICE.getREQUIRED().equals("female") ? "female01" : "male01";
            }
            String string3 = "<VOICE";
            if (string2 != null) {
                string3 = string3 + " OPTIONAL=\"" + string2 + "\"";
            }
            if ((string = vxmlJVOICE.getALPHA()) != null) {
                string3 = string3 + " ALPHA=\"" + string + "\"";
            }
            string3 = string3 + ">";
            this.textBuf_.appendString(string3);
            return true;
        }

        public void leave(VxmlJVOICE vxmlJVOICE) {
            this.textBuf_.appendString("</VOICE>");
        }

        public boolean enter(VxmlRATE vxmlRATE) {
            this.textBuf_.appendString("<RATE SPEED=\"" + vxmlRATE.getSPEED() + "\">");
            return true;
        }

        public void leave(VxmlRATE vxmlRATE) {
            this.textBuf_.appendString("</RATE>");
        }

        public boolean enter(VxmlVOLUME vxmlVOLUME) {
            this.textBuf_.appendString("<VOLUME LEVEL=\"" + vxmlVOLUME.getLEVEL() + "\">");
            return true;
        }

        public void leave(VxmlVOLUME vxmlVOLUME) {
            this.textBuf_.appendString("</VOLUME>");
        }

        public boolean enter(VxmlPITCH vxmlPITCH) {
            String string = "";
            if (vxmlPITCH.getLEVEL() != null) {
                string = string + " LEVEL=\"" + vxmlPITCH.getLEVEL() + "\"";
            }
            if (vxmlPITCH.getRANGE() != null) {
                string = string + " RANGE=\"" + vxmlPITCH.getRANGE() + "\"";
            }
            this.textBuf_.appendString("<PITCH" + string + ">");
            return true;
        }

        public void leave(VxmlPITCH vxmlPITCH) {
            this.textBuf_.appendString("</PITCH>");
        }

        public boolean enter(VxmlSPELL vxmlSPELL) {
            this.textBuf_.appendString("<SPELL>");
            return true;
        }

        public void leave(VxmlSPELL vxmlSPELL) {
            this.textBuf_.appendString("</SPELL>");
        }

        public boolean enter(VxmlCONTEXT vxmlCONTEXT) {
            String string = "";
            if (vxmlCONTEXT.getTYPE() != null) {
                string = string + " TYPE=\"" + vxmlCONTEXT.getTYPE() + "\"";
            }
            if (vxmlCONTEXT.getTYPE().equals("NUMBER") && vxmlCONTEXT.getFORMAT() != null) {
                string = string + " FORMAT=\"" + vxmlCONTEXT.getFORMAT() + "\"";
            }
            if (vxmlCONTEXT.getTYPE().equals("DATE")) {
                if (vxmlCONTEXT.getFORMAT() != null) {
                    string = string + " FORMAT=\"" + vxmlCONTEXT.getFORMAT() + "\"";
                }
                if (vxmlCONTEXT.getDELIM() != null) {
                    string = string + " DELIM=\"" + vxmlCONTEXT.getDELIM() + "\"";
                }
            }
            this.textBuf_.appendString("<CONTEXT" + string + ">");
            return true;
        }

        public void leave(VxmlCONTEXT vxmlCONTEXT) {
            this.textBuf_.appendString("</CONTEXT>");
        }

        public boolean enter(VxmlAudio vxmlAudio) {
            this.textBuf_.flushSpeak();
            String string = vxmlAudio.getSrc();
            if (string == null) {
                VXMLDoc.this.docWarnings_.add(new DocWarning("Error: <audio src> missing."));
                return true;
            }
            String string2 = VXMLDoc.this.resolveAdrs(string);
            String string3 = System.getProperty("user.dir") + "/";
            String string4 = Util.resolveAdrs(string3, string2);
            string4 = "'" + string4 + "'";
            this.execContents_.appendExecContent(new AddOutItemCommand(new AudioOutItem(string4, this.currPromptBargein_)));
            return true;
        }

        public void leave(VxmlAudio vxmlAudio) {
            this.textBuf_.setupSpeak();
        }

        public boolean enter(VxmlEmotion vxmlEmotion) {
            this.textBuf_.flushSpeak();
            String string = vxmlEmotion.getType();
            int n = 100;
            int n2 = 0;
            int n3 = 1;
            if (vxmlEmotion.checkPattern()) {
                n = vxmlEmotion.getPattern();
            }
            if (vxmlEmotion.checkValue()) {
                n = vxmlEmotion.getValue();
            }
            if (vxmlEmotion.checkDuration()) {
                n2 = vxmlEmotion.getDuration();
            }
            if (string == null) {
                string = "NEUTRAL";
            }
            if ((string = string.toUpperCase()).equals("SURPRISED")) {
                n /= 2;
            }
            String string2 = "'to @FSM set FaceExp = " + string + " " + n3 + " " + n + " " + n2 + "'";
            NativeOutItem nativeOutItem = new NativeOutItem(string2, this.dialog_.getName());
            this.execContents_.appendExecContent(new AddOutItemCommand(nativeOutItem));
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlEmotion vxmlEmotion) {
            this.textBuf_.flushSpeak();
            String string = "'to @FSM set FaceExp = NEUTRAL'";
            NativeOutItem nativeOutItem = new NativeOutItem(string, this.dialog_.getName());
            this.execContents_.appendExecContent(new AddOutItemCommand(nativeOutItem));
            this.textBuf_.setupSpeak();
        }

        protected class TextBuf {
            private BaseText speakText_ = new SpeakText();
            private BaseText logText_ = new LogText();
            private BaseText nativeText_ = new NativeText();
            private BaseText context_ = this.speakText_;

            protected TextBuf() {
            }

            public void appendString(String string) {
                this.context_.appendString(string);
            }

            public void appendValue(String string) {
                this.context_.appendValue(string);
            }

            public void setupSpeak() {
                this.context_ = this.speakText_;
                this.context_.resetText();
            }

            public void flushSpeak() {
                VXMLDoc.this.dbg.ASSERT(this.context_ instanceof SpeakText, "error");
                StringBuffer stringBuffer = this.context_.getText();
                if (stringBuffer != null) {
                    String string = new String(stringBuffer).trim();
                    if (string.length() > 0) {
                        VoiceOutItem voiceOutItem = new VoiceOutItem(string, Visitor.this.dialog_.getName(), Visitor.this.currPromptBargein_);
                        AddOutItemCommand addOutItemCommand = new AddOutItemCommand(voiceOutItem);
                        Visitor.this.execContents_.appendExecContent(addOutItemCommand);
                    }
                    this.context_.resetText();
                }
            }

            public void setupLog() {
                this.context_ = this.logText_;
                this.context_.resetText();
            }

            public void flushLog() {
                VXMLDoc.this.dbg.ASSERT(this.context_ instanceof LogText, "error flushLog()");
                StringBuffer stringBuffer = this.context_.getText();
                if (stringBuffer != null) {
                    String string = new String(stringBuffer).trim();
                    if (string.length() > 0) {
                        LogOutItem logOutItem = new LogOutItem(string, Visitor.this.dialog_.getName());
                        AddOutItemCommand addOutItemCommand = new AddOutItemCommand(logOutItem);
                        Visitor.this.execContents_.appendExecContent(addOutItemCommand);
                    }
                    this.context_.resetText();
                }
                this.context_ = this.speakText_;
            }

            public void setupNative() {
                this.context_ = this.nativeText_;
                this.context_.resetText();
            }

            public void flushNative() {
                VXMLDoc.this.dbg.ASSERT(this.context_ instanceof NativeText, "error flushNative()");
                StringBuffer stringBuffer = this.context_.getText();
                if (stringBuffer != null) {
                    String string = new String(stringBuffer).trim();
                    if (string.length() > 0) {
                        NativeOutItem nativeOutItem = new NativeOutItem(string, Visitor.this.dialog_.getName());
                        AddOutItemCommand addOutItemCommand = new AddOutItemCommand(nativeOutItem);
                        Visitor.this.execContents_.appendExecContent(addOutItemCommand);
                    }
                    this.context_.resetText();
                }
                this.context_ = this.speakText_;
            }

            private class NativeText
            extends BaseText {
                private NativeText() {
                }
            }

            private class LogText
            extends BaseText {
                private LogText() {
                }

                public void appendString(String string) {
                    String string2 = Util.removeNewLines(string);
                    super.appendString(string2);
                }
            }

            private class SpeakText
            extends BaseText {
                private SpeakText() {
                }

                public void appendString(String string) {
                    String string2 = Util.xmlSafeRemoveSpaces(string);
                    super.appendString(string2);
                }
            }

            private class BaseText {
                private StringBuffer text_ = null;

                private BaseText() {
                }

                public void resetText() {
                    this.text_ = new StringBuffer();
                }

                public StringBuffer getText() {
                    if (this.text_ == null) {
                        this.text_ = new StringBuffer("");
                    }
                    return this.text_;
                }

                public void setText(StringBuffer stringBuffer) {
                    this.text_ = stringBuffer;
                }

                public void appendString(String string) {
                    VXMLDoc.this.dbg.ASSERT(TextBuf.this.context_ != null, "context_ null error");
                    StringBuffer stringBuffer = TextBuf.this.context_.getText();
                    if (stringBuffer != null && string != null && string.length() > 0) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append("+");
                        }
                        stringBuffer.append("'");
                        stringBuffer.append(string);
                        stringBuffer.append("'");
                        TextBuf.this.context_.setText(stringBuffer);
                    }
                }

                public void appendValue(String string) {
                    VXMLDoc.this.dbg.ASSERT(TextBuf.this.context_ != null, "context_ null error");
                    StringBuffer stringBuffer = TextBuf.this.context_.getText();
                    if (stringBuffer != null && string != null && string.length() > 0) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append("+");
                        }
                        stringBuffer.append(string);
                        TextBuf.this.context_.setText(stringBuffer);
                    }
                }
            }
        }

        protected class ExecContents {
            private Stack execContentsStack_ = new Stack();
            private int stackCount_ = 0;

            protected ExecContents() {
            }

            private void setupExecContent(String string) {
                ++this.stackCount_;
                VXMLDoc.this.dbg.print("setupExecContent: " + this.stackCount_ + " " + string);
                Vector vector = new Vector();
                CompositeCommand compositeCommand = new CompositeCommand(vector, string);
                this.execContentsStack_.push(compositeCommand);
            }

            private void setupExecContent() {
                this.setupExecContent("true");
            }

            private void appendExecContent(Command command) {
                CompositeCommand compositeCommand;
                VXMLDoc.this.dbg.print("appendExecContent: " + this.stackCount_ + " " + command);
                if (!this.execContentsStack_.empty() && (compositeCommand = (CompositeCommand)this.execContentsStack_.peek()) != null) {
                    compositeCommand.getCommands().add(command);
                }
            }

            private void flushExecContent() {
                VXMLDoc.this.dbg.print("flushExecContent: " + this.stackCount_);
                --this.stackCount_;
                if (!this.execContentsStack_.empty()) {
                    CompositeCommand compositeCommand = (CompositeCommand)this.execContentsStack_.pop();
                    if (this.execContentsStack_.empty()) {
                        Visitor.this.commands_.appendCommands(compositeCommand);
                    } else {
                        CompositeCommand compositeCommand2 = (CompositeCommand)this.execContentsStack_.peek();
                        compositeCommand2.getCommands().add(compositeCommand);
                    }
                }
            }
        }

        protected class Commands {
            private Vector cmdvec_ = null;

            protected Commands() {
            }

            public void setupCommands() {
                if (this.cmdvec_ == null) {
                    this.cmdvec_ = new Vector();
                }
            }

            public void appendCommands(Command command) {
                VXMLDoc.this.dbg.print("appendCommands:" + command.toString());
                if (this.cmdvec_ != null) {
                    this.cmdvec_.add(command);
                }
            }

            public void flushCommands(String string) {
                if (this.cmdvec_ != null && this.cmdvec_.size() > 0) {
                    VXMLDoc.this.stateMap_.addCommand(string, this.cmdvec_);
                    this.cmdvec_ = null;
                }
            }

            public Vector getCommands() {
                return this.cmdvec_;
            }

            public void setCommands(Vector vector) {
                this.cmdvec_ = vector;
            }

            public void clearCommands() {
                this.cmdvec_ = null;
            }
        }

        protected class Prompt {
            public int count = 1;
            public String cond = null;
            public Vector commands = null;

            protected Prompt() {
            }
        }

        protected class Dialog {
            private String currFormName_ = null;
            private String currFormItemName_ = null;

            protected Dialog() {
            }

            public void setName(String string) {
                this.currFormName_ = string;
            }

            public String getName() {
                return this.currFormName_;
            }

            public void setItemName(String string) {
                this.currFormItemName_ = string;
            }

            public String getItemName() {
                return this.currFormItemName_;
            }
        }
    }
}

