/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import main.Debug;
import main.DeviceEvent;
import main.DeviceListener;
import main.GrammarSet;
import main.InputDevice;
import main.OutputDevice;
import outitem.AudioOutItem;
import outitem.LogOutItem;
import outitem.NativeOutItem;
import outitem.OutItem;
import outitem.VoiceOutItem;
import relaxer.vxml20.IVxmlBlockMixed;
import relaxer.vxml20.RString;
import relaxer.vxml20.VxmlBlock;
import relaxer.vxml20.VxmlForm;
import relaxer.vxml20.VxmlNative;
import relaxer.vxml20.VxmlVxml;
import util.SubProcess;
import util.Util;

public class AMThread
extends Thread
implements OutputDevice,
InputDevice {
    private int srmstate = 30;
    private Debug dbg = new Debug("AMThread", 0);
    private DeviceListener recoglistener_;
    private DeviceListener synthlistener_;
    private SubProcess sp_;
    private String grammar_path = "";
    private boolean showStdErr_ = false;
    private String AMCom_;
    private VxmlBlock initOutputCmd_ = null;
    private VxmlBlock initRecogCmd_ = null;

    private void _loadSubmoduleConfigFile(String string) {
        try {
            VxmlVxml vxmlVxml = new VxmlVxml(string);
            for (int i = 0; i < vxmlVxml.sizeContent(); ++i) {
                if (!(vxmlVxml.getContent(i) instanceof VxmlForm)) continue;
                VxmlForm vxmlForm = (VxmlForm)vxmlVxml.getContent(i);
                if (vxmlForm.getId().equals("initOutput")) {
                    this.dbg.print("AMT: loadSubmoduleConfig: initOutput");
                    this.initOutputCmd_ = (VxmlBlock)vxmlForm.getContent(0);
                    continue;
                }
                if (!vxmlForm.getId().equals("initRecog")) continue;
                this.dbg.print("AMT: loadSubmoduleConfig: initRecog");
                this.initRecogCmd_ = (VxmlBlock)vxmlForm.getContent(0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public AMThread() {
        String string;
        String string2;
        String string3 = System.getProperty("SubmoduleConfigFile");
        if (string3 != null) {
            this._loadSubmoduleConfigFile(string3);
        }
        if ((string2 = System.getProperty("AMThread.ShowStdErr")) != null && string2.equals("1")) {
            this.showStdErr_ = true;
            this.dbg.print("AMT: ShowStdErr = true");
        }
        if ((string = System.getProperty("AMCommand")) == null) {
            Util.halt("AMThread(): Cannot run AM");
        }
        this.dbg.print("AMT: AMCommand = " + string);
        this.AMCom_ = string;
        this.sp_ = new SubProcess(this.AMCom_);
        if (!this.sp_.Run()) {
            Util.halt("AMThread(): Cannot run AM; " + this.AMCom_);
        }
        this.setName("Thread-AM");
        this._initAgent();
        if (this.srmstate == 30) {
            this._initRecog();
            this.srmstate = 20;
        }
        String string4 = System.getProperty("AMThread.StartupWait", "10.0");
        int n = (int)(Double.parseDouble(string4) * 1000.0);
        this.dbg.print("AMT: StartupWait " + n);
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isReady() {
        return this.srmstate != 20;
    }

    public boolean isListening() {
        return this.srmstate == 0;
    }

    private String _getNativeAsString(IVxmlBlockMixed iVxmlBlockMixed) {
        String string = "";
        if (iVxmlBlockMixed instanceof VxmlNative) {
            VxmlNative vxmlNative = (VxmlNative)iVxmlBlockMixed;
            for (int i = 0; i < vxmlNative.sizeContent(); ++i) {
                if (!(vxmlNative.getContent(i) instanceof RString)) continue;
                string = string + ((RString)vxmlNative.getContent(i)).getText();
            }
        }
        return string;
    }

    private void _outputNative(VxmlBlock vxmlBlock) {
        for (int i = 0; i < vxmlBlock.sizeContent(); ++i) {
            String string = this._getNativeAsString(vxmlBlock.getContent(i));
            if (string.length() <= 0) continue;
            this.outputNative(string);
        }
    }

    private void _initAgent() {
        this._outputNative(this.initOutputCmd_);
    }

    private void _initRecog() {
        this._outputNative(this.initRecogCmd_);
    }

    public void setInputListener(DeviceListener deviceListener) {
        this.recoglistener_ = deviceListener;
    }

    public void setOutputListener(DeviceListener deviceListener) {
        this.synthlistener_ = deviceListener;
    }

    public void outputDeviceStart(OutItem outItem) {
        if (outItem instanceof VoiceOutItem) {
            VoiceOutItem voiceOutItem = (VoiceOutItem)outItem;
            this.outputSpeak(voiceOutItem.getArg());
        } else if (outItem instanceof AudioOutItem) {
            AudioOutItem audioOutItem = (AudioOutItem)outItem;
            this.outputAudio(audioOutItem.getArg());
        } else if (outItem instanceof LogOutItem) {
            LogOutItem logOutItem = (LogOutItem)outItem;
            this.outputLog(logOutItem.getArg());
        } else if (outItem instanceof NativeOutItem) {
            NativeOutItem nativeOutItem = (NativeOutItem)outItem;
            this.outputNative(nativeOutItem.getArg());
        }
    }

    public void outputNative(String string) {
        this.dbg.print(string);
        this.sp_.ToStdin(string);
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            this.sp_.ToStdin("to @MON set SysLogText = " + stringArray[i]);
        }
    }

    public void outputSpeak(String string) {
        this.outputNative("to @AM-MCL set Speak = " + string);
    }

    public void outputAudio(String string) {
        this.outputNative("to @SND set Play = " + string);
    }

    public void outputLog(String string) {
        this.outputNative("to @MON set AppLogText = " + string);
    }

    public void outputDeviceStop() {
        this.outputNative("to @AM-MCL set Speak = STOP");
    }

    public void setSpeaker(String string) {
        this.outputNative("to @SSM set Speaker = " + string);
    }

    public synchronized boolean prepareGrammar(GrammarSet grammarSet) {
        this.dbg.print("AMT: prepareGrammar: " + grammarSet);
        if (this.srmstate == 30 || this.srmstate == 20) {
            this.dbg.print("AMT: prepareGrammar: ignored (srmstate" + this.srmstate + ")");
            return false;
        }
        if (grammarSet.getJulian()) {
            String string = grammarSet.getJulianGramName();
            if (string == null) {
                return false;
            }
            this.outputNative("to @SIM set SRM_Julian = " + string);
            this.srmstate = 10;
        } else {
            String string = grammarSet.getSRMGramStr();
            if (string == null) {
                return false;
            }
            this.outputNative("to @SIM set SRM_XML_String = " + string);
            this.srmstate = 10;
        }
        this.dbg.print("AMT: prepareGrammar: waiting for LISTEN");
        return true;
    }

    private synchronized boolean iteration() {
        Matcher matcher;
        Object object;
        Matcher matcher2;
        Object object2;
        Matcher matcher3;
        Object object3;
        Pattern pattern;
        Matcher matcher4;
        Pattern pattern2;
        Pattern pattern3;
        String string;
        if (this.recoglistener_ == null) {
            this.dbg.err("AMThread.run(): recoglistener not set");
            return false;
        }
        if (this.synthlistener_ == null) {
            this.dbg.err("AMThread.run(): synthlistener not set");
            return false;
        }
        String string2 = "";
        while ((string = this.sp_.FromStderrNB()) != "") {
            if (string == null) {
                this.dbg.print("AMT: *** sp_.FromStdoutNB() == null ***", 2);
                return false;
            }
            if (this.showStdErr_) {
                this.dbg.print("AMT: (err) " + string);
            }
            if (!string.startsWith("Error:")) continue;
            return false;
        }
        string = this.sp_.FromStdoutNB();
        if (string == null) {
            this.dbg.print("AMT: *** sp_.FromStdout() == null ***", 2);
            return false;
        }
        if (string.length() > 0) {
            this.dbg.print("AMT: " + string);
        }
        if ((pattern3 = Pattern.compile("From \\@SIM\\s+tell\\s+status\\s+LISTEN$")).matcher(string).matches()) {
            if (this.srmstate == 10) {
                this.dbg.print("AMT: SRM READY");
                this.srmstate = 0;
            }
            if (this.srmstate == 20) {
                this.dbg.print("AMT: SRM default grammar active");
                this.srmstate = 15;
            }
        }
        if ((pattern2 = Pattern.compile("From \\@SIM\\s+tell\\s+status\\s+GRAMMAR_ERROR$")).matcher(string).matches()) {
            Util.halt("GRAMMAR_ERROR");
        }
        if ((matcher4 = (pattern = Pattern.compile("From \\@SIM\\s+tell\\s+status INPUT_START (.*)$")).matcher(string)).matches()) {
            object3 = matcher4.group(1);
            this.dbg.print("AMT:SIM tell status INPUT_START " + (String)object3);
            this.recoglistener_.update(new DeviceEvent(this, DeviceEvent.Type.INPUT, DeviceEvent.State.BUSY, (String)object3));
            this.notify();
        }
        if ((matcher3 = ((Pattern)(object3 = Pattern.compile("From \\@SIM\\s+tell\\s+result\\s+(.*)$"))).matcher(string)).matches()) {
            object2 = matcher3.group(1);
            this.dbg.print("AMT:SIM tell result " + (String)object2);
            this.recoglistener_.update(new DeviceEvent(this, DeviceEvent.Type.INPUT, DeviceEvent.State.READY, (String)object2));
            this.notify();
            this.dbg.print("AMT:SIM tell result done.");
        }
        if ((matcher2 = ((Pattern)(object2 = Pattern.compile("From \\@SSM\\s+rep Speak.stat = (.*)$"))).matcher(string)).matches()) {
            object = matcher2.group(1);
            if (((String)object).equals("IDLE")) {
                this.synthlistener_.update(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.READY, null));
            } else if (((String)object).equals("ERROR")) {
                this.synthlistener_.update(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.READY, null));
            } else if (((String)object).equals("PROCESSING")) {
                this.synthlistener_.update(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.BUSY, null));
            }
        }
        if ((matcher = ((Pattern)(object = Pattern.compile("From \\@SND tell (\\S+) (.*)$"))).matcher(string)).matches()) {
            String string3 = matcher.group(1);
            String string4 = matcher.group(2);
            if (string3.equals("start")) {
                this.synthlistener_.update(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.BUSY, string4));
            } else if (string3.equals("end")) {
                this.synthlistener_.update(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.READY, string4));
            }
        }
        return true;
    }

    public void run() {
        while (this.iteration()) {
            try {
                Thread.sleep(0L, 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void terminate() {
    }
}

