/*
 * Decompiled with CFR 0.152.
 */
package main;

import main.Debug;
import main.DeviceEvent;
import main.DeviceListener;
import main.OutputDevice;
import outitem.BreakOutItem;
import outitem.OutItem;

public class BreakThread
extends Thread
implements OutputDevice {
    private Debug dbg = new Debug(0);
    private DeviceListener listener_;
    private long millis_ = 0L;
    private boolean start_ = false;
    private boolean term_ = false;

    public BreakThread() {
        this.setName("Thread Break");
    }

    public synchronized void outputDeviceStart(OutItem outItem) {
        if (outItem instanceof BreakOutItem) {
            BreakOutItem breakOutItem = (BreakOutItem)outItem;
            this.dbg.print("Break output\n");
            Double d = new Double(breakOutItem.getArgAsDouble() * 1000.0);
            this.millis_ = d.longValue();
            this.start_ = true;
            this.notify();
        }
    }

    public void setOutputListener(DeviceListener deviceListener) {
        this.listener_ = deviceListener;
    }

    public synchronized void outputDeviceStop() {
        this.notify();
    }

    public synchronized void terminate() {
        this.term_ = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        BreakThread breakThread = this;
        synchronized (breakThread) {
            do {
                this.dbg.print("BreakThread wait");
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (!this.start_) continue;
                this.dbg.print("Break Start : " + this.millis_ + " msec");
                this.listener_.update(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.BUSY, null));
                try {
                    this.wait(this.millis_);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.start_ = false;
                this.dbg.print("Break End : " + this.millis_ + " msec");
                this.listener_.update(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.READY, null));
            } while (!this.term_);
        }
        this.dbg.print("BreakThread exitting...");
    }
}

