/*
 * Decompiled with CFR 0.152.
 */
package main;

public class Debug {
    private int debuglevel;

    public Debug(int n) {
        this.debuglevel = n;
    }

    public Debug(String string, int n) {
        String string2 = System.getProperty("Debug." + string);
        this.debuglevel = string2 == null ? n : Integer.parseInt(string2);
    }

    public Debug(String string) {
        String string2 = System.getProperty("Debug." + string);
        this.debuglevel = string2 == null ? 0 : Integer.parseInt(string2);
    }

    public void Debug() {
        this.debuglevel = 0;
    }

    public void setLevel(int n) {
        this.debuglevel = n;
    }

    public int getLevel() {
        return this.debuglevel;
    }

    public void print(String string) {
        if (this.debuglevel != 0) {
            System.out.println(string);
        }
    }

    public void print(String string, int n) {
        if (this.debuglevel >= n) {
            System.out.println(string);
        }
    }

    public void err(String string) {
        if (this.debuglevel != 0) {
            System.err.println(string);
        }
    }

    public void err(String string, int n) {
        if (this.debuglevel >= n) {
            System.err.println(string);
        }
    }

    public void DIE(Exception exception) {
        if (this.debuglevel != 0) {
            System.out.println("DIE:");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void DIE(String string) {
        if (this.debuglevel != 0) {
            System.out.println("DIE: " + string);
            System.exit(1);
        }
    }

    public void ASSERT(boolean bl, String string) {
        if (this.debuglevel != 0 && !bl) {
            System.out.println("ASSERTION FAILED: " + string);
            System.exit(1);
        }
    }

    public void ASSERT(boolean bl, String string, int n) {
        if (this.debuglevel >= n && !bl) {
            System.out.println("ASSERTION FAILED: " + string);
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Debug debug = new Debug(5);
        debug.print("1: this is shown.", 4);
        debug.print("2: this is shown.", 5);
        debug.print("3: not shown.", 6);
        int n = 1;
        int n2 = 2;
        debug.ASSERT(n == n, "4: not shown.");
        debug.ASSERT(n == n2, "5: this is shown.", 4);
        debug.ASSERT(n == n2, "6: not shown.", 5);
        debug.ASSERT(n == n2, "7: not shown.", 6);
    }
}

