/*
 * Decompiled with CFR 0.152.
 */
package main;

import relaxer.vxml20.GramGrammar;
import relaxer.vxml20.GramItem;
import relaxer.vxml20.GramOneOf;
import relaxer.vxml20.GramRule;
import relaxer.vxml20.GramRuleref;
import relaxer.vxml20.GramToken;
import relaxer.vxml20.IGramGrammarChoice;
import util.HashArray;
import util.Util;

public class GrammarSet {
    private boolean isJulian_ = true;
    private String julianGramName_ = null;
    private HashArray rules_ = new HashArray();
    private GramGrammar templateGrammar_ = new GramGrammar();
    private int unique_ = 0;

    private String _getUniqueId() {
        ++this.unique_;
        String string = "g" + this.unique_;
        return string;
    }

    public GrammarSet() {
        String string = System.getProperty("GrammarTemplateFile", "grammar.xml");
        try {
            this.templateGrammar_.setup(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setJulian(boolean bl) {
        this.isJulian_ = bl;
    }

    public boolean getJulian() {
        return this.isJulian_;
    }

    public void setJulianGramName(String string) {
        this.julianGramName_ = string;
    }

    public String getJulianGramName() {
        return this.julianGramName_;
    }

    private String _getTokenContent(GramRule gramRule) {
        String string = "";
        String string2 = "";
        for (int i = 0; i < gramRule.sizeContent(); ++i) {
            if (!(gramRule.getContent(i) instanceof GramToken)) continue;
            string = string + ((GramToken)gramRule.getContent(i)).getPhoneme();
            string2 = string2 + ((GramToken)gramRule.getContent(i)).getContent();
        }
        return string + "/" + string2;
    }

    private boolean _sameRuleExists(String string) {
        for (int i = 0; i < this.rules_.size(); ++i) {
            String string2 = this._getTokenContent((GramRule)this.rules_.get(i));
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private void _addJulianRules(GramRule gramRule, String string) {
        String string2 = this._getTokenContent(gramRule);
        if (!this._sameRuleExists(string2)) {
            this.rules_.put(string, gramRule);
        }
    }

    private boolean _isSingleTokenRule(GramRule gramRule) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < gramRule.sizeContent(); ++i) {
            if (gramRule.getContent(i) instanceof GramToken) {
                ++n;
                continue;
            }
            if (gramRule.getContent(i) instanceof GramItem) {
                ++n2;
                continue;
            }
            if (gramRule.getContent(i) instanceof GramOneOf) {
                ++n2;
                continue;
            }
            if (!(gramRule.getContent(i) instanceof GramRuleref)) continue;
            ++n2;
        }
        return n == 1 && n2 == 0;
    }

    private void _addRegularRules(GramRule gramRule, String string) {
    }

    public void addRules(GramGrammar gramGrammar, String string) {
        if (gramGrammar == null) {
            return;
        }
        if (string == null) {
            string = "";
        }
        String string2 = gramGrammar.getRoot();
        int n = gramGrammar.sizeContent();
        for (int i = 0; i < n; ++i) {
            String string3;
            IGramGrammarChoice iGramGrammarChoice = gramGrammar.getContent(i);
            if (!(iGramGrammarChoice instanceof GramRule)) continue;
            GramRule gramRule = (GramRule)iGramGrammarChoice;
            boolean bl = true;
            if (string2 != null && gramRule.getId() != null && !gramRule.getId().equals(string2)) {
                bl = false;
            }
            if ((string3 = gramRule.getId()) == null) {
                string3 = this._getUniqueId();
                gramRule.setId(string3);
            }
            if (string3.matches("[A-Z_]+")) {
                bl = false;
            }
            if (!bl) continue;
            String string4 = string + ":" + string3;
            if (this._isSingleTokenRule(gramRule)) {
                this._addJulianRules(gramRule, string4);
                continue;
            }
            this._addRegularRules(gramRule, string4);
        }
    }

    private void _addRuleref(GramRule gramRule, String string) {
        GramRuleref gramRuleref = new GramRuleref();
        gramRuleref.setUri(string);
        gramRule.addContent(gramRuleref);
    }

    public String getSRMGramStr() {
        IGramGrammarChoice iGramGrammarChoice;
        int n;
        String string = "";
        GramGrammar gramGrammar = new GramGrammar();
        gramGrammar.setVersion("1.0");
        for (n = 0; n < this.templateGrammar_.sizeContent(); ++n) {
            iGramGrammarChoice = this.templateGrammar_.getContent(n);
            if (!(iGramGrammarChoice instanceof GramRule)) continue;
            gramGrammar.addContent((GramRule)iGramGrammarChoice);
        }
        for (n = 0; n < this.rules_.size(); ++n) {
            iGramGrammarChoice = (GramRule)this.rules_.get(n);
            gramGrammar.addContent(iGramGrammarChoice);
            String string2 = ((GramRule)iGramGrammarChoice).getId();
            GramRule gramRule = new GramRule();
            gramRule.setId("SENTENCE");
            this._addRuleref(gramRule, string2);
            gramGrammar.addContent(gramRule);
        }
        string = Util.removeNewLines(gramGrammar.makeTextDocument());
        string = string.replaceAll(" xmlns=\"[^\"]*\"", "");
        return string;
    }

    public String getRulesAsString() {
        String string = "";
        if (this.isJulian_) {
            string = this.julianGramName_ == null ? "<julian name=\"\" />" : "<julian name=\"" + this.julianGramName_ + "\" />";
        } else {
            GramGrammar gramGrammar = new GramGrammar();
            gramGrammar.setVersion("1.0");
            for (int i = 0; i < this.rules_.size(); ++i) {
                GramRule gramRule = (GramRule)this.rules_.get(i);
                gramGrammar.addContent(gramRule);
            }
            string = Util.removeNewLines(gramGrammar.makeTextDocument());
            string = string.replaceFirst(" xmlns=\"[^\"]*\"", "");
            string = string.replaceAll("<rule ", "\n<rule ");
            string = string.replaceAll("</grammar>", "\n</grammar>");
            string = string.replaceAll("> <", "><");
        }
        return string;
    }

    public String getRuleNames() {
        String string = "";
        for (int i = 0; i < this.rules_.size(); ++i) {
            GramRule gramRule = (GramRule)this.rules_.get(i);
            string = string + gramRule.getId() + ";";
        }
        return string;
    }

    public String toString() {
        String string = this.isJulian_ ? "julian:" + this.julianGramName_ : "srgs:" + this.getRuleNames();
        return string;
    }
}

