/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import main.CachedFile;
import main.FetchThread;
import main.HttpManagerListener;

public class HttpManager {
    private Map cacheMap_ = new HashMap(100);
    private Map fetchingMap_ = new HashMap(10);
    private static HttpManager httpm_;

    private HttpManager() {
    }

    public static HttpManager getInstance() {
        if (httpm_ == null) {
            httpm_ = new HttpManager();
        }
        return httpm_;
    }

    public synchronized void store(URL uRL, String string, File file) {
        System.out.println("Stored file: " + uRL + " " + file.getPath());
        this.cacheMap_.put(uRL, new CachedFile(uRL, string, file));
        this.fetchingMap_.remove(uRL);
    }

    public synchronized boolean isCached(URL uRL) {
        return this.cacheMap_.containsKey(uRL);
    }

    public synchronized void purge(URL uRL) {
        File file;
        if (this.cacheMap_.containsKey(uRL) && (file = ((CachedFile)this.cacheMap_.remove(uRL)).getFile()).isFile()) {
            file.delete();
        }
    }

    public synchronized File getFile(URL uRL) {
        CachedFile cachedFile = (CachedFile)this.cacheMap_.get(uRL);
        if (cachedFile != null) {
            return cachedFile.getFile();
        }
        return null;
    }

    public synchronized String getFileName(URL uRL) {
        CachedFile cachedFile = (CachedFile)this.cacheMap_.get(uRL);
        if (cachedFile != null) {
            return cachedFile.getFile().getPath();
        }
        return null;
    }

    public synchronized String getContentType(URL uRL) {
        CachedFile cachedFile = (CachedFile)this.cacheMap_.get(uRL);
        if (cachedFile != null) {
            return cachedFile.getContentType();
        }
        return null;
    }

    public synchronized void fetchStart(URL uRL, HttpManagerListener httpManagerListener) {
        FetchThread fetchThread = new FetchThread(uRL, this, httpManagerListener);
        this.fetchingMap_.put(uRL, fetchThread);
        Thread thread = new Thread(fetchThread);
        thread.start();
    }

    public synchronized void maskEvent(URL uRL) {
        FetchThread fetchThread = (FetchThread)this.fetchingMap_.get(uRL);
        if (fetchThread != null) {
            fetchThread.maskEvent();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            URL uRL = new URL(stringArray[0]);
            FetchThread fetchThread = new FetchThread(uRL);
            Thread thread = new Thread(fetchThread);
            thread.start();
            thread.join();
            System.in.read();
        } else {
            System.out.println("No arg");
        }
    }
}

