/*
 * Decompiled with CFR 0.152.
 */
package main;

import command.Command;
import java.net.URL;
import java.util.Vector;
import main.Debug;
import main.DocError;
import main.DocLoader;
import main.HttpManager;
import main.HttpManagerEvent;
import main.HttpManagerListener;
import main.InterpreterContextManager;
import main.MMMEvent;
import main.MMMListener;
import main.MultiModalManager;
import main.OutQueueManager;
import outitem.OutItem;
import scripting.ECMAScript;
import util.SubProcess;
import util.Util;

public class InteractionControler
implements MMMListener,
HttpManagerListener {
    private Debug dbg = new Debug("IC", 0);
    private InterpreterContextManager icm_;
    private MultiModalManager mmm_;
    private OutQueueManager oqm_;
    private HttpManager httpm_;
    private ECMAScript script_ = null;
    private URL fetchingURL_;
    private boolean reservefetch_ = false;
    private boolean fetching_ = false;
    private boolean endflag_ = false;
    private boolean endimm_ = false;
    private boolean nextout_ = false;
    private boolean nextcmd_ = true;
    private boolean inputbusy_ = false;
    private Vector commands_ = null;
    private String nextDocFile_ = "";

    public void setNextDocFile(String string) {
        this.nextDocFile_ = string;
    }

    public String getNextDocFile() {
        if (this.nextDocFile_ == null) {
            return "";
        }
        return this.nextDocFile_;
    }

    public InteractionControler() throws Exception {
        this.dbg.print("IC: constructor begin.");
        this.icm_ = new InterpreterContextManager();
        this.mmm_ = new MultiModalManager();
        this.oqm_ = new OutQueueManager();
        this.httpm_ = HttpManager.getInstance();
        this.mmm_.setListener(this);
        this.dbg.print("IC: constructor done.");
    }

    public void loadDocument(String string) throws Exception {
        DocLoader docLoader = new DocLoader(string, string);
        this.icm_.setDocument(docLoader);
        this.mmm_.prepareGrammar(this.icm_.getGrammarSet());
        this.endflag_ = false;
        this.endimm_ = false;
        this.nextout_ = false;
        this.nextcmd_ = true;
        this.inputbusy_ = false;
        this.commands_ = null;
        this.nextDocFile_ = "";
    }

    private synchronized void waitWhileInputBusy() {
        this.dbg.print("IC: waitWhileInputBusy: begin.");
        while (this.inputbusy_) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.dbg.print("IC: waitWhileInputBusy: done.");
    }

    private void executeAllCommands() {
        while (!this.commands_.isEmpty()) {
            Command command = (Command)this.commands_.remove(0);
            String string = command.toString();
            if ((string = Util.removeNewLines(string)).length() > 40) {
                string = string.substring(0, 40) + "...";
            }
            this.dbg.print("IC: cmd:" + string);
            command.execute(this);
        }
    }

    private boolean outputItems() {
        boolean bl = false;
        while (this.nextout_) {
            this.dbg.print("IC: outputItems: begin.");
            OutItem outItem = this.oqm_.dequeue();
            if (outItem != null) {
                String string = outItem.getClass().getName();
                this.nextout_ = this.mmm_.output(outItem);
                this.dbg.print("IC: outputItems: " + string + " done. nextout=" + this.nextout_);
                if (this.nextout_) continue;
                this.dbg.print("IC: outputItems: output_something = true");
                bl = true;
                continue;
            }
            if (this.reservefetch_) {
                this.reservefetch_ = false;
                this.fetchstart();
            } else {
                this.icm_.noinput();
            }
            this.nextout_ = false;
            this.nextcmd_ = true;
        }
        return bl;
    }

    private synchronized void waitOutputEndEvent() {
        this.dbg.print("IC: waitOutputEndEvent: begin.");
        try {
            this.wait();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.dbg.print("IC: waitOutputEndEvent: done.");
    }

    private boolean iteration() {
        boolean bl = false;
        do {
            this.waitWhileInputBusy();
            if (this.nextcmd_ && !this.endflag_) {
                this.nextcmd_ = false;
                this.commands_ = this.icm_.getCmd();
                this.dbg.print("IC: iteration: icm.getCmd done.");
                this.executeAllCommands();
            }
            this.dbg.print("IC: endflag:" + this.endflag_ + " endimm:" + this.endimm_ + " nextcmd:" + this.nextcmd_ + " nextout:" + this.nextout_ + " inputbusy:" + this.inputbusy_);
            if (this.endflag_ && (this.endimm_ || !this.nextout_)) {
                this.commands_.removeAllElements();
                this.oqm_.discard();
                this.dbg.print("IC: iteration done.");
                return false;
            }
            bl = this.outputItems();
        } while (this.nextcmd_);
        if (bl) {
            this.waitOutputEndEvent();
        } else {
            this.icm_.noinput();
            this.dbg.print("IC: iteration: icm.noinput done. inputbusy = false.");
            this.inputbusy_ = false;
            this.nextcmd_ = true;
        }
        return true;
    }

    public void mainLoop() {
        while (this.iteration()) {
        }
        this.dbg.print("IC: mainLoop done.");
    }

    private void _finalize() {
        String string = System.getProperty("FinCommand");
        if (string != null) {
            SubProcess subProcess = new SubProcess(string);
            if (!subProcess.Run()) {
                System.err.println("Cannot run fin.");
            }
            subProcess.destroy();
        }
    }

    public void terminate() {
        this.mmm_.terminate();
        ECMAScript.doExit();
        this._finalize();
    }

    public synchronized void updateHTTPMStatus(HttpManagerEvent httpManagerEvent) {
        this.dbg.print("IC: HTTPManager event");
        this.fetching_ = false;
        this.fetchingURL_ = null;
        this.mmm_.stop();
        this.nextcmd_ = true;
        String string = httpManagerEvent.getUrl().toString();
        try {
            this.icm_.newDocument(httpManagerEvent.getUrl().toString(), string);
        }
        catch (DocError docError) {
            System.err.println();
            System.err.println(docError);
            System.err.println("IC: stopped.");
            docError.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.notifyAll();
    }

    public synchronized void updateMMMStatus(MMMEvent mMMEvent) {
        MMMEvent.Type type = mMMEvent.getEventType();
        String string = Thread.currentThread().getName();
        if (type == MMMEvent.Type.INPUT_END) {
            String string2 = mMMEvent.getString();
            this.dbg.print("IC: update: INPUT_END event " + string2 + " from " + string);
            if (!this.inputbusy_) {
                this.dbg.print("IC: update: ignored (because inputbusy == false)");
                return;
            }
            if (this.fetching_) {
                this.httpm_.maskEvent(this.fetchingURL_);
                this.fetchingURL_ = null;
                this.fetching_ = false;
            }
            this.dbg.print("IC: update: icm.inputText " + string2);
            this.icm_.inputText(string2);
            String string3 = Thread.currentThread().getName();
            if (string3.equals("main")) {
                OutItem outItem;
                while ((outItem = this.oqm_.dequeue()) != null) {
                    if (!outItem.isInstant()) continue;
                    this.mmm_.outputNow(outItem);
                }
                this.dbg.print("IC: update: inputbusy = false");
                this.nextcmd_ = true;
            } else {
                this.oqm_.removeDelayedItems();
            }
            this.inputbusy_ = false;
            this.notifyAll();
        } else if (type == MMMEvent.Type.INPUT_START) {
            this.dbg.print("IC: update: INPUT_START event from " + string);
            this.dbg.print("IC: update: mmm.stop");
            this.mmm_.stop();
            this.dbg.print("IC: update: inputbusy = true");
            this.inputbusy_ = true;
        } else if (type == MMMEvent.Type.OUTPUT_END) {
            this.dbg.print("IC: update: OUTPUT_END event from " + string);
            this.nextout_ = true;
            this.notifyAll();
        }
    }

    public void enqueueOutput(OutItem outItem) {
        this.oqm_.enqueue(outItem);
    }

    public void setNextOut(boolean bl) {
        this.nextout_ = bl;
    }

    public void setEndFlag(boolean bl) {
        this.dbg.print("IC: setEndFlag " + bl);
        this.endflag_ = bl;
    }

    public void setEndImm(boolean bl) {
        this.dbg.print("IC: setEndImm " + bl);
        this.endimm_ = bl;
    }

    public void setFetchingURL(URL uRL) {
        this.fetchingURL_ = uRL;
    }

    public void setReserveFetch(boolean bl) {
        this.reservefetch_ = bl;
    }

    public synchronized int getNumCommands() {
        if (this.commands_ == null) {
            return 0;
        }
        return this.commands_.size();
    }

    public synchronized void insertCommandsTop(Vector vector) {
        if (this.commands_ == null) {
            return;
        }
        this.commands_.addAll(0, vector);
    }

    public void fetchstart() {
        if (this.httpm_.isCached(this.fetchingURL_)) {
            String string = this.fetchingURL_.toString();
            try {
                this.icm_.newDocument(this.fetchingURL_.toString(), string);
            }
            catch (DocError docError) {
                System.err.println();
                System.err.println(docError);
                System.err.println("IntractionControler stopped.");
                docError.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.fetchingURL_ = null;
        } else {
            this.fetching_ = true;
            this.httpm_.fetchStart(this.fetchingURL_, this);
        }
    }

    public void setNextState(String string) {
        this.dbg.print("IC: next: " + string);
        this.icm_.setNextState(string);
    }

    public void gotoState(String string) {
        this.dbg.print("IC: goto: " + string);
        this.icm_.setNextState(string);
        this.commands_.removeAllElements();
    }
}

