/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Vector;
import main.AMThread;
import main.BreakThread;
import main.Debug;
import main.DeviceEvent;
import main.DeviceListener;
import main.GrammarSet;
import main.InputDevice;
import main.MMMEvent;
import main.MMMListener;
import main.OutputDevices;
import outitem.OutItem;

public class MultiModalManager
implements DeviceListener {
    private Debug dbg = new Debug("MMM", 0);
    private OutputDevices odevs_;
    private Vector idevs_;
    private MMMListener mmml_;
    private OutItem currOutItem_;
    private boolean nowOutput_ = false;
    private AMThread amt_;
    private GrammarSet gs_ = new GrammarSet();

    public MultiModalManager() {
        this.amt_ = new AMThread();
        this.amt_.setOutputListener(this);
        this.amt_.setInputListener(this);
        this.amt_.start();
        BreakThread breakThread = new BreakThread();
        breakThread.setOutputListener(this);
        breakThread.start();
        this.odevs_ = new OutputDevices();
        this.odevs_.addDevice(breakThread, OutputDevices.Type.BREAK);
        this.odevs_.addDevice(this.amt_, OutputDevices.Type.VOICE);
        this.odevs_.addDevice(this.amt_, OutputDevices.Type.AUDIO);
        this.odevs_.addDevice(this.amt_, OutputDevices.Type.LOG);
        this.odevs_.addDevice(this.amt_, OutputDevices.Type.NATIVE);
        this.idevs_ = new Vector();
        this.idevs_.add(this.amt_);
        this.idevs_.trimToSize();
        while (!this.amt_.isReady()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public synchronized void terminate() {
        this.dbg.print("MMM Terminate");
        while (!this.idevs_.isEmpty()) {
            ((InputDevice)this.idevs_.remove(0)).terminate();
        }
        this.odevs_.terminate(OutputDevices.Type.BREAK);
        this.amt_.terminate();
    }

    public void prepareGrammar(GrammarSet grammarSet) {
        this.dbg.print("MMM: AMT.prepareGrammar");
        if (this.amt_.prepareGrammar(grammarSet)) {
            while (!this.amt_.isListening()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public synchronized void outputNow(OutItem outItem) {
        outItem.doOutput(this.odevs_);
    }

    public synchronized boolean output(OutItem outItem) {
        this.dbg.print("MMM: output start: " + Thread.currentThread().getName());
        this.dbg.ASSERT(Thread.currentThread().getName().equals("main"), "bad thread");
        this.dbg.print(outItem.toString() + " isInstant=" + outItem.isInstant());
        if (outItem.isInstant()) {
            this.outputNow(outItem);
            this.dbg.print("MMM: output done: " + Thread.currentThread().getName());
            return true;
        }
        this.currOutItem_ = outItem;
        this.currOutItem_.doOutput(this.odevs_);
        while (!this.nowOutput_) {
            this.dbg.print("MMM: output : outStart wait");
            try {
                this.wait(5000L);
                this.nowOutput_ = false;
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.dbg.print("MMM: output : outStart wait end...");
            }
        }
        this.dbg.print("MMM: output : " + Thread.currentThread().getName());
        return false;
    }

    public synchronized void stop() {
        if (this.currOutItem_ != null) {
            this.dbg.print("MMM.stop()");
            this.currOutItem_.stop(this.odevs_);
        }
    }

    public synchronized void updateInput(DeviceEvent deviceEvent) {
        DeviceEvent.State state = deviceEvent.getState();
        boolean bl = false;
        if (this.currOutItem_ != null) {
            bl = this.currOutItem_.canInput();
        }
        this.dbg.print("MMM : currOutItem=" + this.currOutItem_ + " caninput=" + bl);
        if (bl) {
            if (state == DeviceEvent.State.BUSY) {
                this.mmml_.updateMMMStatus(new MMMEvent(MMMEvent.Type.INPUT_START));
            } else if (state == DeviceEvent.State.READY) {
                String string = deviceEvent.getString();
                while (this.nowOutput_) {
                    this.dbg.print("---- MMM.update : outEnd wait");
                    try {
                        this.wait(5000L);
                        this.nowOutput_ = false;
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.dbg.print("---- MMM.output : outEnd wait end...");
                    }
                }
                if (string != null && !string.equals("")) {
                    this.mmml_.updateMMMStatus(new MMMEvent(MMMEvent.Type.INPUT_END, string));
                } else {
                    this.mmml_.updateMMMStatus(new MMMEvent(MMMEvent.Type.INPUT_END));
                }
            }
        }
    }

    public synchronized void updateOutput(DeviceEvent deviceEvent) {
        DeviceEvent.State state = deviceEvent.getState();
        if (state == DeviceEvent.State.READY) {
            if (this.currOutItem_.isLoop()) {
                this.output(this.currOutItem_);
            } else {
                this.nowOutput_ = false;
                this.mmml_.updateMMMStatus(new MMMEvent(MMMEvent.Type.OUTPUT_END));
                this.notify();
            }
        } else {
            this.nowOutput_ = true;
            this.notify();
        }
    }

    public void update(DeviceEvent deviceEvent) {
        DeviceEvent.Type type = deviceEvent.getDeviceType();
        DeviceEvent.State state = deviceEvent.getState();
        this.dbg.print("::::::::::: MMM : INPUT EVENT");
        this.dbg.print("   " + type.toString());
        this.dbg.print("   " + state.toString());
        this.dbg.print("   String = " + deviceEvent.getString());
        this.dbg.print(":::::::::::::::::::::::::::::");
        this.dbg.print("---- MMM.update");
        if (this.mmml_ != null) {
            if (type == DeviceEvent.Type.INPUT) {
                this.updateInput(deviceEvent);
            } else if (type == DeviceEvent.Type.OUTPUT) {
                this.updateOutput(deviceEvent);
            }
        }
    }

    public void setListener(MMMListener mMMListener) {
        this.mmml_ = mMMListener;
    }
}

