/*
 * Decompiled with CFR 0.152.
 */
package main;

import command.Command;
import command.CompositeCommand;
import command.EvaluateCommand;
import command.SetNextCommand;
import java.util.HashMap;
import java.util.Vector;
import main.ContentState;
import main.Debug;
import main.GrammarSet;

public class StateMap {
    public static final String PDOC_ENCODING = "euc-jp";
    private static float PDOC_VERSION = 0.6f;
    private Debug dbg = new Debug("StateMap");
    private float pdocVersion_ = 0.0f;
    private HashMap hashMap_ = new HashMap();
    private String firstStateName_ = null;
    private Vector states_ = new Vector();
    private GrammarSet grammarSet_ = null;

    public void setPdocVersion(float f) {
        this.pdocVersion_ = f;
    }

    public StateMap() {
        this.setPdocVersion(PDOC_VERSION);
    }

    public ContentState put(String string, ContentState contentState) {
        this.states_.add(string);
        ContentState contentState2 = this.hashMap_.put(string, contentState);
        this.dbg.ASSERT(contentState2 == null, "put with no override");
        return contentState2;
    }

    public ContentState get(String string) {
        this.dbg.print("using StateMap.get(" + string + ")");
        ContentState contentState = (ContentState)this.hashMap_.get(string);
        return contentState;
    }

    public boolean has(String string) {
        ContentState contentState = (ContentState)this.hashMap_.get(string);
        return contentState != null;
    }

    public String newState(String string) {
        String string2 = string;
        ContentState contentState = (ContentState)this.hashMap_.get(string2);
        if (contentState != null) {
            return string;
        }
        this.dbg.ASSERT(contentState == null, "newState()");
        contentState = new ContentState();
        contentState.setName(string2);
        contentState.setExecOnly(false);
        this.dbg.print("newState:" + string2);
        this.put(string2, contentState);
        return string2;
    }

    public void addCommand(String string, Command command) {
        Object object;
        ContentState contentState = this.get(string);
        if (contentState == null) {
            object = this.newState(string);
            contentState = this.get((String)object);
            this.dbg.ASSERT(string.equals(object), "addCommand()");
        }
        this.dbg.ASSERT(contentState != null, "addCommand()");
        if (command != null) {
            if (command instanceof CompositeCommand && !command.hasCondition()) {
                object = ((CompositeCommand)command).getCommands();
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    contentState.addCommand((Command)((Vector)object).get(i));
                }
            } else {
                contentState.addCommand(command);
            }
        }
    }

    public void addCommand(String string, Vector vector) {
        ContentState contentState = this.get(string);
        this.dbg.ASSERT(contentState != null, "addCommand()");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.addCommand(string, (Command)vector.get(i));
            }
        }
    }

    public void addCommandOnTop(String string, Command command) {
        ContentState contentState = this.get(string);
        this.dbg.ASSERT(contentState != null, "addCommandOnTop()");
        contentState.addCommandOnTop(command);
    }

    public void addScriptCommand(String string, String string2) {
        this.addCommand(string, new EvaluateCommand(string2));
    }

    public void addScriptCommand(String string, String string2, String string3) {
        this.addCommand(string, new EvaluateCommand(string2, string3));
    }

    public void addTrans(String string, String string2, String string3) {
        this.dbg.print("addTrans: " + string + ", " + string2 + ", " + string3);
        ContentState contentState = this.get(string);
        this.dbg.ASSERT(contentState != null, "addTrans()");
        contentState.putEventHandler(string3, string2);
    }

    public void addNomatch(String string, String string2) {
        this.addTrans(string, string2, "<nomatch>");
    }

    public void setNext(String string, String string2) {
        this.addCommand(string, new SetNextCommand("'" + string2 + "'"));
    }

    public void setFirstStateName(String string) {
        this.firstStateName_ = string;
    }

    public String getFirstStateName() {
        return this.firstStateName_;
    }

    public ContentState getFirstState() {
        return (ContentState)this.hashMap_.get(this.firstStateName_);
    }

    public void add(ContentState contentState) {
        this.put(contentState.getName(), contentState);
    }

    public GrammarSet getGrammarSet() {
        return this.grammarSet_;
    }

    public void setGrammarSet(GrammarSet grammarSet) {
        this.grammarSet_ = grammarSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"");
        stringBuffer.append(PDOC_ENCODING);
        stringBuffer.append("\" ?>\n");
        stringBuffer.append("<pdoc version=\"");
        stringBuffer.append(this.pdocVersion_);
        stringBuffer.append("\">\n");
        stringBuffer.append("<head>\n");
        if (this.grammarSet_ != null) {
            stringBuffer.append(this.grammarSet_.getRulesAsString());
            stringBuffer.append("\n");
            stringBuffer.append("<!--\n");
            stringBuffer.append(this.grammarSet_.getSRMGramStr());
            stringBuffer.append("\n");
            stringBuffer.append("-->\n");
        }
        stringBuffer.append("</head>\n\n");
        stringBuffer.append("<body start=\"");
        stringBuffer.append(this.firstStateName_);
        stringBuffer.append("\">\n");
        for (int i = 0; i < this.states_.size(); ++i) {
            String string = (String)this.states_.get(i);
            ContentState contentState = (ContentState)this.hashMap_.get(string);
            stringBuffer.append(contentState.toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append("</body>\n");
        stringBuffer.append("</pdoc>\n");
        return stringBuffer.toString();
    }
}

