/*
 * Decompiled with CFR 0.152.
 */
package relaxer.pdoc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import relaxer.pdoc.IPdocHeadChoice;
import relaxer.pdoc.PdocRule;
import relaxer.pdoc.RStack;
import relaxer.pdoc.UJAXP;
import relaxer.pdoc.URelaxer;

public class PdocGrammar
implements Serializable,
Cloneable,
IPdocHeadChoice {
    private float version_;
    private List rule_ = new ArrayList();

    public PdocGrammar() {
    }

    public PdocGrammar(PdocGrammar pdocGrammar) {
        this.setup(pdocGrammar);
    }

    public PdocGrammar(RStack rStack) {
        this.setup(rStack);
    }

    public PdocGrammar(Document document) {
        this.setup(document.getDocumentElement());
    }

    public PdocGrammar(Element element) {
        this.setup(element);
    }

    public PdocGrammar(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public PdocGrammar(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(string);
    }

    public PdocGrammar(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uRL);
    }

    public PdocGrammar(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputStream);
    }

    public PdocGrammar(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputSource);
    }

    public PdocGrammar(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(PdocGrammar pdocGrammar) {
        this.setVersion(pdocGrammar.getVersion());
        this.rule_.clear();
        int n = pdocGrammar.rule_.size();
        for (int i = 0; i < n; ++i) {
            this.addRule((PdocRule)pdocGrammar.getRule(i).clone());
        }
    }

    public void setup(Document document) {
        this.setup(document.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack rStack) {
        this.init(rStack.popElement());
    }

    private void init(Element element) {
        RStack rStack = new RStack(element);
        this.version_ = URelaxer.getAttributePropertyAsFloat(element, "version");
        this.rule_.clear();
        while (PdocRule.isMatch(rStack)) {
            this.addRule(new PdocRule(rStack));
        }
    }

    public Object clone() {
        return new PdocGrammar(this);
    }

    public void makeElement(Node node) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = document.createElement("grammar");
        URelaxer.setAttributePropertyByFloat(element, "version", this.version_);
        int n = this.rule_.size();
        for (int i = 0; i < n; ++i) {
            PdocRule pdocRule = (PdocRule)this.rule_.get(i);
            pdocRule.makeElement(element);
        }
        node.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(string, 0));
    }

    public void setup(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uRL, 0));
    }

    public void setup(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputStream, 0));
    }

    public void setup(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputSource, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document document = UJAXP.makeDocument();
        this.makeElement(document);
        return document;
    }

    public final float getVersion() {
        return this.version_;
    }

    public final void setVersion(float f) {
        this.version_ = f;
    }

    public final PdocRule[] getRule() {
        PdocRule[] pdocRuleArray = new PdocRule[this.rule_.size()];
        return this.rule_.toArray(pdocRuleArray);
    }

    public final void setRule(PdocRule[] pdocRuleArray) {
        this.rule_.clear();
        for (int i = 0; i < pdocRuleArray.length; ++i) {
            this.addRule(pdocRuleArray[i]);
        }
    }

    public final void setRule(PdocRule pdocRule) {
        this.rule_.clear();
        this.addRule(pdocRule);
    }

    public final void addRule(PdocRule pdocRule) {
        this.rule_.add(pdocRule);
    }

    public final void addRule(PdocRule[] pdocRuleArray) {
        for (int i = 0; i < pdocRuleArray.length; ++i) {
            this.addRule(pdocRuleArray[i]);
        }
    }

    public final int sizeRule() {
        return this.rule_.size();
    }

    public final PdocRule getRule(int n) {
        return (PdocRule)this.rule_.get(n);
    }

    public final void setRule(int n, PdocRule pdocRule) {
        this.rule_.set(n, pdocRule);
    }

    public final void addRule(int n, PdocRule pdocRule) {
        this.rule_.add(n, pdocRule);
    }

    public final void removeRule(int n) {
        this.rule_.remove(n);
    }

    public final void removeRule(PdocRule pdocRule) {
        this.rule_.remove(pdocRule);
    }

    public final void clearRule() {
        this.rule_.clear();
    }

    public String makeTextDocument() {
        StringBuffer stringBuffer = new StringBuffer();
        this.makeTextElement(stringBuffer);
        return new String(stringBuffer);
    }

    public void makeTextElement(StringBuffer stringBuffer) {
        stringBuffer.append("<grammar");
        stringBuffer.append(" version=\"");
        stringBuffer.append(URelaxer.getString(this.getVersion()));
        stringBuffer.append("\"");
        stringBuffer.append(">");
        int n = this.rule_.size();
        for (int i = 0; i < n; ++i) {
            PdocRule pdocRule = (PdocRule)this.rule_.get(i);
            pdocRule.makeTextElement(stringBuffer);
        }
        stringBuffer.append("</grammar>");
    }

    public void makeTextElement(Writer writer) throws IOException {
        writer.write("<grammar");
        writer.write(" version=\"");
        writer.write(URelaxer.getString(this.getVersion()));
        writer.write("\"");
        writer.write(">");
        int n = this.rule_.size();
        for (int i = 0; i < n; ++i) {
            PdocRule pdocRule = (PdocRule)this.rule_.get(i);
            pdocRule.makeTextElement(writer);
        }
        writer.write("</grammar>");
    }

    public void makeTextElement(PrintWriter printWriter) {
        printWriter.print("<grammar");
        printWriter.print(" version=\"");
        printWriter.print(URelaxer.getString(this.getVersion()));
        printWriter.print("\"");
        printWriter.print(">");
        int n = this.rule_.size();
        for (int i = 0; i < n; ++i) {
            PdocRule pdocRule = (PdocRule)this.rule_.get(i);
            pdocRule.makeTextElement(printWriter);
        }
        printWriter.print("</grammar>");
    }

    public void makeTextAttribute(StringBuffer stringBuffer) {
    }

    public void makeTextAttribute(Writer writer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter printWriter) {
    }

    public String getVersionAsString() {
        return URelaxer.getString(this.getVersion());
    }

    public void setVersionByString(String string) {
        this.setVersion(Float.parseFloat(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "grammar")) {
            return false;
        }
        RStack rStack = new RStack(element);
        boolean bl = false;
        if (!URelaxer.hasAttributeHungry(rStack, "version")) {
            return false;
        }
        bl = true;
        if (!PdocRule.isMatchHungry(rStack)) {
            return false;
        }
        bl = true;
        while (PdocRule.isMatchHungry(rStack)) {
            bl = true;
        }
        return rStack.isEmptyElement();
    }

    public static boolean isMatch(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        return PdocGrammar.isMatch(element);
    }

    public static boolean isMatchHungry(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        if (PdocGrammar.isMatch(element)) {
            rStack.popElement();
            return true;
        }
        return false;
    }
}

