/*
 * Decompiled with CFR 0.152.
 */
package relaxer.pdoc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import relaxer.pdoc.PdocCatch;
import relaxer.pdoc.PdocCmd;
import relaxer.pdoc.PdocNomatch;
import relaxer.pdoc.RStack;
import relaxer.pdoc.UJAXP;
import relaxer.pdoc.URelaxer;

public class PdocState
implements Serializable,
Cloneable {
    private String id_;
    private PdocCmd cmd_;
    private PdocNomatch nomatch_;
    private List catch_ = new ArrayList();

    public PdocState() {
        this.id_ = "";
    }

    public PdocState(PdocState pdocState) {
        this.setup(pdocState);
    }

    public PdocState(RStack rStack) {
        this.setup(rStack);
    }

    public PdocState(Document document) {
        this.setup(document.getDocumentElement());
    }

    public PdocState(Element element) {
        this.setup(element);
    }

    public PdocState(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public PdocState(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(string);
    }

    public PdocState(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uRL);
    }

    public PdocState(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputStream);
    }

    public PdocState(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputSource);
    }

    public PdocState(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(PdocState pdocState) {
        this.setId(pdocState.getId());
        this.setCmd((PdocCmd)pdocState.getCmd().clone());
        this.setNomatch((PdocNomatch)pdocState.getNomatch().clone());
        this.catch_.clear();
        int n = pdocState.catch_.size();
        for (int i = 0; i < n; ++i) {
            this.addCatch((PdocCatch)pdocState.getCatch(i).clone());
        }
    }

    public void setup(Document document) {
        this.setup(document.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack rStack) {
        this.init(rStack.popElement());
    }

    private void init(Element element) {
        RStack rStack = new RStack(element);
        this.id_ = URelaxer.getAttributePropertyAsString(element, "id");
        this.setCmd(new PdocCmd(rStack));
        if (PdocNomatch.isMatch(rStack)) {
            this.setNomatch(new PdocNomatch(rStack));
        }
        this.catch_.clear();
        while (PdocCatch.isMatch(rStack)) {
            this.addCatch(new PdocCatch(rStack));
        }
    }

    public Object clone() {
        return new PdocState(this);
    }

    public void makeElement(Node node) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = document.createElement("state");
        if (this.id_ != null) {
            URelaxer.setAttributePropertyByString(element, "id", this.id_);
        }
        this.cmd_.makeElement(element);
        if (this.nomatch_ != null) {
            this.nomatch_.makeElement(element);
        }
        int n = this.catch_.size();
        for (int i = 0; i < n; ++i) {
            PdocCatch pdocCatch = (PdocCatch)this.catch_.get(i);
            pdocCatch.makeElement(element);
        }
        node.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(string, 0));
    }

    public void setup(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uRL, 0));
    }

    public void setup(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputStream, 0));
    }

    public void setup(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputSource, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document document = UJAXP.makeDocument();
        this.makeElement(document);
        return document;
    }

    public final String getId() {
        return this.id_;
    }

    public final void setId(String string) {
        this.id_ = string;
    }

    public final PdocCmd getCmd() {
        return this.cmd_;
    }

    public final void setCmd(PdocCmd pdocCmd) {
        this.cmd_ = pdocCmd;
    }

    public final PdocNomatch getNomatch() {
        return this.nomatch_;
    }

    public final void setNomatch(PdocNomatch pdocNomatch) {
        this.nomatch_ = pdocNomatch;
    }

    public final PdocCatch[] getCatch() {
        PdocCatch[] pdocCatchArray = new PdocCatch[this.catch_.size()];
        return this.catch_.toArray(pdocCatchArray);
    }

    public final void setCatch(PdocCatch[] pdocCatchArray) {
        this.catch_.clear();
        for (int i = 0; i < pdocCatchArray.length; ++i) {
            this.addCatch(pdocCatchArray[i]);
        }
    }

    public final void setCatch(PdocCatch pdocCatch) {
        this.catch_.clear();
        this.addCatch(pdocCatch);
    }

    public final void addCatch(PdocCatch pdocCatch) {
        this.catch_.add(pdocCatch);
    }

    public final void addCatch(PdocCatch[] pdocCatchArray) {
        for (int i = 0; i < pdocCatchArray.length; ++i) {
            this.addCatch(pdocCatchArray[i]);
        }
    }

    public final int sizeCatch() {
        return this.catch_.size();
    }

    public final PdocCatch getCatch(int n) {
        return (PdocCatch)this.catch_.get(n);
    }

    public final void setCatch(int n, PdocCatch pdocCatch) {
        this.catch_.set(n, pdocCatch);
    }

    public final void addCatch(int n, PdocCatch pdocCatch) {
        this.catch_.add(n, pdocCatch);
    }

    public final void removeCatch(int n) {
        this.catch_.remove(n);
    }

    public final void removeCatch(PdocCatch pdocCatch) {
        this.catch_.remove(pdocCatch);
    }

    public final void clearCatch() {
        this.catch_.clear();
    }

    public String makeTextDocument() {
        StringBuffer stringBuffer = new StringBuffer();
        this.makeTextElement(stringBuffer);
        return new String(stringBuffer);
    }

    public void makeTextElement(StringBuffer stringBuffer) {
        stringBuffer.append("<state");
        if (this.id_ != null) {
            stringBuffer.append(" id=\"");
            stringBuffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        this.cmd_.makeTextElement(stringBuffer);
        if (this.nomatch_ != null) {
            this.nomatch_.makeTextElement(stringBuffer);
        }
        int n = this.catch_.size();
        for (int i = 0; i < n; ++i) {
            PdocCatch pdocCatch = (PdocCatch)this.catch_.get(i);
            pdocCatch.makeTextElement(stringBuffer);
        }
        stringBuffer.append("</state>");
    }

    public void makeTextElement(Writer writer) throws IOException {
        writer.write("<state");
        if (this.id_ != null) {
            writer.write(" id=\"");
            writer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            writer.write("\"");
        }
        writer.write(">");
        this.cmd_.makeTextElement(writer);
        if (this.nomatch_ != null) {
            this.nomatch_.makeTextElement(writer);
        }
        int n = this.catch_.size();
        for (int i = 0; i < n; ++i) {
            PdocCatch pdocCatch = (PdocCatch)this.catch_.get(i);
            pdocCatch.makeTextElement(writer);
        }
        writer.write("</state>");
    }

    public void makeTextElement(PrintWriter printWriter) {
        printWriter.print("<state");
        if (this.id_ != null) {
            printWriter.print(" id=\"");
            printWriter.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            printWriter.print("\"");
        }
        printWriter.print(">");
        this.cmd_.makeTextElement(printWriter);
        if (this.nomatch_ != null) {
            this.nomatch_.makeTextElement(printWriter);
        }
        int n = this.catch_.size();
        for (int i = 0; i < n; ++i) {
            PdocCatch pdocCatch = (PdocCatch)this.catch_.get(i);
            pdocCatch.makeTextElement(printWriter);
        }
        printWriter.print("</state>");
    }

    public void makeTextAttribute(StringBuffer stringBuffer) {
    }

    public void makeTextAttribute(Writer writer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter printWriter) {
    }

    public String getIdAsString() {
        return URelaxer.getString(this.getId());
    }

    public void setIdByString(String string) {
        this.setId(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "state")) {
            return false;
        }
        RStack rStack = new RStack(element);
        boolean bl = false;
        if (!URelaxer.hasAttributeHungry(rStack, "id")) {
            return false;
        }
        bl = true;
        if (!PdocCmd.isMatchHungry(rStack)) {
            return false;
        }
        bl = true;
        if (PdocNomatch.isMatchHungry(rStack)) {
            // empty if block
        }
        while (PdocCatch.isMatchHungry(rStack)) {
            bl = true;
        }
        return rStack.isEmptyElement();
    }

    public static boolean isMatch(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        return PdocState.isMatch(element);
    }

    public static boolean isMatchHungry(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        if (PdocState.isMatch(element)) {
            rStack.popElement();
            return true;
        }
        return false;
    }
}

